/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.BaseReleaseItemRepository;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow$;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0005\re\u0001B\t\u0013\u0001uA\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t!\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005m!AQ\b\u0001BC\u0002\u0013\u0005a\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003@\u0011!\u0019\u0005A!b\u0001\n\u0003!\u0005\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u000b%\u0003A\u0011\u0001&\t\u000b=\u0003A\u0011\t)\t\u000b=\u0004A\u0011\t9\t\u000be\u0004A\u0011\t>\t\u000be\u0004A\u0011\t@\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"!9\u0011q\u0005\u0001\u0005\n\u0005%\u0002bBA\u0018\u0001\u0011\u0005\u0013\u0011\u0007\u0005\b\u0003w\u0001A\u0011IA\u001f\u0011%\tI\u0006AI\u0001\n\u0003\tYFA\fTc2$U\r]3oI\u0016t7-\u001f*fa>\u001c\u0018\u000e^8ss*\u00111\u0003F\u0001\u0004gFd'BA\u000b\u0017\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003/a\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005eQ\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005Y\u0012aA2p[\u000e\u00011#\u0002\u0001\u001fI!b\u0003CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#AB!osJ+g\r\u0005\u0002&M5\tA#\u0003\u0002()\t!B)\u001a9f]\u0012,gnY=SKB|7/\u001b;pef\u0004\"!\u000b\u0016\u000e\u0003II!a\u000b\n\u00033\t\u000b7/\u001a*fY\u0016\f7/Z%uK6\u0014V\r]8tSR|'/\u001f\t\u0003[Ij\u0011A\f\u0006\u0003_A\nQa\u001d7gi)T\u0011!M\u0001\tOJL'P\u001f7fI&\u00111G\f\u0002\b\u0019><w-\u001b8h\u0003I\u0011X\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0016\u0003Y\u0002\"a\u000e\u001e\u000e\u0003aR!!\u000f\n\u0002\u0017A,'o]5ti\u0016t7-Z\u0005\u0003wa\u0012!CU3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dK\u0006\u0019\"/\u001a7fCN,\u0007+\u001a:tSN$XM\\2fA\u0005)B-\u001a9f]\u0012,gnY=QKJ\u001c\u0018n\u001d;f]\u000e,W#A \u0011\u0005]\u0002\u0015BA!9\u0005U!U\r]3oI\u0016t7-\u001f)feNL7\u000f^3oG\u0016\fa\u0003Z3qK:$WM\\2z!\u0016\u00148/[:uK:\u001cW\rI\u0001\u0012e\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014X#A#\u0011\u0005%2\u0015BA$\u0013\u0005Q\u0019\u0016\u000f\u001c*fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;fe\u0006\u0011\"/\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:!\u0003\u0019a\u0014N\\5u}Q!1\nT'O!\tI\u0003\u0001C\u00035\u000f\u0001\u0007a\u0007C\u0003>\u000f\u0001\u0007q\bC\u0003D\u000f\u0001\u0007Q)\u0001\u0005gS:$')_%e)\t\tv\u000b\u0005\u0002S+6\t1K\u0003\u0002U-\u00051Am\\7bS:L!AV*\u0003\u0015\u0011+\u0007/\u001a8eK:\u001c\u0017\u0010C\u0003Y\u0011\u0001\u0007\u0011,\u0001\u0002jIB\u0011!,\u0019\b\u00037~\u0003\"\u0001\u0018\u0011\u000e\u0003uS!A\u0018\u000f\u0002\rq\u0012xn\u001c;?\u0013\t\u0001\u0007%\u0001\u0004Qe\u0016$WMZ\u0005\u0003E\u000e\u0014aa\u0015;sS:<'B\u00011!Q\tAQ\r\u0005\u0002g[6\tqM\u0003\u0002iS\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005)\\\u0017aB7fiJL7m\u001d\u0006\u0003Yj\t\u0001bY8eC\"\fG.Z\u0005\u0003]\u001e\u0014Q\u0001V5nK\u0012\faa\u0019:fCR,GcA)rm\")!/\u0003a\u0001g\u00069!/\u001a7fCN,\u0007C\u0001*u\u0013\t)8KA\u0004SK2,\u0017m]3\t\u000b]L\u0001\u0019A)\u0002\u0015\u0011,\u0007/\u001a8eK:\u001c\u0017\u0010\u000b\u0002\nK\u00061Q\u000f\u001d3bi\u0016$2!U>}\u0011\u0015\u0011(\u00021\u0001t\u0011\u00159(\u00021\u0001RQ\tQQ\rF\u0003\u0000\u0003\u000b\t9\u0001E\u0002 \u0003\u0003I1!a\u0001!\u0005\u0011)f.\u001b;\t\u000bI\\\u0001\u0019A:\t\u000f\u0005%1\u00021\u0001\u0002\f\u0005aA-\u001a9f]\u0012,gnY5fgB)\u0011QBA\f#:!\u0011qBA\n\u001d\ra\u0016\u0011C\u0005\u0002C%\u0019\u0011Q\u0003\u0011\u0002\u000fA\f7m[1hK&!\u0011\u0011DA\u000e\u0005\r\u0019V-\u001d\u0006\u0004\u0003+\u0001\u0003FA\u0006f\u0003\u0019!W\r\\3uKR\u0019q0a\t\t\u000b]d\u0001\u0019A))\u00051)\u0017!\u00053fY\u0016$XM\u0012:p[J+G.Z1tKR)q0a\u000b\u0002.!)!/\u0004a\u0001g\")q/\u0004a\u0001#\u00069\u0011M]2iSZ,G#B@\u00024\u0005U\u0002\"\u0002:\u000f\u0001\u0004\u0019\bbBA\u001c\u001d\u0001\u0007\u00111B\u0001\u0015CJ\u001c\u0007.\u001b<fI\u0012+\u0007/\u001a8eK:\u001c\u0017.Z:)\u00059)\u0017a\u00074j]\u0012\fE\u000e\\%oG>l\u0017N\\4EKB,g\u000eZ3oG&,7\u000f\u0006\u0006\u0002\f\u0005}\u0012QIA%\u0003'Bq!!\u0011\u0010\u0001\u0004\t\u0019%A\u0005uCJ<W\r^%egB)\u0011QBA\f3\"9\u0011qI\bA\u0002\u0005\r\u0013\u0001C:uCR,8/Z:\t\u000f\u0005-s\u00021\u0001\u0002N\u0005\u0019\"/\u001a4fe\u0016t7-\u001b8h\u0007\"LG\u000e\u001a:f]B\u0019q$a\u0014\n\u0007\u0005E\u0003EA\u0004C_>dW-\u00198\t\u0013\u0005Us\u0002%AA\u0002\u00055\u0013\u0001E5oG2,H-\u001a+f[Bd\u0017\r^3tQ\tyQ-A\u0013gS:$\u0017\t\u001c7J]\u000e|W.\u001b8h\t\u0016\u0004XM\u001c3f]\u000eLWm\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011Q\f\u0016\u0005\u0003\u001b\nyf\u000b\u0002\u0002bA!\u00111MA6\u001b\t\t)G\u0003\u0003\u0002h\u0005%\u0014!C;oG\",7m[3e\u0015\tA\u0007%\u0003\u0003\u0002n\u0005\u0015$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"\u001a\u0001!!\u001d\u0011\t\u0005M\u0014qP\u0007\u0003\u0003kRA!a\u001e\u0002z\u0005YAO]1og\u0006\u001cG/[8o\u0015\r\u0019\u00121\u0010\u0006\u0004\u0003{2\u0012A\u00013c\u0013\u0011\t\t)!\u001e\u0003\u001f%\u001bHK]1og\u0006\u001cG/[8oC2\u0004")
public class SqlDependencyRepository
implements DependencyRepository,
BaseReleaseItemRepository,
Logging {
    private final ReleasePersistence releasePersistence;
    private final DependencyPersistence dependencyPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Release getRelease(String releaseId, String entityId) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId);
    }

    @Override
    public Release getRelease(String releaseId, String entityId, ResolveOptions resolveOptions) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId, resolveOptions);
    }

    @Override
    public <T> T notNull(T ci, String ciId) {
        return (T)BaseReleaseItemRepository.notNull$(this, ci, ciId);
    }

    @Override
    public void insertDependencyWithGateTaskUid(Integer gateTaskUid, Dependency dependency) {
        BaseReleaseItemRepository.insertDependencyWithGateTaskUid$(this, gateTaskUid, dependency);
    }

    @Override
    public void insertDependency(Dependency dependency) {
        BaseReleaseItemRepository.insertDependency$(this, dependency);
    }

    @Override
    public void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        BaseReleaseItemRepository.checkIsNotReferencedByDependencies$(this, planItemIdOrItsChildren);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlDependencyRepository sqlDependencyRepository = this;
        synchronized (sqlDependencyRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    @Override
    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Timed
    public Dependency findById(String id) {
        String releaseId = Ids.releaseIdFrom((String)id);
        Release release = this.getRelease(releaseId, id);
        Option maybeDependency = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllGates()).asScala().flatMap((Function1 & Serializable)x$1 -> CollectionConverters$.MODULE$.ListHasAsScala(x$1.getDependencies()).asScala())).find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SqlDependencyRepository.$anonfun$findById$2(id, x$2)));
        return (Dependency)maybeDependency.getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(30).append("Repository entity [").append(id).append("] not found").toString(), new Object[0]);
        });
    }

    @Timed
    public Dependency create(Release release, Dependency dependency) {
        this.insertDependency(dependency);
        this.releasePersistence().update(release);
        return dependency;
    }

    @Timed
    public Dependency update(Release release, Dependency dependency) {
        if (!dependency.isArchived()) {
            this.dependencyPersistence().updateDependency(dependency);
        } else {
            this.dependencyPersistence().deleteDependency(dependency);
        }
        this.releasePersistence().update(release);
        return dependency;
    }

    @Timed
    public void update(Release release, Seq<Dependency> dependencies) {
        dependencies.foreach((Function1 & Serializable)dependency -> {
            SqlDependencyRepository.$anonfun$update$1(this, dependency);
            return BoxedUnit.UNIT;
        });
        this.releasePersistence().update(release);
    }

    @Timed
    public void delete(Dependency dependency) {
        Release release = dependency.getGateTask().getRelease();
        this.deleteFromRelease(release, dependency);
    }

    private void deleteFromRelease(Release release, Dependency dependency) {
        Option maybeGateTask = CollectionConverters$.MODULE$.ListHasAsScala(release.getAllGates()).asScala().find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SqlDependencyRepository.$anonfun$deleteFromRelease$1(dependency, x$3)));
        maybeGateTask.map((Function1 & Serializable)gateTask -> {
            gateTask.setDependencies(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(gateTask.getDependencies()).asScala().filterNot((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SqlDependencyRepository.$anonfun$deleteFromRelease$3(dependency, x$4)))).asJava());
            this.releasePersistence().update(release);
            this.dependencyPersistence().deleteDependency(dependency);
            return dependency;
        }).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(47).append("GateTask ").append(dependency.getGateTask().getId()).append(" not found while deleting dependency ").append(dependency.getId()).append(".").toString(), new Object[0]);
        });
    }

    @Timed
    public void archive(Release release, Seq<Dependency> archivedDependencies) {
        if (archivedDependencies.nonEmpty()) {
            archivedDependencies.foreach((Function1 & Serializable)dependency -> {
                SqlDependencyRepository.$anonfun$archive$1(this, dependency);
                return BoxedUnit.UNIT;
            });
            this.releasePersistence().update(release);
            return;
        }
    }

    @Timed
    public Seq<Dependency> findAllIncomingDependencies(Seq<String> targetIds, Seq<String> statuses, boolean referencingChildren, boolean includeTemplates) {
        Seq<DependencyRow> dependencies = referencingChildren ? this.dependencyPersistence().findByPartialTargetIds((Set<String>)targetIds.toSet(), (Option<Set<String>>)SqlDependencyRepository.status$1(statuses)) : this.dependencyPersistence().findByTargetIds((Set<String>)targetIds.toSet(), (Option<Set<String>>)SqlDependencyRepository.status$1(statuses));
        return DependencyRow$.MODULE$.DependencyDataSeqOps((Seq<DependencyRow>)((Seq)dependencies.filter((Function1 & Serializable)dep -> BoxesRunTime.boxToBoolean((boolean)SqlDependencyRepository.$anonfun$findAllIncomingDependencies$1(includeTemplates, dep))))).asDependencies();
    }

    public boolean findAllIncomingDependencies$default$4() {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$findById$2(String id$1, Dependency x$2) {
        String string = x$2.getId();
        String string2 = CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id$1));
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$update$1(SqlDependencyRepository $this, Dependency dependency) {
        if (!dependency.isArchived()) {
            $this.dependencyPersistence().updateDependency(dependency);
            return;
        }
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    public static final /* synthetic */ boolean $anonfun$deleteFromRelease$1(Dependency dependency$1, GateTask x$3) {
        String string = x$3.getId();
        String string2 = CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(dependency$1.getGateTask().getId()));
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$deleteFromRelease$3(Dependency dependency$1, Dependency x$4) {
        String string = x$4.getId();
        String string2 = CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(dependency$1.getId()));
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$archive$1(SqlDependencyRepository $this, Dependency dependency) {
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    private static final Option status$1(Seq statuses$1) {
        if (statuses$1.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some((Object)statuses$1.toSet());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$findAllIncomingDependencies$1(boolean includeTemplates$1, DependencyRow dep) {
        if (includeTemplates$1) return true;
        String string = dep.gateReleaseStatus();
        String string2 = ReleaseStatus.TEMPLATE.value();
        if (string == null) {
            if (string2 == null) return false;
            return true;
        } else if (string.equals(string2)) return false;
        return true;
    }

    public SqlDependencyRepository(ReleasePersistence releasePersistence, DependencyPersistence dependencyPersistence, SqlRepositoryAdapter repositoryAdapter) {
        this.releasePersistence = releasePersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.repositoryAdapter = repositoryAdapter;
        BaseReleaseItemRepository.$init$(this);
        Logging.$init$((Logging)this);
    }
}

