/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.CiWithUid;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata$;
import com.xebialabs.xlrelease.domain.calendar.Blackout;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.CommentRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.repository.sql.BaseReleaseItemRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.TasksSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow$;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\rEc\u0001B\u0015+\u0001UB\u0001B\u0015\u0001\u0003\u0006\u0004%\ta\u0015\u0005\t5\u0002\u0011\t\u0011)A\u0005)\"A1\f\u0001BC\u0002\u0013\u0005A\f\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003^\u0011!\t\u0007A!b\u0001\n\u0003\u0011\u0007\u0002\u00034\u0001\u0005\u0003\u0005\u000b\u0011B2\t\u0011\u001d\u0004!Q1A\u0005\u0002!D\u0001\u0002\u001c\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\t[\u0002\u0011)\u0019!C\u0001]\"A!\u000f\u0001B\u0001B\u0003%q\u000e\u0003\u0005t\u0001\t\u0015\r\u0011\"\u0001u\u0011!Y\bA!A!\u0002\u0013)\b\u0002\u0003?\u0001\u0005\u000b\u0007I\u0011A?\t\u0013\u0005\r\u0001A!A!\u0002\u0013q\bBCA\u0003\u0001\t\u0015\r\u0011b\u0001\u0002\b!Q\u0011q\u0007\u0001\u0003\u0002\u0003\u0006I!!\u0003\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<!9\u0011q\n\u0001\u0005B\u0005E\u0003bBA(\u0001\u0011\u0005\u00131\u0014\u0005\b\u0003{\u0003A\u0011IA`\u0011\u001d\t\u0019\u0010\u0001C!\u0003kDqAa\u0001\u0001\t\u0003\u0012)\u0001C\u0004\u0003\u000e\u0001!\tEa\u0004\t\u000f\t=\u0002\u0001\"\u0011\u00032!9!q\u0007\u0001\u0005B\te\u0002b\u0002B#\u0001\u0011\u0005#q\t\u0005\b\u0005/\u0002A\u0011\tB-\u0011\u001d\u0011y\u0006\u0001C!\u0005CBqAa\u001a\u0001\t\u0013\u0011I\u0007C\u0004\u0003p\u0001!\tE!\u001d\t\u000f\t]\u0004\u0001\"\u0011\u0003z!9!1\u0013\u0001\u0005B\tU\u0005b\u0002BU\u0001\u0011\u0005#1\u0016\u0005\b\u0005_\u0003A\u0011\tBY\u0011\u001d\u0011I\f\u0001C!\u0005wCqAa4\u0001\t\u0003\u0012\t\u000eC\u0004\u0003j\u0002!\tE!5\t\u000f\t=\b\u0001\"\u0011\u0003r\"91Q\u0001\u0001\u0005B\r\u001d\u0001bBB\f\u0001\u0011\u00053\u0011\u0004\u0002\u0012'FdG+Y:l%\u0016\u0004xn]5u_JL(BA\u0016-\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003[9\n!B]3q_NLGo\u001c:z\u0015\ty\u0003'A\u0005yYJ,G.Z1tK*\u0011\u0011GM\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aM\u0001\u0004G>l7\u0001A\n\b\u0001Yb\u0004\tR$K!\t9$(D\u00019\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0005\u0019\te.\u001f*fMB\u0011QHP\u0007\u0002Y%\u0011q\b\f\u0002\u000f)\u0006\u001c8NU3q_NLGo\u001c:z!\t\t%)D\u0001+\u0013\t\u0019%FA\rCCN,'+\u001a7fCN,\u0017\n^3n%\u0016\u0004xn]5u_JL\bCA!F\u0013\t1%F\u0001\fEKN,'/[1mSj\fG/[8o'V\u0004\bo\u001c:u!\t\t\u0005*\u0003\u0002JU\tq2i\u001c8gS\u001e,(/\u0019;j_:\u0014VMZ3sK:\u001cWm]*vaB|'\u000f\u001e\t\u0003\u0017Bk\u0011\u0001\u0014\u0006\u0003\u001b:\u000bQa\u001d7gi)T\u0011aT\u0001\tOJL'P\u001f7fI&\u0011\u0011\u000b\u0014\u0002\b\u0019><w-\u001b8h\u0003I\u0011X\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0016\u0003Q\u0003\"!\u0016-\u000e\u0003YS!a\u0016\u0016\u0002\u0017A,'o]5ti\u0016t7-Z\u0005\u00033Z\u0013!CU3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dK\u0006\u0019\"/\u001a7fCN,\u0007+\u001a:tSN$XM\\2fA\u0005)B-\u001a9f]\u0012,gnY=QKJ\u001c\u0018n\u001d;f]\u000e,W#A/\u0011\u0005Us\u0016BA0W\u0005U!U\r]3oI\u0016t7-\u001f)feNL7\u000f^3oG\u0016\fa\u0003Z3qK:$WM\\2z!\u0016\u00148/[:uK:\u001cW\rI\u0001\u0010i\u0006\u001c8\u000eU3sg&\u001cH/\u001a8dKV\t1\r\u0005\u0002VI&\u0011QM\u0016\u0002\u0010)\u0006\u001c8\u000eU3sg&\u001cH/\u001a8dK\u0006\u0001B/Y:l!\u0016\u00148/[:uK:\u001cW\rI\u0001\u0012G>lW.\u001a8u%\u0016\u0004xn]5u_JLX#A5\u0011\u0005uR\u0017BA6-\u0005E\u0019u.\\7f]R\u0014V\r]8tSR|'/_\u0001\u0013G>lW.\u001a8u%\u0016\u0004xn]5u_JL\b%A\tsKB|7/\u001b;pef\fE-\u00199uKJ,\u0012a\u001c\t\u0003\u0003BL!!\u001d\u0016\u0003)M\u000bHNU3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3s\u0003I\u0011X\r]8tSR|'/_!eCB$XM\u001d\u0011\u00021\r|gNZ5hkJ\fG/[8o!\u0016\u00148/[:uK:\u001cW-F\u0001v!\t1\u00180D\u0001x\u0015\tAh+A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0003u^\u0014\u0011eQ8oM&<WO]1uS>t'+\u001a4fe\u0016t7-\u001a)feNL7\u000f^3oG\u0016\f\u0011dY8oM&<WO]1uS>t\u0007+\u001a:tSN$XM\\2fA\u0005Ib-Y2fiJ+\u0007o\\:ji>\u0014\u0018\u0010R5ta\u0006$8\r[3s+\u0005q\bCA\u001f\u0000\u0013\r\t\t\u0001\f\u0002\u001a\r\u0006\u001cW\r\u001e*fa>\u001c\u0018\u000e^8ss\u0012K7\u000f]1uG\",'/\u0001\u000egC\u000e,GOU3q_NLGo\u001c:z\t&\u001c\b/\u0019;dQ\u0016\u0014\b%A\u0004eS\u0006dWm\u0019;\u0016\u0005\u0005%\u0001\u0003BA\u0006\u0003cqA!!\u0004\u0002,9!\u0011qBA\u0014\u001d\u0011\t\t\"a\t\u000f\t\u0005M\u0011\u0011\u0005\b\u0005\u0003+\tyB\u0004\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tY\u0002N\u0001\u0007yI|w\u000e\u001e \n\u0003MJ!!\r\u001a\n\u0005=\u0002\u0014bAA\u0013]\u0005\u0011AMY\u0005\u0004W\u0005%\"bAA\u0013]%!\u0011QFA\u0018\u0003)\u0019\u0016\u000f\u001c\"vS2$WM\u001d\u0006\u0004W\u0005%\u0012\u0002BA\u001a\u0003k\u0011q\u0001R5bY\u0016\u001cGO\u0003\u0003\u0002.\u0005=\u0012\u0001\u00033jC2,7\r\u001e\u0011\u0002\rqJg.\u001b;?)I\ti$a\u0010\u0002B\u0005\r\u0013QIA$\u0003\u0013\nY%!\u0014\u0011\u0005\u0005\u0003\u0001\"\u0002*\u0012\u0001\u0004!\u0006\"B.\u0012\u0001\u0004i\u0006\"B1\u0012\u0001\u0004\u0019\u0007\"B4\u0012\u0001\u0004I\u0007\"B7\u0012\u0001\u0004y\u0007\"B:\u0012\u0001\u0004)\b\"\u0002?\u0012\u0001\u0004q\bbBA\u0003#\u0001\u000f\u0011\u0011B\u0001\tM&tGMQ=JIV!\u00111KA-)\u0011\t)&!\u001d\u0011\t\u0005]\u0013\u0011\f\u0007\u0001\t\u001d\tYF\u0005b\u0001\u0003;\u0012\u0011\u0001V\t\u0005\u0003?\n)\u0007E\u00028\u0003CJ1!a\u00199\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!a\u001a\u0002n5\u0011\u0011\u0011\u000e\u0006\u0004\u0003Wr\u0013A\u00023p[\u0006Lg.\u0003\u0003\u0002p\u0005%$\u0001\u0002+bg.Dq!a\u001d\u0013\u0001\u0004\t)(\u0001\u0004uCN\\\u0017\n\u001a\t\u0005\u0003o\nyH\u0004\u0003\u0002z\u0005m\u0004cAA\fq%\u0019\u0011Q\u0010\u001d\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t)a!\u0003\rM#(/\u001b8h\u0015\r\ti\b\u000f\u0015\u0004%\u0005\u001d\u0005\u0003BAE\u0003/k!!a#\u000b\t\u00055\u0015qR\u0001\u000bC:tw\u000e^1uS>t'\u0002BAI\u0003'\u000bq!\\3ue&\u001c7OC\u0002\u0002\u0016J\n\u0001bY8eC\"\fG.Z\u0005\u0005\u00033\u000bYIA\u0003US6,G-\u0006\u0003\u0002\u001e\u0006\u0005FCBAP\u0003G\u000b)\u000b\u0005\u0003\u0002X\u0005\u0005FaBA.'\t\u0007\u0011Q\f\u0005\b\u0003g\u001a\u0002\u0019AA;\u0011\u001d\t9k\u0005a\u0001\u0003S\u000baB]3t_24Xm\u00149uS>t7\u000f\u0005\u0003\u0002,\u0006]VBAAW\u0015\ri\u0013q\u0016\u0006\u0005\u0003c\u000b\u0019,\u0001\u0003kg>t'bAA[]\u0005i1/\u001a:jC2L'0\u0019;j_:LA!!/\u0002.\nq!+Z:pYZ,w\n\u001d;j_:\u001c\bfA\n\u0002\b\u0006\u0011b-\u001b8e)\u0006\u001c8n\u001d\"bg&\u001cG)\u0019;b)\u0011\t\t-!8\u0011\r\u0005\r\u0017QZAi\u001b\t\t)M\u0003\u0003\u0002H\u0006%\u0017\u0001B;uS2T!!a3\u0002\t)\fg/Y\u0005\u0005\u0003\u001f\f)M\u0001\u0003MSN$\b\u0003BAj\u00033l!!!6\u000b\u0007\u0005]G&A\u0003rk\u0016\u0014\u00180\u0003\u0003\u0002\\\u0006U'!\u0004+bg.\u0014\u0015m]5d\t\u0006$\u0018\rC\u0004\u0002`R\u0001\r!!9\u0002\u000fQ\f7o[%egB1\u00111YAg\u0003kB3\u0001FAs!\u0011\t9/!<\u000e\u0005\u0005%(\u0002BAv\u0003_\t1\u0002\u001e:b]N\f7\r^5p]&!\u0011q^Au\u0005)I5OU3bI>sG.\u001f\u0015\u0004)\u0005\u001d\u0015AB3ySN$8\u000f\u0006\u0003\u0002x\u0006u\bcA\u001c\u0002z&\u0019\u00111 \u001d\u0003\u000f\t{w\u000e\\3b]\"9\u00111O\u000bA\u0002\u0005U\u0004fA\u000b\u0002f\"\u001aQ#a\"\u0002\rU\u0004H-\u0019;f)\u0011\t)Ga\u0002\t\u000f\t%a\u00031\u0001\u0002f\u0005!A/Y:lQ\r1\u0012qQ\u0001\fkB$\u0017\r^3UCN\\7\u000f\u0006\u0003\u0003\u0012\t]\u0001cA\u001c\u0003\u0014%\u0019!Q\u0003\u001d\u0003\tUs\u0017\u000e\u001e\u0005\b\u000539\u0002\u0019\u0001B\u000e\u0003\u0015!\u0018m]6t!\u00159$QDA3\u0013\r\u0011y\u0002\u000f\u0002\u000byI,\u0007/Z1uK\u0012t\u0004fA\f\u0003$A!!Q\u0005B\u0015\u001b\t\u00119CC\u0002\u0002\u000ebJAAa\u000b\u0003(\t9a/\u0019:be\u001e\u001c\bfA\f\u0002\b\u0006!R\u000f\u001d3bi\u0016$\u0016m]6Qe>\u0004XM\u001d;jKN$BA!\u0005\u00034!9!\u0011\u0002\rA\u0002\u0005\u0015\u0004f\u0001\r\u0002\b\u0006I\"-\u0019;dQV\u0003H-\u0019;f)\u0006\u001c8\u000e\u0015:pa\u0016\u0014H/[3t)\u0011\u0011\tBa\u000f\t\u000f\te\u0011\u00041\u0001\u0003>A1\u0011q\u000fB \u0003KJAA!\u0011\u0002\u0004\n\u00191+\u001a;)\u0007e\t9)\u0001\u0010va\u0012\fG/\u001a+bg.\fe\u000e\u001a*fY\u0016\f7/\u001a$mC\u001e\u001cF/\u0019;vgR1\u0011Q\rB%\u0005\u0017BqA!\u0003\u001b\u0001\u0004\t)\u0007C\u0004\u0003Ni\u0001\rAa\u0014\u0002\u000fI,G.Z1tKB!\u0011q\rB)\u0013\u0011\u0011\u0019&!\u001b\u0003\u000fI+G.Z1tK\"\u001a!$a\"\u0002\u0015U\u0004H-\u0019;f)f\u0004X\r\u0006\u0003\u0002f\tm\u0003b\u0002B\u00057\u0001\u0007\u0011Q\r\u0015\u00047\u0005\u001d\u0015A\u00023fY\u0016$X\r\u0006\u0003\u0003\u0012\t\r\u0004b\u0002B\u00059\u0001\u0007\u0011Q\r\u0015\u00049\u0005\u001d\u0015AC2sK\u0006$X\rV1tWR!\u0011Q\rB6\u0011\u001d\u0011i'\ba\u0001\u0003K\nqA\\3x)\u0006\u001c8.\u0001\u0004de\u0016\fG/\u001a\u000b\u0005\u0003K\u0012\u0019\bC\u0004\u0003ny\u0001\r!!\u001a)\u0007y\t9)\u0001\u0005n_Z,G+Y:l))\t)Ga\u001f\u0003\u0000\t\r%Q\u0012\u0005\b\u0005{z\u0002\u0019AA3\u0003)!\u0018m]6U_6{g/\u001a\u0005\b\u0005\u0003{\u0002\u0019AA3\u0003%iwN^3e)\u0006\u001c8\u000eC\u0004\u0003\u0006~\u0001\rAa\"\u0002-U\u0004H-\u0019;fI>\u0013\u0018nZ5o\u0007>tG/Y5oKJ\u0004B!a\u001a\u0003\n&!!1RA5\u00055!\u0016m]6D_:$\u0018-\u001b8fe\"9!qR\u0010A\u0002\t\u001d\u0015AF;qI\u0006$X\r\u001a+be\u001e,GoQ8oi\u0006Lg.\u001a:)\u0007}\t9)\u0001\fgS:$\u0017I\u001a4fGR,GMQ=CY\u0006\u001c7n\\;u)\u0011\t\tOa&\t\u000f\te\u0005\u00051\u0001\u0003\u001c\u0006A!\r\\1dW>,H\u000f\u0005\u0003\u0003\u001e\n\rVB\u0001BP\u0015\u0011\u0011\t+!\u001b\u0002\u0011\r\fG.\u001a8eCJLAA!*\u0003 \nA!\t\\1dW>,H\u000fK\u0002!\u0003\u000f\u000b!DZ5oIB+g\u000eZ5oOR\u000b7o[:XSRDg)Y2fiN$\"!!9)\u0007\u0005\n9)\u0001\u0005hKR$\u0016\u000e\u001e7f)\u0011\t)Ha-\t\u000f\u0005M$\u00051\u0001\u0002v!\u001a!%!:)\u0007\t\n9)\u0001\u0006hKR\fE\u000e\u001c+bON$BA!0\u0003BB1\u00111\u0019B`\u0003kJAA!\u0011\u0002F\"9!1Y\u0012A\u0002\t\u0015\u0017a\u00037j[&$h*^7cKJ\u00042a\u000eBd\u0013\r\u0011I\r\u000f\u0002\u0004\u0013:$\bfA\u0012\u0002f\"\u001a1%a\"\u0002%\u0019Lg\u000eZ(wKJ$W/\u001a+bg.LEm\u001d\u000b\u0003\u0005'\u0004bA!6\u0003`\u0006Ud\u0002\u0002Bl\u00057tA!a\u0006\u0003Z&\t\u0011(C\u0002\u0003^b\nq\u0001]1dW\u0006<W-\u0003\u0003\u0003b\n\r(aA*fc*\u0019!Q\u001c\u001d)\u0007\u0011\n)\u000fK\u0002%\u0003\u000f\u000b!CZ5oI\u0012+XmU8p]R\u000b7o[%eg\"\u001aQ%!:)\u0007\u0015\n9)A\u0005hKR\u001cF/\u0019;vgR!!1\u001fB\u0000!\u0011\u0011)Pa?\u000e\u0005\t](\u0002\u0002B}\u0003S\naa\u001d;biV\u001c\u0018\u0002\u0002B\u007f\u0005o\u0014!\u0002V1tWN#\u0018\r^;t\u0011\u001d\t\u0019H\na\u0001\u0003kB3AJAsQ\r1\u0013qQ\u0001\u0010O\u0016$H+Y:l'R\fG/^:fgR!1\u0011BB\b!!\t\u0019ma\u0003\u0002v\tM\u0018\u0002BB\u0007\u0003\u000b\u00141!T1q\u0011\u001d\u0019\tb\na\u0001\u0003k\n\u0011B]3mK\u0006\u001cX-\u00133)\u0007\u001d\n)\u000fK\u0002(\u0003\u000f\u000bqEZ5oIR\u000b7o[%eg\nKH+Y:l)f\u0004Xm\u0015;biV\u001c\u0018I\u001c3Ti\u0006\u0014H\u000fR1uKRA!1[B\u000e\u0007o\u0019Y\u0004C\u0004\u0004\u001e!\u0002\raa\b\u0002\u0011Q\f7o\u001b+za\u0016\u0004Ba!\t\u000445\u001111\u0005\u0006\u0005\u0007K\u00199#A\u0004sK\u001adWm\u0019;\u000b\t\r%21F\u0001\u0004CBL'\u0002BB\u0017\u0007_\ta\u0001\u001d7vO&t'bAB\u0019a\u0005AA-\u001a9m_fLG/\u0003\u0003\u00046\r\r\"\u0001\u0002+za\u0016Dqa!\u000f)\u0001\u0004\u0011\u00190\u0001\u0006uCN\\7\u000b^1ukNDqa!\u0010)\u0001\u0004\u0019y$A\u0007ti\u0006\u0014H/\u001a3CK\u001a|'/\u001a\t\u0005\u0003\u0007\u001c\t%\u0003\u0003\u0004D\u0005\u0015'\u0001\u0002#bi\u0016D3\u0001KAsQ\rA\u0013q\u0011\u0015\u0004\u0001\r-\u0003\u0003BAt\u0007\u001bJAaa\u0014\u0002j\ny\u0011j\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000e")
public class SqlTaskRepository
implements TaskRepository,
BaseReleaseItemRepository,
DeserializationSupport,
ConfigurationReferencesSupport,
Logging {
    private final ReleasePersistence releasePersistence;
    private final DependencyPersistence dependencyPersistence;
    private final TaskPersistence taskPersistence;
    private final CommentRepository commentRepository;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final ConfigurationReferencePersistence configurationPersistence;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final SqlBuilder.Dialect dialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void updateConfigurationRefs(CiWithUid entity) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, entity);
    }

    @Override
    public void deleteConfigurationRefs(Integer uid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, uid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.deserializeRelease$(this, releaseData);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData);
    }

    @Override
    public Release getRelease(String releaseId, String entityId) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId);
    }

    @Override
    public Release getRelease(String releaseId, String entityId, ResolveOptions resolveOptions) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId, resolveOptions);
    }

    @Override
    public <T> T notNull(T ci, String ciId) {
        return (T)BaseReleaseItemRepository.notNull$(this, ci, ciId);
    }

    @Override
    public void insertDependencyWithGateTaskUid(Integer gateTaskUid, Dependency dependency) {
        BaseReleaseItemRepository.insertDependencyWithGateTaskUid$(this, gateTaskUid, dependency);
    }

    @Override
    public void insertDependency(Dependency dependency) {
        BaseReleaseItemRepository.insertDependency$(this, dependency);
    }

    @Override
    public void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        BaseReleaseItemRepository.checkIsNotReferencedByDependencies$(this, planItemIdOrItsChildren);
    }

    public TaskBasicData findTaskBasicData(String taskId) {
        return TaskRepository.findTaskBasicData$((TaskRepository)this, (String)taskId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTaskRepository sqlTaskRepository = this;
        synchronized (sqlTaskRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public void updateTasks(Task ... tasks) {
        this.updateTasks((scala.collection.immutable.Seq<Task>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])tasks));
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    @Override
    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public CommentRepository commentRepository() {
        return this.commentRepository;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Override
    public ConfigurationReferencePersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    public FacetRepositoryDispatcher facetRepositoryDispatcher() {
        return this.facetRepositoryDispatcher;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    public <T extends Task> T findById(String taskId) {
        return this.findById(taskId, ResolveOptions$.MODULE$.WITH_DECORATORS());
    }

    @Timed
    public <T extends Task> T findById(String taskId, ResolveOptions resolveOptions) {
        if (!this.exists(taskId)) {
            throw new NotFoundException(new StringBuilder(30).append("Repository entity [").append(taskId).append("] not found").toString(), new Object[0]);
        }
        Release release = this.getRelease(Ids.releaseIdFrom((String)taskId), taskId, resolveOptions);
        return (T)((Task)Option$.MODULE$.apply((Object)release.getTask(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(taskId)))).fold((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(41).append("Repository entity [").append(taskId).append("] not found in release").toString(), new Object[0]);
        }, (Function1 & Serializable)task -> {
            task.getAllTasks().forEach(t -> this.commentRepository().decorate(t));
            return task;
        }));
    }

    @Timed
    @IsReadOnly
    public List<TaskBasicData> findTasksBasicData(List<String> taskIds) {
        List list;
        if (taskIds.isEmpty()) {
            list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().empty()).asJava();
        } else {
            scala.collection.immutable.Seq<TaskRow> tasksData = this.taskPersistence().findByIds((Iterable<String>)CollectionConverters$.MODULE$.ListHasAsScala(taskIds).asScala());
            list = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(taskIds).asScala().map((Function1 & Serializable)taskId -> new Tuple2(taskId, (Object)tasksData.find((Function1 & Serializable)data -> BoxesRunTime.boxToBoolean((boolean)taskId.endsWith(data.taskId())))))).flatMap((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) return None$.MODULE$;
                String id = (String)tuple2._1();
                Option option = (Option)tuple2._2();
                if (!(option instanceof Some)) return None$.MODULE$;
                Some some = (Some)option;
                TaskRow data = (TaskRow)some.value();
                return new Some((Object)TaskRow$.MODULE$.TaskDataOps(data).asTaskData(id));
            })).asJava();
        }
        return list;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(26).append("Checking if exists task [").append(taskId).append("]").toString());
        return this.taskPersistence().exists(taskId);
    }

    @Timed
    public Task update(Task task) {
        Release release = task.getRelease();
        this.releasePersistence().update(release);
        this.updateTaskProperties(task);
        this.updateConfigurationRefs((CiWithUid)release);
        return task;
    }

    @Timed
    public void updateTasks(scala.collection.immutable.Seq<Task> tasks) {
        tasks.groupBy((Function1 & Serializable)x$1 -> x$1.getRelease()).foreach((Function1 & Serializable)x0$1 -> {
            SqlTaskRepository.$anonfun$updateTasks$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void updateTaskProperties(Task task) {
        this.taskPersistence().updateProperties(task);
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)x0$1 -> {
            SqlTaskRepository.$anonfun$updateTaskProperties$1(this, task, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void batchUpdateTaskProperties(scala.collection.immutable.Set<Task> tasks) {
        this.taskPersistence().batchUpdateTaskProperties(tasks);
        Tuple2 tuple2 = ((IterableOps)tasks.flatMap((Function1 & Serializable)x$2 -> syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(x$2)))).partition((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isArchived()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Set archivedDeps = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set otherDeps = (scala.collection.immutable.Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)archivedDeps, (Object)otherDeps);
        Tuple2 tuple23 = tuple22;
        scala.collection.immutable.Set archivedDeps2 = (scala.collection.immutable.Set)tuple23._1();
        scala.collection.immutable.Set otherDeps2 = (scala.collection.immutable.Set)tuple23._2();
        this.dependencyPersistence().batchDeleteDependencies((scala.collection.immutable.Set<Dependency>)archivedDeps2);
        this.dependencyPersistence().batchUpdateDependencies((scala.collection.immutable.Set<Dependency>)otherDeps2);
    }

    @Timed
    public Task updateTaskAndReleaseFlagStatus(Task task, Release release) {
        return this.update(task);
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Task updateType(Task task) {
        void var2_2;
        Task updated = this.update(task);
        this.taskPersistence().updateType(task);
        return var2_2;
    }

    @Timed
    public void delete(Task task) {
        this.checkIsNotReferencedByDependencies(task.getId());
        this.releasePersistence().update(task.getRelease());
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)dependency -> {
            SqlTaskRepository.$anonfun$delete$1(this, dependency);
            return BoxedUnit.UNIT;
        });
        task.getAllTasks().forEach(t -> {
            this.commentRepository().deleteByTask(t);
            this.taskPersistence().delete((Task)t);
        });
        this.updateConfigurationRefs((CiWithUid)task.getRelease());
    }

    private Task createTask(Task newTask2) {
        this.taskPersistence().insert(newTask2, Predef$.MODULE$.Integer2int(newTask2.getRelease().getCiUid()));
        Object object = newTask2 instanceof TaskGroup ? ((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(newTask2.getAllTasks()).asScala().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$createTask$1(newTask2, x$5)))).map((Function1 & Serializable)newTask -> this.createTask((Task)newTask)) : BoxedUnit.UNIT;
        return newTask2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Task create(Task newTask) {
        void var2_2;
        this.releasePersistence().update(newTask.getRelease());
        Task createdTask = this.createTask(newTask);
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(createdTask)).foreach((Function1 & Serializable)dependency -> {
            this.insertDependency(dependency);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs((CiWithUid)createdTask.getRelease());
        this.facetRepositoryDispatcher().liveRepository().createFromTasks(CollectionConverters$.MODULE$.ListHasAsScala(newTask.getAllTasks()).asScala().toSeq(), this.facetRepositoryDispatcher().liveRepository().createFromTasks$default$2());
        return var2_2;
    }

    @Timed
    public Task moveTask(Task taskToMove, Task movedTask, TaskContainer updatedOriginContainer, TaskContainer updatedTargetContainer) {
        TaskContainer taskContainer = updatedOriginContainer;
        TaskContainer taskContainer2 = updatedTargetContainer;
        if (taskContainer == null ? taskContainer2 != null : !taskContainer.equals(taskContainer2)) {
            this.checkIsNotReferencedByDependencies(taskToMove.getId());
            CollectionConverters$.MODULE$.ListHasAsScala(taskToMove.getAllTasks()).asScala().foreach((Function1 & Serializable)taskWithOldId -> {
                SqlTaskRepository.$anonfun$moveTask$1(this, taskToMove, movedTask, taskWithOldId);
                return BoxedUnit.UNIT;
            });
        }
        this.releasePersistence().update(movedTask.getRelease());
        return movedTask;
    }

    @Timed
    public List<String> findAffectedByBlackout(Blackout blackout) {
        Date endDate = BlackoutMetadata$.MODULE$.toStartOfNextMinute(blackout.getEndDate());
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.dialect()).selectReleaseData().withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)ReleaseStatus.ACTIVE_STATUSES)).build();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOps)((IterableOps)((IterableOps)this.releasePersistence().findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable)releaseData -> this.tryDeserializeRelease((ReleaseRow)releaseData))).flatMap((Function1 & Serializable)rel -> CollectionConverters$.MODULE$.ListHasAsScala(rel.getAllTasks()).asScala())).filter((Function1 & Serializable)task -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$findAffectedByBlackout$3(endDate, task)))).map((Function1 & Serializable)x$6 -> x$6.getId())).asJava();
    }

    @Timed
    public List<String> findPendingTasksWithFacets() {
        Tuple2 sqlWithParams = new TasksSqlBuilder(this.dialect()).selectTaskId().withOneOfTaskStatuses((scala.collection.immutable.Seq<TaskStatus>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TaskStatus[]{TaskStatus.PENDING})))).withAnyFacets().build();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.taskPersistence().findTaskIdsByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).toSet().toList()).asJava();
    }

    @Timed
    @IsReadOnly
    public String getTitle(String taskId) {
        return (String)this.taskPersistence().getTitle(taskId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Task [%s] not found", new Object[]{taskId});
        });
    }

    @Timed
    @IsReadOnly
    public Set<String> getAllTags(int limitNumber) {
        return CollectionConverters$.MODULE$.SetHasAsJava(this.taskPersistence().findAllTags(limitNumber)).asJava();
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findOverdueTaskIds() {
        return this.taskPersistence().findOverdueTaskIds();
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findDueSoonTaskIds() {
        return this.taskPersistence().findDueSoonTaskIds();
    }

    @Timed
    @IsReadOnly
    public TaskStatus getStatus(String taskId) {
        return (TaskStatus)this.taskPersistence().getStatus(taskId).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(33).append("getStatus: could not find task '").append(taskId).append("'").toString(), new Object[0]);
        });
    }

    @Timed
    @IsReadOnly
    public Map<String, TaskStatus> getTaskStatuses(String releaseId) {
        return this.taskPersistence().getTaskStatuses(releaseId);
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findTaskIdsByTaskTypeStatusAndStartDate(Type taskType, TaskStatus taskStatus, Date startedBefore) {
        return this.taskPersistence().findTaskIdsByTaskTypeStatusAndStartDate(taskType, taskStatus, startedBefore);
    }

    public static final /* synthetic */ void $anonfun$updateTasks$2(SqlTaskRepository $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Release release = (Release)tuple2._1();
        scala.collection.immutable.Seq tasks = (scala.collection.immutable.Seq)tuple2._2();
        $this.releasePersistence().update(release);
        tasks.foreach((Function1 & Serializable)task -> {
            $this.updateTaskProperties(task);
            return BoxedUnit.UNIT;
        });
        $this.updateConfigurationRefs((CiWithUid)release);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$updateTaskProperties$1(SqlTaskRepository $this, Task task$1, Dependency x0$1) {
        Dependency dependency = x0$1;
        if (dependency.isArchived()) {
            $this.dependencyPersistence().deleteDependency(dependency);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            try {
                $this.dependencyPersistence().updateDependency(dependency);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (NotFoundException e) {
                $this.logger().error((Function0 & Serializable)() -> new StringBuilder(41).append("Dependency ").append(dependency).append(" not found when updating task ").append(task$1).toString(), (Function0 & Serializable)() -> e);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public static final /* synthetic */ void $anonfun$delete$1(SqlTaskRepository $this, Dependency dependency) {
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    public static final /* synthetic */ boolean $anonfun$createTask$1(Task newTask$1, Task x$5) {
        String string = x$5.getContainer().getId();
        String string2 = newTask$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$moveTask$1(SqlTaskRepository $this, Task taskToMove$1, Task movedTask$1, Task taskWithOldId) {
        String oldId = taskWithOldId.getId();
        String newId = oldId.replace(taskToMove$1.getId(), movedTask$1.getId());
        $this.taskPersistence().move(oldId, newId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$findAffectedByBlackout$3(Date endDate$1, Task task) {
        TaskStatus taskStatus = task.getStatus();
        TaskStatus taskStatus2 = TaskStatus.PENDING;
        if (taskStatus == null) {
            if (taskStatus2 != null) {
                return false;
            }
        } else if (!taskStatus.equals(taskStatus2)) return false;
        if (!task.isPostponedDueToBlackout()) return false;
        Date date = task.getScheduledStartDate();
        Date date2 = endDate$1;
        if (date == null) {
            if (date2 == null) return true;
            return false;
        } else {
            if (!((Object)date).equals(date2)) return false;
            return true;
        }
    }

    public SqlTaskRepository(ReleasePersistence releasePersistence, DependencyPersistence dependencyPersistence, TaskPersistence taskPersistence, CommentRepository commentRepository, SqlRepositoryAdapter repositoryAdapter, ConfigurationReferencePersistence configurationPersistence, FacetRepositoryDispatcher facetRepositoryDispatcher, SqlBuilder.Dialect dialect) {
        this.releasePersistence = releasePersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.taskPersistence = taskPersistence;
        this.commentRepository = commentRepository;
        this.repositoryAdapter = repositoryAdapter;
        this.configurationPersistence = configurationPersistence;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.dialect = dialect;
        TaskRepository.$init$((TaskRepository)this);
        BaseReleaseItemRepository.$init$(this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        Logging.$init$((Logging)this);
    }
}

