package com.xebialabs.xlrelease.spring.config

import com.xebialabs.deployit.security.{PermissionChecker, PermissionEditor, PermissionLister, UserService}
import com.xebialabs.xlrelease.security.sql.{SqlPermissionChecker, SqlPermissionEditor, SqlPermissionLister, SqlRoleService, SqlUserService}
import org.springframework.context.annotation.{Bean, Configuration}

@Configuration
class SqlSecurityConfiguration(sqlConfiguration: SqlConfiguration) {

  @Bean
  def roleService(): SqlRoleService = {
    new SqlRoleService(sqlConfiguration.xlrRepositoryDatabase())
  }

  @Bean
  def userService(): UserService = {
    new SqlUserService(sqlConfiguration.xlrRepositoryDatabase())
  }

  @Bean
  def permissionLister(): PermissionLister = {
    new SqlPermissionLister(sqlConfiguration.xlrRepositoryDatabase())
  }

  @Bean
  def permissionEditor(): PermissionEditor = {
    new SqlPermissionEditor(sqlConfiguration.xlrRepositoryDatabase(), roleService())
  }

  @Bean
  def xlrPermissionChecker(): PermissionChecker = {
    new SqlPermissionChecker(sqlConfiguration.xlrRepositoryDatabase())
  }

}
