/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql.persistence;

import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.Token$;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow$Root$;
import com.xebialabs.xlrelease.security.sql.db.SecuritySchema;
import com.xebialabs.xlrelease.utils.FolderId;
import java.io.Serializable;
import java.util.UUID;
import org.springframework.jdbc.core.RowMapper;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;

public final class FindDescendantsQueryBuilder$ {
    public static final FindDescendantsQueryBuilder$ MODULE$ = new FindDescendantsQueryBuilder$();
    private static final String selectDescendants = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       | SELECT DISTINCT\n       |   d." + Schema.VIEW$.MODULE$.FOLDER_ID() + ",\n       |   d." + Schema.VIEW$.MODULE$.FOLDER_PATH() + ",\n       |   d." + Schema.VIEW$.MODULE$.DESCENDANT_UID() + ",\n       |   d." + Schema.VIEW$.MODULE$.SECURITY_UID() + ",\n       |   d." + Schema.VIEW$.MODULE$.TOKEN() + ",\n       |   d." + Schema.VIEW$.MODULE$.NAME() + ",\n       |   p." + Schema.PATHS$.MODULE$.ANCESTOR_UID() + ",\n       |   d." + Schema.VIEW$.MODULE$.DEPTH() + "\n       | FROM " + Schema.FOLDERS$.MODULE$.TABLE() + " f\n       "));
    private static final String descendantsOf = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       | JOIN " + Schema.VIEW$.MODULE$.TABLE() + " d\n       |    ON ( d." + Schema.VIEW$.MODULE$.ANCESTOR_UID() + " = f." + Schema.FOLDERS$.MODULE$.CI_UID() + " AND d." + Schema.PATHS$.MODULE$.DEPTH() + " <= :depth )\n       "));
    private static final String parentOf = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       | JOIN " + Schema.PATHS$.MODULE$.TABLE() + " p\n       |    ON  ( p." + Schema.PATHS$.MODULE$.DESCENDANT_UID() + " = d." + Schema.VIEW$.MODULE$.DESCENDANT_UID() + "\n       |          AND (     p." + Schema.PATHS$.MODULE$.DEPTH() + " = 1\n       |               OR ( p." + Schema.PATHS$.MODULE$.DEPTH() + " = 0 AND p." + Schema.PATHS$.MODULE$.ANCESTOR_UID() + " = " + FolderRow$Root$.MODULE$.uid() + " ) ) )\n       "));
    private static final String folderIdCondition = "f." + Schema.FOLDERS$.MODULE$.FOLDER_ID() + " = :folderId";
    private static final String folderUidCondition = "f." + Schema.FOLDERS$.MODULE$.CI_UID() + " = :ciUid";
    private static final String findAncestorByIdAndPermission = MODULE$.findAncestorWithPermission(MODULE$.folderIdCondition());
    private static final String findAncestorById = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       | WHERE " + MODULE$.folderIdCondition() + "\n       "));
    private static final String findAncestorByUidAndPermission = MODULE$.findAncestorWithPermission(MODULE$.folderUidCondition());
    private static final String findAncestorByUid = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       | WHERE " + MODULE$.folderUidCondition() + "\n       "));
    private static final String grouped = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       | GROUP BY\n       |  d." + Schema.VIEW$.MODULE$.DESCENDANT_UID() + ",\n       |  p." + Schema.PATHS$.MODULE$.ANCESTOR_UID() + ",\n       |  d." + Schema.VIEW$.MODULE$.SECURITY_UID() + ",\n       |  d." + Schema.VIEW$.MODULE$.TOKEN() + ",\n       |  d." + Schema.VIEW$.MODULE$.FOLDER_PATH() + ",\n       |  d." + Schema.VIEW$.MODULE$.FOLDER_ID() + ",\n       |  d." + Schema.VIEW$.MODULE$.NAME() + ",\n       |  d." + Schema.VIEW$.MODULE$.DEPTH() + "\n       "));
    private static final String topDownOrder = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       | ORDER BY\n       |   d." + Schema.VIEW$.MODULE$.DEPTH() + " ASC,\n       |   d." + Schema.VIEW$.MODULE$.NAME() + " ASC,\n       |   p." + Schema.PATHS$.MODULE$.ANCESTOR_UID() + " ASC,\n       |   d." + Schema.VIEW$.MODULE$.DESCENDANT_UID() + " ASC\n      "));
    private static final RowMapper<FolderRow> toFolderData = Utils$.MODULE$.rowMapper((Function1 & Serializable)rs -> {
        int uid = rs.getInt(Schema.VIEW$.MODULE$.DESCENDANT_UID());
        if (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)uid), (Object)FolderRow$Root$.MODULE$.uid())) {
            return FolderRow$Root$.MODULE$;
        }
        return new FolderRow.FolderEntry(Predef$.MODULE$.int2Integer(uid), (UUID)Token$.MODULE$.fromString(rs.getString(Schema.VIEW$.MODULE$.TOKEN())).get(), Predef$.MODULE$.int2Integer(rs.getInt(Schema.VIEW$.MODULE$.SECURITY_UID())), new FolderId(rs.getString(Schema.VIEW$.MODULE$.FOLDER_PATH())).$div(rs.getString(Schema.VIEW$.MODULE$.FOLDER_ID())), rs.getString(Schema.VIEW$.MODULE$.NAME()), Predef$.MODULE$.int2Integer(rs.getInt(Schema.PATHS$.MODULE$.ANCESTOR_UID())), rs.getInt(Schema.VIEW$.MODULE$.DEPTH()));
    });

    private String selectDescendants() {
        return selectDescendants;
    }

    private String descendantsOf() {
        return descendantsOf;
    }

    private String parentOf() {
        return parentOf;
    }

    private String findAncestorWithPermission(String folderCondition) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       | LEFT JOIN " + SecuritySchema.ROLES$.MODULE$.TABLE() + " roles ON d." + Schema.FOLDERS$.MODULE$.SECURITY_UID() + " = roles." + SecuritySchema.ROLES$.MODULE$.ciId() + "\n       | LEFT JOIN " + SecuritySchema.ROLE_PERMISSIONS$.MODULE$.TABLE() + " permissions\n       |  ON roles." + SecuritySchema.ROLES$.MODULE$.id() + " = permissions." + SecuritySchema.ROLE_PERMISSIONS$.MODULE$.roleId() + "\n       | LEFT JOIN " + SecuritySchema.ROLE_ROLES$.MODULE$.TABLE() + " teamRoles\n       |  ON roles." + SecuritySchema.ROLES$.MODULE$.id() + " = teamRoles." + SecuritySchema.ROLE_ROLES$.MODULE$.roleId() + "\n       | LEFT JOIN " + SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE() + " rolePrincipals\n       |  ON teamRoles." + SecuritySchema.ROLE_ROLES$.MODULE$.memberRoleId() + " = rolePrincipals." + SecuritySchema.ROLE_PRINCIPALS$.MODULE$.roleId() + "\n       | LEFT JOIN " + SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE() + " teamPrincipals\n       |  ON roles." + SecuritySchema.ROLES$.MODULE$.id() + " = teamPrincipals." + SecuritySchema.ROLE_PRINCIPALS$.MODULE$.roleId() + "\n       | WHERE\n       |  " + folderCondition + "\n       |  AND (\n       |    f." + Schema.FOLDERS$.MODULE$.FOLDER_ID() + " = d." + Schema.FOLDERS$.MODULE$.FOLDER_ID() + "\n       |    OR (\n       |      permissions." + SecuritySchema.ROLE_PERMISSIONS$.MODULE$.permissionName() + " = :permissionName\n       |      AND (\n       |        LOWER(rolePrincipals." + SecuritySchema.ROLE_PRINCIPALS$.MODULE$.principalName() + ") IN (:principalNames)\n       |        OR\n       |        LOWER(teamPrincipals." + SecuritySchema.ROLE_PRINCIPALS$.MODULE$.principalName() + ") IN (:principalNames)\n       |      )\n       |    )\n       |  )\n     "));
    }

    private String folderIdCondition() {
        return folderIdCondition;
    }

    private String folderUidCondition() {
        return folderUidCondition;
    }

    private String findAncestorByIdAndPermission() {
        return findAncestorByIdAndPermission;
    }

    private String findAncestorById() {
        return findAncestorById;
    }

    private String findAncestorByUidAndPermission() {
        return findAncestorByUidAndPermission;
    }

    private String findAncestorByUid() {
        return findAncestorByUid;
    }

    private String grouped() {
        return grouped;
    }

    private String topDownOrder() {
        return topDownOrder;
    }

    public RowMapper<FolderRow> toFolderData() {
        return toFolderData;
    }

    public String findByUid() {
        return StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(this.selectDescendants()), this.descendantsOf())), this.parentOf())), this.findAncestorByUid())), this.grouped())), this.topDownOrder());
    }

    public String findByUidHavingPermission() {
        return StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(this.selectDescendants()), this.descendantsOf())), this.parentOf())), this.findAncestorByUidAndPermission())), this.grouped())), this.topDownOrder());
    }

    public String findById() {
        return StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(this.selectDescendants()), this.descendantsOf())), this.parentOf())), this.findAncestorById())), this.grouped())), this.topDownOrder());
    }

    public String findByIdHavingPermission() {
        return StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(this.selectDescendants()), this.descendantsOf())), this.parentOf())), this.findAncestorByIdAndPermission())), this.grouped())), this.topDownOrder());
    }

    private FindDescendantsQueryBuilder$() {
    }
}

