package com.xebialabs.xlrelease.repository.sql.persistence

import com.xebialabs.xlrelease.domain.events.{ReleaseActorStarted, ReleaseActorStopped}
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}


@EventListener
class ReleaseCacheEventHandler {

  @Subscribe
  def onActorStart(event: ReleaseActorStarted): Unit = {
    ReleaseCacheService.invalidate(event.releaseId)
    ReleaseCacheService.allow(event.releaseId)
  }

  @Subscribe
  def onActorStop(event: ReleaseActorStopped): Unit = {
    ReleaseCacheService.disallow(event.releaseId)
    ReleaseCacheService.invalidate(event.releaseId)
  }

}
