/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.CiWithUid;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.DependencyTarget;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.status.PhaseStatus;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.repository.DependencyTargetLoader;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PhaseRepository;
import com.xebialabs.xlrelease.repository.sql.BaseReleaseItemRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskTagsPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.TasksSqlBuilder$;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0005}e\u0001\u0002\r\u001a\u0001\u0011B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A\u0011\t\u0001BC\u0002\u0013\u0005!\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003D\u0011!Q\u0005A!b\u0001\n\u0003Y\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u0011A\u0003!Q1A\u0005\u0002EC\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\t-\u0002\u0011)\u0019!C\u0001/\"A1\f\u0001B\u0001B\u0003%\u0001\f\u0003\u0005]\u0001\t\u0015\r\u0011\"\u0001^\u0011!\t\u0007A!A!\u0002\u0013q\u0006\u0002\u00032\u0001\u0005\u000b\u0007I\u0011A2\t\u0011\u001d\u0004!\u0011!Q\u0001\n\u0011DQ\u0001\u001b\u0001\u0005\u0002%DQa\u001d\u0001\u0005\u0002QDq!a\n\u0001\t\u0003\nI\u0003C\u0004\u00020\u0001!\t%!\r\t\u000f\u0005\r\u0003\u0001\"\u0011\u0002F!9\u0011Q\n\u0001\u0005B\u0005=\u0003bBA/\u0001\u0011\u0005\u0013q\f\u0005\b\u0003S\u0002A\u0011IA6\u0011\u001d\t)\t\u0001C!\u0003\u000f\u0013!cU9m!\"\f7/\u001a*fa>\u001c\u0018\u000e^8ss*\u0011!dG\u0001\u0004gFd'B\u0001\u000f\u001e\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003=}\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005\u0001\n\u0013!\u0003=fE&\fG.\u00192t\u0015\u0005\u0011\u0013aA2p[\u000e\u00011#\u0002\u0001&W=\u001a\u0004C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#AB!osJ+g\r\u0005\u0002-[5\t1$\u0003\u0002/7\ty\u0001\u000b[1tKJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00021c5\t\u0011$\u0003\u000233\tI\")Y:f%\u0016dW-Y:f\u0013R,WNU3q_NLGo\u001c:z!\t\u0001D'\u0003\u000263\tq2i\u001c8gS\u001e,(/\u0019;j_:\u0014VMZ3sK:\u001cWm]*vaB|'\u000f^\u0001\u0013e\u0016dW-Y:f!\u0016\u00148/[:uK:\u001cW\r\u0005\u00029w5\t\u0011H\u0003\u0002;3\u0005Y\u0001/\u001a:tSN$XM\\2f\u0013\ta\u0014H\u0001\nSK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0017a\u0004;bg.\u0004VM]:jgR,gnY3\u0011\u0005az\u0014B\u0001!:\u0005=!\u0016m]6QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\u0001G2p]\u001aLw-\u001e:bi&|g\u000eU3sg&\u001cH/\u001a8dKV\t1\t\u0005\u0002E\u000f6\tQI\u0003\u0002Gs\u0005i1m\u001c8gS\u001e,(/\u0019;j_:L!\u0001S#\u0003C\r{gNZ5hkJ\fG/[8o%\u00164WM]3oG\u0016\u0004VM]:jgR,gnY3\u00023\r|gNZ5hkJ\fG/[8o!\u0016\u00148/[:uK:\u001cW\rI\u0001\u0013G>lW.\u001a8u!\u0016\u00148/[:uK:\u001cW-F\u0001M!\tAT*\u0003\u0002Os\t\u00112i\\7nK:$\b+\u001a:tSN$XM\\2f\u0003M\u0019w.\\7f]R\u0004VM]:jgR,gnY3!\u0003Y!W\r]3oI\u0016t7-\u001f+be\u001e,G\u000fT8bI\u0016\u0014X#\u0001*\u0011\u00051\u001a\u0016B\u0001+\u001c\u0005Y!U\r]3oI\u0016t7-\u001f+be\u001e,G\u000fT8bI\u0016\u0014\u0018a\u00063fa\u0016tG-\u001a8dsR\u000b'oZ3u\u0019>\fG-\u001a:!\u0003U!W\r]3oI\u0016t7-\u001f)feNL7\u000f^3oG\u0016,\u0012\u0001\u0017\t\u0003qeK!AW\u001d\u0003+\u0011+\u0007/\u001a8eK:\u001c\u0017\u0010U3sg&\u001cH/\u001a8dK\u00061B-\u001a9f]\u0012,gnY=QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%A\rgC\u000e,GOU3q_NLGo\u001c:z\t&\u001c\b/\u0019;dQ\u0016\u0014X#\u00010\u0011\u00051z\u0016B\u00011\u001c\u0005e1\u0015mY3u%\u0016\u0004xn]5u_JLH)[:qCR\u001c\u0007.\u001a:\u00025\u0019\f7-\u001a;SKB|7/\u001b;pef$\u0015n\u001d9bi\u000eDWM\u001d\u0011\u0002#I,\u0007o\\:ji>\u0014\u00180\u00113baR,'/F\u0001e!\t\u0001T-\u0003\u0002g3\t!2+\u001d7SKB|7/\u001b;pef\fE-\u00199uKJ\f!C]3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3sA\u00051A(\u001b8jiz\"\u0012B[6m[:|\u0007/\u001d:\u0011\u0005A\u0002\u0001\"\u0002\u001c\u0010\u0001\u00049\u0004\"B\u001f\u0010\u0001\u0004q\u0004\"B!\u0010\u0001\u0004\u0019\u0005\"\u0002&\u0010\u0001\u0004a\u0005\"\u0002)\u0010\u0001\u0004\u0011\u0006\"\u0002,\u0010\u0001\u0004A\u0006\"\u0002/\u0010\u0001\u0004q\u0006\"\u00022\u0010\u0001\u0004!\u0017!\u00074j]\u0012\u0014\u00150\u00133XSRDw.\u001e;EK\u000e|'/\u0019;peN$\"!^>\u0011\u0005YLX\"A<\u000b\u0005al\u0012A\u00023p[\u0006Lg.\u0003\u0002{o\n)\u0001\u000b[1tK\")A\u0010\u0005a\u0001{\u00069\u0001\u000f[1tK&#\u0007c\u0001@\u0002\f9\u0019q0a\u0002\u0011\u0007\u0005\u0005q%\u0004\u0002\u0002\u0004)\u0019\u0011QA\u0012\u0002\rq\u0012xn\u001c;?\u0013\r\tIaJ\u0001\u0007!J,G-\u001a4\n\t\u00055\u0011q\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%q\u0005K\u0002\u0011\u0003'\u0001B!!\u0006\u0002$5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"\u0001\u0006b]:|G/\u0019;j_:TA!!\b\u0002 \u00059Q.\u001a;sS\u000e\u001c(bAA\u0011C\u0005A1m\u001c3bQ\u0006dW-\u0003\u0003\u0002&\u0005]!!\u0002+j[\u0016$\u0017\u0001\u00034j]\u0012\u0014\u00150\u00133\u0015\u0007U\fY\u0003C\u0003}#\u0001\u0007Q\u0010K\u0002\u0012\u0003'\taa\u0019:fCR,G#B;\u00024\u0005u\u0002bBA\u001b%\u0001\u0007\u0011qG\u0001\be\u0016dW-Y:f!\r1\u0018\u0011H\u0005\u0004\u0003w9(a\u0002*fY\u0016\f7/\u001a\u0005\u0007\u0003\u007f\u0011\u0002\u0019A;\u0002\u000bAD\u0017m]3)\u0007I\t\u0019\"\u0001\u0004eK2,G/\u001a\u000b\u0006k\u0006\u001d\u0013\u0011\n\u0005\b\u0003k\u0019\u0002\u0019AA\u001c\u0011\u0019\tyd\u0005a\u0001k\"\u001a1#a\u0005\u0002\rU\u0004H-\u0019;f)\u001d)\u0018\u0011KA*\u0003/Bq!!\u000e\u0015\u0001\u0004\t9\u0004\u0003\u0004\u0002VQ\u0001\r!^\u0001\t_JLw-\u001b8bY\"1\u0011\u0011\f\u000bA\u0002U\fq!\u001e9eCR,G\rK\u0002\u0015\u0003'\tA!\\8wKR)Q/!\u0019\u0002d!9\u0011QG\u000bA\u0002\u0005]\u0002BBA3+\u0001\u0007Q/\u0001\u0006n_Z,G\r\u00155bg\u0016D3!FA\n\u0003!9W\r\u001e+ji2,GcA?\u0002n!)AP\u0006a\u0001{\"\u001aa#!\u001d\u0011\t\u0005M\u0014qP\u0007\u0003\u0003kRA!a\u001e\u0002z\u0005YAO]1og\u0006\u001cG/[8o\u0015\rQ\u00121\u0010\u0006\u0004\u0003{j\u0012A\u00013c\u0013\u0011\t\t)!\u001e\u0003\u0015%\u001b(+Z1e\u001f:d\u0017\u0010K\u0002\u0017\u0003'\t\u0011bZ3u'R\fG/^:\u0015\t\u0005%\u0015Q\u0013\t\u0005\u0003\u0017\u000b\t*\u0004\u0002\u0002\u000e*\u0019\u0011qR<\u0002\rM$\u0018\r^;t\u0013\u0011\t\u0019*!$\u0003\u0017AC\u0017m]3Ti\u0006$Xo\u001d\u0005\u0006y^\u0001\r! \u0015\u0004\u0001\u0005e\u0005\u0003BA:\u00037KA!!(\u0002v\ty\u0011j\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000e")
public class SqlPhaseRepository
implements PhaseRepository,
BaseReleaseItemRepository,
ConfigurationReferencesSupport {
    private final ReleasePersistence releasePersistence;
    private final TaskPersistence taskPersistence;
    private final ConfigurationReferencePersistence configurationPersistence;
    private final CommentPersistence commentPersistence;
    private final DependencyTargetLoader dependencyTargetLoader;
    private final DependencyPersistence dependencyPersistence;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final SqlRepositoryAdapter repositoryAdapter;

    @Override
    public void updateConfigurationRefs(CiWithUid entity) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, entity);
    }

    @Override
    public void deleteConfigurationRefs(Integer uid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, uid);
    }

    @Override
    public Release getRelease(String releaseId, String entityId) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId);
    }

    @Override
    public Release getRelease(String releaseId, String entityId, ResolveOptions resolveOptions) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId, resolveOptions);
    }

    @Override
    public <T> T notNull(T ci, String ciId) {
        return (T)BaseReleaseItemRepository.notNull$(this, ci, ciId);
    }

    @Override
    public void insertDependencyWithGateTaskUid(Integer gateTaskUid, Dependency dependency) {
        BaseReleaseItemRepository.insertDependencyWithGateTaskUid$(this, gateTaskUid, dependency);
    }

    @Override
    public void insertDependency(Dependency dependency) {
        BaseReleaseItemRepository.insertDependency$(this, dependency);
    }

    @Override
    public void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        BaseReleaseItemRepository.checkIsNotReferencedByDependencies$(this, planItemIdOrItsChildren);
    }

    @Override
    public ConfigurationReferencePersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    public CommentPersistence commentPersistence() {
        return this.commentPersistence;
    }

    public DependencyTargetLoader dependencyTargetLoader() {
        return this.dependencyTargetLoader;
    }

    @Override
    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public FacetRepositoryDispatcher facetRepositoryDispatcher() {
        return this.facetRepositoryDispatcher;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Timed
    public Phase findByIdWithoutDecorators(String phaseId) {
        Release release = this.getRelease(Ids.releaseIdFrom((String)phaseId), phaseId, ResolveOptions$.MODULE$.WITHOUT_DECORATORS());
        return this.notNull(release.getPhase(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(phaseId))), phaseId);
    }

    @Timed
    public Phase findById(String phaseId) {
        Release release = this.getRelease(Ids.releaseIdFrom((String)phaseId), phaseId);
        return this.notNull(release.getPhase(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(phaseId))), phaseId);
    }

    @Timed
    public Phase create(Release release, Phase phase) {
        this.releasePersistence.update(release);
        Buffer tasks = CollectionConverters$.MODULE$.ListHasAsScala(phase.getAllTasks()).asScala();
        this.taskPersistence.batchInsert((Set<Task>)tasks.toSet(), Predef$.MODULE$.Integer2int(release.getCiUid()));
        Map<String, Integer> taskUidsByTaskId = this.taskPersistence.releaseTaskUids(Predef$.MODULE$.Integer2int(release.getCiUid()));
        tasks.foreach((Function1 & Serializable)task -> {
            task.setCiUid((Integer)taskUidsByTaskId.apply((Object)Ids.getFolderlessId((String)task.getId())));
            return BoxedUnit.UNIT;
        });
        Buffer taskTags = (Buffer)tasks.flatMap((Function1 & Serializable)t -> (Set)Predef$.MODULE$.Set().from((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(t.getTags()).asScala().map((Function1 & Serializable)tag -> TasksSqlBuilder$.MODULE$.normalizeTag((String)tag))).flatMap((Function1 & Serializable)tag -> taskUidsByTaskId.get((Object)CiId$RichCiId$.MODULE$.shortId$extension(CiId$.MODULE$.RichCiId(t.getId()))).map((Function1 & Serializable)taskUid -> new TaskTagsPersistence.TaskTag((Integer)taskUid, (String)tag))));
        this.taskPersistence.batchInsertTags((List<TaskTagsPersistence.TaskTag>)taskTags.toList());
        Set filteredTasks = ((IterableOnceOps)((IterableOps)tasks.flatMap((Function1 & Serializable)x$1 -> syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(x$1)))).map((Function1 & Serializable)x$2 -> x$2.getGateTask())).toSet();
        Set taskDependencies = (Set)filteredTasks.flatMap((Function1 & Serializable)t -> (Iterable)((IterableOps)syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps((Task)t)).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isArchived()))).flatMap((Function1 & Serializable)dependency -> taskUidsByTaskId.get((Object)CiId$RichCiId$.MODULE$.shortId$extension(CiId$.MODULE$.RichCiId(t.getId()))).map((Function1 & Serializable)taskUid -> new DependencyPersistence.TaskDependency((Integer)taskUid, (Dependency)dependency))));
        this.dependencyPersistence().batchInsert((Set<DependencyPersistence.TaskDependency>)taskDependencies);
        this.updateConfigurationRefs((CiWithUid)release);
        this.facetRepositoryDispatcher().liveRepository().createFromTasks(CollectionConverters$.MODULE$.ListHasAsScala(phase.getAllTasks()).asScala().toSeq(), this.facetRepositoryDispatcher().liveRepository().createFromTasks$default$2());
        return phase;
    }

    @Timed
    public Phase delete(Release release, Phase phase) {
        this.checkIsNotReferencedByDependencies(phase.getId());
        Integer releaseUid = release.getCiUid();
        this.releasePersistence.updateReleaseJson(releaseUid, release);
        Iterator taskCiUidChunks = ((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(phase.getAllTasks()).asScala().map((Function1 & Serializable)x$4 -> x$4.getCiUid())).grouped(100);
        taskCiUidChunks.foreach((Function1 & Serializable)taskCiUids -> {
            SqlPhaseRepository.$anonfun$delete$2(this, taskCiUids);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs((CiWithUid)release);
        return phase;
    }

    @Timed
    public Phase update(Release release, Phase original, Phase updated) {
        this.releasePersistence.update(release);
        return updated;
    }

    @Timed
    public Phase move(Release release, Phase movedPhase) {
        this.releasePersistence.update(release);
        return movedPhase;
    }

    @Timed
    @IsReadOnly
    public String getTitle(String phaseId) {
        DependencyTarget target = this.dependencyTargetLoader().getDependencyNodeData(phaseId);
        return target.phaseTitle();
    }

    public PhaseStatus getStatus(String phaseId) {
        DependencyTarget target = this.dependencyTargetLoader().getDependencyNodeData(phaseId);
        return target.phaseStatus();
    }

    public static final /* synthetic */ void $anonfun$delete$2(SqlPhaseRepository $this, Buffer taskCiUids) {
        $this.dependencyPersistence().deleteByTaskUids((Seq<Integer>)taskCiUids.toSeq());
        $this.commentPersistence().deleteAllByTaskUids((Seq<Integer>)taskCiUids.toSeq());
        $this.taskPersistence.deleteByUids((Seq<Integer>)taskCiUids.toSeq());
    }

    public SqlPhaseRepository(ReleasePersistence releasePersistence, TaskPersistence taskPersistence, ConfigurationReferencePersistence configurationPersistence, CommentPersistence commentPersistence, DependencyTargetLoader dependencyTargetLoader, DependencyPersistence dependencyPersistence, FacetRepositoryDispatcher facetRepositoryDispatcher, SqlRepositoryAdapter repositoryAdapter) {
        this.releasePersistence = releasePersistence;
        this.taskPersistence = taskPersistence;
        this.configurationPersistence = configurationPersistence;
        this.commentPersistence = commentPersistence;
        this.dependencyTargetLoader = dependencyTargetLoader;
        this.dependencyPersistence = dependencyPersistence;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.repositoryAdapter = repositoryAdapter;
        BaseReleaseItemRepository.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
    }
}

