/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.customscripts.ScriptTypes;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.utils.TaskTypes;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.service.NewType;
import com.xebialabs.xlrelease.service.NewType$;
import com.xebialabs.xlrelease.service.SqlTaskTypeConversion$;
import com.xebialabs.xlrelease.service.TaskTypeConversion;
import com.xebialabs.xlrelease.service.TaskTypeConverterSyntax$;
import com.xebialabs.xlrelease.service.TaskTypeConverters$;
import java.io.Serializable;
import org.springframework.stereotype.Component;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@IsTransactional
@Component
@ScalaSignature(bytes="\u0006\u0005\u0005eu!B\r\u001b\u0011\u0003\u0019c!B\u0013\u001b\u0011\u00031\u0003\"B\u0017\u0002\t\u0003q\u0003bB\u0018\u0002\u0005\u0004%I\u0001\r\u0005\u0007{\u0005\u0001\u000b\u0011B\u0019\t\u000fy\n!\u0019!C\u0005a!1q(\u0001Q\u0001\nEBq\u0001Q\u0001C\u0002\u0013%\u0001\u0007\u0003\u0004B\u0003\u0001\u0006I!\r\u0005\b\u0005\u0006\u0011\r\u0011\"\u00031\u0011\u0019\u0019\u0015\u0001)A\u0005c\u0019!QE\u0007\u0001E\u0011!\u00016B!A!\u0002\u0013\t\u0006\u0002C,\f\u0005\u0003\u0005\u000b\u0011\u0002-\t\u0011y[!\u0011!Q\u0001\n}C\u0001\"Z\u0006\u0003\u0002\u0003\u0006IA\u001a\u0005\u0006[-!\tA\u001c\u0005\u0006i.!\t%\u001e\u0005\b\u0003/YA\u0011BA\r\u0011\u001d\tyc\u0003C\u0005\u0003cAq!!\u000e\f\t\u0013\t9\u0004C\u0004\u0002B-!I!a\u0011\t\u000f\u0005\u001d3\u0002\"\u0003\u0002J!9\u0011QJ\u0006\u0005\n\u0005=\u0003bBA5\u0017\u0011%\u00111N\u0001\u0016'FdG+Y:l)f\u0004XmQ8om\u0016\u00148/[8o\u0015\tYB$A\u0004tKJ4\u0018nY3\u000b\u0005uq\u0012!\u0003=me\u0016dW-Y:f\u0015\ty\u0002%A\u0005yK\nL\u0017\r\\1cg*\t\u0011%A\u0002d_6\u001c\u0001\u0001\u0005\u0002%\u00035\t!DA\u000bTc2$\u0016m]6UsB,7i\u001c8wKJ\u001c\u0018n\u001c8\u0014\u0005\u00059\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002G\u0005\u0019B+\u0017)F?\u000e{e\nV!J\u001d\u0016\u0013v\fV!T\u0017V\t\u0011\u0007\u0005\u00023w5\t1G\u0003\u00025k\u00059!/\u001a4mK\u000e$(B\u0001\u001c8\u0003\r\t\u0007/\u001b\u0006\u0003qe\na\u0001\u001d7vO&t'B\u0001\u001e\u001f\u0003!!W\r\u001d7ps&$\u0018B\u0001\u001f4\u0005\u0011!\u0016\u0010]3\u0002)QK\u0006+R0D\u001f:#\u0016)\u0013(F%~#\u0016iU&!\u0003]!\u0016\fU#`\u0007V\u001bFkT'`'\u000e\u0013\u0016\n\u0015+`)\u0006\u001b6*\u0001\rU3B+ulQ+T)>kulU\"S\u0013B#v\fV!T\u0017\u0002\n\u0011\u0002V-Q\u000b~#\u0016iU&\u0002\u0015QK\u0006+R0U\u0003N[\u0005%A\bU3B+u\fV!T\u0017~;%kT+Q\u0003A!\u0016\fU#`)\u0006\u001b6jX$S\u001fV\u0003\u0006eE\u0002\f\u000b6\u0003\"AR&\u000e\u0003\u001dS!\u0001S%\u0002\t1\fgn\u001a\u0006\u0002\u0015\u0006!!.\u0019<b\u0013\tauI\u0001\u0004PE*,7\r\u001e\t\u0003I9K!a\u0014\u000e\u0003%Q\u000b7o\u001b+za\u0016\u001cuN\u001c<feNLwN\\\u0001\fg\u000e\u0014\u0018\u000e\u001d;UsB,7\u000f\u0005\u0002S+6\t1K\u0003\u0002U9\u0005i1-^:u_6\u001c8M]5qiNL!AV*\u0003\u0017M\u001b'/\u001b9u)f\u0004Xm]\u0001\u000fi\u0006\u001c8NU3q_NLGo\u001c:z!\tIF,D\u0001[\u0015\tYF$\u0001\u0006sKB|7/\u001b;pefL!!\u0018.\u0003\u001dQ\u000b7o\u001b*fa>\u001c\u0018\u000e^8ss\u0006AQM^3oi\n+8\u000f\u0005\u0002aG6\t\u0011M\u0003\u0002c9\u00051QM^3oiNL!\u0001Z1\u0003#ac%+\u001a7fCN,WI^3oi\n+8/A\u000beKB,g\u000eZ3oGf\u0004VM]:jgR,gnY3\u0011\u0005\u001ddW\"\u00015\u000b\u0005%T\u0017a\u00039feNL7\u000f^3oG\u0016T!a\u001b.\u0002\u0007M\fH.\u0003\u0002nQ\n)B)\u001a9f]\u0012,gnY=QKJ\u001c\u0018n\u001d;f]\u000e,G#B8qcJ\u001c\bC\u0001\u0013\f\u0011\u0015\u0001\u0006\u00031\u0001R\u0011\u00159\u0006\u00031\u0001Y\u0011\u0015q\u0006\u00031\u0001`\u0011\u0015)\u0007\u00031\u0001g\u0003Q\u0019\u0007.\u00198hK\u0006\u001bG/\u001b<f)\u0006\u001c8\u000eV=qKR\u0019a\u000f @\u0011\u0005]TX\"\u0001=\u000b\u0005ed\u0012A\u00023p[\u0006Lg.\u0003\u0002|q\n!A+Y:l\u0011\u0015i\u0018\u00031\u0001w\u0003\u0011!\u0018m]6\t\u000b}\f\u0002\u0019A\u0019\u0002\u0015Q\f'oZ3u)f\u0004X\rK\u0002\u0012\u0003\u0007\u0001B!!\u0002\u0002\u00145\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0006b]:|G/\u0019;j_:TA!!\u0004\u0002\u0010\u00059Q.\u001a;sS\u000e\u001c(bAA\tA\u0005A1m\u001c3bQ\u0006dW-\u0003\u0003\u0002\u0016\u0005\u001d!!\u0002+j[\u0016$\u0017AG2iK\u000e\\G+\u001f9f\u0007\"\fgnZ3JgN+\b\u000f]8si\u0016$GCBA\u000e\u0003C\tY\u0003E\u0002)\u0003;I1!a\b*\u0005\u0011)f.\u001b;\t\u000f\u0005\r\"\u00031\u0001\u0002&\u00059a.Z<UsB,\u0007c\u0001\u0013\u0002(%\u0019\u0011\u0011\u0006\u000e\u0003\u000f9+w\u000fV=qK\"1\u0011Q\u0006\nA\u0002Y\fqa\u001c7e)\u0006\u001c8.\u0001\bsKN|GN^3OK^$\u0016\u0010]3\u0015\t\u0005\u0015\u00121\u0007\u0005\u0006\u007fN\u0001\r!M\u0001\u000fSN\u0004\u0016\u0010\u001e5p]N\u001b'/\u001b9u)\u0011\tI$a\u0010\u0011\u0007!\nY$C\u0002\u0002>%\u0012qAQ8pY\u0016\fg\u000eC\u0003\u0000)\u0001\u0007\u0011'A\bjg\u000e{g\u000e^1j]\u0016\u0014H+Y:l)\u0011\tI$!\u0012\t\u000b},\u0002\u0019A\u0019\u0002%\rDWmY6UCN\\\u0017j\u001d)mC:tW\r\u001a\u000b\u0005\u00037\tY\u0005C\u0003~-\u0001\u0007a/\u0001\u000bhKR\fE\u000e\\*vaB|'\u000f^3e)f\u0004Xm]\u000b\u0003\u0003#\u0002R!a\u0015\u0002dErA!!\u0016\u0002`9!\u0011qKA/\u001b\t\tIFC\u0002\u0002\\\t\na\u0001\u0010:p_Rt\u0014\"\u0001\u0016\n\u0007\u0005\u0005\u0014&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0015\u0014q\r\u0002\u0004'\u0016\f(bAA1S\u0005I\u0002/\u001e:hK\u001e\u000bG/\u001a+bg.$U\r]3oI\u0016t7-[3t)\u0011\tY\"!\u001c\t\u000buD\u0002\u0019\u0001<)\u0007-\t\t\b\u0005\u0003\u0002t\u0005\u0005UBAA;\u0015\u0011\t9(!\u001f\u0002\u0015M$XM]3pif\u0004XM\u0003\u0003\u0002|\u0005u\u0014aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\u0005}\u0014aA8sO&!\u00111QA;\u0005%\u0019u.\u001c9p]\u0016tG\u000fK\u0002\f\u0003\u000f\u0003B!!#\u0002\u00166\u0011\u00111\u0012\u0006\u0005\u0003\u001b\u000by)A\u0006ue\u0006t7/Y2uS>t'bA6\u0002\u0012*\u0019\u00111\u0013\u000f\u0002\u0005\u0011\u0014\u0017\u0002BAL\u0003\u0017\u0013q\"S:Ue\u0006t7/Y2uS>t\u0017\r\u001c")
public class SqlTaskTypeConversion
implements TaskTypeConversion {
    private final ScriptTypes scriptTypes;
    private final TaskRepository taskRepository;
    private final XLReleaseEventBus eventBus;
    private final DependencyPersistence dependencyPersistence;

    @Timed
    public Task changeActiveTaskType(Task task, Type targetType) {
        Object object;
        boolean isNotCustomScriptTypeOrItHasNotChanged;
        this.checkTaskIsPlanned(task);
        NewType newType = this.resolveNewType(targetType);
        this.checkTypeChangeIsSupported(newType, task);
        Type type = task.getType();
        Type type2 = newType.ciType();
        boolean ciTypeHasNotChanged = !(type != null ? !type.equals(type2) : type2 != null);
        Type type3 = task.getTaskType();
        Object object2 = newType.customScriptType().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        boolean bl = !(type3 != null ? !type3.equals(object2) : object2 != null) ? true : (isNotCustomScriptTypeOrItHasNotChanged = false);
        if (ciTypeHasNotChanged && isNotCustomScriptTypeOrItHasNotChanged) {
            return task;
        }
        Type type4 = newType.ciType();
        Type type5 = SqlTaskTypeConversion$.MODULE$.com$xebialabs$xlrelease$service$SqlTaskTypeConversion$$TYPE_CUSTOM_SCRIPT_TASK();
        Type type6 = type4;
        if (!(type5 != null ? !type5.equals(type6) : type6 != null)) {
            object = TaskTypeConverterSyntax$.MODULE$.TaskTypeConverterOps(task).convertTo(newType, TaskTypeConverters$.MODULE$.toCustomScriptTaskConverter());
        } else {
            Type type7 = SqlTaskTypeConversion$.MODULE$.com$xebialabs$xlrelease$service$SqlTaskTypeConversion$$TYPE_CONTAINER_TASK();
            Type type8 = type4;
            object = !(type7 != null ? !type7.equals(type8) : type8 != null) ? TaskTypeConverterSyntax$.MODULE$.TaskTypeConverterOps(task).convertTo(newType, TaskTypeConverters$.MODULE$.toContainerTaskConverter()) : TaskTypeConverterSyntax$.MODULE$.TaskTypeConverterOps(task).convertTo(newType, TaskTypeConverters$.MODULE$.toTaskConverter());
        }
        CustomScriptTask updatedTask = object;
        this.purgeGateTaskDependencies(task);
        Task result = this.taskRepository.updateType((Task)updatedTask);
        this.eventBus.publish((XLReleaseEvent)new TaskUpdatedEvent(task, result));
        return result;
    }

    private void checkTypeChangeIsSupported(NewType newType, Task oldTask) {
        boolean newTypeIsTaskType = newType.ciType().instanceOf(SqlTaskTypeConversion$.MODULE$.com$xebialabs$xlrelease$service$SqlTaskTypeConversion$$TYPE_TASK());
        Checks.checkArgument((this.isPythonScript(newType.ciType()) || newTypeIsTaskType ? 1 : 0) != 0, (String)("Cannot change type of task '" + oldTask.getTitle() + "' to '" + newType + "' because it is not one of supported types: " + this.getAllSupportedTypes().mkString(",")), (Object[])new Object[0]);
        if (oldTask.getType().isSubTypeOf(SqlTaskTypeConversion$.MODULE$.com$xebialabs$xlrelease$service$SqlTaskTypeConversion$$TYPE_TASK_GROUP())) {
            throw new IllegalArgumentException("Conversion of task '" + oldTask.getTitle() + "' from '" + oldTask.getType() + "' is not supported.");
        }
    }

    private NewType resolveNewType(Type targetType) {
        if (this.isPythonScript(targetType)) {
            return new NewType(SqlTaskTypeConversion$.MODULE$.com$xebialabs$xlrelease$service$SqlTaskTypeConversion$$TYPE_CUSTOM_SCRIPT_TASK(), (Option<Type>)new Some((Object)targetType), NewType$.MODULE$.apply$default$3());
        }
        if (this.isContainerTask(targetType)) {
            return new NewType(SqlTaskTypeConversion$.MODULE$.com$xebialabs$xlrelease$service$SqlTaskTypeConversion$$TYPE_CONTAINER_TASK(), (Option<Type>)None$.MODULE$, (Option<Type>)new Some((Object)targetType));
        }
        return new NewType(targetType, (Option<Type>)None$.MODULE$, NewType$.MODULE$.apply$default$3());
    }

    private boolean isPythonScript(Type targetType) {
        return this.scriptTypes.getPythonScriptTypes().contains(targetType);
    }

    private boolean isContainerTask(Type targetType) {
        return this.scriptTypes.getContainerTaskTypes().contains(targetType);
    }

    private void checkTaskIsPlanned(Task task) {
        Checks.checkArgument((boolean)task.isPlanned(), (String)"Cannot change type of the task '%s' because it is in state %s and not %s", (Object[])new Object[]{task.getTitle(), task.getStatus(), TaskStatus.PLANNED});
    }

    private Seq<Type> getAllSupportedTypes() {
        return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(TaskTypes.getDefaultTaskTypes()).asScala().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.CollectionHasAsScala(this.scriptTypes.getPythonScriptTypes()).asScala())).$plus$plus((IterableOnce)CollectionConverters$.MODULE$.CollectionHasAsScala(this.scriptTypes.getContainerTaskTypes()).asScala())).toSeq();
    }

    private void purgeGateTaskDependencies(Task task) {
        Task task2 = task;
        if (task2 instanceof GateTask) {
            GateTask gateTask = (GateTask)task2;
            CollectionConverters$.MODULE$.ListHasAsScala(gateTask.getDependencies()).asScala().foreach((Function1 & Serializable)dependency -> {
                this.dependencyPersistence.deleteDependency(dependency);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public SqlTaskTypeConversion(ScriptTypes scriptTypes, TaskRepository taskRepository, XLReleaseEventBus eventBus, DependencyPersistence dependencyPersistence) {
        this.scriptTypes = scriptTypes;
        this.taskRepository = taskRepository;
        this.eventBus = eventBus;
        this.dependencyPersistence = dependencyPersistence;
    }
}

