package com.xebialabs.xlrelease.repository.sql

import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional
import com.xebialabs.xlrelease.repository.CustomPersistentTokenRepository
import com.xebialabs.xlrelease.repository.sql.persistence.TokenPersistence
import org.springframework.security.web.authentication.rememberme.PersistentRememberMeToken
import org.springframework.stereotype.Component

import java.util.{Date, List => JList}
import scala.jdk.CollectionConverters._

@Component
@IsTransactional
class SqlTokenRepository(tokenPersistence: TokenPersistence) extends CustomPersistentTokenRepository {

  override def createNewToken(persistentRememberMeToken: PersistentRememberMeToken): Unit = tokenPersistence.insert(persistentRememberMeToken)

  override def getTokenForSeries(series: String): PersistentRememberMeToken = tokenPersistence.getTokenForSeries(series)

  override def getPreviousTokenForSeries(series: String, token: String): JList[PersistentRememberMeToken] =
    tokenPersistence.getPreviousTokenForSeries(series, token).asJava

  override def removeUserTokens(username: String): Unit = tokenPersistence.removeUserTokens(username)

  override def removeTokenInSeriesBeforeGivenDate(series: String, date: Date): Unit =
    tokenPersistence.removeTokenInSeriesBeforeGivenDate(series, date)

  override def removeUserTokensBasedOnSeries(series: String): Unit =
    tokenPersistence.removeUserTokensBasedOnSeries(series)
}
