/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache$;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurity;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.FolderVariablesDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.FoldersStoreException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.SqlRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow$FolderDataOps$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow$NodeFolderDataOps$;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.utils.Tree;
import com.xebialabs.xlrelease.utils.Tree$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.HashSet;
import org.slf4j.Marker;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\rUe\u0001B\u001a5\u0001}B\u0001\"\u0019\u0001\u0003\u0002\u0003\u0006IA\u0019\u0005\tQ\u0002\u0011\t\u0011)A\u0005S\"AA\u000e\u0001B\u0001B\u0003%Q\u000e\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003r\u0011!I\bA!A!\u0002\u0013Q\b\u0002C?\u0001\u0005\u000b\u0007I\u0011\u0001@\t\u0013\u0005=\u0001A!A!\u0002\u0013y\bBCA\t\u0001\t\u0015\r\u0011b\u0001\u0002\u0014!Q\u0011Q\u0006\u0001\u0003\u0002\u0003\u0006I!!\u0006\t\u0015\u0005=\u0002A!b\u0001\n\u0007\t\t\u0004\u0003\u0006\u0002b\u0001\u0011\t\u0011)A\u0005\u0003gAq!a\u0019\u0001\t\u0003\t)\u0007C\u0004\u0002z\u0001!\t%a\u001f\t\u000f\u0005m\u0006\u0001\"\u0011\u0002>\"9\u00111\u001a\u0001\u0005B\u00055\u0007bBAt\u0001\u0011\u0005\u0011\u0011\u001e\u0005\b\u0005\u0013\u0001A\u0011\tB\u0006\u0011\u001d\u0011i\u0002\u0001C!\u0005?A\u0011Ba\u000b\u0001#\u0003%\tA!\f\t\u000f\t\u0005\u0003\u0001\"\u0011\u0003D!I!Q\f\u0001\u0012\u0002\u0013\u0005!Q\u0006\u0005\n\u0005?\u0002\u0011\u0013!C\u0001\u0005[AqA!\u0019\u0001\t\u0003\u0012\u0019\u0007C\u0004\u0003j\u0001!IAa\u001b\t\u000f\tm\u0004\u0001\"\u0003\u0003~!9!\u0011\u0011\u0001\u0005\u0002\t\r\u0005b\u0002BE\u0001\u0011\u0005!1\u0012\u0005\b\u0005#\u0003A\u0011\tBJ\u0011\u001d\u0011Y\n\u0001C!\u0005;CqA!,\u0001\t\u0003\u0012y\u000bC\u0004\u0003:\u0002!\tEa/\t\u000f\t\u0015\u0007\u0001\"\u0011\u0003H\"I!\u0011\u001b\u0001\u0012\u0002\u0013\u0005!1\u001b\u0005\b\u0005/\u0004A\u0011\tBm\u0011\u001d\u0011\u0019\u000f\u0001C!\u0005KD\u0001B!<\u0001\t\u0003!$q\u001e\u0005\t\u0007\u0007\u0001A\u0011\u0001\u001b\u0004\u0006!A1q\u0005\u0001\u0005\u0002Q\u001aI\u0003\u0003\u0006\u00040\u0001\t\n\u0011\"\u00015\u0005'D\u0001b!\r\u0001\t\u0003!41\u0007\u0005\u000b\u0007w\u0001\u0011\u0013!C\u0001i\tM\u0007bBB\u001f\u0001\u0011%1q\b\u0005\n\u0007\u001b\u0002\u0011\u0013!C\u0005\u0005'D\u0011ba\u0014\u0001#\u0003%IA!\f\t\u0011\rE\u0003\u0001\"\u00015\u0007'B!ba\u0017\u0001#\u0003%\t\u0001\u000eBj\u0011)\u0019i\u0006AI\u0001\n\u0003!$Q\u0006\u0005\t\u0007?\u0002A\u0011\u0001\u001b\u0004b!Q1q\u000f\u0001\u0012\u0002\u0013\u0005AGa5\t\u000f\re\u0004\u0001\"\u0003\u0004|\t\u00192+\u001d7G_2$WM\u001d*fa>\u001c\u0018\u000e^8ss*\u0011QGN\u0001\u0004gFd'BA\u001c9\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003si\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005mb\u0014!\u0003=fE&\fG.\u00192t\u0015\u0005i\u0014aA2p[\u000e\u00011C\u0002\u0001A\r*3\u0016\f\u0005\u0002B\t6\t!IC\u0001D\u0003\u0015\u00198-\u00197b\u0013\t)%I\u0001\u0004B]f\u0014VM\u001a\t\u0003\u000f\"k\u0011AN\u0005\u0003\u0013Z\u0012\u0001CR8mI\u0016\u0014(+\u001a9pg&$xN]=\u0011\u0007-ce*D\u00015\u0013\tiEGA\u000bJ]R,'oY3qi\u0016$'+\u001a9pg&$xN]=\u0011\u0005=#V\"\u0001)\u000b\u0005E\u0013\u0016A\u00024pY\u0012,'O\u0003\u0002Tq\u00051Am\\7bS:L!!\u0016)\u0003\r\u0019{G\u000eZ3s!\tYu+\u0003\u0002Yi\ti1+\u001d7SKB|7/\u001b;pef\u0004\"AW0\u000e\u0003mS!\u0001X/\u0002\u000bMdg\r\u000e6\u000b\u0003y\u000b\u0001b\u001a:jujdW\rZ\u0005\u0003An\u0013q\u0001T8hO&tw-A\tg_2$WM\u001d)feNL7\u000f^3oG\u0016\u0004\"a\u00194\u000e\u0003\u0011T!!\u001a\u001b\u0002\u0017A,'o]5ti\u0016t7-Z\u0005\u0003O\u0012\u0014\u0011CR8mI\u0016\u0014\b+\u001a:tSN$XM\\2f\u0003I\u0011X\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0011\u0005\rT\u0017BA6e\u0005I\u0011V\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0002\u001dQ,\u0017-\u001c*fa>\u001c\u0018\u000e^8ssB\u0011qI\\\u0005\u0003_Z\u0012a\u0002V3b[J+\u0007o\\:ji>\u0014\u00180\u0001\nqKJl\u0017n]:j_:,eNZ8sG\u0016\u0014\bC\u0001:x\u001b\u0005\u0019(B\u0001;v\u0003!\u0019XmY;sSRL(B\u0001<;\u0003!!W\r\u001d7ps&$\u0018B\u0001=t\u0005I\u0001VM]7jgNLwN\\#oM>\u00148-\u001a:\u0002\u0017I|G.Z*feZL7-\u001a\t\u0003enL!\u0001`:\u0003\u0017I{G.Z*feZL7-Z\u0001\u0011I\u0016\u001cwN]1u_J\u001cVM\u001d<jG\u0016,\u0012a \t\u0005\u0003\u0003\tY!\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003!Ig\u000e^3s]\u0006d'bAA\u0005q\u0005\u0019\u0011\r]5\n\t\u00055\u00111\u0001\u0002!\u0013:$XM\u001d8bY6+G/\u00193bi\u0006$UmY8sCR|'oU3sm&\u001cW-A\teK\u000e|'/\u0019;peN+'O^5dK\u0002\nAB\u001b3cGR+W\u000e\u001d7bi\u0016,\"!!\u0006\u0011\t\u0005]\u0011\u0011F\u0007\u0003\u00033QA!a\u0007\u0002\u001e\u0005!1m\u001c:f\u0015\u0011\ty\"!\t\u0002\t)$'m\u0019\u0006\u0005\u0003G\t)#A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\t9#A\u0002pe\u001eLA!a\u000b\u0002\u001a\ta!\n\u001a2d)\u0016l\u0007\u000f\\1uK\u0006i!\u000e\u001a2d)\u0016l\u0007\u000f\\1uK\u0002\nq\u0001Z5bY\u0016\u001cG/\u0006\u0002\u00024A!\u0011QGA.\u001d\u0011\t9$!\u0016\u000f\t\u0005e\u0012\u0011\u000b\b\u0005\u0003w\tiE\u0004\u0003\u0002>\u0005-c\u0002BA \u0003\u0013rA!!\u0011\u0002H5\u0011\u00111\t\u0006\u0004\u0003\u000br\u0014A\u0002\u001fs_>$h(C\u0001>\u0013\tYD(\u0003\u0002:u%\u0019\u0011q\n\u001d\u0002\u0005\u0011\u0014\u0017bA\u001b\u0002T)\u0019\u0011q\n\u001d\n\t\u0005]\u0013\u0011L\u0001\u000b'Fd')^5mI\u0016\u0014(bA\u001b\u0002T%!\u0011QLA0\u0005\u001d!\u0015.\u00197fGRTA!a\u0016\u0002Z\u0005AA-[1mK\u000e$\b%\u0001\u0004=S:LGO\u0010\u000b\u0013\u0003O\nI'a\u001b\u0002n\u0005=\u0014\u0011OA:\u0003k\n9\b\u0005\u0002L\u0001!)\u0011\r\u0004a\u0001E\")\u0001\u000e\u0004a\u0001S\")A\u000e\u0004a\u0001[\")\u0001\u000f\u0004a\u0001c\")\u0011\u0010\u0004a\u0001u\")Q\u0010\u0004a\u0001\u007f\"9\u0011\u0011\u0003\u0007A\u0004\u0005U\u0001bBA\u0018\u0019\u0001\u000f\u00111G\u0001\u0007KbL7\u000f^:\u0015\t\u0005u\u00141\u0011\t\u0004\u0003\u0006}\u0014bAAA\u0005\n9!i\\8mK\u0006t\u0007bBAC\u001b\u0001\u0007\u0011qQ\u0001\tM>dG-\u001a:JIB!\u0011\u0011RAI\u001d\u0011\tY)!$\u0011\u0007\u0005\u0005#)C\u0002\u0002\u0010\n\u000ba\u0001\u0015:fI\u00164\u0017\u0002BAJ\u0003+\u0013aa\u0015;sS:<'bAAH\u0005\"\u001aQ\"!'\u0011\t\u0005m\u0015\u0011V\u0007\u0003\u0003;SA!a(\u0002\"\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\u0005\r\u0016QU\u0001\b[\u0016$(/[2t\u0015\r\t9\u000bP\u0001\tG>$\u0017\r[1mK&!\u00111VAO\u0005\u0015!\u0016.\\3eQ\ri\u0011q\u0016\t\u0005\u0003c\u000b9,\u0004\u0002\u00024*!\u0011QWA-\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\t\u0005e\u00161\u0017\u0002\u000b\u0013N\u0014V-\u00193P]2L\u0018\u0001C4fiRKG\u000f\\3\u0015\t\u0005}\u0016Q\u0019\t\u0006\u0003\u0006\u0005\u0017qQ\u0005\u0004\u0003\u0007\u0014%AB(qi&|g\u000eC\u0004\u0002\u0006:\u0001\r!a\")\u00079\tI\nK\u0002\u000f\u0003_\u000bqaZ3u!\u0006$\b\u000e\u0006\u0003\u0002P\u0006\u0005\bCBAi\u00037\f9I\u0004\u0003\u0002T\u0006]g\u0002BA!\u0003+L\u0011aQ\u0005\u0004\u00033\u0014\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003;\fyNA\u0002TKFT1!!7C\u0011\u001d\t)i\u0004a\u0001\u0003\u000fC3aDAMQ\ry\u0011qV\u0001\u0007O\u0016$X+\u001b3\u0015\t\u0005-(1\u0001\t\u0005\u0003[\fiP\u0004\u0003\u0002p\u0006mh\u0002BAy\u0003stA!a=\u0002x:!\u00111HA{\u0013\t9\u0004(\u0003\u00026m%\u0011Q\rN\u0005\u0004\u00033$\u0017\u0002BA\u0000\u0005\u0003\u0011QaQ5VS\u0012T1!!7e\u0011\u001d\t)\t\u0005a\u0001\u0003\u000fC3\u0001EAMQ\r\u0001\u0012qV\u0001\tM&tGMQ=JIR1!Q\u0002B\b\u0005#\u0001B!QAa\u001d\"9\u0011QQ\tA\u0002\u0005\u001d\u0005\"\u0003B\n#A\u0005\t\u0019\u0001B\u000b\u0003\u0015!W\r\u001d;i!\r\t%qC\u0005\u0004\u00053\u0011%aA%oi\"\u001a\u0011#!'\u0002/\u0019Lg\u000e\u001a,jK^\f'\r\\3G_2$WM]:Cs&#G\u0003\u0003B\u0007\u0005C\u0011\u0019C!\n\t\u000f\u0005\u0015%\u00031\u0001\u0002\b\"I!1\u0003\n\u0011\u0002\u0003\u0007!Q\u0003\u0005\n\u0005O\u0011\u0002\u0013!a\u0001\u0003{\n\u0011#\u001a8g_J\u001cW\rU3s[&\u001c8/[8oQ\r\u0011\u0012\u0011T\u0001\"M&tGMV5fo\u0006\u0014G.\u001a$pY\u0012,'o\u001d\"z\u0013\u0012$C-\u001a4bk2$HeM\u000b\u0003\u0005_QC!! \u00032-\u0012!1\u0007\t\u0005\u0005k\u0011i$\u0004\u0002\u00038)!!\u0011\bB\u001e\u0003%)hn\u00195fG.,GMC\u0002\u0002 \nKAAa\u0010\u00038\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002'1L7\u000f\u001e,jK^\f'\r\\3G_2$WM]:\u0015\u0015\t\u0015#q\tB&\u0005+\u0012I\u0006E\u0003\u0002R\u0006mg\nC\u0004\u0003JQ\u0001\r!a\"\u0002\u0011A\f'/\u001a8u\u0013\u0012DqA!\u0014\u0015\u0001\u0004\u0011y%\u0001\u0003qC\u001e,\u0007cA$\u0003R%\u0019!1\u000b\u001c\u0003\tA\u000bw-\u001a\u0005\n\u0005/\"\u0002\u0013!a\u0001\u0003{\nq\u0003Z3d_J\fG/Z,ji\"\u0004VM]7jgNLwN\\:\t\u0013\t\u001dB\u0003%AA\u0002\u0005u\u0004f\u0001\u000b\u0002\u001a\u0006iB.[:u-&,w/\u00192mK\u001a{G\u000eZ3sg\u0012\"WMZ1vYR$3'A\u000fmSN$h+[3xC\ndWMR8mI\u0016\u00148\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0003y1\u0017N\u001c3Ok6\u0014WM](g\u0007\"LG\u000e\u001a:f]\u001a{'/\u0011$pY\u0012,'\u000f\u0006\u0003\u0003\u0016\t\u0015\u0004bBAC/\u0001\u0007\u0011q\u0011\u0015\u0004/\u0005e\u0015A\u00073fG>\u0014\u0018\r^3XSRDW\tZ5u!\u0016\u0014X.[:tS>tGC\u0002B7\u0005g\u00129\bE\u0002B\u0005_J1A!\u001dC\u0005\u0011)f.\u001b;\t\u000f\tU\u0004\u00041\u0001\u0003F\u00059am\u001c7eKJ\u001c\bb\u0002B=1\u0001\u0007\u0011qZ\u0001\u0010M>dG-\u001a:t/&$\b.\u00123ji\u0006QB-Z2pe\u0006$XmV5uQZKWm\u001e)fe6L7o]5p]R!!Q\u000eB@\u0011\u001d\u0011)(\u0007a\u0001\u0005\u000b\n\u0001d]3u\u0003N,eMZ3di&4XmU3dkJLG/_%e)\u0011\u0011iG!\"\t\u000f\u0005\u0015%\u00041\u0001\u0002\b\"\u001a!$!'\u00025%t\u0007.\u001a:ji\u00163g-Z2uSZ,7+Z2ve&$\u00180\u00133\u0015\t\t5$Q\u0012\u0005\b\u0003\u000b[\u0002\u0019AADQ\rY\u0012\u0011T\u0001\u0007GJ,\u0017\r^3\u0015\u000b9\u0013)Ja&\t\u000f\t%C\u00041\u0001\u0002\b\")\u0011\u000b\ba\u0001\u001d\"\u001aA$!'\u0002\r\u0011,G.\u001a;f)\u0019\u0011iGa(\u0003\"\"9\u0011QQ\u000fA\u0002\u0005\u001d\u0005\"\u0003BR;A\u0005\t\u0019\u0001BS\u00035!W\r\\3uKJ+G.Z1tKBI\u0011Ia*\u0003\u0016\u0005\u001d%QN\u0005\u0004\u0005S\u0013%!\u0003$v]\u000e$\u0018n\u001c83Q\ri\u0012\u0011T\u0001\u0007e\u0016t\u0017-\\3\u0015\u000b9\u0013\tLa-\t\u000f\u0005\u0015e\u00041\u0001\u0002\b\"9!Q\u0017\u0010A\u0002\u0005\u001d\u0015a\u00028fo:\u000bW.\u001a\u0015\u0004=\u0005e\u0015\u0001B7pm\u0016$RA\u0014B_\u0005\u007fCq!!\" \u0001\u0004\t9\tC\u0004\u0003B~\u0001\r!a\"\u0002\u00179,w\u000fU1sK:$\u0018\n\u001a\u0015\u0004?\u0005e\u0015A\u00034j]\u0012\u0014\u0015\u0010U1uQR)aJ!3\u0003N\"9!1\u001a\u0011A\u0002\u0005\u001d\u0015!\u0003;ji2,\u0007+\u0019;i\u0011%\u0011\u0019\u0002\tI\u0001\u0002\u0004\u0011)\u0002K\u0002!\u00033\u000bACZ5oI\nK\b+\u0019;iI\u0011,g-Y;mi\u0012\u0012TC\u0001BkU\u0011\u0011)B!\r\u0002)\u0019Lg\u000eZ*vE\u001a{G\u000eZ3s\u0005f$\u0016\u000e\u001e7f)\u0019\u0011iAa7\u0003^\"9!\u0011\n\u0012A\u0002\u0005\u001d\u0005b\u0002BpE\u0001\u0007\u0011qQ\u0001\u0005]\u0006lW\rK\u0002#\u00033\u000b\u0011#[:G_2$WM]%oQ\u0016\u0014\u0018\u000e^3e)\u0011\tiHa:\t\u000f\u0005\u00155\u00051\u0001\u0002\b\"\u001a1%!')\u0007\r\ny+\u0001\rgS:$7+\u001e2G_2$WM\u001d#bi\u0006\u0014\u0015\u0010V5uY\u0016$bA!=\u0003\u0000\u000e\u0005\u0001#B!\u0002B\nM\b\u0003\u0002B{\u0005wl!Aa>\u000b\u0007\teH-\u0001\u0003eCR\f\u0017\u0002\u0002B\u007f\u0005o\u0014\u0011BR8mI\u0016\u0014(k\\<\t\u000f\u0005\u0015E\u00051\u0001\u0002\b\"9!q\u001c\u0013A\u0002\u0005\u001d\u0015AC5og\u0016\u0014HOT8eKRA1qAB\u000f\u0007?\u0019\u0019\u0003\u0005\u0004\u0004\n\r]!1\u001f\b\u0005\u0007\u0017\u0019\tB\u0004\u0003\u0002<\r5\u0011bAB\bq\u0005)Q\u000f^5mg&!11CB\u000b\u0003\u0011!&/Z3\u000b\u0007\r=\u0001(\u0003\u0003\u0004\u001a\rm!\u0001\u0002(pI\u0016TAaa\u0005\u0004\u0016!9!q\\\u0013A\u0002\u0005\u001d\u0005bBB\u0011K\u0001\u0007\u0011qQ\u0001\bO&4XM\\%e\u0011\u001d\u0019)#\na\u0001\u0003\u007f\u000b1\u0002]1sK:$\u0018\nZ(qi\u0006aa-\u001b8e\u001d>$WMQ=JIR11qAB\u0016\u0007[Aq!!\"'\u0001\u0004\t9\tC\u0005\u0003\u0014\u0019\u0002\n\u00111\u0001\u0003\u0016\u00051b-\u001b8e\u001d>$WMQ=JI\u0012\"WMZ1vYR$#'A\u0007gS:$gj\u001c3f\u0005f,\u0016\u000e\u001a\u000b\u0007\u0007\u000f\u0019)d!\u000f\t\u000f\r]\u0002\u00061\u0001\u0002l\u0006)1-[+jI\"I!1\u0003\u0015\u0011\u0002\u0003\u0007!QC\u0001\u0018M&tGMT8eK\nKX+\u001b3%I\u00164\u0017-\u001e7uII\n\u0011\u0003\\5tiZKWm^1cY\u0016tu\u000eZ3t)!\u0019\tea\u0012\u0004J\r-\u0003CBAi\u0007\u0007\u001a9!\u0003\u0003\u0004F\u0005}'\u0001\u0002'jgRDq!!\"+\u0001\u0004\t9\tC\u0005\u0003\u0014)\u0002\n\u00111\u0001\u0003\u0016!I!q\u0005\u0016\u0011\u0002\u0003\u0007\u0011QP\u0001\u001cY&\u001cHOV5fo\u0006\u0014G.\u001a(pI\u0016\u001cH\u0005Z3gCVdG\u000f\n\u001a\u000271L7\u000f\u001e,jK^\f'\r\\3O_\u0012,7\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003U1\u0017N\u001c3WS\u0016<\u0018M\u00197f\u001d>$Wm\u001d\"z\u0013\u0012$\u0002ba\u0002\u0004V\r]3\u0011\f\u0005\b\u0003\u000bk\u0003\u0019AAD\u0011%\u0011\u0019\"\fI\u0001\u0002\u0004\u0011)\u0002C\u0005\u0003(5\u0002\n\u00111\u0001\u0002~\u0005yb-\u001b8e-&,w/\u00192mK:{G-Z:Cs&#G\u0005Z3gCVdG\u000f\n\u001a\u0002?\u0019Lg\u000e\u001a,jK^\f'\r\\3O_\u0012,7OQ=JI\u0012\"WMZ1vYR$3'A\fgS:$W\tZ5uC\ndWMR8mI\u0016\u00148OQ=JIR111MB:\u0007k\u0002ba!\u001a\u0004p\tMXBAB4\u0015\u0011\u0019Iga\u001b\u0002\u000f5,H/\u00192mK*\u00191Q\u000e\"\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0004r\r\u001d$A\u0002\"vM\u001a,'\u000fC\u0004\u0002\u0006B\u0002\r!a\"\t\u0013\tM\u0001\u0007%AA\u0002\tU\u0011!\t4j]\u0012,E-\u001b;bE2,gi\u001c7eKJ\u001c()_%eI\u0011,g-Y;mi\u0012\u0012\u0014\u0001D4fiV\u001bXM\u001d*pY\u0016\u001cHCAB?!\u0019\u0019)ga\u001c\u0004\u0000A!1\u0011QBF\u001b\t\u0019\u0019I\u0003\u0003\u0004\u0006\u000e\u001d\u0015\u0001\u00027b]\u001eT!a!#\u0002\t)\fg/Y\u0005\u0005\u0003'\u001b\u0019\tK\u0002\u0001\u0007\u001f\u0003B!!-\u0004\u0012&!11SAZ\u0005=I5\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007")
public class SqlFolderRepository
implements FolderRepository,
InterceptedRepository<Folder>,
SqlRepository {
    private final FolderPersistence folderPersistence;
    private final ReleasePersistence releasePersistence;
    private final TeamRepository teamRepository;
    private final PermissionEnforcer permissionEnforcer;
    private final RoleService roleService;
    private final InternalMetadataDecoratorService decoratorService;
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private scala.collection.immutable.Seq<PersistenceInterceptor<Folder>> persistenceInterceptors;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public void registerPersistenceInterceptor(PersistenceInterceptor<Folder> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    public Function2<Object, String, BoxedUnit> delete$default$2() {
        return FolderRepository.delete$default$2$((FolderRepository)this);
    }

    public int findById$default$2() {
        return FolderRepository.findById$default$2$((FolderRepository)this);
    }

    public int findViewableFoldersById$default$2() {
        return FolderRepository.findViewableFoldersById$default$2$((FolderRepository)this);
    }

    public void checkFolderExists(String folderId) {
        FolderRepository.checkFolderExists$((FolderRepository)this, (String)folderId);
    }

    public void checkNameIsUnique(String parentId, String name) {
        FolderRepository.checkNameIsUnique$((FolderRepository)this, (String)parentId, (String)name);
    }

    public scala.collection.immutable.Seq<Folder> paginate(scala.collection.immutable.Seq<Folder> folders, Page page) {
        return FolderRepository.paginate$((FolderRepository)this, folders, (Page)page);
    }

    public scala.collection.immutable.Seq<Folder> decorateWithEffectiveSecurity(scala.collection.immutable.Seq<Folder> folders, DecoratorsCache cache) {
        return FolderRepository.decorateWithEffectiveSecurity$((FolderRepository)this, folders, (DecoratorsCache)cache);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public scala.collection.immutable.Seq<PersistenceInterceptor<Folder>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(scala.collection.immutable.Seq<PersistenceInterceptor<Folder>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlFolderRepository sqlFolderRepository = this;
        synchronized (sqlFolderRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public InternalMetadataDecoratorService decoratorService() {
        return this.decoratorService;
    }

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String folderId) {
        return this.folderPersistence.exists(folderId);
    }

    @Timed
    @IsReadOnly
    public Option<String> getTitle(String folderId) {
        return this.findById(folderId, 0).map((Function1 & Serializable)x$1 -> x$1.getTitle());
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> getPath(String folderId) {
        return this.folderPersistence.getFolderPathSegments(folderId);
    }

    @Timed
    @IsReadOnly
    public Integer getUid(String folderId) {
        return this.folderPersistence.getUid(folderId);
    }

    @Timed
    public Option<Folder> findById(String folderId, int depth) {
        return Tree.TreeOps$.MODULE$.toOption$extension(Tree$.MODULE$.TreeOps(this.findNodeById(folderId, depth))).map((Function1 & Serializable)tree -> {
            Folder folder = FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)tree));
            this.decoratorService().decorate((ConfigurationItem)folder, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY(), (List)new .colon.colon((Object)FolderVariablesDecorator$.MODULE$.FOLDER_VARIABLES(), (List)Nil$.MODULE$))).asJava());
            return folder;
        });
    }

    @Timed
    public Option<Folder> findViewableFoldersById(String folderId, int depth, boolean enforcePermission) {
        DecoratorsCache cache = new DecoratorsCache(DecoratorsCache$.MODULE$.$lessinit$greater$default$1());
        return Tree.TreeOps$.MODULE$.toOption$extension(Tree$.MODULE$.TreeOps(this.findViewableNodesById(folderId, depth, enforcePermission))).map((Function1 & Serializable)tree -> {
            Folder folder = FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)tree));
            this.decoratorService().decorate((ConfigurationItem)folder, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY(), (List)new .colon.colon((Object)FolderVariablesDecorator$.MODULE$.FOLDER_VARIABLES(), (List)Nil$.MODULE$))).asJava(), cache);
            folder.setChildren(CollectionConverters$.MODULE$.SetHasAsJava((Set)this.decorateWithEffectiveSecurity((scala.collection.immutable.Seq<Folder>)CollectionConverters$.MODULE$.SetHasAsScala(folder.getChildren()).asScala().toSeq(), cache).toSet()).asJava());
            return folder;
        });
    }

    public boolean findViewableFoldersById$default$3() {
        return true;
    }

    @Timed
    public scala.collection.immutable.Seq<Folder> listViewableFolders(String parentId, Page page, boolean decorateWithPermissions, boolean enforcePermission) {
        scala.collection.immutable.Seq<Folder> viewableResults = this.paginate((scala.collection.immutable.Seq<Folder>)this.listViewableNodes(parentId, page.depth(), enforcePermission).map((Function1 & Serializable)x$2 -> FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)x$2))), page);
        if (decorateWithPermissions) {
            DecoratorsCache decoratorsCache = new DecoratorsCache(DecoratorsCache$.MODULE$.$lessinit$greater$default$1());
            return this.decorateWithEffectiveSecurity(viewableResults, decoratorsCache);
        }
        Buffer<FolderRow> editableResults = this.findEditableFoldersById(parentId, page.depth());
        this.decorateWithViewPermission(viewableResults);
        this.decorateWithEditPermission(viewableResults, (scala.collection.immutable.Seq<String>)((IterableOnceOps)editableResults.map((Function1 & Serializable)x$3 -> FolderRow$FolderDataOps$.MODULE$.asFolder$extension(FolderRow$.MODULE$.FolderDataOps((FolderRow)x$3)).getId())).toSeq());
        return viewableResults;
    }

    public boolean listViewableFolders$default$3() {
        return true;
    }

    public boolean listViewableFolders$default$4() {
        return true;
    }

    @Timed
    public int findNumberOfChildrenForAFolder(String folderId) {
        return this.folderPersistence.findNumberOfChildrenForAFolder(folderId);
    }

    private void decorateWithEditPermission(scala.collection.immutable.Seq<Folder> folders, scala.collection.immutable.Seq<String> foldersWithEdit) {
        folders.foreach((Function1 & Serializable)f -> {
            SqlFolderRepository.$anonfun$decorateWithEditPermission$1(this, foldersWithEdit, f);
            return BoxedUnit.UNIT;
        });
    }

    private void decorateWithViewPermission(scala.collection.immutable.Seq<Folder> folders) {
        folders.foreach((Function1 & Serializable)f -> {
            SqlFolderRepository.$anonfun$decorateWithViewPermission$1(this, f);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void setAsEffectiveSecurityId(String folderId) {
        this.folderPersistence.setAsEffectiveSecuredCi(folderId);
    }

    @Timed
    public void inheritEffectiveSecurityId(String folderId) {
        this.folderPersistence.inheritEffectiveSecuredCi(folderId);
    }

    @Timed
    public Folder create(String parentId, Folder folder) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.interceptCreate((ConfigurationItem)folder);
            return this.insertNode(folder.getTitle(), folder.getId(), (Option<String>)new Some((Object)parentId));
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Tree.Node created = (Tree.Node)success.value();
            return FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)created));
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().error((Function0 & Serializable)() -> e);
            throw new FoldersStoreException("Cannot create folder " + folder.getId() + " under " + parentId);
        }
        throw new MatchError((Object)try_);
    }

    @Timed
    public void delete(String folderId, Function2<Object, String, BoxedUnit> deleteRelease) {
        Integer ciUid = ((FolderRow)this.findNodeById(folderId, 0).value()).uid();
        this.folderPersistence.deleteReleases(ciUid, deleteRelease);
        Tree.TreeOps$.MODULE$.bottomUp$extension(Tree$.MODULE$.TreeOps(this.findNodeById(folderId, this.findNodeById$default$2()))).foreach((Function1 & Serializable)data -> {
            SqlFolderRepository.$anonfun$delete$1(this, data);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Folder rename(String folderId, String newName) {
        return this.folderPersistence.rename(folderId, newName, this.folderPersistence.rename$default$3());
    }

    @Timed
    public Folder move(String folderId, String newParentId) {
        Integer oldSubtreeSecurityUid = ((FolderRow)this.findNodeById(folderId, 0).value()).securityUid();
        Tree.Node<FolderRow> moved = this.folderPersistence.move(folderId, newParentId, this.folderPersistence.move$default$3());
        Integer newSubtreeSecurityUid = ((FolderRow)moved.value()).securityUid();
        this.releasePersistence.replaceSecurityUid(((FolderRow)moved.value()).uid(), oldSubtreeSecurityUid, newSubtreeSecurityUid);
        return FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps(moved));
    }

    @Timed
    public Folder findByPath(String titlePath, int depth) {
        if (Strings.isEmpty((String)titlePath)) {
            throw new NotFoundException("Cannot find folder by empty path: " + titlePath, new Object[0]);
        }
        String pathFromRoot = titlePath.startsWith("/") ? titlePath.substring(1) : titlePath;
        this.logger().debug((Function0 & Serializable)() -> "Finding folder by path " + pathFromRoot);
        String[] pathElements = (String[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.refArrayOps((Object[])pathFromRoot.split("/")), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isEmpty()));
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])pathElements))) {
            throw new IllegalArgumentException("No folder path specified, the root path is not supported");
        }
        Option option = ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])pathElements));
        if (None$.MODULE$.equals(option)) {
            throw new NotFoundException("Cannot find folder by empty path: " + titlePath, new Object[0]);
        }
        if (!(option instanceof Some)) {
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        String topName = (String)some.value();
        Option<FolderRow> topLevelData = this.findSubFolderDataByTitle(Ids.ROOT_FOLDER_ID, topName);
        Integer topLevelUid = (Integer)topLevelData.map((Function1 & Serializable)x$5 -> x$5.uid()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Could not find folder [" + ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])pathElements)).getOrElse((Function0 & Serializable)() -> "") + "] in path [" + titlePath + "]", new Object[0]);
        });
        Tree.Node topNode = (Tree.Node)Tree.TreeOps$.MODULE$.toOption$extension(Tree$.MODULE$.TreeOps(this.findNodeByUid(topLevelUid, Math.max(depth, ((String[])ArrayOps$.MODULE$.tail$extension(Predef$.MODULE$.refArrayOps((Object[])pathElements))).length)))).get();
        return FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)((Tree.Node)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.tail$extension(Predef$.MODULE$.refArrayOps((Object[])pathElements))), (Object)topNode, (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tree.Node node = (Tree.Node)tuple2._1();
                String pathElement = (String)tuple2._2();
                return (Tree.Node)node.children().find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SqlFolderRepository.$anonfun$findByPath$7(pathElement, x$6))).getOrElse((Function0 & Serializable)() -> {
                    throw new NotFoundException("Could not find folder [" + pathElement + "] in path [" + titlePath + "]", new Object[0]);
                });
            }
            throw new MatchError((Object)tuple2);
        }))));
    }

    public int findByPath$default$2() {
        return Integer.MAX_VALUE;
    }

    @Timed
    public Option<Folder> findSubFolderByTitle(String parentId, String name) {
        return this.findSubFolderDataByTitle(parentId, name).map((Function1 & Serializable)x$7 -> FolderRow$FolderDataOps$.MODULE$.asFolder$extension(FolderRow$.MODULE$.FolderDataOps((FolderRow)x$7)));
    }

    @Timed
    @IsReadOnly
    public boolean isFolderInherited(String folderId) {
        return this.folderPersistence.isInherited(folderId);
    }

    public Option<FolderRow> findSubFolderDataByTitle(String folderId, String name) {
        return this.folderPersistence.findSubFolderByTitle(name, folderId);
    }

    public Tree.Node<FolderRow> insertNode(String name, String givenId, Option<String> parentIdOpt) {
        return this.folderPersistence.create(name, givenId, parentIdOpt);
    }

    public Tree.Node<FolderRow> findNodeById(String folderId, int depth) {
        return this.folderPersistence.findById(folderId, depth);
    }

    public int findNodeById$default$2() {
        return Integer.MAX_VALUE;
    }

    public Tree.Node<FolderRow> findNodeByUid(Integer ciUid, int depth) {
        Tree.Node<FolderRow> viewableTree = this.permissionEnforcer.isCurrentUserAdmin() || this.permissionEnforcer.hasLoggedInUserPermission(new Permission[]{XLReleasePermissions.AUDIT_ALL}) ? this.folderPersistence.findByUid(ciUid, depth) : this.folderPersistence.findByUidHavingPermission(ciUid, XLReleasePermissions.VIEW_FOLDER, (Iterable<String>)CollectionConverters$.MODULE$.CollectionHasAsScala(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala(), (Iterable<String>)this.getUserRoles(), depth);
        return viewableTree;
    }

    public int findNodeByUid$default$2() {
        return Integer.MAX_VALUE;
    }

    private List<Tree.Node<FolderRow>> listViewableNodes(String folderId, int depth, boolean enforcePermission) {
        Tree.Node<FolderRow> viewableTree = this.findViewableNodesById(folderId, depth, enforcePermission);
        return (List)Tree.TreeOps$.MODULE$.toOption$extension(Tree$.MODULE$.TreeOps(viewableTree)).fold((Function0 & Serializable)() -> package$.MODULE$.List().empty(), (Function1 & Serializable)x$8 -> x$8.children());
    }

    private int listViewableNodes$default$2() {
        return Integer.MAX_VALUE;
    }

    private boolean listViewableNodes$default$3() {
        return true;
    }

    public Tree.Node<FolderRow> findViewableNodesById(String folderId, int depth, boolean enforcePermission) {
        Tree.Node<FolderRow> viewableTree = !enforcePermission || this.permissionEnforcer.isCurrentUserAdmin() || this.permissionEnforcer.hasLoggedInUserPermission(new Permission[]{XLReleasePermissions.AUDIT_ALL}) ? this.folderPersistence.findById(folderId, depth) : this.folderPersistence.findByIdHavingPermission(folderId, XLReleasePermissions.VIEW_FOLDER, (Iterable<String>)CollectionConverters$.MODULE$.CollectionHasAsScala(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala(), (Iterable<String>)this.getUserRoles(), depth);
        return viewableTree;
    }

    public int findViewableNodesById$default$2() {
        return Integer.MAX_VALUE;
    }

    public boolean findViewableNodesById$default$3() {
        return true;
    }

    public Buffer<FolderRow> findEditableFoldersById(String folderId, int depth) {
        Buffer<FolderRow> folders = this.permissionEnforcer.isCurrentUserAdmin() || this.permissionEnforcer.hasLoggedInUserPermission(new Permission[]{XLReleasePermissions.AUDIT_ALL}) ? this.folderPersistence.findDescendantsById(folderId, depth) : this.folderPersistence.findDescendantsByIdHavingPermission(folderId, XLReleasePermissions.EDIT_FOLDER, (Iterable<String>)CollectionConverters$.MODULE$.CollectionHasAsScala(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala(), (Iterable<String>)this.getUserRoles(), depth);
        return folders;
    }

    public int findEditableFoldersById$default$2() {
        return Integer.MAX_VALUE;
    }

    private Buffer<String> getUserRoles() {
        return (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.roleService.getRolesFor(Permissions.getAuthentication())).asScala().map((Function1 & Serializable)x$9 -> x$9.getId());
    }

    public static final /* synthetic */ void $anonfun$decorateWithEditPermission$1(SqlFolderRepository $this, scala.collection.immutable.Seq foldersWithEdit$1, Folder f) {
        if (foldersWithEdit$1.contains((Object)f.getId())) {
            EffectiveSecurity effectiveSecurity = (EffectiveSecurity)f.get$metadata().get("security");
            v0 = BoxesRunTime.boxToBoolean((boolean)effectiveSecurity.getPermissions().add(XLReleasePermissions.EDIT_FOLDER.getPermissionName()));
        } else {
            v0 = BoxedUnit.UNIT;
        }
        $this.decorateWithEditPermission((scala.collection.immutable.Seq<Folder>)CollectionConverters$.MODULE$.SetHasAsScala(f.getChildren()).asScala().toSeq(), (scala.collection.immutable.Seq<String>)foldersWithEdit$1);
    }

    public static final /* synthetic */ void $anonfun$decorateWithViewPermission$1(SqlFolderRepository $this, Folder f) {
        HashSet<String> permissions = new HashSet<String>();
        permissions.add(XLReleasePermissions.VIEW_FOLDER.getPermissionName());
        f.get$metadata().put("security", new EffectiveSecurity(permissions, java.util.Set.of()));
        $this.decorateWithViewPermission((scala.collection.immutable.Seq<Folder>)CollectionConverters$.MODULE$.SetHasAsScala(f.getChildren()).asScala().toSeq());
    }

    public static final /* synthetic */ void $anonfun$delete$1(SqlFolderRepository $this, FolderRow data) {
        if (data.hasSecurity()) {
            $this.teamRepository.deleteTeamsFromPlatform(data.folderId().absolute());
        }
        $this.folderPersistence.deleteByUid(data.uid());
        $this.interceptDelete(data.folderId().absolute());
    }

    public static final /* synthetic */ boolean $anonfun$findByPath$7(String pathElement$1, Tree.Node x$6) {
        String string = ((FolderRow)x$6.value()).name();
        String string2 = pathElement$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public SqlFolderRepository(FolderPersistence folderPersistence, ReleasePersistence releasePersistence, TeamRepository teamRepository, PermissionEnforcer permissionEnforcer, RoleService roleService, InternalMetadataDecoratorService decoratorService, JdbcTemplate jdbcTemplate, SqlBuilder.Dialect dialect) {
        this.folderPersistence = folderPersistence;
        this.releasePersistence = releasePersistence;
        this.teamRepository = teamRepository;
        this.permissionEnforcer = permissionEnforcer;
        this.roleService = roleService;
        this.decoratorService = decoratorService;
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        Logging.$init$((Logging)this);
        FolderRepository.$init$((FolderRepository)this);
        InterceptedRepository.$init$((InterceptedRepository)this);
    }
}

