package com.xebialabs.xlrelease.repository.sql

import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow


trait DeserializationSupport {

  def repositoryAdapter: SqlRepositoryAdapter

  def deserializeRelease(releaseData: ReleaseRow): Release =
    repositoryAdapter.deserialize(releaseData)

  def tryDeserializeRelease(releaseData: ReleaseRow): Option[Release] =
    repositoryAdapter.tryDeserialize(releaseData)
}
