package com.xebialabs.xlrelease.spring.config

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.security.sql.SecurityUserCacheConfigurationCondition
import org.springframework.cache.CacheManager
import org.springframework.cache.annotation.EnableCaching
import org.springframework.context.annotation.{Bean, Conditional, Configuration}
import com.xebialabs.xlrelease.security.sql.SecurityCacheConfigurationConstants.SECURITY_USER_CACHE_MANAGER
import com.xebialabs.xlrelease.support.cache.caffeine.spring.XlrCaffeineCacheManager

@Configuration
@Conditional(value = Array(classOf[SecurityUserCacheConfigurationCondition]))
@EnableCaching(proxyTargetClass = true)
class SecurityUserCacheConfiguration {

  @Bean
  def securityUserCacheManager(xlrConfig: XlrConfig): CacheManager = {
    new XlrCaffeineCacheManager(SECURITY_USER_CACHE_MANAGER, "security-user", xlrConfig.cache)
  }

}

