/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.customscripts.ScriptTypes;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.utils.TaskTypes;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.service.NewType;
import com.xebialabs.xlrelease.service.NewType$;
import com.xebialabs.xlrelease.service.SqlTaskTypeConversion$;
import com.xebialabs.xlrelease.service.TaskTypeConversion;
import com.xebialabs.xlrelease.service.TaskTypeConverterService;
import com.xebialabs.xlrelease.service.TaskTypeConverterSyntax$;
import com.xebialabs.xlrelease.service.TaskTypeConverters$;
import java.io.Serializable;
import org.springframework.stereotype.Component;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@IsTransactional
@Component
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015v!\u0002\u000e\u001c\u0011\u0003!c!\u0002\u0014\u001c\u0011\u00039\u0003\"\u0002\u0018\u0002\t\u0003y\u0003b\u0002\u0019\u0002\u0005\u0004%I!\r\u0005\u0007}\u0005\u0001\u000b\u0011\u0002\u001a\t\u000f}\n!\u0019!C\u0005c!1\u0001)\u0001Q\u0001\nIBq!Q\u0001C\u0002\u0013%\u0011\u0007\u0003\u0004C\u0003\u0001\u0006IA\r\u0005\b\u0007\u0006\u0011\r\u0011\"\u00032\u0011\u0019!\u0015\u0001)A\u0005e\u0019!ae\u0007\u0001F\u0011!\t6B!A!\u0002\u0013\u0011\u0006\u0002\u0003-\f\u0005\u0003\u0005\u000b\u0011B-\t\u0011}[!\u0011!Q\u0001\n\u0001D\u0001BZ\u0006\u0003\u0002\u0003\u0006Ia\u001a\u0005\t_.\u0011\t\u0011)A\u0005a\")af\u0003C\u0001g\")!p\u0003C!w\"9\u00111E\u0006\u0005\n\u0005\u0015\u0002bBA\u001e\u0017\u0011%\u0011Q\b\u0005\b\u0003\u0003ZA\u0011BA\"\u0011\u001d\tie\u0003C\u0005\u0003\u001fBq!a\u0015\f\t\u0013\t)\u0006C\u0004\u0002Z-!I!a\u0017\t\u000f\u0005U4\u0002\"\u0003\u0002x\u0005)2+\u001d7UCN\\G+\u001f9f\u0007>tg/\u001a:tS>t'B\u0001\u000f\u001e\u0003\u001d\u0019XM\u001d<jG\u0016T!AH\u0010\u0002\u0013ad'/\u001a7fCN,'B\u0001\u0011\"\u0003%AXMY5bY\u0006\u00147OC\u0001#\u0003\r\u0019w.\\\u0002\u0001!\t)\u0013!D\u0001\u001c\u0005U\u0019\u0016\u000f\u001c+bg.$\u0016\u0010]3D_:4XM]:j_:\u001c\"!\u0001\u0015\u0011\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tA%A\nU3B+ulQ(O)\u0006Ke*\u0012*`)\u0006\u001b6*F\u00013!\t\u0019D(D\u00015\u0015\t)d'A\u0004sK\u001adWm\u0019;\u000b\u0005]B\u0014aA1qS*\u0011\u0011HO\u0001\u0007a2,x-\u001b8\u000b\u0005mz\u0012\u0001\u00033fa2|\u00170\u001b;\n\u0005u\"$\u0001\u0002+za\u0016\fA\u0003V-Q\u000b~\u001buJ\u0014+B\u0013:+%k\u0018+B'.\u0003\u0013a\u0006+Z!\u0016{6)V*U\u001f6{6k\u0011*J!R{F+Q*L\u0003a!\u0016\fU#`\u0007V\u001bFkT'`'\u000e\u0013\u0016\n\u0015+`)\u0006\u001b6\nI\u0001\n)f\u0003Vi\u0018+B'.\u000b!\u0002V-Q\u000b~#\u0016iU&!\u0003=!\u0016\fU#`)\u0006\u001b6jX$S\u001fV\u0003\u0016\u0001\u0005+Z!\u0016{F+Q*L?\u001e\u0013v*\u0016)!'\rYaI\u0014\t\u0003\u000f2k\u0011\u0001\u0013\u0006\u0003\u0013*\u000bA\u0001\\1oO*\t1*\u0001\u0003kCZ\f\u0017BA'I\u0005\u0019y%M[3diB\u0011QeT\u0005\u0003!n\u0011!\u0003V1tWRK\b/Z\"p]Z,'o]5p]\u0006Y1o\u0019:jaR$\u0016\u0010]3t!\t\u0019f+D\u0001U\u0015\t)V$A\u0007dkN$x.\\:de&\u0004Ho]\u0005\u0003/R\u00131bU2sSB$H+\u001f9fg\u0006qA/Y:l%\u0016\u0004xn]5u_JL\bC\u0001.^\u001b\u0005Y&B\u0001/\u001e\u0003)\u0011X\r]8tSR|'/_\u0005\u0003=n\u0013a\u0002V1tWJ+\u0007o\\:ji>\u0014\u00180\u0001\u0005fm\u0016tGOQ;t!\t\tG-D\u0001c\u0015\t\u0019W$\u0001\u0004fm\u0016tGo]\u0005\u0003K\n\u0014\u0011\u0003\u0017'SK2,\u0017m]3Fm\u0016tGOQ;t\u0003U!W\r]3oI\u0016t7-\u001f)feNL7\u000f^3oG\u0016\u0004\"\u0001[7\u000e\u0003%T!A[6\u0002\u0017A,'o]5ti\u0016t7-\u001a\u0006\u0003Yn\u000b1a]9m\u0013\tq\u0017NA\u000bEKB,g\u000eZ3oGf\u0004VM]:jgR,gnY3\u0002!\r|gN^3si\u0016\u00148+\u001a:wS\u000e,\u0007CA\u0013r\u0013\t\u00118D\u0001\rUCN\\G+\u001f9f\u0007>tg/\u001a:uKJ\u001cVM\u001d<jG\u0016$b\u0001^;wobL\bCA\u0013\f\u0011\u0015\t\u0016\u00031\u0001S\u0011\u0015A\u0016\u00031\u0001Z\u0011\u0015y\u0016\u00031\u0001a\u0011\u00151\u0017\u00031\u0001h\u0011\u0015y\u0017\u00031\u0001q\u0003Q\u0019\u0007.\u00198hK\u0006\u001bG/\u001b<f)\u0006\u001c8\u000eV=qKR)A0!\u0002\u0002\nA\u0019Q0!\u0001\u000e\u0003yT!a`\u000f\u0002\r\u0011|W.Y5o\u0013\r\t\u0019A \u0002\u0005)\u0006\u001c8\u000e\u0003\u0004\u0002\bI\u0001\r\u0001`\u0001\u0005i\u0006\u001c8\u000e\u0003\u0004\u0002\fI\u0001\rAM\u0001\u000bi\u0006\u0014x-\u001a;UsB,\u0007f\u0001\n\u0002\u0010A!\u0011\u0011CA\u0010\u001b\t\t\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011AC1o]>$\u0018\r^5p]*!\u0011\u0011DA\u000e\u0003\u001diW\r\u001e:jGNT1!!\b\"\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BA\u0011\u0003'\u0011Q\u0001V5nK\u0012\f!d\u00195fG.$\u0016\u0010]3DQ\u0006tw-Z%t'V\u0004\bo\u001c:uK\u0012$b!a\n\u0002.\u0005]\u0002cA\u0015\u0002*%\u0019\u00111\u0006\u0016\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003_\u0019\u0002\u0019AA\u0019\u0003\u001dqWm\u001e+za\u0016\u00042!JA\u001a\u0013\r\t)d\u0007\u0002\b\u001d\u0016<H+\u001f9f\u0011\u0019\tId\u0005a\u0001y\u00069q\u000e\u001c3UCN\\\u0017A\u0004:fg>dg/\u001a(foRK\b/\u001a\u000b\u0005\u0003c\ty\u0004\u0003\u0004\u0002\fQ\u0001\rAM\u0001\u000fSN\u0004\u0016\u0010\u001e5p]N\u001b'/\u001b9u)\u0011\t)%a\u0013\u0011\u0007%\n9%C\u0002\u0002J)\u0012qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002\fU\u0001\rAM\u0001\u0010SN\u001cuN\u001c;bS:,'\u000fV1tWR!\u0011QIA)\u0011\u0019\tYA\u0006a\u0001e\u0005\u00112\r[3dWR\u000b7o[%t!2\fgN\\3e)\u0011\t9#a\u0016\t\r\u0005\u001dq\u00031\u0001}\u0003Q9W\r^!mYN+\b\u000f]8si\u0016$G+\u001f9fgV\u0011\u0011Q\f\t\u0006\u0003?\nyG\r\b\u0005\u0003C\nYG\u0004\u0003\u0002d\u0005%TBAA3\u0015\r\t9gI\u0001\u0007yI|w\u000e\u001e \n\u0003-J1!!\u001c+\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u001d\u0002t\t\u00191+Z9\u000b\u0007\u00055$&A\rqkJ<WmR1uKR\u000b7o\u001b#fa\u0016tG-\u001a8dS\u0016\u001cH\u0003BA\u0014\u0003sBa!a\u0002\u001a\u0001\u0004a\bfA\u0006\u0002~A!\u0011qPAF\u001b\t\t\tI\u0003\u0003\u0002\u0004\u0006\u0015\u0015a\u0003;sC:\u001c\u0018m\u0019;j_:T1\u0001\\AD\u0015\r\tI)H\u0001\u0003I\nLA!!$\u0002\u0002\ny\u0011j\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000eK\u0002\f\u0003#\u0003B!a%\u0002\"6\u0011\u0011Q\u0013\u0006\u0005\u0003/\u000bI*\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016TA!a'\u0002\u001e\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002 \u0006\u0019qN]4\n\t\u0005\r\u0016Q\u0013\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class SqlTaskTypeConversion
implements TaskTypeConversion {
    private final ScriptTypes scriptTypes;
    private final TaskRepository taskRepository;
    private final XLReleaseEventBus eventBus;
    private final DependencyPersistence dependencyPersistence;
    private final TaskTypeConverterService converterService;

    @Timed
    public Task changeActiveTaskType(Task task, Type targetType) {
        Object object;
        boolean isNotCustomScriptTypeOrItHasNotChanged;
        this.checkTaskIsPlanned(task);
        NewType newType = this.resolveNewType(targetType);
        this.checkTypeChangeIsSupported(newType, task);
        Type type = task.getType();
        Type type2 = newType.ciType();
        boolean ciTypeHasNotChanged = !(type != null ? !type.equals(type2) : type2 != null);
        Type type3 = task.getTaskType();
        Object object2 = newType.customScriptType().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        boolean bl = !(type3 != null ? !type3.equals(object2) : object2 != null) ? true : (isNotCustomScriptTypeOrItHasNotChanged = false);
        if (ciTypeHasNotChanged && isNotCustomScriptTypeOrItHasNotChanged) {
            return task;
        }
        Type type4 = newType.ciType();
        Type type5 = SqlTaskTypeConversion$.MODULE$.com$xebialabs$xlrelease$service$SqlTaskTypeConversion$$TYPE_CUSTOM_SCRIPT_TASK();
        Type type6 = type4;
        if (!(type5 != null ? !type5.equals(type6) : type6 != null)) {
            object = TaskTypeConverterSyntax$.MODULE$.TaskTypeConverterOps(task).convertTo(newType, this.converterService, TaskTypeConverters$.MODULE$.toCustomScriptTaskConverter());
        } else {
            Type type7 = SqlTaskTypeConversion$.MODULE$.com$xebialabs$xlrelease$service$SqlTaskTypeConversion$$TYPE_CONTAINER_TASK();
            Type type8 = type4;
            object = !(type7 != null ? !type7.equals(type8) : type8 != null) ? TaskTypeConverterSyntax$.MODULE$.TaskTypeConverterOps(task).convertTo(newType, this.converterService, TaskTypeConverters$.MODULE$.toContainerTaskConverter()) : TaskTypeConverterSyntax$.MODULE$.TaskTypeConverterOps(task).convertTo(newType, this.converterService, TaskTypeConverters$.MODULE$.toTaskConverter());
        }
        CustomScriptTask updatedTask = object;
        this.purgeGateTaskDependencies(task);
        Task result = this.taskRepository.updateType((Task)updatedTask);
        this.eventBus.publish((XLReleaseEvent)new TaskUpdatedEvent(task, result));
        return result;
    }

    private void checkTypeChangeIsSupported(NewType newType, Task oldTask) {
        boolean newTypeIsTaskType = newType.ciType().instanceOf(SqlTaskTypeConversion$.MODULE$.com$xebialabs$xlrelease$service$SqlTaskTypeConversion$$TYPE_TASK());
        Checks.checkArgument((this.isPythonScript(newType.ciType()) || newTypeIsTaskType ? 1 : 0) != 0, (String)("Cannot change type of task '" + oldTask.getTitle() + "' to '" + newType + "' because it is not one of supported types: " + this.getAllSupportedTypes().mkString(",")), (Object[])new Object[0]);
        if (oldTask.getType().isSubTypeOf(SqlTaskTypeConversion$.MODULE$.com$xebialabs$xlrelease$service$SqlTaskTypeConversion$$TYPE_TASK_GROUP())) {
            throw new IllegalArgumentException("Conversion of task '" + oldTask.getTitle() + "' from '" + oldTask.getType() + "' is not supported.");
        }
    }

    private NewType resolveNewType(Type targetType) {
        if (this.isPythonScript(targetType)) {
            return new NewType(SqlTaskTypeConversion$.MODULE$.com$xebialabs$xlrelease$service$SqlTaskTypeConversion$$TYPE_CUSTOM_SCRIPT_TASK(), (Option<Type>)new Some((Object)targetType), NewType$.MODULE$.apply$default$3());
        }
        if (this.isContainerTask(targetType)) {
            return new NewType(SqlTaskTypeConversion$.MODULE$.com$xebialabs$xlrelease$service$SqlTaskTypeConversion$$TYPE_CONTAINER_TASK(), (Option<Type>)None$.MODULE$, (Option<Type>)new Some((Object)targetType));
        }
        return new NewType(targetType, (Option<Type>)None$.MODULE$, NewType$.MODULE$.apply$default$3());
    }

    private boolean isPythonScript(Type targetType) {
        return this.scriptTypes.getPythonScriptTypes().contains(targetType);
    }

    private boolean isContainerTask(Type targetType) {
        return this.scriptTypes.getContainerTaskTypes().contains(targetType);
    }

    private void checkTaskIsPlanned(Task task) {
        Checks.checkArgument((boolean)task.isPlanned(), (String)"Cannot change type of the task '%s' because it is in state %s and not %s", (Object[])new Object[]{task.getTitle(), task.getStatus(), TaskStatus.PLANNED});
    }

    private Seq<Type> getAllSupportedTypes() {
        return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(TaskTypes.getDefaultTaskTypes()).asScala().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.CollectionHasAsScala(this.scriptTypes.getPythonScriptTypes()).asScala())).$plus$plus((IterableOnce)CollectionConverters$.MODULE$.CollectionHasAsScala(this.scriptTypes.getContainerTaskTypes()).asScala())).toSeq();
    }

    private void purgeGateTaskDependencies(Task task) {
        Task task2 = task;
        if (task2 instanceof GateTask) {
            GateTask gateTask = (GateTask)task2;
            CollectionConverters$.MODULE$.ListHasAsScala(gateTask.getDependencies()).asScala().foreach((Function1 & Serializable)dependency -> {
                this.dependencyPersistence.deleteDependency(dependency);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public SqlTaskTypeConversion(ScriptTypes scriptTypes, TaskRepository taskRepository, XLReleaseEventBus eventBus, DependencyPersistence dependencyPersistence, TaskTypeConverterService converterService) {
        this.scriptTypes = scriptTypes;
        this.taskRepository = taskRepository;
        this.eventBus = eventBus;
        this.dependencyPersistence = dependencyPersistence;
        this.converterService = converterService;
    }
}

