package com.xebialabs.xlrelease.security

import com.xebialabs.xlrelease.domain.distributed.events.{DistributedGroupDeleted, DistributedUserGroupMembershipUpdated}
import com.xebialabs.xlrelease.events.{AsyncSubscribe, EventListener}
import com.xebialabs.xlrelease.security.sql.SecurityCacheConfigurationConstants._
import grizzled.slf4j.Logging
import org.springframework.cache.CacheManager
import org.springframework.util.StringUtils.hasText

@EventListener
class DistributedUserGroupEventListener(cacheManager: CacheManager) extends Logging {

  @AsyncSubscribe
  def onGroupDeleted(event: DistributedGroupDeleted): Unit = {
    if (null != event && hasText(event.groupName)) {
      logger.trace(s"Invalidating $SECURITY_USER_GROUPS cache for all users")
      val cache = cacheManager.getCache(SECURITY_USER_GROUPS)
      cache.invalidate()
    }
  }

  @AsyncSubscribe
  def onUserGroupMembershipUpdated(event: DistributedUserGroupMembershipUpdated): Unit = {
    if (null != event && hasText(event.user)) {
      logger.trace(s"Invalidating $SECURITY_USER_GROUPS cache for user '${event.user}'")
      val cache = cacheManager.getCache(SECURITY_USER_GROUPS)
      cache.evict(event.user)
      cache.evict(event.user.toLowerCase)
    }
  }
}
