package com.xebialabs.xlrelease.repository.sql.persistence

import java.util.UUID
import scala.util.Try

object Token {
  def fresh(): Token = UUID.randomUUID()
  def apply(token: Token): String = token.toString
  def asString(token: Token): String = token.toString
  def fromString(s: String): Option[Token] = Try(UUID.fromString(s)).toOption

  implicit class TokenOps(val token: Token) extends AnyVal {
    def asString: String = Token.asString(token)
  }
}
