package com.xebialabs.xlrelease.upgrade.db

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.features.settings.{NoExpirationDuration, PersonalAccessTokenFeatureSettings}
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.common.BaseInitializingUpgrade
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

@Component
class XLRelease2410AccessTokenFeatureUpgrade(configurationRepository: ConfigurationRepository) extends BaseInitializingUpgrade with Logging {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "24.1.0#4")

  override def doUpgrade(): Boolean = {
    logger.info(s"Upgrading personal access token feature settings")
    val featureType = Type.valueOf(classOf[PersonalAccessTokenFeatureSettings])
    val featureSetting = configurationRepository.findFirstByType[PersonalAccessTokenFeatureSettings](featureType)
    if (featureSetting.isEmpty) {
      val feature: PersonalAccessTokenFeatureSettings = featureType.getDescriptor.newInstance("")
      feature.generateId()
      feature.setMaxTokenExpiration(new NoExpirationDuration())
      configurationRepository.create(feature)
    } else {
      val feature = featureSetting.get()
      feature.setMaxTokenExpiration(new NoExpirationDuration())
      configurationRepository.update(feature)
    }

    true
  }
}
