package com.xebialabs.xlrelease.upgrade.db

import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.xlrelease.configuration.PollingSettings
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationPersistence
import com.xebialabs.xlrelease.repository.sql.{ConfigurationRowReader, SqlRepositoryAdapter}
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import grizzled.slf4j.Logging
import org.codehaus.jettison.json.JSONObject
import org.springframework.stereotype.Component

import scala.util.{Failure, Try}

@Component
class XLRelease2230PollingSettingsUpgrade(configurationRepository: ConfigurationRepository,
                                          configurationPersistence: ConfigurationPersistence,
                                          val sqlRepositoryAdapter: SqlRepositoryAdapter)
  extends Upgrade with Logging with ConfigurationRowReader {

  override def doUpgrade(): Boolean = {
    Try(upgradePollingVersionSettings()) match {
      case Failure(_) => logger.error("Unable to upgrade Polling Settings configuration")
      case _ =>
    }
    true

  }

  def upgradePollingVersionSettings(): Unit = {
    for {
      configurationRow <- configurationPersistence.findById(PollingSettings.POLLING_SETTINGS_ID)
      pollingSettingJson = new JSONObject(configurationRow._2) if pollingSettingJson.has("pollingInterval")
      pollingInterval = pollingSettingJson.getInt("pollingInterval")
      _ = pollingSettingJson.remove("pollingInterval")
      pollSettings <- readConfiguration[PollingSettings]((None, pollingSettingJson.toString, configurationRow._3))
    } {
      logger.info("Found Polling Settings configuration for upgrade")
      pollSettings.setTaskStatusInterval(pollingInterval)
      configurationRepository.update[PollingSettings](pollSettings)
      logger.info("Polling Settings configuration upgrade is completed")
    }
  }

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "22.3.0#1")
}
