/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security.entities;

import com.xebialabs.xlrelease.security.entities.XlRole;
import com.xebialabs.xlrelease.security.entities.XlRolePermissionId;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MapsId;
import jakarta.persistence.Table;

@Entity
@Table(name="XL_ROLE_PERMISSIONS")
public class XlRolePermission {
    @EmbeddedId
    private XlRolePermissionId id;
    @MapsId(value="roleId")
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="ROLE_ID", nullable=false)
    private XlRole role;

    public XlRolePermission() {
    }

    public XlRolePermission(XlRolePermissionId id, XlRole role) {
        this.id = id;
        this.role = role;
    }

    public XlRolePermission(XlRole role, String permissionName) {
        this.id = new XlRolePermissionId(role.getId(), permissionName, role.getCiId());
        this.role = role;
    }

    public XlRolePermissionId getId() {
        return this.id;
    }

    public void setId(XlRolePermissionId id) {
        this.id = id;
    }

    public XlRole getRole() {
        return this.role;
    }

    public void setRole(XlRole role) {
        this.role = role;
    }
}

