/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql.persistence.configuration;

import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistenceCommon;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ConfigurationReferenceRow;
import com.xebialabs.xlrelease.utils.FolderId;
import java.io.Serializable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0005Uc\u0001\u0002\b\u0010\u0001yA\u0001b\t\u0001\u0003\u0006\u0004%\t\u0005\n\u0005\tS\u0001\u0011\t\u0011)A\u0005K!A!\u0006\u0001BC\u0002\u0013\u00053\u0006\u0003\u00059\u0001\t\u0005\t\u0015!\u0003-\u0011!I\u0004A!b\u0001\n\u0007R\u0004\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\t\u000bM\u0003A\u0011\u0001+\t\u000fe\u0003!\u0019!C)5\"1\u0001\u000e\u0001Q\u0001\nmCQ!\u001b\u0001\u0005R)DQ!\u001e\u0001\u0005BYDq!a\t\u0001\t\u0003\n)\u0003C\u0004\u00022\u0001!\t&a\r\u0003QQ\u0013\u0018nZ4fe\u000e{gNZ5hkJ\fG/[8o%\u00164WM]3oG\u0016\u0004VM]:jgR,gnY3\u000b\u0005A\t\u0012!D2p]\u001aLw-\u001e:bi&|gN\u0003\u0002\u0013'\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\t!R#A\u0002tc2T!AF\f\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002\u00193\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u00035m\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003q\t1aY8n\u0007\u0001\u0019\"\u0001A\u0010\u0011\u0005\u0001\nS\"A\b\n\u0005\tz!aJ\"p]\u001aLw-\u001e:bi&|gNU3gKJ,gnY3QKJ\u001c\u0018n\u001d;f]\u000e,7i\\7n_:\f\u0011CZ8mI\u0016\u0014\b+\u001a:tSN$XM\\2f+\u0005)\u0003C\u0001\u0014(\u001b\u0005\t\u0012B\u0001\u0015\u0012\u0005E1u\u000e\u001c3feB+'o]5ti\u0016t7-Z\u0001\u0013M>dG-\u001a:QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%\u0001\u0007kI\n\u001cG+Z7qY\u0006$X-F\u0001-!\tic'D\u0001/\u0015\ty\u0003'\u0001\u0003d_J,'BA\u00193\u0003\u0011QGMY2\u000b\u0005M\"\u0014aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003U\n1a\u001c:h\u0013\t9dF\u0001\u0007KI\n\u001cG+Z7qY\u0006$X-A\u0007kI\n\u001cG+Z7qY\u0006$X\rI\u0001\bI&\fG.Z2u+\u0005Y\u0004C\u0001\u001fP\u001d\tiDJ\u0004\u0002?\u0015:\u0011q\b\u0013\b\u0003\u0001\u001es!!\u0011$\u000f\u0005\t+U\"A\"\u000b\u0005\u0011k\u0012A\u0002\u001fs_>$h(C\u0001\u001d\u0013\tQ2$\u0003\u0002\u00193%\u0011\u0011jF\u0001\u0003I\nL!\u0001F&\u000b\u0005%;\u0012BA'O\u0003)\u0019\u0016\u000f\u001c\"vS2$WM\u001d\u0006\u0003)-K!\u0001U)\u0003\u000f\u0011K\u0017\r\\3di*\u0011QJT\u0001\tI&\fG.Z2uA\u00051A(\u001b8jiz\"B!\u0016,X1B\u0011\u0001\u0005\u0001\u0005\u0006G\u001d\u0001\r!\n\u0005\u0006U\u001d\u0001\r\u0001\f\u0005\u0006s\u001d\u0001\u001daO\u0001\u0006i\u0006\u0014G.Z\u000b\u00027B\u0011A,\u001a\b\u0003;\u000et!A\u00182\u000f\u0005}\u000bgBA a\u0013\t1r#\u0003\u0002\u0015+%\u0011!cE\u0005\u0003IF\taaU2iK6\f\u0017B\u00014h\u0005E\u0019uN\u001c4jOV\u0014\u0018\r^5p]J+gm\u001d\u0006\u0003IF\ta\u0001^1cY\u0016\u0004\u0013!D*U\u001bR{v)\u0012+`%\u001635+F\u0001l!\ta'O\u0004\u0002naB\u0011!I\u001c\u0006\u0002_\u0006)1oY1mC&\u0011\u0011O\\\u0001\u0007!J,G-\u001a4\n\u0005M$(AB*ue&twM\u0003\u0002r]\u0006aa-\u001b8e\u00032d')_+jIR\u0019q/a\u0005\u0011\tal\u0018\u0011\u0001\b\u0003snt!A\u0011>\n\u0003=L!\u0001 8\u0002\u000fA\f7m[1hK&\u0011ap \u0002\u0004'\u0016\f(B\u0001?o!\u0011\t\u0019!!\u0004\u000f\t\u0005\u0015\u0011\u0011\u0002\b\u0004;\u0006\u001d\u0011B\u0001\t\u0012\u0013\r\tYaD\u0001\u0019\u0007>tg-[4ve\u0006$\u0018n\u001c8QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\u0002BA\b\u0003#\u0011\u0001cQ8oM&<WO]1uS>t'k\\<\u000b\u0007\u0005-q\u0002C\u0004\u0002\u0016-\u0001\r!a\u0006\u0002\u0007ULG\r\u0005\u0003\u0002\u001a\u0005uabA/\u0002\u001c%\u0011A0E\u0005\u0005\u0003?\t\tCA\u0003DSVKGM\u0003\u0002}#\u0005ib-\u001b8e\u00032dgj\u001c8J]\",'/\u001b;fIJ+g-\u001a:f]\u000e,7\u000f\u0006\u0004\u0002(\u0005%\u0012Q\u0006\t\u0004qv\\\u0007BBA\u0016\u0019\u0001\u00071.\u0001\u0005g_2$WM]%e\u0011\u001d\ty\u0003\u0004a\u0001\u0003O\tq\"];fef\u0004\u0016M]1nKR,'o]\u0001 G>tg-[4ve\u0006$\u0018n\u001c8SK\u001a,'/\u001a8dKJ{w/T1qa\u0016\u0014XCAA\u001b!\u0015i\u0013qGA\u001e\u0013\r\tID\f\u0002\n%><X*\u00199qKJ\u0004B!!\u0010\u0002D5\u0011\u0011q\b\u0006\u0004\u0003\u0003\n\u0012\u0001\u00023bi\u0006LA!!\u0012\u0002@\tI2i\u001c8gS\u001e,(/\u0019;j_:\u0014VMZ3sK:\u001cWMU8xQ\r\u0001\u0011\u0011\n\t\u0005\u0003\u0017\n\t&\u0004\u0002\u0002N)\u0019\u0011q\n(\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0003'\niEA\bJgR\u0013\u0018M\\:bGRLwN\\1m\u0001")
public class TriggerConfigurationReferencePersistence
extends ConfigurationReferencePersistenceCommon {
    private final FolderPersistence folderPersistence;
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private final Schema.ConfigurationRefs table;

    @Override
    public FolderPersistence folderPersistence() {
        return this.folderPersistence;
    }

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Override
    public Schema.ConfigurationRefs table() {
        return this.table;
    }

    @Override
    public String STMT_GET_REFS() {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|SELECT\n        |   entity." + Schema.TRIGGERS$.MODULE$.TRIGGER_TITLE() + ",\n        |   entity." + Schema.TRIGGERS$.MODULE$.ID() + ",\n        |   folders." + Schema.FOLDERS$.MODULE$.FOLDER_ID() + "\n        | FROM\n        |   " + this.table().TABLE() + " refs\n        |   JOIN " + Schema.TRIGGERS$.MODULE$.TABLE() + " entity ON refs." + this.table().USED_BY_UID() + " = entity." + Schema.TRIGGERS$.MODULE$.CI_UID() + "\n        |   JOIN " + Schema.FOLDERS$.MODULE$.TABLE() + " folders ON folders." + Schema.FOLDERS$.MODULE$.CI_UID() + " = entity." + Schema.TRIGGERS$.MODULE$.FOLDER_UID() + "\n        | WHERE\n        |   refs." + this.table().CONFIGURATION_UID() + " = :configurationCiUid"));
    }

    @Override
    public Seq<Tuple3<Option<FolderId>, String, Integer>> findAllByUid(Integer uid) {
        this.logger().trace((Function0 & Serializable)() -> "Eager fetching configurations for a trigger with uid: " + uid);
        return this.sqlQuery(this.STMT_ALL_CONFIGURATIONS_BY_UID(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"uid"), (Object)uid)})), this.configurationBinaryStreamRowMapper(uid)).toSeq();
    }

    @Override
    public Seq<String> findAllNonInheritedReferences(String folderId, Seq<String> queryParameters) {
        String sql = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |SELECT DISTINCT\n         |  cfg." + Schema.CONFIGURATIONS$.MODULE$.ID() + "\n         |FROM\n         |  " + Schema.TRIGGERS$.MODULE$.TABLE() + " tr\n         |  INNER JOIN " + Schema.FOLDERS$.MODULE$.TABLE() + " folder ON folder." + Schema.FOLDERS$.MODULE$.CI_UID() + " = tr." + Schema.TRIGGERS$.MODULE$.FOLDER_UID() + "\n         |  INNER JOIN " + this.table().TABLE() + " refs ON refs." + this.table().USED_BY_UID() + " = tr." + Schema.TRIGGERS$.MODULE$.CI_UID() + "\n         |  INNER JOIN " + Schema.CONFIGURATIONS$.MODULE$.TABLE() + " cfg ON cfg." + Schema.CONFIGURATIONS$.MODULE$.CI_UID() + " = refs." + this.table().CONFIGURATION_UID() + "\n         |    AND cfg." + Schema.CONFIGURATIONS$.MODULE$.FOLDER_CI_UID() + " IS NOT NULL\n         |    AND cfg." + Schema.CONFIGURATIONS$.MODULE$.FOLDER_CI_UID() + " != folder." + Schema.FOLDERS$.MODULE$.CI_UID() + "\n         |WHERE folder." + Schema.FOLDERS$.MODULE$.FOLDER_ID() + " = :folderId\n         |  OR folder." + Schema.FOLDERS$.MODULE$.FOLDER_PATH() + " LIKE :folderPath\n         |"));
        String folderPartialId = Ids.getName((String)folderId);
        String folderPath = "%/" + folderPartialId + "%";
        return this.sqlQuery(sql, Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"folderId"), (Object)folderPartialId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"folderPath"), (Object)folderPath)})), (Function1 & Serializable)rs -> rs.getString(Schema.CONFIGURATIONS$.MODULE$.ID())).toSeq();
    }

    @Override
    public RowMapper<ConfigurationReferenceRow> configurationReferenceRowMapper() {
        return (rs, x$1) -> {
            String title = rs.getString(Schema.TRIGGERS$.MODULE$.TRIGGER_TITLE());
            String id = rs.getString(Schema.TRIGGERS$.MODULE$.ID());
            FolderId folderId = new FolderId(rs.getString(Schema.FOLDERS$.MODULE$.FOLDER_ID()));
            return new ConfigurationReferenceRow(title, folderId.$div(id).absolute());
        };
    }

    public TriggerConfigurationReferencePersistence(FolderPersistence folderPersistence, JdbcTemplate jdbcTemplate, SqlBuilder.Dialect dialect) {
        this.folderPersistence = folderPersistence;
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        this.table = Schema.TRIGGER_CONFIGURATION_REFS$.MODULE$;
    }
}

