/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.repository.FolderVariableRepository;
import com.xebialabs.xlrelease.repository.IdMatchers;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderVariablePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderVariableRow;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@Repository
@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015e\u0001B\b\u0011\u0001mA\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tk\u0001\u0011\t\u0011)A\u0005m!)!\b\u0001C\u0001w!)a\n\u0001C!\u001f\")\u0001\r\u0001C!C\")1\u000e\u0001C!Y\")\u0011\u000f\u0001C!e\")\u0011\u000f\u0001C!k\"9\u0011\u0011\u0004\u0001\u0005B\u0005m\u0001bBA\r\u0001\u0011\u0005\u0013q\u0004\u0005\b\u0003K\u0001A\u0011IA\u0014\u0011\u001d\t\t\u0004\u0001C!\u0003gAq!!\u0013\u0001\t\u0003\nY\u0005C\u0004\u0002P\u0001!I!!\u0015\u00037M\u000bHNR8mI\u0016\u0014h+\u0019:jC\ndWMU3q_NLGo\u001c:z\u0015\t\t\"#A\u0002tc2T!a\u0005\u000b\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002\u0016-\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003/a\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003e\t1aY8n\u0007\u0001\u0019B\u0001\u0001\u000f#MA\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\u0004\"a\t\u0013\u000e\u0003II!!\n\n\u00031\u0019{G\u000eZ3s-\u0006\u0014\u0018.\u00192mKJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002(Y5\t\u0001F\u0003\u0002*U\u0005)1\u000f\u001c45U*\t1&\u0001\u0005he&T(\u0010\\3e\u0013\ti\u0003FA\u0004M_\u001e<\u0017N\\4\u0002'Y\f'/[1cY\u0016\u0004VM]:jgR,gnY3\u0011\u0005A\u001aT\"A\u0019\u000b\u0005I\u0002\u0012a\u00039feNL7\u000f^3oG\u0016L!\u0001N\u0019\u00033\u0019{G\u000eZ3s-\u0006\u0014\u0018.\u00192mKB+'o]5ti\u0016t7-Z\u0001\u0012e\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014\bCA\u001c9\u001b\u0005\u0001\u0012BA\u001d\u0011\u0005Q\u0019\u0016\u000f\u001c*fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;fe\u00061A(\u001b8jiz\"2\u0001P\u001f?!\t9\u0004\u0001C\u0003/\u0007\u0001\u0007q\u0006C\u00036\u0007\u0001\u0007a\u0007\u000b\u0002\u0004\u0001B\u0011\u0011\tT\u0007\u0002\u0005*\u00111\tR\u0001\u000bC:tw\u000e^1uS>t'BA#G\u0003\u001d1\u0017m\u0019;pefT!a\u0012%\u0002\u000b\t,\u0017M\\:\u000b\u0005%S\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003-\u000b1a\u001c:h\u0013\ti%IA\u0005BkR|w/\u001b:fI\u00061Q\r_5tiN$\"\u0001U*\u0011\u0005u\t\u0016B\u0001*\u001f\u0005\u001d\u0011un\u001c7fC:DQ\u0001\u0016\u0003A\u0002U\u000b!B^1sS\u0006\u0014G.Z%e!\t1VL\u0004\u0002X7B\u0011\u0001LH\u0007\u00023*\u0011!LG\u0001\u0007yI|w\u000e\u001e \n\u0005qs\u0012A\u0002)sK\u0012,g-\u0003\u0002_?\n11\u000b\u001e:j]\u001eT!\u0001\u0018\u0010\u0002\u0011\u0019Lg\u000e\u001a\"z\u0013\u0012$\"A\u00196\u0011\u0005\rDW\"\u00013\u000b\u0005\u00154\u0017!\u0003<be&\f'\r\\3t\u0015\t9G#\u0001\u0004e_6\f\u0017N\\\u0005\u0003S\u0012\u0014\u0001BV1sS\u0006\u0014G.\u001a\u0005\u0006)\u0016\u0001\r!V\u0001\nM&tGMQ=LKf$2AY7p\u0011\u0015qg\u00011\u0001V\u0003-1\u0018M]5bE2,7*Z=\t\u000bA4\u0001\u0019A+\u0002\u0011\u0019|G\u000eZ3s\u0013\u0012\faa\u0019:fCR,GC\u00012t\u0011\u0015!x\u00011\u0001c\u0003!1\u0018M]5bE2,Gc\u00012wo\")A\u000f\u0003a\u0001E\")\u0001\u0010\u0003a\u0001s\u0006Yam\u001c7eKJ\u001c\u0015.V5e!\rQ\u00181\u0003\b\u0004w\u0006=ab\u0001?\u0002\u000e9\u0019Q0a\u0003\u000f\u0007y\fIAD\u0002\u0000\u0003\u000fqA!!\u0001\u0002\u00069\u0019\u0001,a\u0001\n\u0003eI!a\u0006\r\n\u0005U1\u0012BA\n\u0015\u0013\t\t\"#\u0003\u00023!%\u0019\u0011\u0011C\u0019\u0002\u000fA\f7m[1hK&!\u0011QCA\f\u0005\u0015\u0019\u0015.V5e\u0015\r\t\t\"M\u0001\u0007kB$\u0017\r^3\u0015\u0007\t\fi\u0002C\u0003u\u0013\u0001\u0007!\rF\u0003c\u0003C\t\u0019\u0003C\u0003u\u0015\u0001\u0007!\rC\u0003y\u0015\u0001\u0007\u00110\u0001\u0004eK2,G/\u001a\u000b\u0005\u0003S\ty\u0003E\u0002\u001e\u0003WI1!!\f\u001f\u0005\u0011)f.\u001b;\t\u000bQ[\u0001\u0019A+\u0002!\u001d,G/\u00117m\rJ|W\u000eU1sK:$H\u0003BA\u001b\u0003\u000b\u0002R!a\u000e\u0002B\tl!!!\u000f\u000b\t\u0005m\u0012QH\u0001\u0005kRLGN\u0003\u0002\u0002@\u0005!!.\u0019<b\u0013\u0011\t\u0019%!\u000f\u0003\t1K7\u000f\u001e\u0005\u0007\u0003\u000fb\u0001\u0019A+\u0002!Y\f'/[1cY\u0016\u0004\u0016M]3oi&#\u0017AE4fi\u0006cGN\u0012:p[\u0006s7-Z:uef$B!!\u000e\u0002N!1\u0011qI\u0007A\u0002U\u000b!\u0002^8WCJL\u0017M\u00197f)\r\u0011\u00171\u000b\u0005\b\u0003+r\u0001\u0019AA,\u0003-1\u0018M]5bE2,'k\\<\u0011\t\u0005e\u0013qL\u0007\u0003\u00037R1!!\u00182\u0003\u0011!\u0017\r^1\n\t\u0005\u0005\u00141\f\u0002\u0012\r>dG-\u001a:WCJL\u0017M\u00197f%><\bf\u0001\u0001\u0002fA!\u0011qMA7\u001b\t\tIGC\u0002\u0002l!\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\ty'!\u001b\u0003\u0015I+\u0007o\\:ji>\u0014\u0018\u0010K\u0002\u0001\u0003g\u0002B!!\u001e\u0002\u00026\u0011\u0011q\u000f\u0006\u0005\u0003s\nY(A\u0006ue\u0006t7/Y2uS>t'bA\t\u0002~)\u0019\u0011q\u0010\u000b\u0002\u0005\u0011\u0014\u0017\u0002BAB\u0003o\u0012q\"S:Ue\u0006t7/Y2uS>t\u0017\r\u001c")
public class SqlFolderVariableRepository
implements FolderVariableRepository,
Logging {
    private final FolderVariablePersistence variablePersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlFolderVariableRepository sqlFolderVariableRepository = this;
        synchronized (sqlFolderVariableRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public boolean exists(String variableId) {
        this.logger().debug((Function0 & Serializable)() -> "checking folder variable exists [" + variableId + "]");
        return this.variablePersistence.exists(variableId);
    }

    public Variable findById(String variableId) {
        this.logger().debug((Function0 & Serializable)() -> "finding folder variable [" + variableId + "]");
        return (Variable)this.variablePersistence.findById(variableId).map((Function1 & Serializable)variableRow -> this.toVariable((FolderVariableRow)variableRow)).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Variable with id='%s' not found", new Object[]{variableId});
        });
    }

    public Variable findByKey(String variableKey, String folderId) {
        this.logger().debug((Function0 & Serializable)() -> "finding folder variable [key=" + variableKey + "], [folderId=" + folderId + "]");
        return (Variable)this.variablePersistence.findVariableByKey(variableKey, folderId).map((Function1 & Serializable)variableRow -> this.toVariable((FolderVariableRow)variableRow)).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Variable with key='%s' not found", new Object[]{variableKey});
        });
    }

    public Variable create(Variable variable) {
        this.logger().debug((Function0 & Serializable)() -> "creating new folder variable [key=" + variable.getKey() + "], [folderId=" + variable.getFolderId() + "]");
        Integer ciUid = this.variablePersistence.create(variable);
        return (Variable)this.variablePersistence.findByCiUid(ciUid).map((Function1 & Serializable)variableRow -> this.toVariable((FolderVariableRow)variableRow)).get();
    }

    public Variable create(Variable variable, Integer folderCiUid) {
        this.logger().debug((Function0 & Serializable)() -> "creating new folder variable [key=" + variable.getKey() + "], [folderId=" + variable.getFolderId() + "]");
        Integer ciUid = this.variablePersistence.create(variable, folderCiUid);
        return (Variable)this.variablePersistence.findByCiUid(ciUid).map((Function1 & Serializable)variableRow -> this.toVariable((FolderVariableRow)variableRow)).get();
    }

    public Variable update(Variable variable) {
        this.logger().debug((Function0 & Serializable)() -> "updating folder variable [key=" + variable.getKey() + "], [folderId=" + variable.getFolderId() + "]");
        this.variablePersistence.update(variable);
        return this.findById(variable.getId());
    }

    public Variable update(Variable variable, Integer folderCiUid) {
        this.logger().debug((Function0 & Serializable)() -> "updating folder variable [key=" + variable.getKey() + "], [folderId=" + variable.getFolderId() + "]");
        this.variablePersistence.update(variable, folderCiUid);
        return this.findById(variable.getId());
    }

    public void delete(String variableId) {
        this.logger().debug((Function0 & Serializable)() -> "deleting folder variable [" + variableId + "])");
        this.variablePersistence.delete(variableId);
    }

    public List<Variable> getAllFromParent(String variableParentId) {
        Option option;
        this.logger().debug((Function0 & Serializable)() -> "getting all folder variables by parent [id=" + variableParentId + "]");
        String string = variableParentId;
        if (string != null && !(option = IdMatchers.FolderId$.MODULE$.unapply(string)).isEmpty()) {
            String folderId = (String)option.get();
            return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)this.variablePersistence.findByFolderId(folderId).map((Function1 & Serializable)variableRow -> this.toVariable((FolderVariableRow)variableRow))).asJava();
        }
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)Buffer$.MODULE$.empty()).asJava();
    }

    public List<Variable> getAllFromAncestry(String variableParentId) {
        Option option;
        this.logger().debug((Function0 & Serializable)() -> "getting all folder variables from ancestry [id=" + variableParentId + "]");
        String string = variableParentId;
        if (string != null && !(option = IdMatchers.FolderId$.MODULE$.unapply(string)).isEmpty()) {
            String folderId = (String)option.get();
            return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)this.variablePersistence.findByParentIdIncludingAncestors(folderId).map((Function1 & Serializable)variableRow -> this.toVariable((FolderVariableRow)variableRow))).asJava();
        }
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)Buffer$.MODULE$.empty()).asJava();
    }

    private Variable toVariable(FolderVariableRow variableRow) {
        return (Variable)this.repositoryAdapter.deserialize(variableRow.json()).map((Function1 & Serializable)variable -> {
            variable.setFolderId(variableRow.folderId().absolute());
            return variable;
        }).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Error reading folder variable '" + variableRow.ciUid() + "', see logs for more details.", new Object[0]);
        });
    }

    @Autowired
    public SqlFolderVariableRepository(FolderVariablePersistence variablePersistence, SqlRepositoryAdapter repositoryAdapter) {
        this.variablePersistence = variablePersistence;
        this.repositoryAdapter = repositoryAdapter;
        Logging.$init$((Logging)this);
    }
}

