/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.LicenseVersion4;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.domain.ReleaseKind;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.exception.LicenseLimitReachedException;
import com.xebialabs.xlrelease.limits.LimitEnforcer;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.sql.ReleasePersistenceInterceptor$;
import com.xebialabs.xlrelease.repository.sql.WorkflowInterceptorLogic;
import com.xebialabs.xlrelease.repository.sql.WorkflowTaskValidator;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.utils.TenantContext$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Component
@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0005-h\u0001\u0002\u0011\"\u00011B\u0001B\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\t%\u0002\u0011)\u0019!C\u0001'\"A!\f\u0001B\u0001B\u0003%A\u000b\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003]\u0011!y\u0006A!A!\u0002\u0013\u0001\u0007\u0002\u00035\u0001\u0005\u0003\u0005\u000b\u0011B5\t\u000b=\u0004A\u0011\u00019\t\u000b]\u0004A\u0011\t=\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006!9\u0011\u0011\u0002\u0001\u0005\n\u0005-\u0001bBA\u0013\u0001\u0011%\u0011q\u0005\u0005\b\u0003_\u0001A\u0011BA\u0019\u0011\u001d\t)\u0005\u0001C\u0005\u0003\u000fBq!!\u0014\u0001\t\u0013\ty\u0005C\u0004\u0002V\u0001!I!a\u0016\t\u000f\u0005m\u0003\u0001\"\u0003\u0002^!9\u0011\u0011\r\u0001\u0005\n\u0005\r\u0004bBA4\u0001\u0011%\u0011\u0011\u000e\u0005\b\u0003[\u0002A\u0011BA8\u0011\u001d\t\u0019\b\u0001C\u0005\u0003kBq!!\u001f\u0001\t\u0013\tY\bC\u0004\u0002\u0000\u0001!I!!!\t\u000f\u0005\u0015\u0005\u0001\"\u0003\u0002\b\"9\u00111\u0012\u0001\u0005\n\u00055uaBA]C!\u0005\u00111\u0018\u0004\u0007A\u0005B\t!!0\t\r=TB\u0011AAc\u0011%\t9M\u0007b\u0001\n\u0013\tI\r\u0003\u0005\u0002Rj\u0001\u000b\u0011BAf\u0011%\t\u0019N\u0007b\u0001\n\u0013\t)\u000e\u0003\u0005\u0002jj\u0001\u000b\u0011BAl\u0005u\u0011V\r\\3bg\u0016\u0004VM]:jgR,gnY3J]R,'oY3qi>\u0014(B\u0001\u0012$\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003I\u0015\n!B]3q_NLGo\u001c:z\u0015\t1s%A\u0005yYJ,G.Z1tK*\u0011\u0001&K\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AK\u0001\u0004G>l7\u0001A\n\u0007\u00015*th\u0011$\u0011\u00059\u001aT\"A\u0018\u000b\u0005A\n\u0014\u0001\u00027b]\u001eT\u0011AM\u0001\u0005U\u00064\u0018-\u0003\u00025_\t1qJ\u00196fGR\u00042AN\u001c:\u001b\u0005\u0019\u0013B\u0001\u001d$\u0005Y\u0001VM]:jgR,gnY3J]R,'oY3qi>\u0014\bC\u0001\u001e>\u001b\u0005Y$B\u0001\u001f&\u0003\u0019!w.\\1j]&\u0011ah\u000f\u0002\b%\u0016dW-Y:f!\t\u0001\u0015)D\u0001\"\u0013\t\u0011\u0015EA\u000bX_J\\g\r\\8x)\u0006\u001c8NV1mS\u0012\fGo\u001c:\u0011\u0005\u0001#\u0015BA#\"\u0005a9vN]6gY><\u0018J\u001c;fe\u000e,\u0007\u000f^8s\u0019><\u0017n\u0019\t\u0003\u000f2k\u0011\u0001\u0013\u0006\u0003\u0013*\u000bQa\u001d7gi)T\u0011aS\u0001\tOJL'P\u001f7fI&\u0011Q\n\u0013\u0002\b\u0019><w-\u001b8h\u0003E\u0011X\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\t\u0003mAK!!U\u0012\u0003#I+G.Z1tKJ+\u0007o\\:ji>\u0014\u00180A\buCN\\\u0007+\u001a:tSN$XM\\2f+\u0005!\u0006CA+Y\u001b\u00051&BA,\"\u0003-\u0001XM]:jgR,gnY3\n\u0005e3&a\u0004+bg.\u0004VM]:jgR,gnY3\u0002!Q\f7o\u001b)feNL7\u000f^3oG\u0016\u0004\u0013\u0001\u00054pY\u0012,'OU3q_NLGo\u001c:z!\t1T,\u0003\u0002_G\t\u0001bi\u001c7eKJ\u0014V\r]8tSR|'/_\u0001\u000fY&\u001cWM\\:f'\u0016\u0014h/[2f!\t\tg-D\u0001c\u0015\t\u0019G-A\u0004tKJ4\u0018nY3\u000b\u0005\u0015<\u0013a\u00027jG\u0016t7/Z\u0005\u0003O\n\u0014a\u0002T5dK:\u001cXmU3sm&\u001cW-A\u0007mS6LG/\u00128g_J\u001cWM\u001d\t\u0003U6l\u0011a\u001b\u0006\u0003Y\u0016\na\u0001\\5nSR\u001c\u0018B\u00018l\u00055a\u0015.\\5u\u000b:4wN]2fe\u00061A(\u001b8jiz\"b!\u001d:tiV4\bC\u0001!\u0001\u0011\u0015qu\u00011\u0001P\u0011\u0015\u0011v\u00011\u0001U\u0011\u0015Yv\u00011\u0001]\u0011\u0015yv\u00011\u0001a\u0011\u0015Aw\u00011\u0001j\u0003!ygn\u0011:fCR,GCA=\u0000!\tQX0D\u0001|\u0015\u0005a\u0018!B:dC2\f\u0017B\u0001@|\u0005\u0011)f.\u001b;\t\r\u0005\u0005\u0001\u00021\u0001:\u0003\t\u0019\u0017.\u0001\u0005p]V\u0003H-\u0019;f)\rI\u0018q\u0001\u0005\u0007\u0003\u0003I\u0001\u0019A\u001d\u0002\u001d\u0015t7/\u001e:f)\u0016t\u0017M\u001c;JIR!\u0011QBA\u0012!\u0011\ty!!\b\u000f\t\u0005E\u0011\u0011\u0004\t\u0004\u0003'YXBAA\u000b\u0015\r\t9bK\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005m10\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003?\t\tC\u0001\u0004TiJLgn\u001a\u0006\u0004\u00037Y\bBBA\u0001\u0015\u0001\u0007\u0011(A\nf]\u001a|'oY3UK:\fg\u000e\u001e'j[&$8\u000fF\u0003z\u0003S\tY\u0003\u0003\u0004\u0002\u0002-\u0001\r!\u000f\u0005\b\u0003[Y\u0001\u0019AA\u0007\u0003!!XM\\1oi&#\u0017a\u0005;f]\u0006tG\u000fV3na2\fG/Z\"pk:$HCBA\u001a\u0003s\tY\u0004E\u0002/\u0003kI1!a\u000e0\u0005\u001dIe\u000e^3hKJDq!!\f\r\u0001\u0004\ti\u0001C\u0004\u0002>1\u0001\r!a\u0010\u0002\u0017I,G.Z1tK.Kg\u000e\u001a\t\u0004u\u0005\u0005\u0013bAA\"w\tY!+\u001a7fCN,7*\u001b8e\u0003I!XM\\1oiJ+G.Z1tK\u000e{WO\u001c;\u0015\r\u0005M\u0012\u0011JA&\u0011\u001d\ti#\u0004a\u0001\u0003\u001bAq!!\u0010\u000e\u0001\u0004\ty$\u0001\tp]\u000e\u0013X-\u0019;f\u001fJ,\u0006\u000fZ1uKR\u0019\u00110!\u0015\t\r\u0005Mc\u00021\u0001:\u0003\u001d\u0011X\r\\3bg\u0016\f1D^1mS\u0012\fG/\u001a#fM\u0006,H\u000e\u001e+be\u001e,GOR8mI\u0016\u0014HcA=\u0002Z!1\u00111K\bA\u0002e\n!D^1mS\u0012\fG/Z,pe.4Gn\\<Qe>\u0004XM\u001d;jKN$2!_A0\u0011\u0019\t\u0019\u0006\u0005a\u0001s\u0005Ab/\u00197jI\u0006$XMT8u\u0003J{w\u000e^,pe.4Gn\\<\u0015\u0007e\f)\u0007\u0003\u0004\u0002TE\u0001\r!O\u0001\u001fm\u0006d\u0017\u000eZ1uK:{G)Y:iE>\f'\u000f\u001a$pe^{'o\u001b4m_^$2!_A6\u0011\u0019\t\u0019F\u0005a\u0001s\u0005!c/\u00197jI\u0006$XMT8M_\u000e\\G+Y:l!J,7/\u001a8u\r>\u0014xk\u001c:lM2|w\u000fF\u0002z\u0003cBa!a\u0015\u0014\u0001\u0004I\u0014\u0001\t<bY&$\u0017\r^3O_JK7o\u001b)s_\u001aLG.\u001a$pe^{'o\u001b4m_^$2!_A<\u0011\u0019\t\u0019\u0006\u0006a\u0001s\u0005Yc/\u00197jI\u0006$XMT8V]N,\b\u000f]8si\u0016$G+Y:l!J,7/\u001a8u\r>\u0014xk\u001c:lM2|w\u000fF\u0002z\u0003{Ba!a\u0015\u0016\u0001\u0004I\u0014A\u000b<bY&$\u0017\r^3O_6+H\u000e^5MKZ,GNT3ti\u0016$G+Y:lg\u001a{'oV8sW\u001adwn\u001e\u000b\u0004s\u0006\r\u0005BBA*-\u0001\u0007\u0011(\u0001\u0012wC2LG-\u0019;f)>$\u0018\r\u001c(p\u001f\u001a<vN]6gY><H+Z7qY\u0006$Xm\u001d\u000b\u0004s\u0006%\u0005BBA*/\u0001\u0007\u0011(A\thKRd\u0015nY3og\u0016,E-\u001b;j_:$\"!!\u0004)\u0007\u0001\t\t\n\u0005\u0003\u0002\u0014\u0006\u0005VBAAK\u0015\u0011\t9*!'\u0002\u0015M$XM]3pif\u0004XM\u0003\u0003\u0002\u001c\u0006u\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\u0005}\u0015aA8sO&!\u00111UAK\u0005%\u0019u.\u001c9p]\u0016tG\u000fK\u0002\u0001\u0003O\u0003B!!+\u000266\u0011\u00111\u0016\u0006\u0005\u0003[\u000by+A\u0006ue\u0006t7/Y2uS>t'b\u0001\u0012\u00022*\u0019\u00111W\u0013\u0002\u0005\u0011\u0014\u0017\u0002BA\\\u0003W\u0013q\"S:Ue\u0006t7/Y2uS>t\u0017\r\\\u0001\u001e%\u0016dW-Y:f!\u0016\u00148/[:uK:\u001cW-\u00138uKJ\u001cW\r\u001d;peB\u0011\u0001IG\n\u00045\u0005}\u0006c\u0001>\u0002B&\u0019\u00111Y>\u0003\r\u0005s\u0017PU3g)\t\tY,A\u0011N\u0003b{fjT0X\u001fJ[e\tT(X?R+U\n\u0015'B)\u0016\u001bv,\u0011'M\u001f^+E)\u0006\u0002\u0002LB\u0019!0!4\n\u0007\u0005=7PA\u0002J]R\f!%T!Y?:{ulV(S\u0017\u001acujV0U\u000b6\u0003F*\u0011+F'~\u000bE\nT(X\u000b\u0012\u0003\u0013!H+O%\u0016\u001bFKU%D)\u0016#u\fT%D\u000b:\u001bViX#E\u0013RKuJT*\u0016\u0005\u0005]\u0007CBAm\u0003G\fiA\u0004\u0003\u0002\\\u0006}g\u0002BA\n\u0003;L\u0011\u0001`\u0005\u0004\u0003C\\\u0018a\u00029bG.\fw-Z\u0005\u0005\u0003K\f9OA\u0002TKFT1!!9|\u0003y)fJU#T)JK5\tV#E?2K5)\u0012(T\u000b~+E)\u0013+J\u001f:\u001b\u0006\u0005")
public class ReleasePersistenceInterceptor
implements PersistenceInterceptor<Release>,
WorkflowTaskValidator,
WorkflowInterceptorLogic,
Logging {
    private final ReleaseRepository releaseRepository;
    private final TaskPersistence taskPersistence;
    private final FolderRepository folderRepository;
    private final LicenseService licenseService;
    private final LimitEnforcer limitEnforcer;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void updateWorkflowProperties(Release release) {
        WorkflowInterceptorLogic.updateWorkflowProperties$((WorkflowInterceptorLogic)this, release);
    }

    @Override
    public void updateWorkflowProperties(Task task) {
        WorkflowInterceptorLogic.updateWorkflowProperties$((WorkflowInterceptorLogic)this, task);
    }

    @Override
    public void validateNoLockTaskPresent(Task task) {
        WorkflowTaskValidator.validateNoLockTaskPresent$((WorkflowTaskValidator)this, task);
    }

    @Override
    public void validateNoLockTaskPresent(Seq<Task> tasks) {
        WorkflowTaskValidator.validateNoLockTaskPresent$((WorkflowTaskValidator)this, tasks);
    }

    @Override
    public void validateNoUnsupportedTaskPresent(Task task) {
        WorkflowTaskValidator.validateNoUnsupportedTaskPresent$((WorkflowTaskValidator)this, task);
    }

    @Override
    public void validateNoUnsupportedTaskPresent(Seq<Task> tasks) {
        WorkflowTaskValidator.validateNoUnsupportedTaskPresent$((WorkflowTaskValidator)this, tasks);
    }

    @Override
    public void validateWorkflowTaskCount(Release release) {
        WorkflowTaskValidator.validateWorkflowTaskCount$(this, release);
    }

    @Override
    public void validateNoMultiLevelNestedTasks(Task task) {
        WorkflowTaskValidator.validateNoMultiLevelNestedTasks$((WorkflowTaskValidator)this, task);
    }

    @Override
    public void validateNoMultiLevelNestedTasks(Seq<Task> tasks) {
        WorkflowTaskValidator.validateNoMultiLevelNestedTasks$((WorkflowTaskValidator)this, tasks);
    }

    public void onDelete(String ciId) {
        super.onDelete(ciId);
    }

    public void afterCreate(ConfigurationItem ci) {
        super.afterCreate(ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        super.afterUpdate(ci);
    }

    public void afterDelete(String ciId) {
        super.afterDelete(ciId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReleasePersistenceInterceptor releasePersistenceInterceptor = this;
        synchronized (releasePersistenceInterceptor) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public void onCreate(Release ci) {
        String tenantId = this.ensureTenantId(ci);
        this.enforceTenantLimits(ci, tenantId);
        this.onCreateOrUpdate(ci);
    }

    public void onUpdate(Release ci) {
        this.onCreateOrUpdate(ci);
    }

    private String ensureTenantId(Release ci) {
        if (StringUtils.hasText((String)ci.getTenantId())) {
            return ci.getTenantId();
        }
        String tenantIdFromContext = TenantContext$.MODULE$.getTenant();
        ci.setTenantId(tenantIdFromContext);
        return tenantIdFromContext;
    }

    private void enforceTenantLimits(Release ci, String tenantId) {
        Tuple3 tuple3;
        Tuple3 tuple32 = tuple3 = ci.isWorkflow() ? new Tuple3((Object)LimitEnforcer.LimitType.WORKFLOW_TEMPLATES, (Object)LimitEnforcer.LimitType.WORKFLOW_EXECUTIONS, (Object)ReleaseKind.WORKFLOW) : new Tuple3((Object)LimitEnforcer.LimitType.TEMPLATES, (Object)LimitEnforcer.LimitType.RELEASES, (Object)ReleaseKind.RELEASE);
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        LimitEnforcer.LimitType templateLimitType = (LimitEnforcer.LimitType)tuple3._1();
        LimitEnforcer.LimitType releaseLimitType = (LimitEnforcer.LimitType)tuple3._2();
        ReleaseKind releaseKind = (ReleaseKind)tuple3._3();
        Tuple3 tuple33 = new Tuple3((Object)templateLimitType, (Object)releaseLimitType, (Object)releaseKind);
        LimitEnforcer.LimitType templateLimitType2 = (LimitEnforcer.LimitType)tuple33._1();
        LimitEnforcer.LimitType releaseLimitType2 = (LimitEnforcer.LimitType)tuple33._2();
        ReleaseKind releaseKind2 = (ReleaseKind)tuple33._3();
        ReleaseStatus releaseStatus = ci.getStatus();
        if (ReleaseStatus.TEMPLATE.equals(releaseStatus)) {
            this.limitEnforcer.enforceLimit(tenantId, templateLimitType2, 1, () -> Predef$.MODULE$.Integer2int(this.tenantTemplateCount(tenantId, releaseKind2)));
            return;
        }
        if (ReleaseStatus.PLANNED.equals(releaseStatus) ? true : (ReleaseStatus.IN_PROGRESS.equals(releaseStatus) ? true : (ReleaseStatus.PAUSED.equals(releaseStatus) ? true : (ReleaseStatus.FAILED.equals(releaseStatus) ? true : ReleaseStatus.FAILING.equals(releaseStatus))))) {
            this.limitEnforcer.enforceLimit(tenantId, releaseLimitType2, 1, () -> Predef$.MODULE$.Integer2int(this.tenantReleaseCount(tenantId, releaseKind2)));
            return;
        }
    }

    private Integer tenantTemplateCount(String tenantId, ReleaseKind releaseKind) {
        return this.releaseRepository.tenantTemplateCountByKind(tenantId, releaseKind);
    }

    private Integer tenantReleaseCount(String tenantId, ReleaseKind releaseKind) {
        return this.releaseRepository.tenantReleaseCountByKind(tenantId, releaseKind);
    }

    private void onCreateOrUpdate(Release release) {
        this.validateTotalNoOfWorkflowTemplates(release);
        this.updateWorkflowProperties(release);
        this.validateDefaultTargetFolder(release);
        this.validateWorkflowProperties(release);
    }

    private void validateDefaultTargetFolder(Release release) {
        boolean defaultTargetFolderIdIsEmpty;
        boolean doesNotAllowTargetFolderOverride = !release.getAllowTargetFolderOverride();
        String defaultTargetFolderId = release.getDefaultTargetFolderId();
        boolean bl = defaultTargetFolderIdIsEmpty = !StringUtils.hasText((String)defaultTargetFolderId);
        if (release.isTemplate() && doesNotAllowTargetFolderOverride && defaultTargetFolderIdIsEmpty) {
            String msg = "Override of the target folder is not allowed, but default target folder is not provided for release with ID [" + release.getId() + "]";
            throw new Checks.IncorrectArgumentException(msg, new Object[0]);
        }
        if (!defaultTargetFolderIdIsEmpty) {
            Option optionalFolder = this.folderRepository.findById(defaultTargetFolderId, 1);
            if (optionalFolder.isEmpty()) {
                throw new Checks.IncorrectArgumentException("Cannot find folder with id [" + defaultTargetFolderId + "]", new Object[0]);
            }
            return;
        }
    }

    private void validateWorkflowProperties(Release release) {
        this.validateNotARootWorkflow(release);
        this.validateNoDashboardForWorkflow(release);
        this.validateNoRiskProfileForWorkflow(release);
        this.validateNoLockTaskPresentForWorkflow(release);
        this.validateNoUnsupportedTaskPresentForWorkflow(release);
        this.validateWorkflowTaskCount(release);
        this.validateNoMultiLevelNestedTasksForWorkflow(release);
    }

    private void validateNotARootWorkflow(Release release) {
        String parentFolder = Ids.getParentId((String)release.getId());
        if (release.isWorkflow()) {
            String string = parentFolder;
            String string2 = Ids.ROOT_FOLDER_ID;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw new Checks.IncorrectArgumentException("Workflows can be created only inside a folder", new Object[0]);
            }
        }
    }

    private void validateNoDashboardForWorkflow(Release release) {
        if (release.isWorkflow()) {
            boolean hasDashboards = CollectionConverters$.MODULE$.ListHasAsScala(release.getExtensions()).asScala().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReleasePersistenceInterceptor.$anonfun$validateNoDashboardForWorkflow$1(x$2)));
            if (hasDashboards) {
                throw new Checks.IncorrectArgumentException("Dashboards are not supported for workflows", new Object[0]);
            }
            return;
        }
    }

    private void validateNoLockTaskPresentForWorkflow(Release release) {
        if (release.isWorkflow()) {
            this.validateNoLockTaskPresent((Seq<Task>)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().toSeq());
            return;
        }
    }

    private void validateNoRiskProfileForWorkflow(Release release) {
        if (release.isWorkflow() && release.getRiskProfile() != null) {
            throw new Checks.IncorrectArgumentException("Risk profile is not supported for workflows", new Object[0]);
        }
    }

    private void validateNoUnsupportedTaskPresentForWorkflow(Release release) {
        if (release.isWorkflow()) {
            this.validateNoUnsupportedTaskPresent((Seq<Task>)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().toSeq());
            return;
        }
    }

    private void validateNoMultiLevelNestedTasksForWorkflow(Release release) {
        if (release.isWorkflow()) {
            this.validateNoMultiLevelNestedTasks((Seq<Task>)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().toSeq());
            return;
        }
    }

    private void validateTotalNoOfWorkflowTemplates(Release release) {
        if (release.isTemplate() && release.isWorkflow()) {
            String licenseEdition = this.getLicenseEdition();
            if (!ReleasePersistenceInterceptor$.MODULE$.com$xebialabs$xlrelease$repository$sql$ReleasePersistenceInterceptor$$UNRESTRICTED_LICENSE_EDITIONS().contains((Object)licenseEdition)) {
                int totalWorkflowTemplates = this.releaseRepository.countTemplatesByKind(ReleaseKind.WORKFLOW);
                if (totalWorkflowTemplates >= ReleasePersistenceInterceptor$.MODULE$.com$xebialabs$xlrelease$repository$sql$ReleasePersistenceInterceptor$$MAX_NO_WORKFLOW_TEMPLATES_ALLOWED()) {
                    throw new LicenseLimitReachedException("License limit reached. You have exceeded the limit on the number of workflow templates supported with your license.");
                }
                return;
            }
            return;
        }
    }

    private String getLicenseEdition() {
        License license = this.licenseService.getLicense();
        if (license.isDummyLicense()) {
            return LicenseVersion4.Edition4.Unregistered.name();
        }
        return this.licenseService.getLicense().getStringValue(LicenseProperty.EDITION);
    }

    public static final /* synthetic */ boolean $anonfun$validateNoDashboardForWorkflow$1(ReleaseExtension x$2) {
        return x$2 instanceof Dashboard;
    }

    public ReleasePersistenceInterceptor(ReleaseRepository releaseRepository, TaskPersistence taskPersistence, FolderRepository folderRepository, LicenseService licenseService, LimitEnforcer limitEnforcer) {
        this.releaseRepository = releaseRepository;
        this.taskPersistence = taskPersistence;
        this.folderRepository = folderRepository;
        this.licenseService = licenseService;
        this.limitEnforcer = limitEnforcer;
        WorkflowTaskValidator.$init$(this);
        WorkflowInterceptorLogic.$init$(this);
        Logging.$init$((Logging)this);
        releaseRepository.registerPersistenceInterceptor((PersistenceInterceptor)this);
    }
}

