package com.xebialabs.xlrelease.security.entities;

import java.io.Serializable;
import java.util.Objects;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Nationalized;

@Embeddable
public class XlRolePrincipalId implements Serializable {
    private static final long serialVersionUID = -2611284005740626429L;
    @Size(max = 255)
    @NotNull
    @Nationalized
    @Column(name = "ROLE_ID", nullable = false)
    private String roleId;

    @Size(max = 255)
    @NotNull
    @Nationalized
    @Column(name = "PRINCIPAL_NAME", nullable = false)
    private String principalName;

    public XlRolePrincipalId(){

    }

    public XlRolePrincipalId(String roleId, String principalName){
        this.roleId = roleId;
        this.principalName = principalName;
    }

    public String getRoleId() {
        return roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public String getPrincipalName() {
        return principalName;
    }

    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || Hibernate.getClass(this) != Hibernate.getClass(o)) return false;
        XlRolePrincipalId entity = (XlRolePrincipalId) o;
        return Objects.equals(this.roleId, entity.roleId) &&
                Objects.equals(this.principalName, entity.principalName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(roleId, principalName);
    }

}