package com.xebialabs.xlrelease.spring.config

import com.xebialabs.xlrelease.config.CacheManagementConstants.RELEASE_CACHE_MANAGER
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.features.CacheManagementFeature
import com.xebialabs.xlrelease.support.cache.caffeine.spring.XlrCaffeineCacheManager
import com.xebialabs.xlrelease.support.cache.config.ConfigCacheSettings
import org.springframework.context.annotation.{Bean, Configuration}

@Configuration
class ReleaseCacheConfiguration(xlrConfig: XlrConfig) {

  @Bean(name = Array(RELEASE_CACHE_MANAGER))
  def releaseCacheManager(): XlrCaffeineCacheManager = {
    val configCacheSettings = xlrConfig.getCacheSettings().asInstanceOf[ConfigCacheSettings]
    val withFeatureSettings = configCacheSettings.withFeatureSettings(CacheManagementFeature)
    new XlrCaffeineCacheManager(RELEASE_CACHE_MANAGER, withFeatureSettings)
  }
}
