/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.package$;
import com.xebialabs.xlrelease.security.SecuredCi;
import com.xebialabs.xlrelease.security.sql.SqlRoleService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.util.HashSet;
import org.slf4j.Marker;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tec\u0001\u0002\u0013&\u0001AB\u0001b\u0011\u0001\u0003\u0006\u0004%\t\u0001\u0012\u0005\t#\u0002\u0011\t\u0011)A\u0005\u000b\"A!\u000b\u0001BC\u0002\u0013\u00051\u000b\u0003\u0005]\u0001\t\u0005\t\u0015!\u0003U\u0011!i\u0006A!b\u0001\n\u0003q\u0006\u0002C3\u0001\u0005\u0003\u0005\u000b\u0011B0\t\u0011\u0019\u0004!Q1A\u0005\u0002\u001dD\u0001b\u001b\u0001\u0003\u0002\u0003\u0006I\u0001\u001b\u0005\u0006Y\u0002!\t!\u001c\u0005\bi\u0002\u0011\r\u0011\"\u0003v\u0011\u0019a\b\u0001)A\u0005m\")Q\u0010\u0001C!}\"9\u0011\u0011\t\u0001\u0005B\u0005\r\u0003bBA%\u0001\u0011\u0005\u00131\n\u0005\b\u0003\u0013\u0002A\u0011IA1\u0011%\t\t\b\u0001b\u0001\n\u0013\t\u0019\b\u0003\u0005\u0002v\u0001\u0001\u000b\u0011BA\b\u0011\u001d\t9\b\u0001C!\u0003sB\u0011\"a,\u0001\u0005\u0004%I!a\u001d\t\u0011\u0005E\u0006\u0001)A\u0005\u0003\u001fA\u0011\"a-\u0001\u0005\u0004%I!a\u001d\t\u0011\u0005U\u0006\u0001)A\u0005\u0003\u001fAq!a.\u0001\t\u0003\nI\fC\u0004\u0002F\u0002!\t%a2\t\u000f\u0005U\u0007\u0001\"\u0011\u0002X\"9\u0011Q\u001b\u0001\u0005B\u0005u\u0007bBAr\u0001\u0011\u0005\u0013Q\u001d\u0005\b\u0003G\u0004A\u0011BAx\u0011\u001d\t9\u0010\u0001C\u0005\u0003sDqAa\u0006\u0001\t\u0013\u0011I\u0002C\u0004\u0003 \u0001!IA!\t\t\u000f\t\u001d\u0002\u0001\"\u0003\u0003*!9!1\t\u0001\u0005\n\t\u0015\u0003b\u0002B%\u0001\u0011%!1\n\u0005\b\u0005#\u0002A\u0011\u0002B*\u0005E\u0019\u0016\u000f\u001c+fC6\u0014V\r]8tSR|'/\u001f\u0006\u0003M\u001d\n1a]9m\u0015\tA\u0013&\u0001\u0006sKB|7/\u001b;pefT!AK\u0016\u0002\u0013ad'/\u001a7fCN,'B\u0001\u0017.\u0003%AXMY5bY\u0006\u00147OC\u0001/\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001\u0011gN\u001e\u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\r\u0005s\u0017PU3g!\tA\u0014(D\u0001(\u0013\tQtE\u0001\bUK\u0006l'+\u001a9pg&$xN]=\u0011\u0005q\nU\"A\u001f\u000b\u0005yz\u0014!B:mMRR'\"\u0001!\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!AQ\u001f\u0003\u000f1{wmZ5oO\u0006a!\u000e\u001a2d)\u0016l\u0007\u000f\\1uKV\tQ\t\u0005\u0002G\u001f6\tqI\u0003\u0002I\u0013\u0006!1m\u001c:f\u0015\tQ5*\u0001\u0003kI\n\u001c'B\u0001'N\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001(\u0002\u0007=\u0014x-\u0003\u0002Q\u000f\na!\n\u001a2d)\u0016l\u0007\u000f\\1uK\u0006i!\u000e\u001a2d)\u0016l\u0007\u000f\\1uK\u0002\n\u0001\u0003]3s[&\u001c8/[8o\u000b\u0012LGo\u001c:\u0016\u0003Q\u0003\"!\u0016.\u000e\u0003YS!a\u0016-\u0002\u0011M,7-\u001e:jifT!!W\u0016\u0002\u0011\u0011,\u0007\u000f\\8zSRL!a\u0017,\u0003!A+'/\\5tg&|g.\u00123ji>\u0014\u0018!\u00059fe6L7o]5p]\u0016#\u0017\u000e^8sA\u0005Y!o\u001c7f'\u0016\u0014h/[2f+\u0005y\u0006C\u00011d\u001b\u0005\t'B\u0001\u0014c\u0015\t9\u0016&\u0003\u0002eC\nq1+\u001d7S_2,7+\u001a:wS\u000e,\u0017\u0001\u0004:pY\u0016\u001cVM\u001d<jG\u0016\u0004\u0013AC:fGV\u0014X\rZ\"jgV\t\u0001\u000e\u0005\u00029S&\u0011!n\n\u0002\u000b'\u0016\u001cWO]3e\u0007&\u001c\u0018aC:fGV\u0014X\rZ\"jg\u0002\na\u0001P5oSRtD#\u00028qcJ\u001c\bCA8\u0001\u001b\u0005)\u0003\"B\"\n\u0001\u0004)\u0005\"\u0002*\n\u0001\u0004!\u0006\"B/\n\u0001\u0004y\u0006\"\u00024\n\u0001\u0004A\u0017A\u00078b[\u0016$\u0007+\u0019:b[\u0016$XM\u001d&eE\u000e$V-\u001c9mCR,W#\u0001<\u0011\u0005]TX\"\u0001=\u000b\u0005e<\u0015A\u00038b[\u0016$\u0007/\u0019:b[&\u00111\u0010\u001f\u0002\u001b\u001d\u0006lW\r\u001a)be\u0006lW\r^3s\u0015\u0012\u00147\rV3na2\fG/Z\u0001\u001c]\u0006lW\r\u001a)be\u0006lW\r^3s\u0015\u0012\u00147\rV3na2\fG/\u001a\u0011\u0002\r\r\u0014X-\u0019;f)\u0015y\u00181BA\u0013!\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003S\u00051Am\\7bS:LA!!\u0003\u0002\u0004\t!A+Z1n\u0011\u001d\ti\u0001\u0004a\u0001\u0003\u001f\t1bY8oi\u0006Lg.\u001a:JIB!\u0011\u0011CA\u0010\u001d\u0011\t\u0019\"a\u0007\u0011\u0007\u0005U1'\u0004\u0002\u0002\u0018)\u0019\u0011\u0011D\u0018\u0002\rq\u0012xn\u001c;?\u0013\r\tibM\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00121\u0005\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005u1\u0007\u0003\u0004\u0002(1\u0001\ra`\u0001\u0005i\u0016\fW\u000eK\u0002\r\u0003W\u0001B!!\f\u0002>5\u0011\u0011q\u0006\u0006\u0005\u0003c\t\u0019$\u0001\u0006b]:|G/\u0019;j_:T1\u0001SA\u001b\u0015\u0011\t9$!\u000f\u0002\u00155L7M]8nKR,'O\u0003\u0002\u0002<\u0005\u0011\u0011n\\\u0005\u0005\u0003\u007f\tyCA\u0003US6,G-\u0001\u0004va\u0012\fG/\u001a\u000b\u0004\u007f\u0006\u0015\u0003BBA\u0014\u001b\u0001\u0007q\u0010K\u0002\u000e\u0003W\t\u0001bZ3u)\u0016\fWn\u001d\u000b\u0005\u0003\u001b\ni\u0006E\u0003\u0002P\u0005es0\u0004\u0002\u0002R)!\u00111KA+\u0003\u0011)H/\u001b7\u000b\u0005\u0005]\u0013\u0001\u00026bm\u0006LA!a\u0017\u0002R\t!A*[:u\u0011\u001d\tiA\u0004a\u0001\u0003\u001fA3ADA\u0016)\u0011\ti%a\u0019\t\u000f\u0005\u0015t\u00021\u0001\u0002h\u0005\u00111-\u001b\t\u0005\u0003S\nY'D\u0001c\u0013\r\tiG\u0019\u0002\n'\u0016\u001cWO]3e\u0007&D3aDA\u0016\u0003u\u0019F+\u0014+`\u000f\u0016#v\fV#B\u001b~\u0003VIU'J'NKuJT0S\u001f^\u001bVCAA\b\u0003y\u0019F+\u0014+`\u000f\u0016#v\fV#B\u001b~\u0003VIU'J'NKuJT0S\u001f^\u001b\u0006%A\u000bhKR$V-Y7QKJl\u0017n]:j_:\u0014vn^:\u0015\t\u0005m\u00141\u0016\t\u0007\u0003{\n9)!$\u000f\t\u0005}\u00141\u0011\b\u0005\u0003+\t\t)C\u00015\u0013\r\t)iM\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI)a#\u0003\u0007M+\u0017OC\u0002\u0002\u0006N\u0002B!a$\u0002&:!\u0011\u0011SAQ\u001d\u0011\t\u0019*a(\u000f\t\u0005U\u0015Q\u0014\b\u0005\u0003/\u000bYJ\u0004\u0003\u0002\u0016\u0005e\u0015\"\u0001\u0018\n\u00051j\u0013B\u0001\u0016,\u0013\tA\u0013&C\u0002\u0002$\u001e\na\u0002V3b[J+\u0007o\\:ji>\u0014\u00180\u0003\u0003\u0002(\u0006%&!\u0005+fC6\u0004VM]7jgNLwN\u001c*po*\u0019\u00111U\u0014\t\u000f\u00055&\u00031\u0001\u0002h\u0005I1m\u001c8uC&tWM]\u0001)'RkEkX$F)~\u0003&+\u0013(D\u0013B\u000bEj\u0018+F\u00036{V*R'C\u000bJ{f+S#X?J{ukU\u0001*'RkEkX$F)~\u0003&+\u0013(D\u0013B\u000bEj\u0018+F\u00036{V*R'C\u000bJ{f+S#X?J{uk\u0015\u0011\u0002GM#V\nV0H\u000bR{&k\u0014'F?R+\u0015)T0N\u000b6\u0013UIU0W\u0013\u0016;vLU(X'\u0006!3\u000bV'U?\u001e+Ek\u0018*P\u0019\u0016{F+R!N?6+UJQ#S?ZKUiV0S\u001f^\u001b\u0006%A\thKRlU-\u001c2feN\u0004VM\u001d+fC6$B!a/\u0002DB1\u0011QPAD\u0003{\u0003B!a$\u0002@&!\u0011\u0011YAU\u00055!V-Y7NK6\u0014WM\u001d*po\"9\u0011QV\fA\u0002\u0005\u001d\u0014A\u00023fY\u0016$X\r\u0006\u0003\u0002J\u0006=\u0007c\u0001\u001a\u0002L&\u0019\u0011QZ\u001a\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003#D\u0002\u0019AA\b\u0003\u0019!X-Y7JI\"\u001a\u0001$a\u000b\u0002/\u0011,G.\u001a;f)\u0016\fWn\u001d$s_6\u0004F.\u0019;g_JlG\u0003BAe\u00033Dq!!\u0004\u001a\u0001\u0004\ty\u0001K\u0002\u001a\u0003W!B!!3\u0002`\"9\u0011Q\u0016\u000eA\u0002\u0005\u001d\u0004f\u0001\u000e\u0002,\u0005\u00192/\u0019<f)\u0016\fWn\u001d+p!2\fGOZ8s[R1\u0011QJAt\u0003SDq!!\u0004\u001c\u0001\u0004\ty\u0001C\u0004\u0002ln\u0001\r!!\u0014\u0002\u000bQ,\u0017-\\:)\u0007m\tY\u0003\u0006\u0004\u0002r\u0006M\u0018Q\u001f\t\u0006\u0003{\n9i \u0005\b\u0003\u001ba\u0002\u0019AA\b\u0011\u001d\tY\u000f\ba\u0001\u0003c\f\u0011#\u001e9eCR,\u0007+\u001a:nSN\u001c\u0018n\u001c8t)\u0019\tI-a?\u0002\u0000\"9\u0011Q`\u000fA\u0002\u0005=\u0011aC:fGV\u0014\u0018\u000e^=VS\u0012DqA!\u0001\u001e\u0001\u0004\u0011\u0019!\u0001\u000bs_2,7oV5uQB+'/\\5tg&|gn\u001d\t\u0006e\t\u0015!\u0011B\u0005\u0004\u0005\u000f\u0019$A\u0003\u001fsKB,\u0017\r^3e}A9!Ga\u0003\u0003\u0010\tU\u0011b\u0001B\u0007g\t1A+\u001e9mKJ\u00022!\u0016B\t\u0013\r\u0011\u0019B\u0016\u0002\u0005%>dW\r\u0005\u0004\u0002P\u0005e\u0013qB\u0001\u0016kB$\u0017\r^3J]\",'/\u001b;b]\u000e,g\t\\1h)\u0019\tIMa\u0007\u0003\u001e!9\u0011Q\u0002\u0010A\u0002\u0005=\u0001bBAv=\u0001\u0007\u0011\u0011_\u0001\u0013e\u0016lwN^3NSN\u001c\u0018N\\4S_2,7\u000f\u0006\u0003\u0002J\n\r\u0002bBAv?\u0001\u0007!Q\u0005\t\u0005e\t\u0015q0\u0001\tge>l\u0007\u000b\\1uM>\u0014XNU8mKR9qPa\u000b\u0003.\tE\u0002bBA\u0007A\u0001\u0007\u0011q\u0002\u0005\b\u0005_\u0001\u0003\u0019\u0001B\b\u0003\u0011\u0011x\u000e\\3\t\u000f\tM\u0002\u00051\u0001\u00036\u0005Y\u0001/\u001a:nSN\u001c\u0018n\u001c8t!\u0019\ti(a\"\u00038A!!\u0011\bB \u001b\t\u0011YDC\u0002\u0003>Y\u000b!\u0002]3s[&\u001c8/[8o\u0013\u0011\u0011\tEa\u000f\u0003\u0015A+'/\\5tg&|g.\u0001\bu_Bc\u0017\r\u001e4pe6\u0014v\u000e\\3\u0015\t\t=!q\t\u0005\u0007\u0003O\t\u0003\u0019A@\u0002\u0019Q|\u0007\u000b\\1uM>\u0014X.\u00133\u0015\t\u0005=!Q\n\u0005\b\u0005\u001f\u0012\u0003\u0019AA\b\u0003\tIG-\u0001\bge>l\u0007\u000b\\1uM>\u0014X.\u00133\u0015\r\u0005=!Q\u000bB,\u0011\u001d\tia\ta\u0001\u0003\u001fAqAa\u0014$\u0001\u0004\ty\u0001")
public class SqlTeamRepository
implements TeamRepository,
Logging {
    private final JdbcTemplate jdbcTemplate;
    private final PermissionEditor permissionEditor;
    private final SqlRoleService roleService;
    private final SecuredCis securedCis;
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private final String STMT_GET_TEAM_PERMISSION_ROWS;
    private final String STMT_GET_PRINCIPAL_TEAM_MEMBER_VIEW_ROWS;
    private final String STMT_GET_ROLE_TEAM_MEMBER_VIEW_ROWS;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTeamRepository sqlTeamRepository = this;
        synchronized (sqlTeamRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public PermissionEditor permissionEditor() {
        return this.permissionEditor;
    }

    public SqlRoleService roleService() {
        return this.roleService;
    }

    public SecuredCis securedCis() {
        return this.securedCis;
    }

    private NamedParameterJdbcTemplate namedParameterJdbcTemplate() {
        return this.namedParameterJdbcTemplate;
    }

    @Timed
    public Team create(String containerId, Team team) {
        this.removeMissingRoles((scala.collection.immutable.Seq<Team>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Team[]{team}));
        Role role = this.toPlatformRole(team);
        String securityUid = this.securedCis().getSecuredCi(containerId).getSecurityUid();
        this.roleService().create(securityUid, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Role[]{role}));
        this.updatePermissions(securityUid, (scala.collection.immutable.Seq<Tuple2<Role, java.util.List<String>>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)role), (Object)team.getPermissions())}));
        this.updateInheritanceFlag(containerId, (scala.collection.immutable.Seq<Team>)new .colon.colon((Object)team, (List)Nil$.MODULE$));
        return team;
    }

    @Timed
    public Team update(Team team) {
        String containerId = Ids.getParentId((String)team.getId());
        this.removeMissingRoles((scala.collection.immutable.Seq<Team>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Team[]{team}));
        Role role = this.toPlatformRole(team);
        String securityUid = this.securedCis().getSecuredCi(containerId).getSecurityUid();
        this.roleService().update(securityUid, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Role[]{role}));
        this.updatePermissions(securityUid, (scala.collection.immutable.Seq<Tuple2<Role, java.util.List<String>>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)role), (Object)team.getPermissions())}));
        return team;
    }

    @Timed
    public java.util.List<Team> getTeams(String containerId) {
        return this.getTeams(this.securedCis().getSecuredCi(containerId));
    }

    @Timed
    public java.util.List<Team> getTeams(SecuredCi ci) {
        scala.collection.immutable.Seq seq;
        List roles = CollectionConverters$.MODULE$.ListHasAsScala(this.roleService().readRoleAssignments(ci.getSecurityUid())).asScala().toList();
        List list = roles;
        if (Nil$.MODULE$.equals(list)) {
            seq = (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().empty();
        } else {
            java.util.Map permissionsByRole = this.permissionEditor().readPermissions(ci.getSecurityUid());
            seq = roles.map((Function1 & Serializable)role -> this.fromPlatformRole(ci.getId(), (Role)role, (scala.collection.immutable.Seq<Permission>)CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)permissionsByRole.getOrDefault(role, new HashSet())).asScala().toSeq()));
        }
        return package$.MODULE$.ListExtensions(seq).asJavaMutable();
    }

    private String STMT_GET_TEAM_PERMISSION_ROWS() {
        return this.STMT_GET_TEAM_PERMISSION_ROWS;
    }

    public scala.collection.immutable.Seq<TeamRepository.TeamPermissionRow> getTeamPermissionRows(SecuredCi container) {
        java.util.Map params = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.FOLDERS$.MODULE$.CI_UID()), (Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(container.getSecurityUid()))))}))).asJava();
        RowMapper mapper = (rs, x$1) -> {
            String teamId = rs.getString("teamId");
            String teamName = rs.getString("teamName");
            String permissionName = rs.getString("permissionName");
            return new TeamRepository.TeamPermissionRow(new TeamRepository.TeamRow(teamId, teamName), permissionName);
        };
        scala.collection.immutable.Seq rows = CollectionConverters$.MODULE$.ListHasAsScala(this.namedParameterJdbcTemplate().query(this.STMT_GET_TEAM_PERMISSION_ROWS(), params, mapper)).asScala().toSeq();
        return rows;
    }

    private String STMT_GET_PRINCIPAL_TEAM_MEMBER_VIEW_ROWS() {
        return this.STMT_GET_PRINCIPAL_TEAM_MEMBER_VIEW_ROWS;
    }

    private String STMT_GET_ROLE_TEAM_MEMBER_VIEW_ROWS() {
        return this.STMT_GET_ROLE_TEAM_MEMBER_VIEW_ROWS;
    }

    public scala.collection.immutable.Seq<TeamRepository.TeamMemberRow> getMembersPerTeam(SecuredCi container) {
        java.util.Map params = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.FOLDERS$.MODULE$.CI_UID()), (Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(container.getSecurityUid()))))}))).asJava();
        RowMapper principalMapper = (rs, x$2) -> {
            String teamId = rs.getString("teamId");
            String teamName = rs.getString("teamName");
            String memberName = rs.getString("memberName");
            String fullName = rs.getString("fullName");
            None$ memberRow = memberName != null ? new Some((Object)new TeamRepository.MemberRow(memberName, fullName, null)) : None$.MODULE$;
            return new TeamRepository.TeamMemberRow(new TeamRepository.TeamRow(teamId, teamName), (Option)memberRow);
        };
        scala.collection.immutable.Seq principalRows = CollectionConverters$.MODULE$.ListHasAsScala(this.namedParameterJdbcTemplate().query(this.STMT_GET_PRINCIPAL_TEAM_MEMBER_VIEW_ROWS(), params, principalMapper)).asScala().toSeq();
        RowMapper roleMapper = (rs, x$3) -> {
            String teamId = rs.getString("teamId");
            String teamName = rs.getString("teamName");
            String memberName = rs.getString("memberName");
            String roleId = rs.getString("roleId");
            None$ memberRow = roleId != null && memberName != null ? new Some((Object)new TeamRepository.MemberRow(memberName, null, roleId)) : None$.MODULE$;
            return new TeamRepository.TeamMemberRow(new TeamRepository.TeamRow(teamId, teamName), (Option)memberRow);
        };
        scala.collection.immutable.Seq roleRows = CollectionConverters$.MODULE$.ListHasAsScala(this.namedParameterJdbcTemplate().query(this.STMT_GET_ROLE_TEAM_MEMBER_VIEW_ROWS(), params, roleMapper)).asScala().toSeq();
        return (scala.collection.immutable.Seq)principalRows.$plus$plus((IterableOnce)roleRows);
    }

    @Timed
    public void delete(String teamId) {
        String containerId = Ids.getParentId((String)teamId);
        String securityUid = this.securedCis().getSecuredCi(containerId).getSecurityUid();
        this.roleService().deleteRoles(securityUid, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.toPlatformId(teamId)}));
        this.updateInheritanceFlag(containerId, (scala.collection.immutable.Seq<Team>)CollectionConverters$.MODULE$.ListHasAsScala(this.getTeams(containerId)).asScala().toSeq());
    }

    @Timed
    public void deleteTeamsFromPlatform(String containerId) {
        this.deleteTeamsFromPlatform(this.securedCis().getSecuredCi(containerId));
    }

    @Timed
    public void deleteTeamsFromPlatform(SecuredCi container) {
        scala.collection.immutable.Seq roles = CollectionConverters$.MODULE$.ListHasAsScala(this.roleService().getRoles(container.getSecurityUid())).asScala().toSeq();
        this.roleService().deleteRoles(container.getSecurityUid(), (scala.collection.immutable.Seq)roles.map((Function1 & Serializable)x$4 -> x$4.getId()));
        if (Ids.isFolderId((String)container.getId())) {
            this.securedCis().setAsEffectiveSecuredCi(container.getId(), false);
            return;
        }
    }

    @Timed
    public java.util.List<Team> saveTeamsToPlatform(String containerId, java.util.List<Team> teams) {
        return package$.MODULE$.ListExtensions(this.saveTeamsToPlatform(containerId, (scala.collection.immutable.Seq<Team>)CollectionConverters$.MODULE$.ListHasAsScala(teams).asScala().toSeq())).asJavaMutable();
    }

    private scala.collection.immutable.Seq<Team> saveTeamsToPlatform(String containerId, scala.collection.immutable.Seq<Team> teams) {
        this.removeMissingRoles(teams);
        String securityUid = this.securedCis().getSecuredCi(containerId).getSecurityUid();
        scala.collection.immutable.Seq roles = (scala.collection.immutable.Seq)teams.map((Function1 & Serializable)team -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.toPlatformRole((Team)team)), (Object)team.getPermissions()));
        this.roleService().writeRoleAssignments(securityUid, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)roles.map((Function1 & Serializable)x$5 -> (Role)x$5._1())).asJava());
        this.updatePermissions(securityUid, (scala.collection.immutable.Seq<Tuple2<Role, java.util.List<String>>>)roles);
        this.updateInheritanceFlag(containerId, teams);
        return teams;
    }

    private void updatePermissions(String securityUid, scala.collection.immutable.Seq<Tuple2<Role, java.util.List<String>>> rolesWithPermissions) {
        java.util.Map permissions = this.permissionEditor().readPermissions(securityUid);
        rolesWithPermissions.foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Role role = (Role)tuple2._1();
                java.util.List rolePermissions = (java.util.List)tuple2._2();
                return permissions.put(role, CollectionConverters$.MODULE$.SetHasAsJava((Set)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(rolePermissions).asScala().map((Function1 & Serializable)x$1 -> Permission.find((String)x$1))).toSet()).asJava());
            }
            throw new MatchError((Object)tuple2);
        });
        this.permissionEditor().editPermissions(securityUid, permissions);
    }

    private void updateInheritanceFlag(String containerId, scala.collection.immutable.Seq<Team> teams) {
        this.securedCis().setAsEffectiveSecuredCi(containerId, teams.nonEmpty());
    }

    private void removeMissingRoles(scala.collection.immutable.Seq<Team> teams) {
        LazyRef availableRoles$lzy = new LazyRef();
        teams.foreach((Function1 & Serializable)team -> {
            Buffer nonExistingRoles = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(team.getRoles()).asScala().filter((Function1 & Serializable)roleName -> BoxesRunTime.boxToBoolean((boolean)SqlTeamRepository.$anonfun$removeMissingRoles$2(this, availableRoles$lzy, roleName)));
            if (nonExistingRoles.nonEmpty()) {
                this.logger().warn((Function0 & Serializable)() -> "The following role(s) do not exist: " + nonExistingRoles + ". They were removed from the team " + team.getTeamName() + " [" + team.getId() + "].");
                return BoxesRunTime.boxToBoolean((boolean)team.getRoles().removeAll(CollectionConverters$.MODULE$.BufferHasAsJava(nonExistingRoles).asJava()));
            }
            return BoxedUnit.UNIT;
        });
    }

    private Team fromPlatformRole(String containerId, Role role, scala.collection.immutable.Seq<Permission> permissions) {
        Team team = (Team)Type.valueOf(Team.class).getDescriptor().newInstance(this.fromPlatformId(containerId, role.getId()));
        team.setRoles(role.getRoles());
        team.setMembers(role.getPrincipals());
        team.setTeamName(role.getName());
        scala.collection.immutable.Seq permissionNames = (scala.collection.immutable.Seq)permissions.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Permission, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    A1 A12 = A1;
                    return (B1)A12.getPermissionName();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Permission x1) {
                Permission permission = x1;
                return permission != null;
            }
        });
        team.setPermissions(package$.MODULE$.ListExtensions(permissionNames).asJavaMutable());
        return team;
    }

    private Role toPlatformRole(Team team) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)team.getTeamName()), (String)("Team name is missing in team " + team.getId()), (Object[])new Object[0]);
        Role role = new Role(this.toPlatformId(team.getId()), team.getTeamName());
        role.setRoles(team.getRoles());
        role.setPrincipals(team.getMembers());
        return role;
    }

    private String toPlatformId(String id) {
        return Ids.getName((String)id);
    }

    private String fromPlatformId(String containerId, String id) {
        return containerId + "/" + id;
    }

    private final /* synthetic */ Buffer availableRoles$lzycompute$1(LazyRef availableRoles$lzy$1) {
        Buffer buffer;
        LazyRef lazyRef = availableRoles$lzy$1;
        synchronized (lazyRef) {
            buffer = availableRoles$lzy$1.initialized() ? (Buffer)availableRoles$lzy$1.value() : (Buffer)availableRoles$lzy$1.initialize((Object)CollectionConverters$.MODULE$.ListHasAsScala(this.roleService().getRoles()).asScala());
        }
        return buffer;
    }

    private final Buffer availableRoles$1(LazyRef availableRoles$lzy$1) {
        if (availableRoles$lzy$1.initialized()) {
            return (Buffer)availableRoles$lzy$1.value();
        }
        return this.availableRoles$lzycompute$1(availableRoles$lzy$1);
    }

    public static final /* synthetic */ boolean $anonfun$removeMissingRoles$3(String roleName$1, Role x$6) {
        String string = x$6.getName();
        String string2 = roleName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$removeMissingRoles$2(SqlTeamRepository $this, LazyRef availableRoles$lzy$1, String roleName) {
        return !$this.availableRoles$1(availableRoles$lzy$1).exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SqlTeamRepository.$anonfun$removeMissingRoles$3(roleName, x$6)));
    }

    public SqlTeamRepository(JdbcTemplate jdbcTemplate, PermissionEditor permissionEditor, SqlRoleService roleService, SecuredCis securedCis) {
        this.jdbcTemplate = jdbcTemplate;
        this.permissionEditor = permissionEditor;
        this.roleService = roleService;
        this.securedCis = securedCis;
        Logging.$init$((Logging)this);
        this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate);
        this.STMT_GET_TEAM_PERMISSION_ROWS = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |SELECT\n       |    teams.ID        teamId,\n       |    teams.NAME      teamName,\n       |    team_permissions.PERMISSION_NAME permissionName\n       |FROM\n       |    XL_ROLES teams\n       |    JOIN XL_ROLE_PERMISSIONS team_permissions on teams.ID = team_permissions.ROLE_ID\n       |WHERE teams.CI_ID = :" + Schema.FOLDERS$.MODULE$.CI_UID() + "\n       |ORDER BY teamName, teamId\n       |"));
        this.STMT_GET_PRINCIPAL_TEAM_MEMBER_VIEW_ROWS = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |SELECT teams.ID                              teamId,\n       |       teams.NAME                            teamName,\n       |       team_principal_members.PRINCIPAL_NAME memberName,\n       |       team_principal_profile.FULL_NAME      fullName\n       |FROM XL_ROLES teams\n       |         LEFT JOIN XL_ROLE_PRINCIPALS team_principal_members on teams.ID = team_principal_members.ROLE_ID\n       |         LEFT JOIN XLR_USER_PROFILES team_principal_profile on team_principal_profile.USERNAME = team_principal_members.PRINCIPAL_NAME\n       |WHERE teams.CI_ID = :" + Schema.FOLDERS$.MODULE$.CI_UID() + "\n       |ORDER BY teamName, teamId\n       |"));
        this.STMT_GET_ROLE_TEAM_MEMBER_VIEW_ROWS = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |SELECT teams.ID        teamId,\n       |       teams.NAME      teamName,\n       |       team_roles.NAME memberName,\n       |       team_roles.ID   roleId\n       |FROM XL_ROLES teams\n       |         LEFT JOIN XL_ROLE_ROLES team_role_members on teams.ID = team_role_members.ROLE_ID\n       |         LEFT JOIN XL_ROLES team_roles on team_role_members.MEMBER_ROLE_ID = team_roles.ID\n       |WHERE teams.CI_ID = :" + Schema.FOLDERS$.MODULE$.CI_UID() + "\n       |ORDER BY teamName, teamId\n       |"));
    }
}

