/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.customscripts.ScriptTypes;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.utils.TaskTypes;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.service.NewType;
import com.xebialabs.xlrelease.service.NewType$;
import com.xebialabs.xlrelease.service.SqlTaskTypeConversion$;
import com.xebialabs.xlrelease.service.TaskTypeConversion;
import com.xebialabs.xlrelease.service.TaskTypeConverterService;
import com.xebialabs.xlrelease.service.TaskTypeConverterSyntax$;
import com.xebialabs.xlrelease.service.TaskTypeConverters$;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import org.springframework.stereotype.Component;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@IsTransactional
@Component
@ScalaSignature(bytes="\u0006\u0005\u0005%v!\u0002\u000e\u001c\u0011\u0003!c!\u0002\u0014\u001c\u0011\u00039\u0003\"\u0002\u0018\u0002\t\u0003y\u0003b\u0002\u0019\u0002\u0005\u0004%I!\r\u0005\u0007}\u0005\u0001\u000b\u0011\u0002\u001a\t\u000f}\n!\u0019!C\u0005c!1\u0001)\u0001Q\u0001\nIBq!Q\u0001C\u0002\u0013%\u0011\u0007\u0003\u0004C\u0003\u0001\u0006IA\r\u0005\b\u0007\u0006\u0011\r\u0011\"\u00032\u0011\u0019!\u0015\u0001)A\u0005e\u0019!ae\u0007\u0001F\u0011!\t6B!A!\u0002\u0013\u0011\u0006\u0002\u0003-\f\u0005\u0003\u0005\u000b\u0011B-\t\u0011}[!\u0011!Q\u0001\n\u0001D\u0001BZ\u0006\u0003\u0002\u0003\u0006Ia\u001a\u0005\t_.\u0011\t\u0011)A\u0005a\")af\u0003C\u0001g\")!p\u0003C!w\"9\u0011qE\u0006\u0005\n\u0005%\u0002bBA \u0017\u0011%\u0011\u0011\t\u0005\b\u0003\u000bZA\u0011BA$\u0011\u001d\t\tf\u0003C\u0005\u0003'Bq!a\u0016\f\t\u0013\tI\u0006C\u0004\u0002^-!I!a\u0018\t\u000f\u0005e4\u0002\"\u0003\u0002|\u0005)2+\u001d7UCN\\G+\u001f9f\u0007>tg/\u001a:tS>t'B\u0001\u000f\u001e\u0003\u001d\u0019XM\u001d<jG\u0016T!AH\u0010\u0002\u0013ad'/\u001a7fCN,'B\u0001\u0011\"\u0003%AXMY5bY\u0006\u00147OC\u0001#\u0003\r\u0019w.\\\u0002\u0001!\t)\u0013!D\u0001\u001c\u0005U\u0019\u0016\u000f\u001c+bg.$\u0016\u0010]3D_:4XM]:j_:\u001c\"!\u0001\u0015\u0011\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tA%A\nU3B+ulQ(O)\u0006Ke*\u0012*`)\u0006\u001b6*F\u00013!\t\u0019D(D\u00015\u0015\t)d'A\u0004sK\u001adWm\u0019;\u000b\u0005]B\u0014aA1qS*\u0011\u0011HO\u0001\u0007a2,x-\u001b8\u000b\u0005mz\u0012\u0001\u00033fa2|\u00170\u001b;\n\u0005u\"$\u0001\u0002+za\u0016\fA\u0003V-Q\u000b~\u001buJ\u0014+B\u0013:+%k\u0018+B'.\u0003\u0013a\u0006+Z!\u0016{6)V*U\u001f6{6k\u0011*J!R{F+Q*L\u0003a!\u0016\fU#`\u0007V\u001bFkT'`'\u000e\u0013\u0016\n\u0015+`)\u0006\u001b6\nI\u0001\n)f\u0003Vi\u0018+B'.\u000b!\u0002V-Q\u000b~#\u0016iU&!\u0003=!\u0016\fU#`)\u0006\u001b6jX$S\u001fV\u0003\u0016\u0001\u0005+Z!\u0016{F+Q*L?\u001e\u0013v*\u0016)!'\rYaI\u0014\t\u0003\u000f2k\u0011\u0001\u0013\u0006\u0003\u0013*\u000bA\u0001\\1oO*\t1*\u0001\u0003kCZ\f\u0017BA'I\u0005\u0019y%M[3diB\u0011QeT\u0005\u0003!n\u0011!\u0003V1tWRK\b/Z\"p]Z,'o]5p]\u0006Y1o\u0019:jaR$\u0016\u0010]3t!\t\u0019f+D\u0001U\u0015\t)V$A\u0007dkN$x.\\:de&\u0004Ho]\u0005\u0003/R\u00131bU2sSB$H+\u001f9fg\u0006qA/Y:l%\u0016\u0004xn]5u_JL\bC\u0001.^\u001b\u0005Y&B\u0001/\u001e\u0003)\u0011X\r]8tSR|'/_\u0005\u0003=n\u0013a\u0002V1tWJ+\u0007o\\:ji>\u0014\u00180\u0001\u0005fm\u0016tGOQ;t!\t\tG-D\u0001c\u0015\t\u0019W$\u0001\u0004fm\u0016tGo]\u0005\u0003K\n\u0014\u0011\u0003\u0017'SK2,\u0017m]3Fm\u0016tGOQ;t\u0003U!W\r]3oI\u0016t7-\u001f)feNL7\u000f^3oG\u0016\u0004\"\u0001[7\u000e\u0003%T!A[6\u0002\u0017A,'o]5ti\u0016t7-\u001a\u0006\u0003Yn\u000b1a]9m\u0013\tq\u0017NA\u000bEKB,g\u000eZ3oGf\u0004VM]:jgR,gnY3\u0002!\r|gN^3si\u0016\u00148+\u001a:wS\u000e,\u0007CA\u0013r\u0013\t\u00118D\u0001\rUCN\\G+\u001f9f\u0007>tg/\u001a:uKJ\u001cVM\u001d<jG\u0016$b\u0001^;wobL\bCA\u0013\f\u0011\u0015\t\u0016\u00031\u0001S\u0011\u0015A\u0016\u00031\u0001Z\u0011\u0015y\u0016\u00031\u0001a\u0011\u00151\u0017\u00031\u0001h\u0011\u0015y\u0017\u00031\u0001q\u0003Q\u0019\u0007.\u00198hK\u0006\u001bG/\u001b<f)\u0006\u001c8\u000eV=qKR)A0!\u0002\u0002\nA\u0019Q0!\u0001\u000e\u0003yT!a`\u000f\u0002\r\u0011|W.Y5o\u0013\r\t\u0019A \u0002\u0005)\u0006\u001c8\u000e\u0003\u0004\u0002\bI\u0001\r\u0001`\u0001\u0005i\u0006\u001c8\u000e\u0003\u0004\u0002\fI\u0001\rAM\u0001\u000bi\u0006\u0014x-\u001a;UsB,\u0007f\u0001\n\u0002\u0010A!\u0011\u0011CA\u0012\u001b\t\t\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011AC1o]>$\u0018\r^5p]*!\u0011\u0011DA\u000e\u0003\u0011\u0019wN]3\u000b\t\u0005u\u0011qD\u0001\u000b[&\u001c'o\\7fi\u0016\u0014(BAA\u0011\u0003\tIw.\u0003\u0003\u0002&\u0005M!!\u0002+j[\u0016$\u0017AG2iK\u000e\\G+\u001f9f\u0007\"\fgnZ3JgN+\b\u000f]8si\u0016$GCBA\u0016\u0003c\tY\u0004E\u0002*\u0003[I1!a\f+\u0005\u0011)f.\u001b;\t\u000f\u0005M2\u00031\u0001\u00026\u00059a.Z<UsB,\u0007cA\u0013\u00028%\u0019\u0011\u0011H\u000e\u0003\u000f9+w\u000fV=qK\"1\u0011QH\nA\u0002q\fqa\u001c7e)\u0006\u001c8.\u0001\bsKN|GN^3OK^$\u0016\u0010]3\u0015\t\u0005U\u00121\t\u0005\u0007\u0003\u0017!\u0002\u0019\u0001\u001a\u0002\u001d%\u001c\b+\u001f;i_:\u001c6M]5qiR!\u0011\u0011JA(!\rI\u00131J\u0005\u0004\u0003\u001bR#a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003\u0017)\u0002\u0019\u0001\u001a\u0002\u001f%\u001c8i\u001c8uC&tWM\u001d+bg.$B!!\u0013\u0002V!1\u00111\u0002\fA\u0002I\n!c\u00195fG.$\u0016m]6JgBc\u0017M\u001c8fIR!\u00111FA.\u0011\u0019\t9a\u0006a\u0001y\u0006!r-\u001a;BY2\u001cV\u000f\u001d9peR,G\rV=qKN,\"!!\u0019\u0011\u000b\u0005\r\u00141\u000f\u001a\u000f\t\u0005\u0015\u0014q\u000e\b\u0005\u0003O\ni'\u0004\u0002\u0002j)\u0019\u00111N\u0012\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0013bAA9U\u00059\u0001/Y2lC\u001e,\u0017\u0002BA;\u0003o\u00121aU3r\u0015\r\t\tHK\u0001\u001aaV\u0014x-Z$bi\u0016$\u0016m]6EKB,g\u000eZ3oG&,7\u000f\u0006\u0003\u0002,\u0005u\u0004BBA\u00043\u0001\u0007A\u0010K\u0002\f\u0003\u0003\u0003B!a!\u0002\u00106\u0011\u0011Q\u0011\u0006\u0005\u0003\u000f\u000bI)A\u0006ue\u0006t7/Y2uS>t'b\u00017\u0002\f*\u0019\u0011QR\u000f\u0002\u0005\u0011\u0014\u0017\u0002BAI\u0003\u000b\u0013q\"S:Ue\u0006t7/Y2uS>t\u0017\r\u001c\u0015\u0004\u0017\u0005U\u0005\u0003BAL\u0003Kk!!!'\u000b\t\u0005m\u0015QT\u0001\u000bgR,'/Z8usB,'\u0002BAP\u0003C\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003G\u000b1a\u001c:h\u0013\u0011\t9+!'\u0003\u0013\r{W\u000e]8oK:$\b")
public class SqlTaskTypeConversion
implements TaskTypeConversion {
    private final ScriptTypes scriptTypes;
    private final TaskRepository taskRepository;
    private final XLReleaseEventBus eventBus;
    private final DependencyPersistence dependencyPersistence;
    private final TaskTypeConverterService converterService;

    @Timed
    public Task changeActiveTaskType(Task task, Type targetType) {
        Object object;
        boolean isNotCustomScriptTypeOrItHasNotChanged;
        this.checkTaskIsPlanned(task);
        NewType newType = this.resolveNewType(targetType);
        this.checkTypeChangeIsSupported(newType, task);
        Type type = task.getType();
        Type type2 = newType.ciType();
        boolean ciTypeHasNotChanged = !(type != null ? !type.equals(type2) : type2 != null);
        Type type3 = task.getTaskType();
        Object object2 = newType.customScriptType().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        boolean bl = !(type3 != null ? !type3.equals(object2) : object2 != null) ? true : (isNotCustomScriptTypeOrItHasNotChanged = false);
        if (ciTypeHasNotChanged && isNotCustomScriptTypeOrItHasNotChanged) {
            return task;
        }
        Type type4 = newType.ciType();
        Type type5 = SqlTaskTypeConversion$.MODULE$.com$xebialabs$xlrelease$service$SqlTaskTypeConversion$$TYPE_CUSTOM_SCRIPT_TASK();
        Type type6 = type4;
        if (!(type5 != null ? !type5.equals(type6) : type6 != null)) {
            object = TaskTypeConverterSyntax$.MODULE$.TaskTypeConverterOps(task).convertTo(newType, this.converterService, TaskTypeConverters$.MODULE$.toCustomScriptTaskConverter());
        } else {
            Type type7 = SqlTaskTypeConversion$.MODULE$.com$xebialabs$xlrelease$service$SqlTaskTypeConversion$$TYPE_CONTAINER_TASK();
            Type type8 = type4;
            object = !(type7 != null ? !type7.equals(type8) : type8 != null) ? TaskTypeConverterSyntax$.MODULE$.TaskTypeConverterOps(task).convertTo(newType, this.converterService, TaskTypeConverters$.MODULE$.toContainerTaskConverter()) : TaskTypeConverterSyntax$.MODULE$.TaskTypeConverterOps(task).convertTo(newType, this.converterService, TaskTypeConverters$.MODULE$.toTaskConverter());
        }
        CustomScriptTask updatedTask = object;
        this.purgeGateTaskDependencies(task);
        Task result = this.taskRepository.updateType((Task)updatedTask);
        this.eventBus.publish((XLReleaseEvent)new TaskUpdatedEvent(task, result));
        return result;
    }

    private void checkTypeChangeIsSupported(NewType newType, Task oldTask) {
        boolean newTypeIsTaskType = newType.ciType().instanceOf(SqlTaskTypeConversion$.MODULE$.com$xebialabs$xlrelease$service$SqlTaskTypeConversion$$TYPE_TASK());
        Checks.checkArgument((this.isPythonScript(newType.ciType()) || newTypeIsTaskType ? 1 : 0) != 0, (String)("Cannot change type of task '" + oldTask.getTitle() + "' to '" + newType + "' because it is not one of supported types: " + this.getAllSupportedTypes().mkString(",")), (Object[])new Object[0]);
        if (oldTask.getType().isSubTypeOf(SqlTaskTypeConversion$.MODULE$.com$xebialabs$xlrelease$service$SqlTaskTypeConversion$$TYPE_TASK_GROUP())) {
            throw new IllegalArgumentException("Conversion of task '" + oldTask.getTitle() + "' from '" + oldTask.getType() + "' is not supported.");
        }
    }

    private NewType resolveNewType(Type targetType) {
        if (this.isPythonScript(targetType)) {
            return new NewType(SqlTaskTypeConversion$.MODULE$.com$xebialabs$xlrelease$service$SqlTaskTypeConversion$$TYPE_CUSTOM_SCRIPT_TASK(), (Option<Type>)new Some((Object)targetType), NewType$.MODULE$.apply$default$3());
        }
        if (this.isContainerTask(targetType)) {
            return new NewType(SqlTaskTypeConversion$.MODULE$.com$xebialabs$xlrelease$service$SqlTaskTypeConversion$$TYPE_CONTAINER_TASK(), (Option<Type>)None$.MODULE$, (Option<Type>)new Some((Object)targetType));
        }
        return new NewType(targetType, (Option<Type>)None$.MODULE$, NewType$.MODULE$.apply$default$3());
    }

    private boolean isPythonScript(Type targetType) {
        return this.scriptTypes.getPythonScriptTypes().contains(targetType);
    }

    private boolean isContainerTask(Type targetType) {
        return this.scriptTypes.getContainerTaskTypes().contains(targetType);
    }

    private void checkTaskIsPlanned(Task task) {
        Checks.checkArgument((boolean)task.isPlanned(), (String)"Cannot change type of the task '%s' because it is in state %s and not %s", (Object[])new Object[]{task.getTitle(), task.getStatus(), TaskStatus.PLANNED});
    }

    private Seq<Type> getAllSupportedTypes() {
        return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(TaskTypes.getDefaultTaskTypes()).asScala().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.CollectionHasAsScala(this.scriptTypes.getPythonScriptTypes()).asScala())).$plus$plus((IterableOnce)CollectionConverters$.MODULE$.CollectionHasAsScala(this.scriptTypes.getContainerTaskTypes()).asScala())).toSeq();
    }

    private void purgeGateTaskDependencies(Task task) {
        Task task2 = task;
        if (task2 instanceof GateTask) {
            GateTask gateTask = (GateTask)task2;
            CollectionConverters$.MODULE$.ListHasAsScala(gateTask.getDependencies()).asScala().foreach((Function1 & Serializable)dependency -> {
                this.dependencyPersistence.deleteDependency(dependency);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public SqlTaskTypeConversion(ScriptTypes scriptTypes, TaskRepository taskRepository, XLReleaseEventBus eventBus, DependencyPersistence dependencyPersistence, TaskTypeConverterService converterService) {
        this.scriptTypes = scriptTypes;
        this.taskRepository = taskRepository;
        this.eventBus = eventBus;
        this.dependencyPersistence = dependencyPersistence;
        this.converterService = converterService;
    }
}

