/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security.entities;

import com.xebialabs.xlrelease.security.entities.XlRole;
import com.xebialabs.xlrelease.security.entities.XlRolePrincipalId;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MapsId;
import jakarta.persistence.Table;

@Entity
@Table(name="XL_ROLE_PRINCIPALS")
public class XlRolePrincipal {
    @EmbeddedId
    private XlRolePrincipalId id;
    @MapsId(value="roleId")
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="ROLE_ID", nullable=false)
    private XlRole role;

    public XlRolePrincipal() {
    }

    public XlRolePrincipal(XlRolePrincipalId id, XlRole role) {
        this.id = id;
        this.role = role;
    }

    public XlRolePrincipal(XlRole role, String principalName) {
        this.id = new XlRolePrincipalId(role.getId(), principalName);
        this.role = role;
    }

    public XlRolePrincipalId getId() {
        return this.id;
    }

    public void setId(XlRolePrincipalId id) {
        this.id = id;
    }

    public XlRole getRole() {
        return this.role;
    }

    public void setRole(XlRole role) {
        this.role = role;
    }
}

