package com.xebialabs.xlrelease.repository.sql.jpa.entities;

import jakarta.persistence.*;

@Entity
@Table(name = "XLR_TENANTS")
public class XlTenant {

    @Id
    @Column(name = "TENANT_ID", updatable = false, nullable = false, unique = true)
    private String tenantId;

    @Column(name = "NAME", nullable = false, unique = true)
    private String name;

    @Column(name = "STATUS", nullable = false)
    private String status;

    @Version
    @Column(name = "VERSION", nullable = false)
    private Integer version;

    @PrePersist
    @PreUpdate
    private void normalizeName() {
        if (name != null) {
            name = name.toLowerCase().trim();
        }
    }

    public String getName() {
        return name;
    }

    public void setName(final String name) {
        this.name = name;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(final String status) {
        this.status = status;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(final String tenantId) {
        this.tenantId = tenantId;
    }

    public Integer getVersion() {
        return version;
    }

    public void setVersion(final Integer version) {
        this.version = version;
    }
}
