package com.xebialabs.xlrelease.repository.sql

import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional
import com.xebialabs.xlrelease.domain.Phase
import com.xebialabs.xlrelease.limits.LimitEnforcer
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence
import com.xebialabs.xlrelease.repository.{PersistenceInterceptor, PhaseRepository}
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._


@Component
@IsTransactional
class PhasePersistenceInterceptor(phaseRepository: PhaseRepository,
                                  val taskPersistence: TaskPersistence,
                                  val limitEnforcer: LimitEnforcer)
  extends PersistenceInterceptor[Phase]
    with ReleasePhaseTaskLimitValidator
    with WorkflowTaskValidator
    with WorkflowInterceptorLogic {

  phaseRepository.registerPersistenceInterceptor(this)

  override def onCreate(ci: Phase): Unit = {
    onCreateOrUpdate(ci)
  }

  override def onUpdate(ci: Phase): Unit = {
    onCreateOrUpdate(ci)
  }

  private def onCreateOrUpdate(phase: Phase): Unit = {
    val release = phase.getRelease()
    if (null != release) {
      enforcePhaseAndTaskLimits(release, ensureTenantId(release))
      if (release.isWorkflow()) {
        validateNoLockTaskPresent(phase.getAllTasks().asScala.toSeq)
        validateNoUnsupportedTaskPresent(phase.getAllTasks().asScala.toSeq)
        validateNoMultiLevelNestedTasks(phase.getAllTasks().asScala.toSeq)
      }
    }
  }

}
