/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql.persistence;

import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.SecurableSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.Token$;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow$Root$;
import com.xebialabs.xlrelease.utils.FolderId;
import java.io.Serializable;
import java.util.UUID;
import org.springframework.jdbc.core.RowMapper;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;

public final class FindDescendantsQueryBuilder$
implements SecurableSqlBuilder {
    public static final FindDescendantsQueryBuilder$ MODULE$ = new FindDescendantsQueryBuilder$();
    private static final String selectDescendants;
    private static final String descendantsOf;
    private static final String parentOf;
    private static final String folderIdCondition;
    private static final String folderUidCondition;
    private static final String findAncestorById;
    private static final String findAncestorByUid;
    private static final String grouped;
    private static final String topDownOrder;
    private static final RowMapper<FolderRow> toFolderData;

    static {
        SecurableSqlBuilder.$init$(MODULE$);
        selectDescendants = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       | SELECT\n       |   d." + Schema.VIEW$.MODULE$.FOLDER_ID() + ",\n       |   d." + Schema.VIEW$.MODULE$.FOLDER_PATH() + ",\n       |   d." + Schema.VIEW$.MODULE$.DESCENDANT_UID() + ",\n       |   d." + Schema.VIEW$.MODULE$.SECURITY_UID() + ",\n       |   d." + Schema.VIEW$.MODULE$.TOKEN() + ",\n       |   d." + Schema.VIEW$.MODULE$.NAME() + ",\n       |   p." + Schema.PATHS$.MODULE$.ANCESTOR_UID() + ",\n       |   d." + Schema.VIEW$.MODULE$.DEPTH() + ",\n       |   d." + Schema.VIEW$.MODULE$.TENANT_ID() + "\n       | FROM " + Schema.FOLDERS$.MODULE$.TABLE() + " f\n       "));
        descendantsOf = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       | JOIN " + Schema.VIEW$.MODULE$.TABLE() + " d\n       |    ON ( d." + Schema.VIEW$.MODULE$.ANCESTOR_UID() + " = f." + Schema.FOLDERS$.MODULE$.CI_UID() + " AND d." + Schema.PATHS$.MODULE$.DEPTH() + " <= :depth )\n       "));
        parentOf = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       | JOIN " + Schema.PATHS$.MODULE$.TABLE() + " p\n       |    ON  ( p." + Schema.PATHS$.MODULE$.DESCENDANT_UID() + " = d." + Schema.VIEW$.MODULE$.DESCENDANT_UID() + "\n       |          AND (     p." + Schema.PATHS$.MODULE$.DEPTH() + " = 1\n       |               OR ( p." + Schema.PATHS$.MODULE$.DEPTH() + " = 0 AND p." + Schema.PATHS$.MODULE$.ANCESTOR_UID() + " = " + FolderRow$Root$.MODULE$.uid() + " ) ) )\n       "));
        folderIdCondition = "f." + Schema.FOLDERS$.MODULE$.FOLDER_ID() + " = :folderId";
        folderUidCondition = "f." + Schema.FOLDERS$.MODULE$.CI_UID() + " = :ciUid";
        findAncestorById = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       | WHERE " + MODULE$.folderIdCondition() + "\n       "));
        findAncestorByUid = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       | WHERE " + MODULE$.folderUidCondition() + "\n       "));
        grouped = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       | GROUP BY\n       |  d." + Schema.VIEW$.MODULE$.DESCENDANT_UID() + ",\n       |  p." + Schema.PATHS$.MODULE$.ANCESTOR_UID() + ",\n       |  d." + Schema.VIEW$.MODULE$.SECURITY_UID() + ",\n       |  d." + Schema.VIEW$.MODULE$.TOKEN() + ",\n       |  d." + Schema.VIEW$.MODULE$.FOLDER_PATH() + ",\n       |  d." + Schema.VIEW$.MODULE$.FOLDER_ID() + ",\n       |  d." + Schema.VIEW$.MODULE$.NAME() + ",\n       |  d." + Schema.VIEW$.MODULE$.DEPTH() + ",\n       |  d." + Schema.VIEW$.MODULE$.TENANT_ID() + "\n       "));
        topDownOrder = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       | ORDER BY\n       |   d." + Schema.VIEW$.MODULE$.DEPTH() + " ASC,\n       |   d." + Schema.VIEW$.MODULE$.NAME() + " ASC,\n       |   p." + Schema.PATHS$.MODULE$.ANCESTOR_UID() + " ASC,\n       |   d." + Schema.VIEW$.MODULE$.DESCENDANT_UID() + " ASC\n      "));
        toFolderData = Utils$.MODULE$.rowMapper((Function1 & Serializable)rs -> {
            int uid = rs.getInt(Schema.VIEW$.MODULE$.DESCENDANT_UID());
            if (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)uid), (Object)FolderRow$Root$.MODULE$.uid())) {
                return FolderRow$Root$.MODULE$;
            }
            Integer x$1 = Predef$.MODULE$.int2Integer(uid);
            UUID x$2 = (UUID)Token$.MODULE$.fromString(rs.getString(Schema.VIEW$.MODULE$.TOKEN())).get();
            Integer x$3 = Predef$.MODULE$.int2Integer(rs.getInt(Schema.VIEW$.MODULE$.SECURITY_UID()));
            FolderId x$4 = new FolderId(rs.getString(Schema.VIEW$.MODULE$.FOLDER_PATH())).$div(rs.getString(Schema.VIEW$.MODULE$.FOLDER_ID()));
            String x$5 = rs.getString(Schema.VIEW$.MODULE$.NAME());
            Integer x$6 = Predef$.MODULE$.int2Integer(rs.getInt(Schema.PATHS$.MODULE$.ANCESTOR_UID()));
            int x$7 = rs.getInt(Schema.VIEW$.MODULE$.DEPTH());
            String x$8 = rs.getString(Schema.VIEW$.MODULE$.TENANT_ID());
            return new FolderRow.FolderEntry(x$1, x$2, x$3, x$4, x$5, x$6, x$8, x$7);
        });
    }

    @Override
    public String selectCiIdsWithPermission(Iterable<String> principalNames, Iterable<String> roleIds) {
        return SecurableSqlBuilder.selectCiIdsWithPermission$(this, principalNames, roleIds);
    }

    @Override
    public String selectCiIdsWithPermissions(Iterable<String> permissionNames, Iterable<String> principalNames, Iterable<String> roleIds) {
        return SecurableSqlBuilder.selectCiIdsWithPermissions$(this, permissionNames, principalNames, roleIds);
    }

    @Override
    public String selectCiIdsWithPermission(Iterable<String> roleIds) {
        return SecurableSqlBuilder.selectCiIdsWithPermission$(this, roleIds);
    }

    private String selectDescendants() {
        return selectDescendants;
    }

    private String descendantsOf() {
        return descendantsOf;
    }

    private String parentOf() {
        return parentOf;
    }

    private String findAncestorWithPermission(String folderCondition, Iterable<String> roleIds) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       | WHERE\n       |    " + folderCondition + "\n       | AND (\n       |            f." + Schema.FOLDERS$.MODULE$.FOLDER_ID() + " = d." + Schema.VIEW$.MODULE$.FOLDER_ID() + "\n       |        OR (\n       |              d." + Schema.VIEW$.MODULE$.SECURITY_UID() + " IN (\n       |                  " + this.selectCiIdsWithPermission(roleIds) + "\n       |              )\n       |           )\n       |     )\n     "));
    }

    private String folderIdCondition() {
        return folderIdCondition;
    }

    private String folderUidCondition() {
        return folderUidCondition;
    }

    private String findAncestorByIdAndPermission(Iterable<String> roleIds) {
        return this.findAncestorWithPermission(this.folderIdCondition(), roleIds);
    }

    private String findAncestorById() {
        return findAncestorById;
    }

    private String findAncestorByUidAndPermission(Iterable<String> roleIds) {
        return this.findAncestorWithPermission(this.folderUidCondition(), roleIds);
    }

    private String findAncestorByUid() {
        return findAncestorByUid;
    }

    private String grouped() {
        return grouped;
    }

    private String topDownOrder() {
        return topDownOrder;
    }

    public RowMapper<FolderRow> toFolderData() {
        return toFolderData;
    }

    public String findByUid() {
        return StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(this.selectDescendants()), this.descendantsOf())), this.parentOf())), this.findAncestorByUid())), this.grouped())), this.topDownOrder());
    }

    public String findByUidHavingPermission(Iterable<String> roles) {
        return StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(this.selectDescendants()), this.descendantsOf())), this.parentOf())), this.findAncestorByUidAndPermission(roles))), this.grouped())), this.topDownOrder());
    }

    public String findById() {
        return StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(this.selectDescendants()), this.descendantsOf())), this.parentOf())), this.findAncestorById())), this.grouped())), this.topDownOrder());
    }

    public String findByIdHavingPermission(Iterable<String> roleIds) {
        return StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(this.selectDescendants()), this.descendantsOf())), this.parentOf())), this.findAncestorByIdAndPermission(roleIds))), this.grouped())), this.topDownOrder());
    }

    private FindDescendantsQueryBuilder$() {
    }
}

