package com.xebialabs.xlrelease.repository.sql

import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional
import com.xebialabs.xlrelease.domain.Task
import com.xebialabs.xlrelease.limits.LimitEnforcer
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence
import com.xebialabs.xlrelease.repository.{PersistenceInterceptor, TaskRepository}
import org.springframework.stereotype.Component


@Component
@IsTransactional
class TaskPersistenceInterceptor(taskRepository: TaskRepository,
                                 val taskPersistence: TaskPersistence,
                                 val limitEnforcer: LimitEnforcer)
  extends PersistenceInterceptor[Task]
    with ReleasePhaseTaskLimitValidator
    with WorkflowTaskValidator
    with WorkflowInterceptorLogic {

  taskRepository.registerPersistenceInterceptor(this)

  override def onCreate(ci: Task): Unit = {
    onCreateOrUpdate(ci)
  }

  override def onUpdate(ci: Task): Unit = {
    onCreateOrUpdate(ci)
  }

  private def onCreateOrUpdate(task: Task): Unit = {
    val release = task.getRelease
    enforcePhaseAndTaskLimits(release, ensureTenantId(release))
    if (release.isWorkflow) {
      updateWorkflowProperties(task)
      validateNoLockTaskPresent(task)
      validateNoUnsupportedTaskPresent(task)
      validateNoMultiLevelNestedTasks(task)
    }
  }

}
