package com.xebialabs.xlrelease.repository.sql

import com.xebialabs.deployit.checks.Checks.IncorrectArgumentException
import com.xebialabs.xlrelease.domain.{Task, TaskGroup}

private[sql] trait WorkflowTaskValidator {

  def validateNoLockTaskPresent(task: Task): Unit = {
    if (task.isLocked) {
      throw new IncorrectArgumentException("Lock tasks are not supported for workflows")
    }
  }

  def validateNoLockTaskPresent(tasks: Seq[Task]): Unit = {
    val hasLockTasks = tasks.exists(_.isLocked)
    if (hasLockTasks) {
      throw new IncorrectArgumentException("Lock tasks are not supported for workflows")
    }
  }

  def validateNoUnsupportedTaskPresent(task: Task): Unit = {
    if (!task.isSupportedInWorkflow) {
      throw new IncorrectArgumentException(s"Task type [${task.getTaskType.toString}] is not supported for workflow")
    }
  }

  def validateNoUnsupportedTaskPresent(tasks: Seq[Task]): Unit = {
    val unsupportedTasks = tasks.filter(!_.isSupportedInWorkflow)
    if (unsupportedTasks.nonEmpty) {
      val taskTypes = unsupportedTasks.map(_.getTaskType.toString).mkString(", ")
      throw new IncorrectArgumentException(s"Found unsupported task types for workflow: $taskTypes")
    }
  }

  def validateNoMultiLevelNestedTasks(task: Task): Unit = {
    if (task.isTaskGroup && task.getContainer.isInstanceOf[TaskGroup]) {
      throw new IncorrectArgumentException("Nesting more than one level of group tasks is not supported for workflows")
    }
  }

  def validateNoMultiLevelNestedTasks(tasks: Seq[Task]): Unit = {
    tasks.foreach(validateNoMultiLevelNestedTasks)
  }
}
