/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.UserToken;
import com.xebialabs.xlrelease.domain.UserTokenPermission;
import com.xebialabs.xlrelease.repository.UserTokenRepository;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.UserTokenMapper;
import com.xebialabs.xlrelease.repository.sql.UserTokenQueryBuilder$;
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceConstants$;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.slf4j.Marker;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.support.SqlBinaryValue;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\t%e\u0001\u0002\u0014(\u0001IB\u0001B\u0015\u0001\u0003\u0006\u0004%\u0019a\u0015\u0005\tW\u0002\u0011\t\u0011)A\u0005)\"AA\u000e\u0001BC\u0002\u0013\rQ\u000e\u0003\u0005{\u0001\t\u0005\t\u0015!\u0003o\u0011!Y\bA!b\u0001\n\u0007a\b\"CA\u0001\u0001\t\u0005\t\u0015!\u0003~\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000bA\u0011\"!\u0005\u0001\u0005\u0004%I!a\u0005\t\u0011\u0005\u0015\u0002\u0001)A\u0005\u0003+Aq!a\n\u0001\t\u0003\nI\u0003C\u0005\u0002r\u0001\u0011\r\u0011\"\u0003\u0002\u0014!A\u00111\u000f\u0001!\u0002\u0013\t)\u0002C\u0005\u0002v\u0001\u0011\r\u0011\"\u0003\u0002\u0014!A\u0011q\u000f\u0001!\u0002\u0013\t)\u0002C\u0004\u0002z\u0001!\t%a\u001f\t\u000f\u0005u\u0005\u0001\"\u0011\u0002 \"9\u0011Q\u0017\u0001\u0005B\u0005]\u0006\"CAl\u0001\t\u0007I\u0011BA\n\u0011!\tI\u000e\u0001Q\u0001\n\u0005U\u0001bBAn\u0001\u0011\u0005\u0013Q\u001c\u0005\n\u0003G\u0004!\u0019!C\u0005\u0003KD\u0001\"a;\u0001A\u0003%\u0011q\u001d\u0005\b\u0003[\u0004A\u0011IAx\u0011%\t)\u0010\u0001b\u0001\n\u0013\t)\u000f\u0003\u0005\u0002x\u0002\u0001\u000b\u0011BAt\u0011\u001d\ti\u000f\u0001C!\u0003sD\u0011B!\u0001\u0001\u0005\u0004%I!a\u0005\t\u0011\t\r\u0001\u0001)A\u0005\u0003+AqA!\u0002\u0001\t\u0003\u00129\u0001C\u0005\u0003\"\u0001\u0011\r\u0011\"\u0003\u0002\u0014!A!1\u0005\u0001!\u0002\u0013\t)\u0002C\u0004\u0003&\u0001!\tEa\n\t\u0013\tM\u0002A1A\u0005\n\u0005M\u0001\u0002\u0003B\u001b\u0001\u0001\u0006I!!\u0006\t\u000f\t]\u0002\u0001\"\u0011\u0003:!9!\u0011\t\u0001\u0005B\t\r\u0003b\u0002B:\u0001\u0011\u0005#Q\u000f\u0002\u0017'FdWk]3s)>\\WM\u001c*fa>\u001c\u0018\u000e^8ss*\u0011\u0001&K\u0001\u0004gFd'B\u0001\u0016,\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003Y5\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u00059z\u0013!\u0003=fE&\fG.\u00192t\u0015\u0005\u0001\u0014aA2p[\u000e\u00011c\u0002\u00014su\u001aeI\u0013\t\u0003i]j\u0011!\u000e\u0006\u0002m\u0005)1oY1mC&\u0011\u0001(\u000e\u0002\u0007\u0003:L(+\u001a4\u0011\u0005iZT\"A\u0015\n\u0005qJ#aE+tKJ$vn[3o%\u0016\u0004xn]5u_JL\bC\u0001 B\u001b\u0005y$B\u0001!(\u0003-\u0001XM]:jgR,gnY3\n\u0005\t{$A\u0005)feNL7\u000f^3oG\u0016\u001cV\u000f\u001d9peR\u0004\"A\u0010#\n\u0005\u0015{$!B+uS2\u001c\bCA$I\u001b\u00059\u0013BA%(\u0005=)6/\u001a:U_.,g.T1qa\u0016\u0014\bCA&Q\u001b\u0005a%BA'O\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005y\u0015\u0001C4sSjTH.\u001a3\n\u0005Ec%a\u0002'pO\u001eLgnZ\u0001\bI&\fG.Z2u+\u0005!\u0006CA+i\u001d\t1VM\u0004\u0002XG:\u0011\u0001,\u0019\b\u00033\u0002t!AW0\u000f\u0005msV\"\u0001/\u000b\u0005u\u000b\u0014A\u0002\u001fs_>$h(C\u00011\u0013\tqs&\u0003\u0002-[%\u0011!mK\u0001\u0003I\nL!\u0001\u000b3\u000b\u0005\t\\\u0013B\u00014h\u0003)\u0019\u0016\u000f\u001c\"vS2$WM\u001d\u0006\u0003Q\u0011L!!\u001b6\u0003\u000f\u0011K\u0017\r\\3di*\u0011amZ\u0001\tI&\fG.Z2uA\u0005a!\u000e\u001a2d)\u0016l\u0007\u000f\\1uKV\ta\u000e\u0005\u0002pq6\t\u0001O\u0003\u0002re\u0006!1m\u001c:f\u0015\t\u0019H/\u0001\u0003kI\n\u001c'BA;w\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A<\u0002\u0007=\u0014x-\u0003\u0002za\na!\n\u001a2d)\u0016l\u0007\u000f\\1uK\u0006i!\u000e\u001a2d)\u0016l\u0007\u000f\\1uK\u0002\nAc]9m%\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014X#A?\u0011\u0005\u001ds\u0018BA@(\u0005Q\u0019\u0016\u000f\u001c*fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;fe\u0006)2/\u001d7SKB|7/\u001b;pef\fE-\u00199uKJ\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002\u0002\bQA\u0011\u0011BA\u0006\u0003\u001b\ty\u0001\u0005\u0002H\u0001!)!k\u0002a\u0002)\")An\u0002a\u0002]\")1p\u0002a\u0002{\u000612\u000bV'U?&s5+\u0012*U?V\u001bVIU0U\u001f.+e*\u0006\u0002\u0002\u0016A!\u0011qCA\u0010\u001d\u0011\tI\"a\u0007\u0011\u0005m+\u0014bAA\u000fk\u00051\u0001K]3eK\u001aLA!!\t\u0002$\t11\u000b\u001e:j]\u001eT1!!\b6\u0003]\u0019F+\u0014+`\u0013:\u001bVI\u0015+`+N+%k\u0018+P\u0017\u0016s\u0005%\u0001\u0004de\u0016\fG/\u001a\u000b\u0007\u0003W\t)%!\u0016\u0011\t\u00055\u0012q\b\b\u0005\u0003_\tYD\u0004\u0003\u00022\u0005eb\u0002BA\u001a\u0003oq1\u0001WA\u001b\u0013\tQ3&\u0003\u0002)S%\u0011\u0001iJ\u0005\u0004\u0003{y\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003\u0003\n\u0019EA\u0003DSVKGMC\u0002\u0002>}Bq!a\u0012\u000b\u0001\u0004\tI%A\u0005vg\u0016\u0014Hk\\6f]B!\u00111JA)\u001b\t\tiEC\u0002\u0002P-\na\u0001Z8nC&t\u0017\u0002BA*\u0003\u001b\u0012\u0011\"V:feR{7.\u001a8\t\u000f\u0005]#\u00021\u0001\u0002\u0016\u0005IAo\\6f]\"\u000b7\u000f\u001b\u0015\u0004\u0015\u0005m\u0003\u0003BA/\u0003[j!!a\u0018\u000b\t\u0005\u0005\u00141M\u0001\u000bC:tw\u000e^1uS>t'bA9\u0002f)!\u0011qMA5\u0003)i\u0017n\u0019:p[\u0016$XM\u001d\u0006\u0003\u0003W\n!![8\n\t\u0005=\u0014q\f\u0002\u0006)&lW\rZ\u0001\u0016'RkEkX+Q\t\u0006#Vi\u0018'B'R{VkU#E\u0003Y\u0019F+\u0014+`+B#\u0015\tV#`\u0019\u0006\u001bFkX+T\u000b\u0012\u0003\u0013!H*U\u001bR{V\u000b\u0015#B)\u0016{FkT&F\u001d~\u0003VIU'J'NKuJT*\u0002=M#V\nV0V!\u0012\u000bE+R0U\u001f.+ej\u0018)F%6K5kU%P\u001dN\u0003\u0013AD;qI\u0006$X\rT1tiV\u001bX\r\u001a\u000b\u0007\u0003{\n\u0019)a\"\u0011\u0007Q\ny(C\u0002\u0002\u0002V\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002\u0006>\u0001\r!a\u000b\u0002\u000b\rLW+\u001b3\t\u000f\u0005%u\u00021\u0001\u0002\f\u0006AA.Y:u+N,G\r\u0005\u0003\u0002\u000e\u0006]UBAAH\u0015\u0011\t\t*a%\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003+\u000bAA[1wC&!\u0011\u0011TAH\u0005\u0011!\u0015\r^3)\u0007=\tY&\u0001\fva\u0012\fG/\u001a+pW\u0016t\u0007+\u001a:nSN\u001c\u0018n\u001c8t)\u0019\t\t+a*\u0002*B\u0019A'a)\n\u0007\u0005\u0015VG\u0001\u0003V]&$\bbBAC!\u0001\u0007\u00111\u0006\u0005\b\u0003W\u0003\u0002\u0019AAW\u0003M)8/\u001a:U_.,g\u000eU3s[&\u001c8/[8o!\u0011\tY%a,\n\t\u0005E\u0016Q\n\u0002\u0014+N,'\u000fV8lK:\u0004VM]7jgNLwN\u001c\u0015\u0004!\u0005m\u0013aE;qI\u0006$X\rT1tiV\u001bX\r\u001a\"bi\u000eDG\u0003BA]\u0003\u007f\u00032\u0001NA^\u0013\r\ti,\u000e\u0002\u0004\u0013:$\bbBAa#\u0001\u0007\u00111Y\u0001\bK:$(/[3t!!\t9\"!2\u0002J\u0006-\u0015\u0002BAd\u0003G\u00111!T1q!\u0011\tY-!5\u000e\u0005\u00055'\u0002BAh\u0003'\u000bA\u0001\\1oO&!\u00111[Ag\u0005\u001dIe\u000e^3hKJD3!EA.\u0003\u0005\u001aF+\u0014+`+B#\u0015\tV#`)>[UIT0F1BK%+R0O\u001fRKe)S#E\u0003\t\u001aF+\u0014+`+B#\u0015\tV#`)>[UIT0F1BK%+R0O\u001fRKe)S#EA\u0005QR\u000f\u001d3bi\u0016$vn[3o\u000bb\u0004\u0018N]3e\u001d>$\u0018NZ5fIR!\u0011\u0011UAp\u0011\u001d\t)\t\u0006a\u0001\u0003WA3\u0001FA.\u0003}\u0019F+\u0014+`\t\u0016cU\tV#`+N+%k\u0018+P\u0017\u0016suLQ-`\u0007&+\u0016\nR\u000b\u0003\u0003O\u0004B!a3\u0002j&!\u0011\u0011EAg\u0003\u0001\u001aF+\u0014+`\t\u0016cU\tV#`+N+%k\u0018+P\u0017\u0016suLQ-`\u0007&+\u0016\n\u0012\u0011\u0002\r\u0011,G.\u001a;f)\u0011\t\t+!=\t\u000f\u0005\u0015u\u00031\u0001\u0002,!\u001aq#a\u0017\u0002EM#V\nV0E\u000b2+E+R0V'\u0016\u0013v\fV(L\u000b:{&)W0V'\u0016\u0013f*Q'F\u0003\r\u001aF+\u0014+`\t\u0016cU\tV#`+N+%k\u0018+P\u0017\u0016suLQ-`+N+%KT!N\u000b\u0002\"B!!)\u0002|\"9\u0011Q \u000eA\u0002\u0005U\u0011\u0001C;tKJt\u0017-\\3)\u0007i\tY&A\rR+\u0016\u0013\u0016lX+T\u000bJ{FkT&F\u001d~\u0013\u0015lX\"J+&#\u0015AG)V\u000bJKv,V*F%~#vjS#O?\nKvlQ%V\u0013\u0012\u0003\u0013a\u00034j]\u0012\u0014\u0015pQ5VS\u0012$BA!\u0003\u0003\u0010A)AGa\u0003\u0002J%\u0019!QB\u001b\u0003\r=\u0003H/[8o\u0011\u001d\t))\ba\u0001\u0003WA3!HA.Q\ri\"Q\u0003\t\u0005\u0005/\u0011i\"\u0004\u0002\u0003\u001a)\u0019!1D4\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0005?\u0011IB\u0001\u0006JgJ+\u0017\rZ(oYf\f\u0011%U+F%f{VkU#S?R{5*\u0012(`\u0005f{VkU#S?\u0006sEi\u0018(P)\u0016\u000b!%U+F%f{VkU#S?R{5*\u0012(`\u0005f{VkU#S?\u0006sEi\u0018(P)\u0016\u0003\u0013!\u00054j]\u0012\u0014\u00150V:fe\u0006sGMT8uKR1!\u0011\u0002B\u0015\u0005WAq!!@!\u0001\u0004\t)\u0002C\u0004\u0003.\u0001\u0002\r!!\u0006\u0002\u0013Q|7.\u001a8O_R,\u0007f\u0001\u0011\u0002\\!\u001a\u0001E!\u0006\u0002=E+VIU-`+N+%k\u0018+P\u0017\u0016suLQ-`)>[UIT0I\u0003NC\u0015aH)V\u000bJKv,V*F%~#vjS#O?\nKv\fV(L\u000b:{\u0006*Q*IA\u0005ya-\u001b8e\u0005f,6/\u001a:U_.,g\u000e\u0006\u0003\u0003\n\tm\u0002bBA,G\u0001\u0007\u0011Q\u0003\u0015\u0004G\u0005m\u0003fA\u0012\u0003\u0016\u0005)\u0011/^3ssR1!Q\tB*\u0005K\u0002bAa\u0012\u0003P\u0005%SB\u0001B%\u0015\u0011\tyEa\u0013\u000b\u0007\t5C/\u0001\u0003eCR\f\u0017\u0002\u0002B)\u0005\u0013\u0012A\u0001U1hK\"9!Q\u000b\u0013A\u0002\t]\u0013!C8qKJ\fG/[8o!\u0011\u0011IFa\u0018\u000f\t\u0005M\"1L\u0005\u0004\u0005;J\u0013aE+tKJ$vn[3o%\u0016\u0004xn]5u_JL\u0018\u0002\u0002B1\u0005G\u0012a\"U;fef|\u0005/\u001a:bi&|gNC\u0002\u0003^%BqAa\u001a%\u0001\u0004\u0011I'\u0001\u0005qC\u001e,\u0017M\u00197f!\u0011\u00119Ea\u001b\n\t\t5$\u0011\n\u0002\t!\u0006<W-\u00192mK\"\u001aA%a\u0017)\u0007\u0011\u0012)\"\u0001\tgS:$')\u001f)fe6L7o]5p]R1!Q\tB<\u0005wBqA!\u001f&\u0001\u0004\t)\"\u0001\u0006qKJl\u0017n]:j_:DqAa\u001a&\u0001\u0004\u0011I\u0007K\u0002&\u00037B3!\nB\u000bQ\r\u0001!1\u0011\t\u0005\u0005/\u0011))\u0003\u0003\u0003\b\ne!aD%t)J\fgn]1di&|g.\u00197")
public class SqlUserTokenRepository
implements UserTokenRepository,
PersistenceSupport,
UserTokenMapper,
Logging {
    private final SqlBuilder.Dialect dialect;
    private final JdbcTemplate jdbcTemplate;
    private final SqlRepositoryAdapter sqlRepositoryAdapter;
    private final String STMT_INSERT_USER_TOKEN;
    private final String STMT_UPDATE_LAST_USED;
    private final String STMT_UPDATE_TOKEN_PERMISSIONS;
    private final String STMT_UPDATE_TOKEN_EXPIRE_NOTIFIED;
    private final String STMT_DELETE_USER_TOKEN_BY_CIUID;
    private final String STMT_DELETE_USER_TOKEN_BY_USERNAME;
    private final String QUERY_USER_TOKEN_BY_CIUID;
    private final String QUERY_USER_TOKEN_BY_USER_AND_NOTE;
    private final String QUERY_USER_TOKEN_BY_TOKEN_HASH;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private NamedParameterJdbcTemplate namedTemplate;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public RowMapper<UserToken> userTokenMapper() {
        return UserTokenMapper.userTokenMapper$(this);
    }

    @Override
    public MapSqlParameterSource paramMap2MapSqlParameterSource(Map<String, Object> params) {
        return PersistenceSupport.paramMap2MapSqlParameterSource$(this, params);
    }

    @Override
    public Integer sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params) {
        return PersistenceSupport.sqlInsert$(this, pkColumn, sqlStatement, params);
    }

    @Override
    public Long sqlInsertTask(String pkColumn, String sqlStatement, Map<String, Object> params) {
        return PersistenceSupport.sqlInsertTask$(this, pkColumn, sqlStatement, params);
    }

    @Override
    public <R> R sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlInsertTask(String pkColumn, String sqlStatement, Map<String, Object> params, Function1<Long, R> mapper) {
        return (R)PersistenceSupport.sqlInsertTask$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlInsert(String pkColumn, String sqlStatement, MapSqlParameterSource params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlInsertTask(String pkColumn, String sqlStatement, MapSqlParameterSource params, Function1<Long, R> mapper) {
        return (R)PersistenceSupport.sqlInsertTask$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public void sqlInsert(String sqlStatement, MapSqlParameterSource params) {
        PersistenceSupport.sqlInsert$(this, sqlStatement, params);
    }

    @Override
    public <R> R sqlExec(String sqlStatement, Map<String, Object> params, PreparedStatementCallback<R> callback) {
        return (R)PersistenceSupport.sqlExec$(this, sqlStatement, params, callback);
    }

    @Override
    public <R> R sqlExecWithContent(String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlExecWithContent$(this, sqlStatement, params, contentParam, mapper);
    }

    @Override
    public <R> R sqlInsertWithContent(String pkColumn, String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsertWithContent$(this, pkColumn, sqlStatement, params, contentParam, mapper);
    }

    @Override
    public <R> R sqlUpdate(String sqlStatement, MapSqlParameterSource params, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlUpdate$(this, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlSet(String sqlStatement, Function1<PreparedStatement, PreparedStatement> setup, Function1<Object, R> callback) {
        return (R)PersistenceSupport.sqlSet$(this, sqlStatement, setup, callback);
    }

    @Override
    public Function1<Object, BoxedUnit> checkCiUpdated(String entityId) {
        return PersistenceSupport.checkCiUpdated$(this, entityId);
    }

    @Override
    public Function1<Object, UUID> checkCiUpdated(Integer uid, Option<UUID> token, UUID freshToken) {
        return PersistenceSupport.checkCiUpdated$(this, uid, token, freshToken);
    }

    @Override
    public Function1<Object, BoxedUnit> checkCiDeleted(Integer uid) {
        return PersistenceSupport.checkCiDeleted$(this, uid);
    }

    @Override
    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, RowMapper<R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, mapper);
    }

    @Override
    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, Function1<ResultSet, R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlQuery(String sqlStatement, Map<String, Object> params, ResultSetExtractor<R> extractor) {
        return (R)PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, extractor);
    }

    @Override
    public Seq<Object> sqlBatch(String sqlStatement, Set<Map<String, Object>> parameters) {
        return PersistenceSupport.sqlBatch$(this, sqlStatement, parameters);
    }

    @Override
    public Seq<Object> sqlBatchWithContent(String sqlStatement, Seq<Tuple2<Map<String, Object>, Tuple2<String, String>>> params) {
        return PersistenceSupport.sqlBatchWithContent$(this, sqlStatement, params);
    }

    @Override
    public String pkName(String pkColumn) {
        return PersistenceSupport.pkName$(this, pkColumn);
    }

    @Override
    public MapSqlParameterSource paramSource(Seq<Tuple2<String, Object>> pairs) {
        return PersistenceSupport.paramSource$(this, pairs);
    }

    @Override
    public byte[] compress(String text) {
        return CompressionSupport.compress$((CompressionSupport)this, text);
    }

    @Override
    public String decompress(InputStream inputStream) {
        return CompressionSupport.decompress$((CompressionSupport)this, inputStream);
    }

    @Override
    public byte[] compress(byte[] byteArray) {
        return CompressionSupport.compress$((CompressionSupport)this, byteArray);
    }

    @Override
    public byte[] decompress(byte[] byteArray) {
        return CompressionSupport.decompress$((CompressionSupport)this, byteArray);
    }

    @Override
    public <A> Option<A> findOptional(Function1<JdbcTemplate, A> body, JdbcTemplate jdbcTemplate) {
        return Utils.findOptional$(this, body, jdbcTemplate);
    }

    @Override
    public <A> Option<A> findOne(Function0<Buffer<A>> body) {
        return Utils.findOne$(this, body);
    }

    @Override
    public <A> Seq<A> findMany(Function0<Buffer<A>> body) {
        return Utils.findMany$(this, body);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlUserTokenRepository sqlUserTokenRepository = this;
        synchronized (sqlUserTokenRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private NamedParameterJdbcTemplate namedTemplate$lzycompute() {
        SqlUserTokenRepository sqlUserTokenRepository = this;
        synchronized (sqlUserTokenRepository) {
            if (!this.bitmap$0) {
                this.namedTemplate = PersistenceSupport.namedTemplate$(this);
                this.bitmap$0 = true;
            }
        }
        return this.namedTemplate;
    }

    @Override
    public NamedParameterJdbcTemplate namedTemplate() {
        if (!this.bitmap$0) {
            return this.namedTemplate$lzycompute();
        }
        return this.namedTemplate;
    }

    @Override
    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public SqlRepositoryAdapter sqlRepositoryAdapter() {
        return this.sqlRepositoryAdapter;
    }

    private String STMT_INSERT_USER_TOKEN() {
        return this.STMT_INSERT_USER_TOKEN;
    }

    @Timed
    public Integer create(UserToken userToken, String tokenHash) {
        this.logger().trace((Function0 & Serializable)() -> "creating user token " + userToken);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(Schema.USER_TOKENS$.MODULE$.USERNAME(), (Object)userToken.username().toLowerCase());
        params.addValue(Schema.USER_TOKENS$.MODULE$.TOKEN_NOTE(), (Object)userToken.tokenNote());
        params.addValue(Schema.USER_TOKENS$.MODULE$.TOKEN_HASH(), (Object)tokenHash);
        params.addValue(Schema.USER_TOKENS$.MODULE$.CREATED_DATE(), (Object)userToken.createdDate());
        params.addValue(Schema.USER_TOKENS$.MODULE$.EXPIRY_DATE(), (Object)userToken.expiryDate());
        params.addValue(Schema.USER_TOKENS$.MODULE$.TOKEN_PERMISSIONS(), Option$.MODULE$.apply((Object)userToken.userTokenPermission()).map((Function1 & Serializable)permission -> new SqlBinaryValue(CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)permission).getBytes(StandardCharsets.UTF_8))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), PersistenceConstants$.MODULE$.BLOB_TYPE());
        return (Integer)this.sqlInsert(this.pkName(Schema.USER_TOKENS$.MODULE$.CI_UID()), this.STMT_INSERT_USER_TOKEN(), params, (Function1 & Serializable)ciUid -> ciUid);
    }

    private String STMT_UPDATE_LAST_USED() {
        return this.STMT_UPDATE_LAST_USED;
    }

    private String STMT_UPDATE_TOKEN_PERMISSIONS() {
        return this.STMT_UPDATE_TOKEN_PERMISSIONS;
    }

    @Timed
    public boolean updateLastUsed(Integer ciUid, Date lastUsed) {
        return BoxesRunTime.unboxToBoolean(this.sqlUpdate(this.STMT_UPDATE_LAST_USED(), this.paramMap2MapSqlParameterSource(Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ciUid"), (Object)ciUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lastUsed"), (Object)lastUsed)}))), (Function1)(JFunction1.mcZI.sp & Serializable)x$1 -> x$1 == 1));
    }

    @Timed
    public void updateTokenPermissions(Integer ciUid, UserTokenPermission userTokenPermission) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(Schema.USER_TOKENS$.MODULE$.CI_UID(), (Object)ciUid);
        params.addValue(Schema.USER_TOKENS$.MODULE$.TOKEN_PERMISSIONS(), Option$.MODULE$.apply((Object)userTokenPermission).map((Function1 & Serializable)permission -> new SqlBinaryValue(CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)permission).getBytes(StandardCharsets.UTF_8))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), PersistenceConstants$.MODULE$.BLOB_TYPE());
        this.sqlUpdate(this.STMT_UPDATE_TOKEN_PERMISSIONS(), params, (Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {});
    }

    @Timed
    public int updateLastUsedBatch(Map<Integer, Date> entries) {
        return BoxesRunTime.unboxToInt((Object)this.sqlBatch(this.STMT_UPDATE_LAST_USED(), (Set<Map<String, Object>>)((IterableOnceOps)entries.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Integer ciUid = (Integer)tuple2._1();
                Date lastUsed = (Date)tuple2._2();
                return Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ciUid"), (Object)ciUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lastUsed"), (Object)lastUsed)}));
            }
            throw new MatchError((Object)tuple2);
        })).toSet()).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    private String STMT_UPDATE_TOKEN_EXPIRE_NOTIFIED() {
        return this.STMT_UPDATE_TOKEN_EXPIRE_NOTIFIED;
    }

    @Timed
    public void updateTokenExpiredNotified(Integer ciUid) {
        this.sqlUpdate(this.STMT_UPDATE_TOKEN_EXPIRE_NOTIFIED(), this.paramMap2MapSqlParameterSource(Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ciUid"), (Object)ciUid)}))), (Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {});
    }

    private String STMT_DELETE_USER_TOKEN_BY_CIUID() {
        return this.STMT_DELETE_USER_TOKEN_BY_CIUID;
    }

    @Timed
    public void delete(Integer ciUid) {
        this.logger().trace((Function0 & Serializable)() -> "deleting user token with ciUid[" + ciUid + "]");
        this.sqlExec(this.STMT_DELETE_USER_TOKEN_BY_CIUID(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.USER_TOKENS$.MODULE$.CI_UID()), (Object)ciUid)})), x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.execute()));
    }

    private String STMT_DELETE_USER_TOKEN_BY_USERNAME() {
        return this.STMT_DELETE_USER_TOKEN_BY_USERNAME;
    }

    @Timed
    public void delete(String username) {
        this.logger().trace((Function0 & Serializable)() -> "deleting all user tokens with username[" + username + "]");
        this.sqlExec(this.STMT_DELETE_USER_TOKEN_BY_USERNAME(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.USER_TOKENS$.MODULE$.USERNAME()), (Object)username.toLowerCase())})), x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.execute()));
    }

    private String QUERY_USER_TOKEN_BY_CIUID() {
        return this.QUERY_USER_TOKEN_BY_CIUID;
    }

    @Timed
    @IsReadOnly
    public Option<UserToken> findByCiUid(Integer ciUid) {
        this.logger().trace((Function0 & Serializable)() -> "finding user token with ciUid[" + ciUid + "]");
        return this.findOptional((Function1 & Serializable)x$6 -> (UserToken)x$6.queryForObject(this.QUERY_USER_TOKEN_BY_CIUID(), this.userTokenMapper(), new Object[]{ciUid}), this.jdbcTemplate());
    }

    private String QUERY_USER_TOKEN_BY_USER_AND_NOTE() {
        return this.QUERY_USER_TOKEN_BY_USER_AND_NOTE;
    }

    @Timed
    @IsReadOnly
    public Option<UserToken> findByUserAndNote(String username, String tokenNote) {
        this.logger().trace((Function0 & Serializable)() -> "finding user token with username[" + username + "] and tokenNote[" + tokenNote + "]");
        return this.findOptional((Function1 & Serializable)x$7 -> (UserToken)x$7.queryForObject(this.QUERY_USER_TOKEN_BY_USER_AND_NOTE(), this.userTokenMapper(), new Object[]{username.toLowerCase(), tokenNote}), this.jdbcTemplate());
    }

    private String QUERY_USER_TOKEN_BY_TOKEN_HASH() {
        return this.QUERY_USER_TOKEN_BY_TOKEN_HASH;
    }

    @Timed
    @IsReadOnly
    public Option<UserToken> findByUserToken(String tokenHash) {
        return this.findOptional((Function1 & Serializable)x$8 -> (UserToken)x$8.queryForObject(this.QUERY_USER_TOKEN_BY_TOKEN_HASH(), this.userTokenMapper(), new Object[]{tokenHash}), this.jdbcTemplate());
    }

    @Timed
    @IsReadOnly
    public Page<UserToken> query(UserTokenRepository.QueryOperation operation, Pageable pageable) {
        return UserTokenQueryBuilder$.MODULE$.apply(this.dialect(), this.namedTemplate(), this.sqlRepositoryAdapter()).from(operation).withPageable(pageable).build().execute();
    }

    @Timed
    @IsReadOnly
    public Page<UserToken> findByPermission(String permission, Pageable pageable) {
        String query = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                    |" + UserTokenQueryBuilder$.MODULE$.STMT_USER_TOKEN_SELECT() + "\n                    |WHERE " + Schema.USER_TOKENS$.MODULE$.TOKEN_PERMISSIONS() + " LIKE '%" + permission + "%'\n                    |"));
        List results = this.namedTemplate().query(query, this.userTokenMapper());
        int pageStart = pageable.getPageNumber() * pageable.getPageSize();
        int pageEnd = package$.MODULE$.min(pageStart + pageable.getPageSize(), results.size());
        List pageContent = pageStart < results.size() ? results.subList(pageStart, pageEnd) : Collections.emptyList();
        return new PageImpl(pageContent, pageable, (long)results.size());
    }

    public SqlUserTokenRepository(SqlBuilder.Dialect dialect, JdbcTemplate jdbcTemplate, SqlRepositoryAdapter sqlRepositoryAdapter) {
        this.dialect = dialect;
        this.jdbcTemplate = jdbcTemplate;
        this.sqlRepositoryAdapter = sqlRepositoryAdapter;
        Utils.$init$(this);
        CompressionSupport.$init$(this);
        PersistenceSupport.$init$(this);
        UserTokenMapper.$init$(this);
        Logging.$init$((Logging)this);
        this.STMT_INSERT_USER_TOKEN = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("INSERT INTO " + Schema.USER_TOKENS$.MODULE$.TABLE() + " (\n       |  " + Schema.USER_TOKENS$.MODULE$.USERNAME() + ",\n       |  " + Schema.USER_TOKENS$.MODULE$.TOKEN_NOTE() + ",\n       |  " + Schema.USER_TOKENS$.MODULE$.TOKEN_HASH() + ",\n       |  " + Schema.USER_TOKENS$.MODULE$.CREATED_DATE() + ",\n       |  " + Schema.USER_TOKENS$.MODULE$.EXPIRY_DATE() + ",\n       |  " + Schema.USER_TOKENS$.MODULE$.TOKEN_PERMISSIONS() + "\n       | ) VALUES (\n       |  :" + Schema.USER_TOKENS$.MODULE$.USERNAME() + ",\n       |  :" + Schema.USER_TOKENS$.MODULE$.TOKEN_NOTE() + ",\n       |  :" + Schema.USER_TOKENS$.MODULE$.TOKEN_HASH() + ",\n       |  :" + Schema.USER_TOKENS$.MODULE$.CREATED_DATE() + ",\n       |  :" + Schema.USER_TOKENS$.MODULE$.EXPIRY_DATE() + ",\n       |  :" + Schema.USER_TOKENS$.MODULE$.TOKEN_PERMISSIONS() + "\n       | )\n       |"));
        this.STMT_UPDATE_LAST_USED = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("UPDATE " + Schema.USER_TOKENS$.MODULE$.TABLE() + "\n       |  SET " + Schema.USER_TOKENS$.MODULE$.LAST_USED_DATE() + " = CASE\n       |    WHEN " + Schema.USER_TOKENS$.MODULE$.LAST_USED_DATE() + " < :lastUsed OR " + Schema.USER_TOKENS$.MODULE$.LAST_USED_DATE() + " IS NULL THEN :lastUsed\n       |    ELSE " + Schema.USER_TOKENS$.MODULE$.LAST_USED_DATE() + "\n       |  END\n       |  WHERE " + Schema.USER_TOKENS$.MODULE$.CI_UID() + " = :ciUid\n       |"));
        this.STMT_UPDATE_TOKEN_PERMISSIONS = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("UPDATE " + Schema.USER_TOKENS$.MODULE$.TABLE() + "\n       |  SET " + Schema.USER_TOKENS$.MODULE$.TOKEN_PERMISSIONS() + " = :" + Schema.USER_TOKENS$.MODULE$.TOKEN_PERMISSIONS() + "\n       |  WHERE " + Schema.USER_TOKENS$.MODULE$.CI_UID() + " = :" + Schema.USER_TOKENS$.MODULE$.CI_UID() + "\n       |"));
        this.STMT_UPDATE_TOKEN_EXPIRE_NOTIFIED = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("UPDATE " + Schema.USER_TOKENS$.MODULE$.TABLE() + "\n       |  SET " + Schema.USER_TOKENS$.MODULE$.IS_TOKEN_EXPIRE_NOTIFIED() + " = 1\n       |  WHERE " + Schema.USER_TOKENS$.MODULE$.CI_UID() + " = :ciUid\n       |"));
        this.STMT_DELETE_USER_TOKEN_BY_CIUID = "DELETE FROM " + Schema.USER_TOKENS$.MODULE$.TABLE() + " WHERE " + Schema.USER_TOKENS$.MODULE$.CI_UID() + " = :" + Schema.USER_TOKENS$.MODULE$.CI_UID();
        this.STMT_DELETE_USER_TOKEN_BY_USERNAME = "DELETE FROM " + Schema.USER_TOKENS$.MODULE$.TABLE() + " WHERE " + Schema.USER_TOKENS$.MODULE$.USERNAME() + " = :" + Schema.USER_TOKENS$.MODULE$.USERNAME();
        this.QUERY_USER_TOKEN_BY_CIUID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |" + UserTokenQueryBuilder$.MODULE$.STMT_USER_TOKEN_SELECT() + "\n       |  WHERE " + Schema.USER_TOKENS$.MODULE$.CI_UID() + " = ?\n       |"));
        this.QUERY_USER_TOKEN_BY_USER_AND_NOTE = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |" + UserTokenQueryBuilder$.MODULE$.STMT_USER_TOKEN_SELECT() + "\n       |  WHERE " + Schema.USER_TOKENS$.MODULE$.USERNAME() + " = ?\n       |  AND " + Schema.USER_TOKENS$.MODULE$.TOKEN_NOTE() + " = ?\n       |"));
        this.QUERY_USER_TOKEN_BY_TOKEN_HASH = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |" + UserTokenQueryBuilder$.MODULE$.STMT_USER_TOKEN_SELECT() + "\n       |  WHERE " + Schema.USER_TOKENS$.MODULE$.TOKEN_HASH() + " = ?\n       |"));
    }
}

