/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.repository.CiId$;
import com.xebialabs.xlrelease.repository.DependenciesSqlRepository$;
import com.xebialabs.xlrelease.repository.FolderId$;
import com.xebialabs.xlrelease.repository.FolderSchema$FOLDERS$;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseStoreException;
import com.xebialabs.xlrelease.repository.ReleasesSqlBuilder$;
import com.xebialabs.xlrelease.repository.ReleasesSqlRepository$;
import com.xebialabs.xlrelease.repository.data.DependencyData;
import com.xebialabs.xlrelease.repository.sql.Utils$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.util.Map;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Profile;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Profile(value={"sql"})
@Repository
@Transactional(value="xlrRepositoryTransactionManager", propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, rollbackFor={Throwable.class}, noRollbackFor={NotFoundException.class})
@ScalaSignature(bytes="\u0006\u0001\t5x!B\u0001\u0003\u0011\u0003Y\u0011!\u0007#fa\u0016tG-\u001a8dS\u0016\u001c8+\u001d7SKB|7/\u001b;pefT!a\u0001\u0003\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002\u0006\r\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u000f!\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003%\t1aY8n\u0007\u0001\u0001\"\u0001D\u0007\u000e\u0003\t1QA\u0004\u0002\t\u0002=\u0011\u0011\u0004R3qK:$WM\\2jKN\u001c\u0016\u000f\u001c*fa>\u001c\u0018\u000e^8ssN\u0011Q\u0002\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000b]iA\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005Y\u0001b\u0002\u000e\u000e\u0005\u0004%\taG\u0001\u0018\t\u0016\u0003VI\u0014#F\u001d\u000eKUiU0U\u0003\ncUi\u0018(B\u001b\u0016+\u0012\u0001\b\t\u0003;\tj\u0011A\b\u0006\u0003?\u0001\nA\u0001\\1oO*\t\u0011%\u0001\u0003kCZ\f\u0017BA\u0012\u001f\u0005\u0019\u0019FO]5oO\"1Q%\u0004Q\u0001\nq\t\u0001\u0004R#Q\u000b:#UIT\"J\u000bN{F+\u0011\"M\u000b~s\u0015)T#!\u0011\u001d9SB1A\u0005\u0002m\ta\u0003R#Q\u000b:#UIT\"J\u000bN{\u0016\nR0D\u001f2+VJ\u0014\u0005\u0007S5\u0001\u000b\u0011\u0002\u000f\u0002/\u0011+\u0005+\u0012(E\u000b:\u001b\u0015*R*`\u0013\u0012{6i\u0014'V\u001b:\u0003\u0003bB\u0016\u000e\u0005\u0004%\taG\u0001%\t\u0016\u0003VI\u0014#F\u001d\u000eKUiU0H\u0003R+uLU#M\u000b\u0006\u001bViX+J\t~\u001bu\nT+N\u001d\"1Q&\u0004Q\u0001\nq\tQ\u0005R#Q\u000b:#UIT\"J\u000bN{v)\u0011+F?J+E*R!T\u000b~+\u0016\nR0D\u001f2+VJ\u0014\u0011\t\u000f=j!\u0019!C\u00017\u0005yB)\u0012)F\u001d\u0012+ejQ%F'~;\u0015\tV#`'R\u000bE+V*`\u0007>cU+\u0014(\t\rEj\u0001\u0015!\u0003\u001d\u0003\u0001\"U\tU#O\t\u0016s5)S#T?\u001e\u000bE+R0T)\u0006#VkU0D\u001f2+VJ\u0014\u0011\t\u000fMj!\u0019!C\u00017\u0005iB)\u0012)F\u001d\u0012+ejQ%F'~#\u0016IU$F)~KEiX\"P\u0019Vke\n\u0003\u00046\u001b\u0001\u0006I\u0001H\u0001\u001f\t\u0016\u0003VI\u0014#F\u001d\u000eKUiU0U\u0003J;U\tV0J\t~\u001bu\nT+N\u001d\u0002BqaN\u0007C\u0002\u0013\u00051$\u0001\u0012E\u000bB+e\nR#O\u0007&+5k\u0018+B%\u001e+EkX%T?\u0012{e*R0D\u001f2+VJ\u0014\u0005\u0007s5\u0001\u000b\u0011\u0002\u000f\u0002G\u0011+\u0005+\u0012(E\u000b:\u001b\u0015*R*`)\u0006\u0013v)\u0012+`\u0013N{Fi\u0014(F?\u000e{E*V'OA!91(\u0004b\u0001\n\u0003Y\u0012A\n#F!\u0016sE)\u0012(D\u0013\u0016\u001bv\fV!S\u000f\u0016#vLU#M\u000b\u0006\u001bViX+J\t~\u001bu\nT+N\u001d\"1Q(\u0004Q\u0001\nq\tq\u0005R#Q\u000b:#UIT\"J\u000bN{F+\u0011*H\u000bR{&+\u0012'F\u0003N+u,V%E?\u000e{E*V'OA!9q(\u0004b\u0001\n\u0003Y\u0012!\n#F!\u0016sE)\u0012(D\u0013\u0016\u001bv\fV!S\u000f\u0016#vLU#M\u000b\u0006\u001bViX%E?\u000e{E*V'O\u0011\u0019\tU\u0002)A\u00059\u00051C)\u0012)F\u001d\u0012+ejQ%F'~#\u0016IU$F)~\u0013V\tT#B'\u0016{\u0016\nR0D\u001f2+VJ\u0014\u0011\u0007\t9\u0011\u0001aQ\n\u0004\u0005B!\u0005CA#K\u001b\u00051%BA$I\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005I\u0015\u0001C4sSjTH.\u001a3\n\u0005-3%a\u0002'pO\u001eLgn\u001a\u0005\t\u001b\n\u0013)\u0019!C\u0001\u001d\u0006a!\u000e\u001a2d)\u0016l\u0007\u000f\\1uKV\tq\n\u0005\u0002Q36\t\u0011K\u0003\u0002S'\u0006!1m\u001c:f\u0015\t!V+\u0001\u0003kI\n\u001c'B\u0001,X\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001-\u0002\u0007=\u0014x-\u0003\u0002[#\na!\n\u001a2d)\u0016l\u0007\u000f\\1uK\"AAL\u0011B\u0001B\u0003%q*A\u0007kI\n\u001cG+Z7qY\u0006$X\r\t\u0005\t=\n\u0013)\u0019!C\u0002?\u0006Q1/\u001d7ES\u0006dWm\u0019;\u0016\u0003\u0001\u0004\"!Y;\u000f\u0005\t\u0014hBA2p\u001d\t!WN\u0004\u0002fY:\u0011am\u001b\b\u0003O*l\u0011\u0001\u001b\u0006\u0003S*\ta\u0001\u0010:p_Rt\u0014\"A\u0005\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\tqG!\u0001\u0002eE&\u0011\u0001/]\u0001\u0004gFd'B\u00018\u0005\u0013\t\u0019H/\u0001\u0006Tc2\u0014U/\u001b7eKJT!\u0001]9\n\u0005Y<(a\u0002#jC2,7\r\u001e\u0006\u0003gRD\u0001\"\u001f\"\u0003\u0002\u0003\u0006I\u0001Y\u0001\fgFdG)[1mK\u000e$\b\u0005C\u0003\u0018\u0005\u0012\u00051\u0010\u0006\u0003}{\u0006e\u0001C\u0001\u0007C\u0011\u0015i%\u00101\u0001PQ\u0019ix0a\u0005\u0002\u0016A!\u0011\u0011AA\b\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011AC1o]>$\u0018\r^5p]*!\u0011\u0011BA\u0006\u0003\u001d1\u0017m\u0019;pefT1!!\u0004V\u0003\u0015\u0011W-\u00198t\u0013\u0011\t\t\"a\u0001\u0003\u0013E+\u0018\r\\5gS\u0016\u0014\u0018!\u0002<bYV,\u0017EAA\f\u0003eAHN\u001d*fa>\u001c\u0018\u000e^8ss*#'m\u0019+f[Bd\u0017\r^3\t\u000byS\b9\u00011)\u000f\u0005eq0a\u0005\u0002\u001e\u0005\u0012\u0011qD\u0001\u0018q2\u0014(+\u001a9pg&$xN]=Tc2$\u0015.\u00197fGRD3A_A\u0012!\u0011\t\t!!\n\n\t\u0005\u001d\u00121\u0001\u0002\n\u0003V$xn^5sK\u0012D\u0011\"a\u000bC\u0005\u0004%I!!\f\u0002\u001b9\fW.\u001a3UK6\u0004H.\u0019;f+\t\ty\u0003\u0005\u0003\u00022\u0005]RBAA\u001a\u0015\r\t)$U\u0001\u000b]\u0006lW\r\u001a9be\u0006l\u0017\u0002BA\u001d\u0003g\u0011!DT1nK\u0012\u0004\u0016M]1nKR,'O\u00133cGR+W\u000e\u001d7bi\u0016D\u0001\"!\u0010CA\u0003%\u0011qF\u0001\u000f]\u0006lW\r\u001a+f[Bd\u0017\r^3!\u0011\u001d\t\tE\u0011C\u0005\u0003\u0007\nqA^1sCJ<7/\u0006\u0003\u0002F\u0005mD\u0003BA$\u0003C\u0002r!EA%\u0003\u001b\nY&C\u0002\u0002LI\u0011a\u0001V;qY\u0016\u0014\u0004\u0003BA(\u0003/rA!!\u0015\u0002TA\u0011qME\u0005\u0004\u0003+\u0012\u0012A\u0002)sK\u0012,g-C\u0002$\u00033R1!!\u0016\u0013!\u0011\t\u0012Q\f\t\n\u0007\u0005}#CA\u0003BeJ\f\u0017\u0010\u0003\u0005\u0002d\u0005}\u0002\u0019AA3\u0003\u0011\t'oZ:\u0011\r\u0005\u001d\u0014\u0011OA<\u001d\u0011\tI'!\u001c\u000f\u0007\u001d\fY'C\u0001\u0014\u0013\r\tyGE\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019(!\u001e\u0003\u0011%#XM]1cY\u0016T1!a\u001c\u0013!\u0011\tI(a\u001f\r\u0001\u0011A\u0011QPA \u0005\u0004\tyHA\u0001U#\u0011\t\t)a\"\u0011\u0007E\t\u0019)C\u0002\u0002\u0006J\u0011qAT8uQ&tw\rE\u0002\u0012\u0003\u0013K1!a#\u0013\u0005\r\te.\u001f\u0005\b\u0003\u001f\u0013E\u0011BAI\u000311\u0017\u000e\u001c;feN#\u0018\r^;t)\u0011\t9%a%\t\u0011\u0005U\u0015Q\u0012a\u0001\u0003/\u000baa\u001d;biV\u001c\b#B\t\u0002\u001a\u0006u\u0015bAAN%\t1q\n\u001d;j_:\u0004b!a\u0014\u0002 \u00065\u0013\u0002BAQ\u00033\u00121aU3u\u0011%\t)K\u0011b\u0001\n\u0013\t9+A\u0007eK\u001a\fW\u000f\u001c;NCB\u0004XM]\u000b\u0003\u0003S\u0003R\u0001UAV\u0003_K1!!,R\u0005%\u0011vn^'baB,'\u000f\u0005\u0003\u00022\u0006]VBAAZ\u0015\r\t)LA\u0001\u0005I\u0006$\u0018-\u0003\u0003\u0002:\u0006M&A\u0004#fa\u0016tG-\u001a8ds\u0012\u000bG/\u0019\u0005\t\u0003{\u0013\u0005\u0015!\u0003\u0002*\u0006qA-\u001a4bk2$X*\u00199qKJ\u0004\u0003\"CAa\u0005\n\u0007I\u0011BAb\u0003q\u0019F+\u0014+`\r&sEi\u0018\"Z?\u001e\u000bE+R0S\u000b2+\u0015iU#`\u0013\u0012+\"!!\u0014\t\u0011\u0005\u001d'\t)A\u0005\u0003\u001b\nQd\u0015+N)~3\u0015J\u0014#`\u0005f{v)\u0011+F?J+E*R!T\u000b~KE\t\t\u0005\b\u0003\u0017\u0014E\u0011AAg\u0003M1\u0017N\u001c3Cs\u001e\u000bG/\u001a*fY\u0016\f7/Z%e)\u0011\ty-!6\u0011\r\u0005\u001d\u0014\u0011[AX\u0013\u0011\t\u0019.!\u001e\u0003\u0007M+\u0017\u000f\u0003\u0005\u0002X\u0006%\u0007\u0019AAm\u0003%\u0011X\r\\3bg\u0016LE\r\u0005\u0003\u0002\\\u0006\u0015h\u0002BAo\u0003Ct1\u0001ZAp\u0013\t\u0019A!C\u0002\u0002d\n\tAaQ5JI&!\u0011q]Au\u0005\u0011\u0019\u0015.\u00133\u000b\u0007\u0005\r(\u0001C\u0004\u0002n\n#\t!a<\u0002-\u0019Lg\u000e\u001a\"z!\u0006\u0014H/[1m)\u0006\u0014x-\u001a;JIN$b!a4\u0002r\u0006]\b\u0002CAz\u0003W\u0004\r!!>\u0002\u0013A\f'/\u001a8u\u0013\u0012\u001c\bCBA(\u0003?\u000bI\u000e\u0003\u0005\u0002\u0016\u0006-\b\u0019AAL\u0011%\tYP\u0011b\u0001\n\u0013\t\u0019-A\bT)6#vLR%O\t~\u0013\u0015lX%E\u0011!\tyP\u0011Q\u0001\n\u00055\u0013\u0001E*U\u001bR{f)\u0013(E?\nKv,\u0013#!\u0011\u001d\u0011\u0019A\u0011C\u0001\u0005\u000b\t\u0001BZ5oI\nK\u0018\n\u001a\u000b\u0005\u0003_\u00139\u0001\u0003\u0005\u0003\n\t\u0005\u0001\u0019AAm\u00031!W\r]3oI\u0016t7-_%e\u0011\u001d\u0011iA\u0011C\u0001\u0005\u001f\tqBZ5oI\nKH+\u0019:hKRLEm\u001d\u000b\u0007\u0003\u001f\u0014\tB!\u0006\t\u0011\tM!1\u0002a\u0001\u0003k\f\u0011\u0002^1sO\u0016$\u0018\nZ:\t\u0011\u0005U%1\u0002a\u0001\u0003/C\u0011B!\u0007C\u0005\u0004%I!a1\u0002-M#V\nV0J\u001dN+%\u000bV0E\u000bB+e\nR#O\u0007fC\u0001B!\bCA\u0003%\u0011QJ\u0001\u0018'RkEkX%O'\u0016\u0013Fk\u0018#F!\u0016sE)\u0012(D3\u0002BqA!\tC\t\u0003\u0011\u0019#\u0001\tj]N,'\u000f\u001e#fa\u0016tG-\u001a8dsR!!Q\u0005B\u001f)\u0011\u00119C!\f\u0011\u0007E\u0011I#C\u0002\u0003,I\u0011A!\u00168ji\"A!q\u0006B\u0010\u0001\u0004\u0011\t$\u0001\u0006eKB,g\u000eZ3oGf\u0004BAa\r\u0003:5\u0011!Q\u0007\u0006\u0004\u0005o!\u0011A\u00023p[\u0006Lg.\u0003\u0003\u0003<\tU\"A\u0003#fa\u0016tG-\u001a8ds\"A!q\bB\u0010\u0001\u0004\u0011\t%A\u0004sK2,\u0017m]3\u0011\t\tM\"1I\u0005\u0005\u0005\u000b\u0012)DA\u0004SK2,\u0017m]3\t\u0013\t%#I1A\u0005\n\u0005\r\u0017aC*U\u001bR{F)\u0012'F)\u0016C\u0001B!\u0014CA\u0003%\u0011QJ\u0001\r'RkEk\u0018#F\u0019\u0016#V\t\t\u0005\b\u0005#\u0012E\u0011\u0001B*\u0003A!W\r\\3uK\u0012+\u0007/\u001a8eK:\u001c\u0017\u0010\u0006\u0003\u0003(\tU\u0003\u0002\u0003B,\u0005\u001f\u0002\r!!\u0014\u0002\u0005%$\u0007b\u0002B)\u0005\u0012\u0005!1\f\u000b\u0005\u0005O\u0011i\u0006\u0003\u0005\u00030\te\u0003\u0019\u0001B\u0019\u0011%\u0011\tG\u0011b\u0001\n\u0013\t\u0019-A\u0006T)6#v,\u0016)E\u0003R+\u0005\u0002\u0003B3\u0005\u0002\u0006I!!\u0014\u0002\u0019M#V\nV0V!\u0012\u000bE+\u0012\u0011\t\u000f\t%$\t\"\u0001\u0003l\u0005\u0001R\u000f\u001d3bi\u0016$U\r]3oI\u0016t7-\u001f\u000b\u0005\u0005[\u0012\t\b\u0006\u0003\u0003(\t=\u0004\u0002\u0003B\u0018\u0005O\u0002\rA!\r\t\u0011\t}\"q\ra\u0001\u0005\u0003BqA!\u001eC\t\u0013\u00119(\u0001\u0006hKR$\u0016M]4fiN$BA!\u001f\u0003|A9\u0011#!\u0013\u0002N\u00055\u0003\u0002\u0003B\u0018\u0005g\u0002\rA!\r)/\t\u0013y(a\u0005\u0003\u000e\nE%1\u0013BO\u0005?\u0013IKa+\u00036\n]\u0006\u0003\u0002BA\u0005\u0013k!Aa!\u000b\t\u0005\u0015!Q\u0011\u0006\u0004\u0005\u000f+\u0016a\u0003;sC:\u001c\u0018m\u0019;j_:LAAa#\u0003\u0004\niAK]1og\u0006\u001cG/[8oC2\f#Aa$\u0002?ad'OU3q_NLGo\u001c:z)J\fgn]1di&|g.T1oC\u001e,'/A\u0006qe>\u0004\u0018mZ1uS>tGE\u0001BK\u0013\u0011\u00119J!'\u0002\u0011I+\u0015+V%S\u000b\u0012SAAa'\u0003\u0004\u0006Y\u0001K]8qC\u001e\fG/[8o\u0003%I7o\u001c7bi&|g\u000e\n\u0002\u0003\"&!!1\u0015BS\u00039\u0011V)\u0011#`\u0007>kU*\u0013+U\u000b\u0012SAAa*\u0003\u0004\u0006I\u0011j]8mCRLwN\\\u0001\fe>dGNY1dW\u001a{'\u000f\f\u0002\u0003.\u000e\u0012!q\u0016\t\u0005\u0003O\u0012\t,\u0003\u0003\u00034\u0006U$!\u0003+ie><\u0018M\u00197f\u00035qwNU8mY\n\f7m\u001b$pe2\u0012!\u0011X\u0012\u0003\u0005w\u0003BA!0\u0003H6\u0011!q\u0018\u0006\u0005\u0005\u0003\u0014\u0019-A\u0005fq\u000e,\u0007\u000f^5p]*\u0019!Q\u0019\u0004\u0002\u0011\u0011,\u0007\u000f\\8zSRLAA!3\u0003@\n\tbj\u001c;G_VtG-\u0012=dKB$\u0018n\u001c8)\u0007\t\u0013i\r\u0005\u0003\u0003P\nUWB\u0001Bi\u0015\r\u0011\u0019.V\u0001\u000bgR,'/Z8usB,\u0017\u0002\u0002Bl\u0005#\u0014!BU3q_NLGo\u001c:zQ\u001d\u0011%1\\A\n\u0005S\u0004BA!8\u0003f6\u0011!q\u001c\u0006\u0005\u0003\u000b\u0011\tOC\u0002\u0003dV\u000bqaY8oi\u0016DH/\u0003\u0003\u0003h\n}'a\u0002)s_\u001aLG.\u001a\u0017\u0003\u0005W\f\u0013\u0001\u001d")
public class DependenciesSqlRepository
implements Logging {
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect sqlDialect;
    private final NamedParameterJdbcTemplate namedTemplate;
    private final RowMapper<DependencyData> defaultMapper;
    private final String STMT_FIND_BY_GATE_RELEASE_ID;
    private final String STMT_FIND_BY_ID;
    private final String STMT_INSERT_DEPENDENCY;
    private final String STMT_DELETE;
    private final String STMT_UPDATE;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public static String DEPENDENCIES_TARGET_RELEASE_ID_COLUMN() {
        return DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_RELEASE_ID_COLUMN();
    }

    public static String DEPENDENCIES_TARGET_RELEASE_UID_COLUMN() {
        return DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_RELEASE_UID_COLUMN();
    }

    public static String DEPENDENCIES_TARGET_IS_DONE_COLUMN() {
        return DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_IS_DONE_COLUMN();
    }

    public static String DEPENDENCIES_TARGET_ID_COLUMN() {
        return DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_ID_COLUMN();
    }

    public static String DEPENDENCIES_GATE_STATUS_COLUMN() {
        return DependenciesSqlRepository$.MODULE$.DEPENDENCIES_GATE_STATUS_COLUMN();
    }

    public static String DEPENDENCIES_GATE_RELEASE_UID_COLUMN() {
        return DependenciesSqlRepository$.MODULE$.DEPENDENCIES_GATE_RELEASE_UID_COLUMN();
    }

    public static String DEPENDENCIES_ID_COLUMN() {
        return DependenciesSqlRepository$.MODULE$.DEPENDENCIES_ID_COLUMN();
    }

    public static String DEPENDENCIES_TABLE_NAME() {
        return DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TABLE_NAME();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DependenciesSqlRepository dependenciesSqlRepository = this;
        synchronized (dependenciesSqlRepository) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    private NamedParameterJdbcTemplate namedTemplate() {
        return this.namedTemplate;
    }

    private <T> Tuple2<String, Object[]> varargs(Iterable<T> args) {
        Seq seq = args.toSeq();
        Tuple2 tuple2 = new Tuple2((Object)((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)x$1 -> "?", Seq$.MODULE$.canBuildFrom())).mkString(", "), ((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.AnyRef()));
        return tuple2;
    }

    private Tuple2<String, Object[]> filterStatus(Option<Set<String>> status) {
        return (Tuple2)status.fold((Function0 & Serializable & scala.Serializable)() -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), Array$.MODULE$.empty(ClassTag$.MODULE$.AnyRef())), (Function1 & Serializable & scala.Serializable)statuses -> {
            Tuple2<String, Object[]> tuple2 = this.varargs((Iterable)statuses);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String placeholdersStatus = (String)tuple2._1();
            Object[] argsStatus = (Object[])tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AND d.", " IN (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DependenciesSqlRepository$.MODULE$.DEPENDENCIES_GATE_STATUS_COLUMN(), placeholdersStatus}))), (Object)argsStatus);
            return tuple22;
        });
    }

    private RowMapper<DependencyData> defaultMapper() {
        return this.defaultMapper;
    }

    private String STMT_FIND_BY_GATE_RELEASE_ID() {
        return this.STMT_FIND_BY_GATE_RELEASE_ID;
    }

    public Seq<DependencyData> findByGateReleaseId(String releaseId) {
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Find dependencies by gate releaseId: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})));
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().query(this.STMT_FIND_BY_GATE_RELEASE_ID(), this.defaultMapper(), new Object[]{Ids.getName((String)CiId$.MODULE$.RichCiId(releaseId).normalized())})).asScala();
    }

    public Seq<DependencyData> findByPartialTargetIds(Set<String> parentIds, Option<Set<String>> status) {
        Nil$ nil$;
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Find dependencies by targetIds starting with ", " with statuses ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parentIds, status})));
        if (parentIds.isEmpty()) {
            nil$ = Nil$.MODULE$;
        } else {
            String clause = ((TraversableOnce)parentIds.map((Function1 & Serializable & scala.Serializable)id -> {
                Tuple2 tuple2 = new Tuple2((Object)Ids.getReleaselessChildId((String)CiId$.MODULE$.RichCiId((String)id).normalized()), (Object)Ids.getName((String)Ids.releaseIdFrom((String)CiId$.MODULE$.RichCiId((String)id).normalized())));
                if (tuple2 != null) {
                    String string = (String)tuple2._1();
                    String releaseId = (String)tuple2._2();
                    if (string == null) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t.", " LIKE '", "%'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ReleasesSqlRepository$.MODULE$.RELEASES_RELEASE_ID_COLUMN(), releaseId}));
                    }
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                String targetId = (String)tuple2._1();
                String releaseId = (String)tuple2._2();
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d.", " LIKE '", "%' AND t.", " = '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_ID_COLUMN(), targetId, ReleasesSqlRepository$.MODULE$.RELEASES_RELEASE_ID_COLUMN(), releaseId}));
            }, Set$.MODULE$.canBuildFrom())).mkString("(", " OR ", ")");
            Tuple2<String, Object[]> tuple2 = this.filterStatus(status);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String statusQuery = (String)tuple2._1();
            Object[] args = (Object[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)statusQuery, (Object)args);
            Tuple2 tuple23 = tuple22;
            String statusQuery2 = (String)tuple23._1();
            Object[] args2 = (Object[])tuple23._2();
            nil$ = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().query(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT\n           | d.", ",\n           | ", ",\n           | d.", ",\n           | d.", ",\n           | d.", ",\n           | ", "\n           |  FROM ", " d\n           |  JOIN ", " r ON\n           |    r.", " = d.", "\n           |  JOIN ", " fr ON\n           |    fr.", " = r.", "\n           |  JOIN ", " t ON\n           |    t.", " = d.", "\n           |  JOIN ", " ft ON\n           |    ft.", " = t.", "\n           |  WHERE ", "\n           |  ", "\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DependenciesSqlRepository$.MODULE$.DEPENDENCIES_ID_COLUMN(), ReleasesSqlBuilder$.MODULE$.selectReleaseFullPathSql("r", "fr", ReleasesSqlRepository$.MODULE$.RELEASES_RELEASE_ID_COLUMN(), this.sqlDialect()), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_GATE_STATUS_COLUMN(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_ID_COLUMN(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_IS_DONE_COLUMN(), ReleasesSqlBuilder$.MODULE$.selectReleaseFullPathSql("t", "ft", DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_RELEASE_ID_COLUMN(), this.sqlDialect()), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TABLE_NAME(), ReleasesSqlRepository$.MODULE$.RELEASES_TABLE_NAME(), ReleasesSqlRepository$.MODULE$.RELEASES_CI_UID_COLUMN(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_GATE_RELEASE_UID_COLUMN(), FolderSchema$FOLDERS$.MODULE$.TABLE(), FolderSchema$FOLDERS$.MODULE$.ciUid(), ReleasesSqlRepository$.MODULE$.RELEASES_FOLDER_CI_UID_COLUMN(), ReleasesSqlRepository$.MODULE$.RELEASES_TABLE_NAME(), ReleasesSqlRepository$.MODULE$.RELEASES_CI_UID_COLUMN(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_RELEASE_UID_COLUMN(), FolderSchema$FOLDERS$.MODULE$.TABLE(), FolderSchema$FOLDERS$.MODULE$.ciUid(), ReleasesSqlRepository$.MODULE$.RELEASES_FOLDER_CI_UID_COLUMN(), clause, statusQuery2})))).stripMargin(), args2, this.defaultMapper())).asScala();
        }
        return nil$;
    }

    private String STMT_FIND_BY_ID() {
        return this.STMT_FIND_BY_ID;
    }

    public DependencyData findById(String dependencyId) {
        DependencyData d;
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Find dependency by id: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependencyId})));
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (DependencyData)this.jdbcTemplate().queryForObject(this.STMT_FIND_BY_ID(), this.defaultMapper(), new Object[]{Ids.getReleaselessChildId((String)CiId$.MODULE$.RichCiId(dependencyId).normalized()), Ids.getName((String)Ids.releaseIdFrom((String)CiId$.MODULE$.RichCiId(dependencyId).normalized()))}));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                bl = true;
                failure = (Failure)try_;
                Throwable e = failure.exception();
                if (e instanceof EmptyResultDataAccessException) {
                    EmptyResultDataAccessException emptyResultDataAccessException = (EmptyResultDataAccessException)e;
                    throw new NotFoundException((Throwable)emptyResultDataAccessException, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dependency with Id '", "' not found."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependencyId})), new Object[0]);
                }
            }
            if (bl) {
                Throwable t = failure.exception();
                throw t;
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        DependencyData dependencyData = d = (DependencyData)success.value();
        return dependencyData;
    }

    public Seq<DependencyData> findByTargetIds(Set<String> targetIds, Option<Set<String>> status) {
        Nil$ nil$;
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Find dependencies by targetIds: ", " with statuses ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetIds, status})));
        if (targetIds.isEmpty()) {
            nil$ = Nil$.MODULE$;
        } else {
            String clause = ((TraversableOnce)targetIds.map((Function1 & Serializable & scala.Serializable)id -> {
                Tuple2 tuple2 = new Tuple2((Object)Ids.getReleaselessChildId((String)CiId$.MODULE$.RichCiId((String)id).normalized()), (Object)Ids.getName((String)Ids.releaseIdFrom((String)CiId$.MODULE$.RichCiId((String)id).normalized())));
                if (tuple2 != null) {
                    String string = (String)tuple2._1();
                    String releaseId = (String)tuple2._2();
                    if (string == null) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d.", " is NULL AND t.", " = '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_ID_COLUMN(), ReleasesSqlRepository$.MODULE$.RELEASES_RELEASE_ID_COLUMN(), releaseId}));
                    }
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                String targetId = (String)tuple2._1();
                String releaseId = (String)tuple2._2();
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d.", " = '", "' AND t.", " = '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_ID_COLUMN(), targetId, ReleasesSqlRepository$.MODULE$.RELEASES_RELEASE_ID_COLUMN(), releaseId}));
            }, Set$.MODULE$.canBuildFrom())).mkString("(", " OR ", ")");
            Tuple2<String, Object[]> tuple2 = this.filterStatus(status);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String statusQuery = (String)tuple2._1();
            Object[] statusArgs = (Object[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)statusQuery, (Object)statusArgs);
            Tuple2 tuple23 = tuple22;
            String statusQuery2 = (String)tuple23._1();
            Object[] statusArgs2 = (Object[])tuple23._2();
            nil$ = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().query(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT\n           | d.", ",\n           | ", ",\n           | d.", ",\n           | d.", ",\n           | d.", ",\n           | ", "\n           |  FROM ", " d\n           |  JOIN ", " r ON\n           |    r.", " = d.", "\n           |  JOIN ", " fr ON\n           |    fr.", " = r.", "\n           |  JOIN ", " t ON\n           |    t.", " = d.", "\n           |  JOIN ", " ft ON\n           |    ft.", " = t.", "\n           |  WHERE ", "\n           |  ", "\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DependenciesSqlRepository$.MODULE$.DEPENDENCIES_ID_COLUMN(), ReleasesSqlBuilder$.MODULE$.selectReleaseFullPathSql("r", "fr", ReleasesSqlRepository$.MODULE$.RELEASES_RELEASE_ID_COLUMN(), this.sqlDialect()), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_GATE_STATUS_COLUMN(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_ID_COLUMN(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_IS_DONE_COLUMN(), ReleasesSqlBuilder$.MODULE$.selectReleaseFullPathSql("t", "ft", DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_RELEASE_ID_COLUMN(), this.sqlDialect()), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TABLE_NAME(), ReleasesSqlRepository$.MODULE$.RELEASES_TABLE_NAME(), ReleasesSqlRepository$.MODULE$.RELEASES_CI_UID_COLUMN(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_GATE_RELEASE_UID_COLUMN(), FolderSchema$FOLDERS$.MODULE$.TABLE(), FolderSchema$FOLDERS$.MODULE$.ciUid(), ReleasesSqlRepository$.MODULE$.RELEASES_FOLDER_CI_UID_COLUMN(), ReleasesSqlRepository$.MODULE$.RELEASES_TABLE_NAME(), ReleasesSqlRepository$.MODULE$.RELEASES_CI_UID_COLUMN(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_RELEASE_UID_COLUMN(), FolderSchema$FOLDERS$.MODULE$.TABLE(), FolderSchema$FOLDERS$.MODULE$.ciUid(), ReleasesSqlRepository$.MODULE$.RELEASES_FOLDER_CI_UID_COLUMN(), clause, statusQuery2})))).stripMargin(), statusArgs2, this.defaultMapper())).asScala();
        }
        return nil$;
    }

    private String STMT_INSERT_DEPENDENCY() {
        return this.STMT_INSERT_DEPENDENCY;
    }

    public void insertDependency(Release release, Dependency dependency) {
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Inserting dependency ", " of Gate ", " to Target ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependency.getId(), dependency.getGateTask().getId(), dependency.getTargetId()})));
        Tuple2<String, String> tuple2 = this.getTargets(dependency);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String targetId = (String)tuple2._1();
        String targetReleaseId = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)targetId, (Object)targetReleaseId);
        Tuple2 tuple23 = tuple22;
        String targetId2 = (String)tuple23._1();
        String targetReleaseId2 = (String)tuple23._2();
        this.namedTemplate().execute(this.STMT_INSERT_DEPENDENCY(), (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dependencyId"), (Object)Ids.getReleaselessChildId((String)CiId$.MODULE$.RichCiId(dependency.getId()).normalized())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"gateReleaseUid"), (Object)release.getCiUid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"gateStatus"), (Object)dependency.getGateTask().getStatus().name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetId"), (Object)targetId2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetReleaseId"), (Object)targetReleaseId2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetIsDone"), (Object)BoxesRunTime.boxToBoolean((boolean)dependency.isDone()))}))).asJava(), (PreparedStatementCallback)new PreparedStatementCallback<BoxedUnit>(null, dependency){
            private final Dependency dependency$1;

            public void doInPreparedStatement(PreparedStatement ps) {
                try {
                    ps.execute();
                }
                catch (Throwable e) {
                    throw new ReleaseStoreException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to insert dependency ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dependency$1.getId()})), e);
                }
            }
            {
                this.dependency$1 = dependency$1;
            }
        });
    }

    private String STMT_DELETE() {
        return this.STMT_DELETE;
    }

    public void deleteDependency(String id) {
        this.jdbcTemplate().update(this.STMT_DELETE(), new Object[]{Ids.getReleaselessChildId((String)CiId$.MODULE$.RichCiId(id).normalized()), Ids.getName((String)Ids.releaseIdFrom((String)CiId$.MODULE$.RichCiId(id).normalized()))});
    }

    public void deleteDependency(Dependency dependency) {
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting dependency ", " of Gate ", " to Target ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependency.getId(), dependency.getGateTask().getId(), dependency.getTargetId()})));
        this.deleteDependency(dependency.getId());
    }

    private String STMT_UPDATE() {
        return this.STMT_UPDATE;
    }

    public void updateDependency(Release release, Dependency dependency) {
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updating dependency ", " of Gate ", " to Target ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependency.getId(), dependency.getGateTask().getId(), dependency.getTargetId()})));
        Tuple2<String, String> tuple2 = this.getTargets(dependency);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String targetId = (String)tuple2._1();
        String targetReleaseId = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)targetId, (Object)targetReleaseId);
        Tuple2 tuple23 = tuple22;
        String targetId2 = (String)tuple23._1();
        String targetReleaseId2 = (String)tuple23._2();
        this.namedTemplate().execute(this.STMT_UPDATE(), (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"gateStatus"), (Object)dependency.getGateTask().getStatus().name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetId"), (Object)targetId2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetReleaseId"), (Object)targetReleaseId2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetIsDone"), (Object)BoxesRunTime.boxToBoolean((boolean)dependency.isDone())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dependencyId"), (Object)Ids.getReleaselessChildId((String)CiId$.MODULE$.RichCiId(dependency.getId()).normalized())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"gateReleaseUid"), (Object)release.getCiUid())}))).asJava(), ps -> {
            DependenciesSqlRepository.$anonfun$updateDependency$2(dependency, ps);
            return BoxedUnit.UNIT;
        });
    }

    private Tuple2<String, String> getTargets(Dependency dependency) {
        String targetId = CiId$.MODULE$.RichCiId(dependency.getTargetId()).normalized();
        return !dependency.hasVariableTarget() && !dependency.isArchived() ? (Ids.isReleaseId((String)targetId) ? new Tuple2(null, (Object)Ids.getName((String)targetId)) : (Tuple2)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)Ids.getReleaselessChildId((String)targetId), (Object)Ids.getName((String)Ids.releaseIdFrom((String)targetId)))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)targetId, null))) : new Tuple2((Object)targetId, null);
    }

    public static final /* synthetic */ void $anonfun$updateDependency$2(Dependency dependency$3, PreparedStatement ps) {
        int n;
        try {
            n = ps.executeUpdate();
        }
        catch (Throwable e) {
            throw new ReleaseStoreException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to update dependency ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependency$3.getId()})), e);
        }
        int updatedCount = n;
        if (updatedCount == 0) {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find dependency to update by ID ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependency$3.getId()})), new Object[0]);
        }
    }

    @Autowired
    public DependenciesSqlRepository(@Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="xlrRepositorySqlDialect") SqlBuilder.Dialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.sqlDialect = sqlDialect;
        Logging.$init$((Logging)this);
        this.namedTemplate = new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate);
        this.defaultMapper = (rs, x$3) -> new DependencyData(FolderId$.MODULE$.absolute$extension(FolderId$.MODULE$.apply(rs.getString(ReleasesSqlRepository$.MODULE$.RELEASES_RELEASE_ID_COLUMN()))), rs.getString(DependenciesSqlRepository$.MODULE$.DEPENDENCIES_ID_COLUMN()), rs.getString(DependenciesSqlRepository$.MODULE$.DEPENDENCIES_GATE_STATUS_COLUMN()), (Option<String>)Option$.MODULE$.apply((Object)rs.getString(DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_RELEASE_ID_COLUMN())).map((Function1 & Serializable & scala.Serializable)x$4 -> FolderId$.MODULE$.absolute$extension(FolderId$.MODULE$.apply((String)x$4))), rs.getString(DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_ID_COLUMN()));
        this.STMT_FIND_BY_GATE_RELEASE_ID = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT\n       | d.", ",\n       | ", ",\n       | d.", ",\n       | d.", ",\n       | d.", ",\n       | ", "\n       |  FROM ", " d\n       |  JOIN ", " r ON\n       |    d.", " = r.", "\n       |  JOIN ", " fr ON\n       |    fr.", " = r.", "\n       |  JOIN ", " t ON\n       |    t.", " = d.", "\n       |  JOIN ", " ft ON\n       |    ft.", " = t.", "\n       |  WHERE\n       |    r.", " = ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DependenciesSqlRepository$.MODULE$.DEPENDENCIES_ID_COLUMN(), ReleasesSqlBuilder$.MODULE$.selectReleaseFullPathSql("r", "fr", ReleasesSqlRepository$.MODULE$.RELEASES_RELEASE_ID_COLUMN(), sqlDialect), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_GATE_STATUS_COLUMN(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_ID_COLUMN(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_IS_DONE_COLUMN(), ReleasesSqlBuilder$.MODULE$.selectReleaseFullPathSql("t", "ft", DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_RELEASE_ID_COLUMN(), sqlDialect), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TABLE_NAME(), ReleasesSqlRepository$.MODULE$.RELEASES_TABLE_NAME(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_GATE_RELEASE_UID_COLUMN(), ReleasesSqlRepository$.MODULE$.RELEASES_CI_UID_COLUMN(), FolderSchema$FOLDERS$.MODULE$.TABLE(), FolderSchema$FOLDERS$.MODULE$.ciUid(), ReleasesSqlRepository$.MODULE$.RELEASES_FOLDER_CI_UID_COLUMN(), ReleasesSqlRepository$.MODULE$.RELEASES_TABLE_NAME(), ReleasesSqlRepository$.MODULE$.RELEASES_CI_UID_COLUMN(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_RELEASE_UID_COLUMN(), FolderSchema$FOLDERS$.MODULE$.TABLE(), FolderSchema$FOLDERS$.MODULE$.ciUid(), ReleasesSqlRepository$.MODULE$.RELEASES_FOLDER_CI_UID_COLUMN(), ReleasesSqlRepository$.MODULE$.RELEASES_RELEASE_ID_COLUMN()})))).stripMargin();
        this.STMT_FIND_BY_ID = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT\n       | d.", ",\n       | ", ",\n       | d.", ",\n       | d.", ",\n       | d.", ",\n       | ", "\n       |  FROM ", " d\n       |  JOIN ", " r ON\n       |    r.", " = d.", "\n       |  JOIN ", " fr ON\n       |    fr.", " = r.", "\n       |  JOIN ", " t ON\n       |    t.", " = d.", "\n       |  JOIN ", " ft ON\n       |    ft.", " = t.", "\n       |  WHERE\n       |    d.", " = ? AND\n       |    r.", " = ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DependenciesSqlRepository$.MODULE$.DEPENDENCIES_ID_COLUMN(), ReleasesSqlBuilder$.MODULE$.selectReleaseFullPathSql("r", "fr", ReleasesSqlRepository$.MODULE$.RELEASES_RELEASE_ID_COLUMN(), sqlDialect), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_GATE_STATUS_COLUMN(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_ID_COLUMN(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_IS_DONE_COLUMN(), ReleasesSqlBuilder$.MODULE$.selectReleaseFullPathSql("t", "ft", DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_RELEASE_ID_COLUMN(), sqlDialect), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TABLE_NAME(), ReleasesSqlRepository$.MODULE$.RELEASES_TABLE_NAME(), ReleasesSqlRepository$.MODULE$.RELEASES_CI_UID_COLUMN(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_GATE_RELEASE_UID_COLUMN(), FolderSchema$FOLDERS$.MODULE$.TABLE(), FolderSchema$FOLDERS$.MODULE$.ciUid(), ReleasesSqlRepository$.MODULE$.RELEASES_FOLDER_CI_UID_COLUMN(), ReleasesSqlRepository$.MODULE$.RELEASES_TABLE_NAME(), ReleasesSqlRepository$.MODULE$.RELEASES_CI_UID_COLUMN(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_RELEASE_UID_COLUMN(), FolderSchema$FOLDERS$.MODULE$.TABLE(), FolderSchema$FOLDERS$.MODULE$.ciUid(), ReleasesSqlRepository$.MODULE$.RELEASES_FOLDER_CI_UID_COLUMN(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_ID_COLUMN(), ReleasesSqlRepository$.MODULE$.RELEASES_RELEASE_ID_COLUMN()})))).stripMargin();
        this.STMT_INSERT_DEPENDENCY = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", " (\n       | ", ",\n       | ", ",\n       | ", ",\n       | ", ",\n       | ", ",\n       | ", "\n       |) VALUES (\n       |  :dependencyId,\n       |  :gateReleaseUid,\n       |  :gateStatus,\n       |  :targetId,\n       |  (SELECT r.", " FROM ", " r WHERE r.", " = :targetReleaseId),\n       |  :targetIsDone\n       |)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TABLE_NAME(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_ID_COLUMN(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_GATE_RELEASE_UID_COLUMN(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_GATE_STATUS_COLUMN(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_ID_COLUMN(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_RELEASE_UID_COLUMN(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_IS_DONE_COLUMN(), ReleasesSqlRepository$.MODULE$.RELEASES_CI_UID_COLUMN(), ReleasesSqlRepository$.MODULE$.RELEASES_TABLE_NAME(), ReleasesSqlRepository$.MODULE$.RELEASES_RELEASE_ID_COLUMN()})))).stripMargin();
        this.STMT_DELETE = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM ", " WHERE\n       | ", " = ? AND\n       | ", " =\n       |   (SELECT ", " FROM ", " WHERE ", " = ?)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TABLE_NAME(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_ID_COLUMN(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_GATE_RELEASE_UID_COLUMN(), ReleasesSqlRepository$.MODULE$.RELEASES_CI_UID_COLUMN(), ReleasesSqlRepository$.MODULE$.RELEASES_TABLE_NAME(), ReleasesSqlRepository$.MODULE$.RELEASES_RELEASE_ID_COLUMN()})))).stripMargin();
        this.STMT_UPDATE = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UPDATE ", "\n     | SET\n     | ", " = :gateStatus,\n     | ", " = :targetId,\n     | ", " =\n     |   (SELECT r.", " FROM ", " r WHERE r.", " = :targetReleaseId),\n     | ", " = :targetIsDone\n     |  WHERE\n     |    ", " = :dependencyId AND\n     |    ", " = :gateReleaseUid"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TABLE_NAME(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_GATE_STATUS_COLUMN(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_ID_COLUMN(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_RELEASE_UID_COLUMN(), ReleasesSqlRepository$.MODULE$.RELEASES_CI_UID_COLUMN(), ReleasesSqlRepository$.MODULE$.RELEASES_TABLE_NAME(), ReleasesSqlRepository$.MODULE$.RELEASES_RELEASE_ID_COLUMN(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_TARGET_IS_DONE_COLUMN(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_ID_COLUMN(), DependenciesSqlRepository$.MODULE$.DEPENDENCIES_GATE_RELEASE_UID_COLUMN()})))).stripMargin();
    }
}

