/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlplatform.security.sql.SqlRoleService;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.XlrRepository;
import com.xebialabs.xlrelease.repository.sql.PlatformSecurityMappingSupport;
import com.xebialabs.xlrelease.repository.sql.TeamDecoratorSupport;
import com.xebialabs.xlrelease.repository.sql.package$;
import com.xebialabs.xlrelease.security.SecuredCi;
import com.xebialabs.xlrelease.service.CiIdService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=e\u0001B\u0001\u0003\u00015\u0011\u0001bU9m)\u0016\fWn\u001d\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!\u0001\u0006sKB|7/\u001b;pefT!a\u0002\u0005\u0002\u0013ad'/\u001a7fCN,'BA\u0005\u000b\u0003%AXMY5bY\u0006\u00147OC\u0001\f\u0003\r\u0019w.\\\u0002\u0001'\u0015\u0001aB\u0006\u000e\u001f!\tyA#D\u0001\u0011\u0015\t\t\"#\u0001\u0003mC:<'\"A\n\u0002\t)\fg/Y\u0005\u0003+A\u0011aa\u00142kK\u000e$\bCA\f\u0019\u001b\u0005!\u0011BA\r\u0005\u0005\u0015!V-Y7t!\tYB$D\u0001\u0003\u0013\ti\"A\u0001\u000bUK\u0006lG)Z2pe\u0006$xN]*vaB|'\u000f\u001e\t\u0003?\u0011j\u0011\u0001\t\u0006\u0003C\t\nQa\u001d7gi)T\u0011aI\u0001\tOJL'P\u001f7fI&\u0011Q\u0005\t\u0002\b\u0019><w-\u001b8h\u0011!9\u0003A!b\u0001\n\u0003A\u0013aC2j\u0013\u0012\u001cVM\u001d<jG\u0016,\u0012!\u000b\t\u0003U5j\u0011a\u000b\u0006\u0003Y\u0019\tqa]3sm&\u001cW-\u0003\u0002/W\tY1)[%e'\u0016\u0014h/[2f\u0011!\u0001\u0004A!A!\u0002\u0013I\u0013\u0001D2j\u0013\u0012\u001cVM\u001d<jG\u0016\u0004\u0003\u0002\u0003\u001a\u0001\u0005\u000b\u0007I\u0011A\u001a\u0002!A,'/\\5tg&|g.\u00123ji>\u0014X#\u0001\u001b\u0011\u0005URT\"\u0001\u001c\u000b\u0005]B\u0014\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005eB\u0011\u0001\u00033fa2|\u00170\u001b;\n\u0005m2$\u0001\u0005)fe6L7o]5p]\u0016#\u0017\u000e^8s\u0011!i\u0004A!A!\u0002\u0013!\u0014!\u00059fe6L7o]5p]\u0016#\u0017\u000e^8sA!Aq\b\u0001BC\u0002\u0013\u0005\u0001)A\u0006s_2,7+\u001a:wS\u000e,W#A!\u0011\u0005\t;U\"A\"\u000b\u0005\r!%BA\u001cF\u0015\t1\u0005\"\u0001\u0006yYBd\u0017\r\u001e4pe6L!\u0001S\"\u0003\u001dM\u000bHNU8mKN+'O^5dK\"A!\n\u0001B\u0001B\u0003%\u0011)\u0001\u0007s_2,7+\u001a:wS\u000e,\u0007\u0005\u0003\u0005M\u0001\t\u0015\r\u0011\"\u0001N\u0003)\u0019XmY;sK\u0012\u001c\u0015n]\u000b\u0002\u001dB\u0011qcT\u0005\u0003!\u0012\u0011!bU3dkJ,GmQ5t\u0011!\u0011\u0006A!A!\u0002\u0013q\u0015aC:fGV\u0014X\rZ\"jg\u0002B\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006I!V\u0001\u000eq2\u0014(+\u001a9pg&$xN]=\u0011\u0005]1\u0016BA,\u0005\u00055AFN\u001d*fa>\u001c\u0018\u000e^8ss\")\u0011\f\u0001C\u00015\u00061A(\u001b8jiz\"ba\u0017/^=~\u0003\u0007CA\u000e\u0001\u0011\u00159\u0003\f1\u0001*\u0011\u0015\u0011\u0004\f1\u00015\u0011\u0015y\u0004\f1\u0001B\u0011\u0015a\u0005\f1\u0001O\u0011\u0015!\u0006\f1\u0001V\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0003\u0019\u0019'/Z1uKR\u0019AM[=\u0011\u0005\u0015DW\"\u00014\u000b\u0005\u001d4\u0011A\u00023p[\u0006Lg.\u0003\u0002jM\n!A+Z1n\u0011\u0015Y\u0017\r1\u0001m\u0003-\u0019wN\u001c;bS:,'/\u00133\u0011\u000554hB\u00018u!\ty'/D\u0001q\u0015\t\tH\"\u0001\u0004=e>|GO\u0010\u0006\u0002g\u0006)1oY1mC&\u0011QO]\u0001\u0007!J,G-\u001a4\n\u0005]D(AB*ue&twM\u0003\u0002ve\")!0\u0019a\u0001I\u0006!A/Z1n\u0011\u0015a\b\u0001\"\u0011~\u0003\u0019)\b\u000fZ1uKR\u0011AM \u0005\u0006un\u0004\r\u0001\u001a\u0005\b\u0003\u0003\u0001A\u0011IA\u0002\u0003\u0019!W\r\\3uKR!\u0011QAA\u0007!\u0011\t9!!\u0003\u000e\u0003IL1!a\u0003s\u0005\u0011)f.\u001b;\t\r\u0005=q\u00101\u0001m\u0003\u0019!X-Y7JI\"9\u00111\u0003\u0001\u0005B\u0005U\u0011a\u00063fY\u0016$X\rV3b[N4%o\\7QY\u0006$hm\u001c:n)\u0011\t)!a\u0006\t\r-\f\t\u00021\u0001m\u0011\u001d\tY\u0002\u0001C!\u0003;\t1c]1wKR+\u0017-\\:U_Bc\u0017\r\u001e4pe6$B!a\b\u0002,A)\u0011\u0011EA\u0014I6\u0011\u00111\u0005\u0006\u0004\u0003K\u0011\u0012\u0001B;uS2LA!!\u000b\u0002$\t!A*[:u\u0011!\ti#!\u0007A\u0002\u0005=\u0012a\u0002:fY\u0016\f7/\u001a\t\u0004K\u0006E\u0012bAA\u001aM\n9!+\u001a7fCN,\u0007bBA\u000e\u0001\u0011\u0005\u0013q\u0007\u000b\u0007\u0003?\tI$a\u000f\t\r-\f)\u00041\u0001m\u0011!\ti$!\u000eA\u0002\u0005}\u0011!\u0002;fC6\u001c\bbBA\u000e\u0001\u0011%\u0011\u0011\t\u000b\u0007\u0003\u0007\n)&a\u0016\u0011\u000b\u0005\u0015\u0013q\n3\u000f\t\u0005\u001d\u00131\n\b\u0004_\u0006%\u0013\"A:\n\u0007\u00055#/A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u00131\u000b\u0002\u0004'\u0016\f(bAA'e\"11.a\u0010A\u00021D\u0001\"!\u0010\u0002@\u0001\u0007\u00111\t\u0005\b\u00037\u0002A\u0011AA/\u0003E)\b\u000fZ1uKB+'/\\5tg&|gn\u001d\u000b\u0007\u0003\u000b\ty&a\u0019\t\u000f\u0005\u0005\u0014\u0011\fa\u0001Y\u0006Y1/Z2ve&$\u00180V5e\u0011!\t)'!\u0017A\u0002\u0005\u001d\u0014\u0001\u0006:pY\u0016\u001cx+\u001b;i!\u0016\u0014X.[:tS>t7\u000f\u0005\u0004\u0002\b\u0005%\u0014QN\u0005\u0004\u0003W\u0012(A\u0003\u001fsKB,\u0017\r^3e}AA\u0011qAA8\u0003g\nI(C\u0002\u0002rI\u0014a\u0001V;qY\u0016\u0014\u0004cA\u001b\u0002v%\u0019\u0011q\u000f\u001c\u0003\tI{G.\u001a\t\u0006\u0003C\t9\u0003\u001c\u0005\b\u0003{\u0002A\u0011BA@\u0003U)\b\u000fZ1uK&s\u0007.\u001a:ji\u0006t7-\u001a$mC\u001e$b!!\u0002\u0002\u0002\u0006\r\u0005BB6\u0002|\u0001\u0007A\u000e\u0003\u0005\u0002>\u0005m\u0004\u0019AA\"\u0011\u001d\t9\t\u0001C\u0005\u0003\u0013\u000b!C]3n_Z,W*[:tS:<'k\u001c7fgR!\u0011QAAF\u0011!\ti$!\"A\u0002\u00055\u0005#BA\u0004\u0003S\"\u0007")
public class SqlTeams
implements TeamDecoratorSupport,
Logging {
    private final CiIdService ciIdService;
    private final PermissionEditor permissionEditor;
    private final SqlRoleService roleService;
    private final SecuredCis securedCis;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void decorateWithEffectiveTeams(Collection<Release> releases) {
        TeamDecoratorSupport.decorateWithEffectiveTeams$((TeamDecoratorSupport)this, releases);
    }

    @Override
    public void decorateWithEffectiveTeams(Release release) {
        TeamDecoratorSupport.decorateWithEffectiveTeams$((TeamDecoratorSupport)this, release);
    }

    @Override
    public List<Team> getEffectiveTeams(Release release) {
        return TeamDecoratorSupport.getEffectiveTeams$((TeamDecoratorSupport)this, release);
    }

    @Override
    public List<Team> getEffectiveTeams(String containerId) {
        return TeamDecoratorSupport.getEffectiveTeams$((TeamDecoratorSupport)this, containerId);
    }

    @Override
    public Optional<Team> findTeamByName(String containerId, String teamName) {
        return TeamDecoratorSupport.findTeamByName$(this, containerId, teamName);
    }

    @Override
    public List<Team> findTeamsByNames(String containerId, Collection<String> teamNames) {
        return TeamDecoratorSupport.findTeamsByNames$(this, containerId, teamNames);
    }

    @Override
    public void decorateWithStoredTeams(Release release) {
        TeamDecoratorSupport.decorateWithStoredTeams$(this, release);
    }

    @Override
    public List<Team> getStoredTeams(String containerId) {
        return TeamDecoratorSupport.getStoredTeams$((TeamDecoratorSupport)this, containerId);
    }

    @Override
    public List<Team> getStoredTeams(SecuredCi ci) {
        return TeamDecoratorSupport.getStoredTeams$((TeamDecoratorSupport)this, ci);
    }

    @Override
    public void generateIdIfNecessary(String containerId, Team team) {
        PlatformSecurityMappingSupport.generateIdIfNecessary$(this, containerId, team);
    }

    @Override
    public Team fromPlatformRole(String containerId, Role role, Seq<Permission> permissions) {
        return PlatformSecurityMappingSupport.fromPlatformRole$(this, containerId, role, permissions);
    }

    @Override
    public Role toPlatformRole(Team team) {
        return PlatformSecurityMappingSupport.toPlatformRole$(this, team);
    }

    @Override
    public String toPlatformId(String id) {
        return PlatformSecurityMappingSupport.toPlatformId$(this, id);
    }

    @Override
    public String fromPlatformId(String containerId, String id) {
        return PlatformSecurityMappingSupport.fromPlatformId$(this, containerId, id);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTeams sqlTeams = this;
        synchronized (sqlTeams) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Override
    public PermissionEditor permissionEditor() {
        return this.permissionEditor;
    }

    @Override
    public SqlRoleService roleService() {
        return this.roleService;
    }

    @Override
    public SecuredCis securedCis() {
        return this.securedCis;
    }

    public Team create(String containerId, Team team) {
        this.generateIdIfNecessary(containerId, team);
        this.removeMissingRoles((Seq<Team>)Predef$.MODULE$.wrapRefArray((Object[])new Team[]{team}));
        Role role = this.toPlatformRole(team);
        String securityUid = this.securedCis().getSecuredCi(containerId).getSecurityUid();
        this.roleService().create(securityUid, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Role[]{role}));
        this.updatePermissions(securityUid, (Seq<Tuple2<Role, List<String>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)role), (Object)team.getPermissions())}));
        this.updateInheritanceFlag(containerId, (Seq<Team>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Team[]{team}))));
        return team;
    }

    public Team update(Team team) {
        String containerId = Ids.getParentId((String)team.getId());
        this.removeMissingRoles((Seq<Team>)Predef$.MODULE$.wrapRefArray((Object[])new Team[]{team}));
        Role role = this.toPlatformRole(team);
        String securityUid = this.securedCis().getSecuredCi(containerId).getSecurityUid();
        this.roleService().update((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Role[]{role}));
        this.updatePermissions(securityUid, (Seq<Tuple2<Role, List<String>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)role), (Object)team.getPermissions())}));
        return team;
    }

    public void delete(String teamId) {
        this.roleService().delete((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.toPlatformId(teamId)}));
        String containerId = Ids.getParentId((String)teamId);
        this.updateInheritanceFlag(containerId, (Seq<Team>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.getStoredTeams(containerId)).asScala()));
    }

    public void deleteTeamsFromPlatform(String containerId) {
        block0: {
            String securityUid = this.securedCis().getSecuredCi(containerId).getSecurityUid();
            Buffer roles = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService().getRoles(securityUid)).asScala();
            this.roleService().delete((Seq)roles.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getId(), Buffer$.MODULE$.canBuildFrom()));
            if (!Ids.isFolderId((String)containerId)) break block0;
            this.securedCis().setAsEffectiveSecuredCi(containerId, false);
        }
    }

    public List<Team> saveTeamsToPlatform(Release release) {
        return this.saveTeamsToPlatform(release.getId(), release.getTeams());
    }

    public List<Team> saveTeamsToPlatform(String containerId, List<Team> teams) {
        return package$.MODULE$.ListExtensions(this.saveTeamsToPlatform(containerId, (Seq<Team>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(teams).asScala()))).asJavaMutable();
    }

    private Seq<Team> saveTeamsToPlatform(String containerId, Seq<Team> teams) {
        Option invalidTeam = teams.find((Function1 & Serializable & scala.Serializable)team -> BoxesRunTime.boxToBoolean((boolean)SqlTeams.$anonfun$saveTeamsToPlatform$1(containerId, team)));
        Checks.checkArgument((boolean)invalidTeam.isEmpty(), (String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot save team [", "] as it does not belong to [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{invalidTeam.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), containerId})), (Object[])new Object[0]);
        this.removeMissingRoles(teams);
        teams.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            this.generateIdIfNecessary(containerId, x$3);
            return BoxedUnit.UNIT;
        });
        String securityUid = this.securedCis().getSecuredCi(containerId).getSecurityUid();
        Seq roles = (Seq)teams.map((Function1 & Serializable & scala.Serializable)team -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.toPlatformRole((Team)team)), (Object)team.getPermissions()), Seq$.MODULE$.canBuildFrom());
        this.roleService().writeRoleAssignments(securityUid, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)roles.map((Function1 & Serializable & scala.Serializable)x$4 -> (Role)x$4._1(), Seq$.MODULE$.canBuildFrom())).asJava());
        this.updatePermissions(securityUid, (Seq<Tuple2<Role, List<String>>>)roles);
        this.updateInheritanceFlag(containerId, teams);
        return teams;
    }

    public void updatePermissions(String securityUid, Seq<Tuple2<Role, List<String>>> rolesWithPermissions) {
        Map permissions = this.permissionEditor().readPermissions(securityUid);
        rolesWithPermissions.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Role role = (Role)tuple2._1();
            List rolePermissions = (List)tuple2._2();
            java.util.Set set = (java.util.Set)permissions.put(role, JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rolePermissions).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> Permission.find((String)x$1), Buffer$.MODULE$.canBuildFrom())).toSet()).asJava());
            return set;
        });
        this.permissionEditor().editPermissions(securityUid, permissions);
    }

    private void updateInheritanceFlag(String containerId, Seq<Team> teams) {
        this.securedCis().setAsEffectiveSecuredCi(containerId, teams.nonEmpty());
    }

    private void removeMissingRoles(Seq<Team> teams) {
        Buffer availableRoles = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService().getRoles()).asScala();
        teams.foreach((Function1 & Serializable & scala.Serializable)team -> {
            Object object;
            Buffer nonExistingRoles = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(team.getRoles()).asScala()).filter((Function1 & Serializable & scala.Serializable)roleName -> BoxesRunTime.boxToBoolean((boolean)SqlTeams.$anonfun$removeMissingRoles$2(availableRoles, roleName)));
            if (nonExistingRoles.nonEmpty()) {
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The following role(s) do not exist: ", ". They were removed from the team ", " [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nonExistingRoles, team.getTeamName(), team.getId()})));
                object = BoxesRunTime.boxToBoolean((boolean)team.getRoles().removeAll((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(nonExistingRoles).asJava()));
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$saveTeamsToPlatform$1(String containerId$1, Team team) {
        if (Ids.isNullId((String)team.getId())) return false;
        String string = Ids.getParentId((String)team.getId());
        String string2 = containerId$1;
        if (string == null) {
            if (string2 == null) return false;
            return true;
        } else if (string.equals(string2)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$removeMissingRoles$3(String roleName$1, Role x$5) {
        String string = x$5.getName();
        String string2 = roleName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$removeMissingRoles$2(Buffer availableRoles$1, String roleName) {
        return !availableRoles$1.exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SqlTeams.$anonfun$removeMissingRoles$3(roleName, x$5)));
    }

    public SqlTeams(CiIdService ciIdService, PermissionEditor permissionEditor, SqlRoleService roleService, SecuredCis securedCis, XlrRepository xlrRepository) {
        this.ciIdService = ciIdService;
        this.permissionEditor = permissionEditor;
        this.roleService = roleService;
        this.securedCis = securedCis;
        PlatformSecurityMappingSupport.$init$(this);
        TeamDecoratorSupport.$init$(this);
        Logging.$init$((Logging)this);
    }
}

