/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.repository.IdMatchers;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PlanItemRepository;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\u0001\u0003\u00015\u0011QcU9m!2\fg.\u0013;f[J+\u0007o\\:ji>\u0014\u0018P\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011A\u0003:fa>\u001c\u0018\u000e^8ss*\u0011q\u0001C\u0001\nq2\u0014X\r\\3bg\u0016T!!\u0003\u0006\u0002\u0013a,'-[1mC\n\u001c(\"A\u0006\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u0001qA\u0003\u0007\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U1R\"\u0001\u0003\n\u0005]!!A\u0005)mC:LE/Z7SKB|7/\u001b;pef\u0004\"!\u0007\u000e\u000e\u0003\tI!a\u0007\u0002\u0003-\u0011+7/\u001a:jC2L'0\u0019;j_:\u001cV\u000f\u001d9peRD\u0001\"\b\u0001\u0003\u0006\u0004%\tAH\u0001\u0013e\u0016dW-Y:f!\u0016\u00148/[:uK:\u001cW-F\u0001 !\t\u00013%D\u0001\"\u0015\t\u0011#!A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,\u0017B\u0001\u0013\"\u0005I\u0011V\r\\3bg\u0016\u0004VM]:jgR,gnY3\t\u0011\u0019\u0002!\u0011!Q\u0001\n}\t1C]3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dK\u0002B\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!K\u0001\u0012e\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014X#\u0001\u0016\u0011\u0005eY\u0013B\u0001\u0017\u0003\u0005Q\u0019\u0016\u000f\u001c*fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;fe\"Aa\u0006\u0001B\u0001B\u0003%!&\u0001\nsKB|7/\u001b;pef\fE-\u00199uKJ\u0004\u0003\"\u0002\u0019\u0001\t\u0003\t\u0014A\u0002\u001fj]&$h\bF\u00023gQ\u0002\"!\u0007\u0001\t\u000buy\u0003\u0019A\u0010\t\u000b!z\u0003\u0019\u0001\u0016\t\u000bY\u0002A\u0011I\u001c\u0002\r\u0015D\u0018n\u001d;t)\tA4\b\u0005\u0002\u0010s%\u0011!\b\u0005\u0002\b\u0005>|G.Z1o\u0011\u0015aT\u00071\u0001>\u0003\tIG\r\u0005\u0002?!:\u0011qH\u0014\b\u0003\u00016s!!\u0011'\u000f\u0005\t[eBA\"K\u001d\t!\u0015J\u0004\u0002F\u00116\taI\u0003\u0002H\u0019\u00051AH]8pizJ\u0011aC\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011BA\u0002\u0005\u0013\t\u0011#!\u0003\u0002PC\u0005!1)[%e\u0013\t\t&K\u0001\u0003DS&#'BA(\"Q\t)D\u000b\u0005\u0002V76\taK\u0003\u0002X1\u0006YAO]1og\u0006\u001cG/[8o\u0015\t\u0019\u0011L\u0003\u0002[\r\u0005\u0011AMY\u0005\u00039Z\u0013!\"S:SK\u0006$wJ\u001c7zQ\t)d\f\u0005\u0002`M6\t\u0001M\u0003\u0002bE\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\r$\u0017aB7fiJL7m\u001d\u0006\u0003K*\t\u0001bY8eC\"\fG.Z\u0005\u0003O\u0002\u0014Q\u0001V5nK\u0012DQ!\u001b\u0001\u0005B)\f\u0001BZ5oI\nK\u0018\nZ\u000b\u0003W:$\"\u0001\u001c>\u0011\u00055tG\u0002\u0001\u0003\u0006_\"\u0014\r\u0001\u001d\u0002\u0002)F\u0011\u0011\u000f\u001e\t\u0003\u001fIL!a\u001d\t\u0003\u000f9{G\u000f[5oOB\u0011Q\u000f_\u0007\u0002m*\u0011qOB\u0001\u0007I>l\u0017-\u001b8\n\u0005e4(\u0001\u0003)mC:LE/Z7\t\u000bqB\u0007\u0019A\u001f)\u0005!t\u0006\"B?\u0001\t\u0013q\u0018\u0001\u00044j]\u0012\u0004F.\u00198Ji\u0016lWcA@\u0002\u0004Q!\u0011\u0011AA\u0003!\ri\u00171\u0001\u0003\u0006_r\u0014\r\u0001\u001d\u0005\u0007\u0003\u000fa\b\u0019A\u001f\u0002\t\rL\u0017\n\u001a\u0005\b\u0003\u0017\u0001A\u0011BA\u0007\u0003-1\u0017N\u001c3SK2,\u0017m]3\u0016\t\u0005=\u0011\u0011\u0004\u000b\u0005\u0003#\t9\u0002E\u0002v\u0003'I1!!\u0006w\u0005\u001d\u0011V\r\\3bg\u0016Da\u0001PA\u0005\u0001\u0004iD\u0001CA\u000b\u0003\u0013\u0011\r!a\u0007\u0012\u0007E\fi\u0002E\u0002\u0010\u0003?I1!!\t\u0011\u0005\r\te.\u001f\u0015\u0004\u0001\u0005\u0015\u0002cA+\u0002(%\u0019\u0011\u0011\u0006,\u0003\u001f%\u001bHK]1og\u0006\u001cG/[8oC2\u0004")
public class SqlPlanItemRepository
implements PlanItemRepository,
DeserializationSupport {
    private final ReleasePersistence releasePersistence;
    private final SqlRepositoryAdapter repositoryAdapter;

    @Override
    public Release deserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.deserializeRelease$(this, releaseData);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData);
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String id) {
        boolean bl;
        try {
            this.findPlanItem(id);
            bl = true;
        }
        catch (NotFoundException notFoundException) {
            bl = false;
        }
        return bl;
    }

    @Timed
    public <T extends PlanItem> T findById(String id) {
        return this.findPlanItem(id);
    }

    private <T extends PlanItem> T findPlanItem(String ciId) {
        Release release;
        String string = CiId$.MODULE$.RichCiId(ciId).normalized();
        Option option = IdMatchers.ReleaseId$.MODULE$.unapply(string);
        if (!option.isEmpty()) {
            String id = (String)option.get();
            release = this.findRelease(id);
        } else {
            Option option2 = IdMatchers.PhaseId$.MODULE$.unapply(string);
            if (!option2.isEmpty()) {
                String id = (String)option2.get();
                release = this.findRelease(Ids.releaseIdFrom((String)id)).getPhase(id);
            } else {
                Option option3 = IdMatchers.TaskId$.MODULE$.unapply(string);
                if (!option3.isEmpty()) {
                    String id = (String)option3.get();
                    release = this.findRelease(Ids.releaseIdFrom((String)id)).getTask(id);
                } else {
                    throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Item [", "] not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})), new Object[0]);
                }
            }
        }
        return (T)release;
    }

    private <Release> Release findRelease(String id) {
        String releaseId = Ids.releaseIdFrom((String)CiId$.MODULE$.RichCiId(id).normalized());
        return (Release)this.releasePersistence().findByReleaseId(releaseId).map((Function1 & Serializable & scala.Serializable)releaseData -> this.deserializeRelease((ReleaseRow)releaseData)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Release [", "] not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})), new Object[0]);
        });
    }

    public SqlPlanItemRepository(ReleasePersistence releasePersistence, SqlRepositoryAdapter repositoryAdapter) {
        this.releasePersistence = releasePersistence;
        this.repositoryAdapter = repositoryAdapter;
        DeserializationSupport.$init$(this);
    }
}

