/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.Diff;
import com.xebialabs.xlrelease.domain.utils.Diff$;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.SqlReleaseRepositoryHelper;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence$CommentRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.ConfigurationPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.TriggerPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.security.SecuredCi;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\r]d\u0001B\u00181\u0001mB\u0001\"\u0019\u0001\u0003\u0002\u0003\u0006IA\u0019\u0005\tQ\u0002\u0011)\u0019!C\tS\"AQ\u000e\u0001B\u0001B\u0003%!\u000e\u0003\u0005o\u0001\t\u0015\r\u0011\"\u0005p\u0011!\u0019\bA!A!\u0002\u0013\u0001\b\u0002\u0003;\u0001\u0005\u000b\u0007I\u0011C;\t\u0011e\u0004!\u0011!Q\u0001\nYD\u0001B\u001f\u0001\u0003\u0006\u0004%\tb\u001f\u0005\t\u007f\u0002\u0011\t\u0011)A\u0005y\"Q\u0011\u0011\u0001\u0001\u0003\u0006\u0004%\t\"a\u0001\t\u0015\u0005-\u0001A!A!\u0002\u0013\t)\u0001\u0003\u0006\u0002\u000e\u0001\u0011)\u0019!C\u0001\u0003\u001fA!\"a\u0006\u0001\u0005\u0003\u0005\u000b\u0011BA\t\u0011)\tI\u0002\u0001BC\u0002\u0013\u0005\u00111\u0004\u0005\u000b\u0003G\u0001!\u0011!Q\u0001\n\u0005u\u0001BCA\u0013\u0001\t\u0015\r\u0011\"\u0005\u0002(!Q\u0011q\u0006\u0001\u0003\u0002\u0003\u0006I!!\u000b\t\u0015\u0005E\u0002A!A!\u0002\u0013\t\u0019\u0004\u0003\u0006\u0002:\u0001\u0011)\u0019!C\u0002\u0003wA!\"a\u001b\u0001\u0005\u0003\u0005\u000b\u0011BA\u001f\u0011\u001d\ti\u0007\u0001C\u0001\u0003_Bq!a#\u0001\t\u0003\ni\tC\u0004\u0002N\u0002!\t%a4\t\u000f\u0005\u001d\b\u0001\"\u0011\u0002j\"9!\u0011\u0001\u0001\u0005B\t\r\u0001b\u0002B\u001e\u0001\u0011\u0005#Q\b\u0005\b\u0005\u000b\u0002A\u0011\u0001B$\u0011\u001d\u0011Y\u0007\u0001C!\u0005[BqAa \u0001\t\u0003\u0011\t\tC\u0004\u0003\u0010\u0002!\tE!%\t\u000f\t\u0015\u0006\u0001\"\u0011\u0003(\"9!Q\u0016\u0001\u0005\n\t=\u0006b\u0002B\\\u0001\u0011\u0005#\u0011\u0018\u0005\b\u0005\u0003\u0004A\u0011\tBb\u0011\u001d\u0011y\r\u0001C!\u0005#DqAa6\u0001\t\u0003\u0012I\u000eC\u0004\u0003d\u0002!\tE!:\t\u000f\t=\b\u0001\"\u0011\u0003r\"9!q \u0001\u0005B\r\u0005\u0001bBB\u0005\u0001\u0011\u000531\u0002\u0005\b\u0007'\u0001A\u0011IB\u000b\u0011\u001d\u0019\u0019\u0002\u0001C!\u00077Aqaa\n\u0001\t\u0003\u001aI\u0003C\u0004\u00042\u0001!\tea\r\t\u000f\r\r\u0003\u0001\"\u0003\u0004F!91q\r\u0001\u0005\n\r%$\u0001F*rYJ+G.Z1tKJ+\u0007o\\:ji>\u0014\u0018P\u0003\u00022e\u0005\u00191/\u001d7\u000b\u0005M\"\u0014A\u0003:fa>\u001c\u0018\u000e^8ss*\u0011QGN\u0001\nq2\u0014X\r\\3bg\u0016T!a\u000e\u001d\u0002\u0013a,'-[1mC\n\u001c(\"A\u001d\u0002\u0007\r|Wn\u0001\u0001\u0014\u0011\u0001a$I\u0012)Y7z\u0003\"!\u0010!\u000e\u0003yR\u0011aP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0003z\u0012a!\u00118z%\u00164\u0007CA\"E\u001b\u0005\u0011\u0014BA#3\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\t\u0004\u000f\"SU\"\u0001\u0019\n\u0005%\u0003$!F%oi\u0016\u00148-\u001a9uK\u0012\u0014V\r]8tSR|'/\u001f\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001bR\na\u0001Z8nC&t\u0017BA(M\u0005\u001d\u0011V\r\\3bg\u0016\u0004\"!\u0015,\u000e\u0003IS!a\u0015+\u0002\u000bMdg\r\u000e6\u000b\u0003U\u000b\u0001b\u001a:jujdW\rZ\u0005\u0003/J\u0013q\u0001T8hO&tw\r\u0005\u0002H3&\u0011!\f\r\u0002\u0017\t\u0016\u001cXM]5bY&T\u0018\r^5p]N+\b\u000f]8siB\u0011q\tX\u0005\u0003;B\u0012adQ8oM&<WO]1uS>t'+\u001a4fe\u0016t7-Z:TkB\u0004xN\u001d;\u0011\u0005\u001d{\u0016B\u000111\u0005i\u0019\u0016\u000f\u001c*fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\"+G\u000e]3s\u0003I\u0011X\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015\u0004\u0014a\u00039feNL7\u000f^3oG\u0016L!a\u001a3\u0003%I+G.Z1tKB+'o]5ti\u0016t7-Z\u0001\u0010i\u0006\u001c8\u000eU3sg&\u001cH/\u001a8dKV\t!\u000e\u0005\u0002dW&\u0011A\u000e\u001a\u0002\u0010)\u0006\u001c8\u000eU3sg&\u001cH/\u001a8dK\u0006\u0001B/Y:l!\u0016\u00148/[:uK:\u001cW\rI\u0001\u0016I\u0016\u0004XM\u001c3f]\u000eL\b+\u001a:tSN$XM\\2f+\u0005\u0001\bCA2r\u0013\t\u0011HMA\u000bEKB,g\u000eZ3oGf\u0004VM]:jgR,gnY3\u0002-\u0011,\u0007/\u001a8eK:\u001c\u0017\u0010U3sg&\u001cH/\u001a8dK\u0002\n!cY8n[\u0016tG\u000fU3sg&\u001cH/\u001a8dKV\ta\u000f\u0005\u0002do&\u0011\u0001\u0010\u001a\u0002\u0013\u0007>lW.\u001a8u!\u0016\u00148/[:uK:\u001cW-A\nd_6lWM\u001c;QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%\u0001\buK\u0006l'+\u001a9pg&$xN]=\u0016\u0003q\u0004\"aQ?\n\u0005y\u0014$A\u0004+fC6\u0014V\r]8tSR|'/_\u0001\u0010i\u0016\fWNU3q_NLGo\u001c:zA\u0005Y\"/\u001a7fCN,W\t\u001f;f]NLwN\\:SKB|7/\u001b;pef,\"!!\u0002\u0011\u0007\r\u000b9!C\u0002\u0002\nI\u00121DU3mK\u0006\u001cX-\u0012=uK:\u001c\u0018n\u001c8t%\u0016\u0004xn]5u_JL\u0018\u0001\b:fY\u0016\f7/Z#yi\u0016t7/[8ogJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0019G>tg-[4ve\u0006$\u0018n\u001c8QKJ\u001c\u0018n\u001d;f]\u000e,WCAA\t!\r\u0019\u00171C\u0005\u0004\u0003+!'\u0001G\"p]\u001aLw-\u001e:bi&|g\u000eU3sg&\u001cH/\u001a8dK\u0006I2m\u001c8gS\u001e,(/\u0019;j_:\u0004VM]:jgR,gnY3!\u0003E\u0011X\r]8tSR|'/_!eCB$XM]\u000b\u0003\u0003;\u00012aRA\u0010\u0013\r\t\t\u0003\r\u0002\u0015'Fd'+\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0002%I,\u0007o\\:ji>\u0014\u00180\u00113baR,'\u000fI\u0001\u0013iJLwmZ3s!\u0016\u00148/[:uK:\u001cW-\u0006\u0002\u0002*A\u00191-a\u000b\n\u0007\u00055BM\u0001\nUe&<w-\u001a:QKJ\u001c\u0018n\u001d;f]\u000e,\u0017a\u0005;sS\u001e<WM\u001d)feNL7\u000f^3oG\u0016\u0004\u0013a\u00044bG\u0016$(+\u001a9pg&$xN]=\u0011\u0007\r\u000b)$C\u0002\u00028I\u0012qBR1dKR\u0014V\r]8tSR|'/_\u0001\u000bgFdG)[1mK\u000e$XCAA\u001f!\u0011\ty$!\u001a\u000f\t\u0005\u0005\u0013q\f\b\u0005\u0003\u0007\nYF\u0004\u0003\u0002F\u0005]c\u0002BA$\u0003+rA!!\u0013\u0002T9!\u00111JA)\u001b\t\tiEC\u0002\u0002Pi\na\u0001\u0010:p_Rt\u0014\"A\u001d\n\u0005]B\u0014BA\u001b7\u0013\r\tI\u0006N\u0001\u0003I\nL1!MA/\u0015\r\tI\u0006N\u0005\u0005\u0003C\n\u0019'\u0001\u0006Tc2\u0014U/\u001b7eKJT1!MA/\u0013\u0011\t9'!\u001b\u0003\u000f\u0011K\u0017\r\\3di*!\u0011\u0011MA2\u0003-\u0019\u0018\u000f\u001c#jC2,7\r\u001e\u0011\u0002\rqJg.\u001b;?)Y\t\t(a\u001e\u0002z\u0005m\u0014QPA@\u0003\u0003\u000b\u0019)!\"\u0002\b\u0006%E\u0003BA:\u0003k\u0002\"a\u0012\u0001\t\u000f\u0005eR\u0003q\u0001\u0002>!)\u0011-\u0006a\u0001E\")\u0001.\u0006a\u0001U\")a.\u0006a\u0001a\")A/\u0006a\u0001m\")!0\u0006a\u0001y\"9\u0011\u0011A\u000bA\u0002\u0005\u0015\u0001bBA\u0007+\u0001\u0007\u0011\u0011\u0003\u0005\b\u00033)\u0002\u0019AA\u000f\u0011\u001d\t)#\u0006a\u0001\u0003SAq!!\r\u0016\u0001\u0004\t\u0019$\u0001\u0004fq&\u001cHo\u001d\u000b\u0005\u0003\u001f\u000b)\nE\u0002>\u0003#K1!a%?\u0005\u001d\u0011un\u001c7fC:Dq!a&\u0017\u0001\u0004\tI*\u0001\u0002jIB!\u00111TAR\u001d\u0011\ti*a(\u0011\u0007\u0005-c(C\u0002\u0002\"z\na\u0001\u0015:fI\u00164\u0017\u0002BAS\u0003O\u0013aa\u0015;sS:<'bAAQ}!\u001aa#a+\u0011\t\u00055\u00161W\u0007\u0003\u0003_SA!!-\u0002d\u0005YAO]1og\u0006\u001cG/[8o\u0013\u0011\t),a,\u0003\u0015%\u001b(+Z1e\u001f:d\u0017\u0010K\u0002\u0017\u0003s\u0003B!a/\u0002J6\u0011\u0011Q\u0018\u0006\u0005\u0003\u007f\u000b\t-\u0001\u0006b]:|G/\u0019;j_:TA!a1\u0002F\u00069Q.\u001a;sS\u000e\u001c(bAAdq\u0005A1m\u001c3bQ\u0006dW-\u0003\u0003\u0002L\u0006u&!\u0002+j[\u0016$\u0017AB2sK\u0006$X\rF\u0003K\u0003#\f)\u000e\u0003\u0004\u0002T^\u0001\rAS\u0001\be\u0016dW-Y:f\u0011\u001d\t9n\u0006a\u0001\u00033\fQC]3mK\u0006\u001cXm\u0011:fCRLwN\\*pkJ\u001cW\r\u0005\u0003\u0002\\\u0006\u0005XBAAo\u0015\r\ty\u000eT\u0001\u0007KZ,g\u000e^:\n\t\u0005\r\u0018Q\u001c\u0002\u0016%\u0016dW-Y:f\u0007J,\u0017\r^5p]N{WO]2fQ\r9\u0012\u0011X\u0001\tM&tGMQ=JIR)!*a;\u0002n\"9\u0011q\u0013\rA\u0002\u0005e\u0005bBAx1\u0001\u0007\u0011\u0011_\u0001\bo>\u00148\u000eR5s!\u0011\t\u00190a?\u000e\u0005\u0005U(bA\u001a\u0002x*\u0019\u0011\u0011 \u001c\u0002\u0011\u0011,\u0007\u000f\\8zSRLA!!@\u0002v\n9qk\u001c:l\t&\u0014\bf\u0001\r\u0002:\u0006ya-\u001b8e\u0013\u0012\u001c()_*uCR,8\u000f\u0006\u0003\u0003\u0006\t]\u0001C\u0002B\u0004\u0005#\tIJ\u0004\u0003\u0003\n\t5a\u0002BA&\u0005\u0017I\u0011aP\u0005\u0004\u0005\u001fq\u0014a\u00029bG.\fw-Z\u0005\u0005\u0005'\u0011)BA\u0002TKFT1Aa\u0004?\u0011\u001d\u0011I\"\u0007a\u0001\u00057\t\u0001b\u001d;biV\u001cXm\u001d\t\u0006{\tu!\u0011E\u0005\u0004\u0005?q$A\u0003\u001fsKB,\u0017\r^3e}A!!1\u0005B\u0015\u001b\t\u0011)CC\u0002\u0003(1\u000baa\u001d;biV\u001c\u0018\u0002\u0002B\u0016\u0005K\u0011QBU3mK\u0006\u001cXm\u0015;biV\u001c\bfA\r\u0002:\"\u001a\u0011D!\r\u0011\t\tM\"qG\u0007\u0003\u0005kQ1!a0?\u0013\u0011\u0011ID!\u000e\u0003\u000fY\f'/\u0019:hg\u0006\u0019b-\u001b8e\u0005f\u001c\u0015\r\\3oI\u0006\u0014Hk\\6f]R\u0019!Ja\u0010\t\u000f\t\u0005#\u00041\u0001\u0002\u001a\u0006i1-\u00197f]\u0012\f'\u000fV8lK:D3AGA]\u0003a1\u0017N\u001c3Be\u000eD\u0017N^1cY\u0016\u0014V\r\\3bg\u0016LEm\u001d\u000b\u0007\u0005\u000b\u0011IE!\u0018\t\u000f\t-3\u00041\u0001\u0003N\u0005!A-\u0019;f!\u0011\u0011yE!\u0017\u000e\u0005\tE#\u0002\u0002B*\u0005+\nA!\u001e;jY*\u0011!qK\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003\\\tE#\u0001\u0002#bi\u0016DqAa\u0018\u001c\u0001\u0004\u0011\t'\u0001\u0005qC\u001e,7+\u001b>f!\ri$1M\u0005\u0004\u0005Kr$aA%oi\"\u001a1$a+)\u0007m\tI,\u0001\btKR\u0004&/Z!sG\"Lg/\u001a3\u0015\r\t=$Q\u000fB=!\ri$\u0011O\u0005\u0004\u0005gr$\u0001B+oSRDqAa\u001e\u001d\u0001\u0004\tI*A\u0005sK2,\u0017m]3JI\"9!1\u0010\u000fA\u0002\u0005=\u0015a\u00039sK\u0006\u00138\r[5wK\u0012D3\u0001HA]\u0003e1\u0017N\u001c3Qe\u0016\f%o\u00195jm\u0006\u0014G.\u001a*fY\u0016\f7/Z:\u0015\r\t\r%Q\u0011BE!\u0015\u00119A!\u0005K\u0011\u001d\u00119)\ba\u0001\u0005C\nA\u0001]1hK\"9!qL\u000fA\u0002\t\u0005\u0004fA\u000f\u0002,\"\u001aQ$!/\u0002\rM,\u0017M]2i)\u0011\u0011\u0019J!'\u0011\u000b\t=#Q\u0013&\n\t\t]%\u0011\u000b\u0002\u0005\u0019&\u001cH\u000fC\u0004\u0003\u001cz\u0001\rA!(\u0002\u0019M,\u0017M]2i!\u0006\u0014\u0018-\\:\u0011\u0007\r\u0013y*C\u0002\u0003\"J\u0012QCU3mK\u0006\u001cXmU3be\u000eD')\u001f)be\u0006l7\u000fK\u0002\u001f\u0003s\u000ba\u0001Z3mKR,G\u0003\u0002B8\u0005SCq!a& \u0001\u0004\tI\nK\u0002 \u0003s\u000bq\u0003Z3mKR,'+\u001a7fCN,'+\u001a4fe\u0016t7-Z:\u0015\r\t=$\u0011\u0017BZ\u0011\u001d\t9\n\ta\u0001\u00033CqA!.!\u0001\u0004\u0011\t'\u0001\u0006sK2,\u0017m]3VS\u0012\fQ\u0002Z3mKR,w+\u001b;i+&$GC\u0002B8\u0005w\u0013i\fC\u0004\u0002\u0018\u0006\u0002\r!!'\t\u000f\tU\u0016\u00051\u0001\u0003b!\u001a\u0011%!/\u0002\t5|g/\u001a\u000b\u0007\u0005_\u0012)M!3\t\u000f\t\u001d'\u00051\u0001\u0002\u001a\u0006QqN]5hS:\fG.\u00133\t\u000f\t-'\u00051\u0001\u0002\u001a\u0006)a.Z<JI\"\u001a!%!/\u0002\u0013\u001d,Go\u0015;biV\u001cH\u0003\u0002B\u0011\u0005'Dq!a&$\u0001\u0004\tI\nK\u0002$\u0003s\u000b1bZ3u'R\fG/^:fgR!!1\u001cBo!\u0019\u00119A!\u0005\u0003\"!9!q\u001c\u0013A\u0002\t\u0015\u0011aA5eg\"\u001aA%!/\u0002\u001b\u001d,GOU5tWN\u001bwN]3t)\u0011\u00119O!;\u0011\r\t\u001d!\u0011\u0003B1\u0011\u001d\u0011y.\na\u0001\u0005\u000bA3!JAVQ\r)\u0013\u0011X\u0001\u000eg\u0016$(+[:l'\u000e|'/Z:\u0015\u0011\t=$1\u001fB{\u0005sDqAa\u001e'\u0001\u0004\tI\nC\u0004\u0003x\u001a\u0002\rA!\u0019\u0002\u000bM\u001cwN]3\t\u000f\tmh\u00051\u0001\u0003b\u0005QAo\u001c;bYN\u001bwN]3)\u0007\u0019\nI,\u0001\u0006jgR+W\u000e\u001d7bi\u0016$B!a$\u0004\u0004!9!qO\u0014A\u0002\u0005e\u0005fA\u0014\u0002,\"\u001aq%!/\u0002\u0011\u001d,G\u000fV5uY\u0016$B!!'\u0004\u000e!9\u0011q\u0013\u0015A\u0002\u0005e\u0005f\u0001\u0015\u0002,\"\u001a\u0001&!/\u0002\rU\u0004H-\u0019;f)\rQ5q\u0003\u0005\u0007\u0003'L\u0003\u0019\u0001&)\u0007%\nI\fF\u0003K\u0007;\u0019\t\u0003\u0003\u0004\u0004 )\u0002\rAS\u0001\t_JLw-\u001b8bY\"111\u0005\u0016A\u0002)\u000bq!\u001e9eCR,G\rK\u0002+\u0003s\u000bqA]3qY\u0006\u001cW\rF\u0003K\u0007W\u0019i\u0003\u0003\u0004\u0004 -\u0002\rA\u0013\u0005\u0007\u0007GY\u0003\u0019\u0001&)\u0007-\nI,\u0001\u0006hKR\fE\u000e\u001c+bON$Ba!\u000e\u0004<A1!qJB\u001c\u00033KAa!\u000f\u0003R\t\u00191+\u001a;\t\u000f\ruB\u00061\u0001\u0003b\u0005YA.[7ji:+XNY3sQ\ra\u00131\u0016\u0015\u0004Y\u0005e\u0016AC4fiJ+G.Z1tKR)!ja\u0012\u0004d!9!qO\u0017A\u0002\r%\u0003\u0003BB&\u0007;rAa!\u0014\u0004Z9!1qJB,\u001d\u0011\u0019\tf!\u0016\u000f\t\u0005\u001531K\u0005\u0003gQJ!!\r\u001a\n\u0005\u0015\u0004\u0014bAB.I\u0006!1)[%e\u0013\u0011\u0019yf!\u0019\u0003\t\rK\u0017\n\u001a\u0006\u0004\u00077\"\u0007bBB3[\u0001\u00071\u0011J\u0001\tK:$\u0018\u000e^=JI\u0006\u00113\r[3dW&\u001bhj\u001c;SK\u001a,'/\u001a8dK\u0012\u0014\u0015\u0010R3qK:$WM\\2jKN$BAa\u001c\u0004l!91Q\u000e\u0018A\u0002\r%\u0013a\u00069mC:LE/Z7JI>\u0013\u0018\n^:DQ&dGM]3oQ\r\u00011\u0011\u000f\t\u0005\u0003[\u001b\u0019(\u0003\u0003\u0004v\u0005=&aD%t)J\fgn]1di&|g.\u00197")
public class SqlReleaseRepository
implements ReleaseRepository,
InterceptedRepository<Release>,
Logging,
DeserializationSupport,
ConfigurationReferencesSupport,
SqlReleaseRepositoryHelper {
    private final ReleasePersistence releasePersistence;
    private final TaskPersistence taskPersistence;
    private final DependencyPersistence dependencyPersistence;
    private final CommentPersistence commentPersistence;
    private final TeamRepository teamRepository;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private final ConfigurationPersistence configurationPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final TriggerPersistence triggerPersistence;
    private final FacetRepository facetRepository;
    private final SqlBuilder.Dialect sqlDialect;
    private Logger grizzled$slf4j$Logging$$_logger;
    private Seq<PersistenceInterceptor<Release>> persistenceInterceptors;
    private volatile boolean bitmap$0;

    @Override
    public void replaceTasks(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceTasks$(this, original, updated);
    }

    @Override
    public void replaceTriggers(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceTriggers$(this, original, updated);
    }

    @Override
    public void replaceReleaseExtensions(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceReleaseExtensions$(this, original, updated);
    }

    @Override
    public void replaceReleaseTeams(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceReleaseTeams$(this, original, updated);
    }

    @Override
    public void updateCommentsOnTasks(Task originalTask, Task updatedTask) {
        SqlReleaseRepositoryHelper.updateCommentsOnTasks$(this, originalTask, updatedTask);
    }

    @Override
    public void insertDependency(Integer gateTaskUid, Dependency dependency) {
        SqlReleaseRepositoryHelper.insertDependency$(this, gateTaskUid, dependency);
    }

    @Override
    public void updateConfigurationRefs(Release release) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, release);
    }

    @Override
    public void deleteConfigurationRefs(Integer releaseUid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, releaseUid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.deserializeRelease$(this, releaseData);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void registerPersistenceInterceptor(PersistenceInterceptor<Release> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$(this, persistenceInterceptor);
    }

    @Override
    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$(this, ci);
    }

    @Override
    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$(this, ciId);
    }

    public Release findById(String id) {
        return ReleaseRepository.findById$((ReleaseRepository)this, (String)id);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlReleaseRepository sqlReleaseRepository = this;
        synchronized (sqlReleaseRepository) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public Seq<PersistenceInterceptor<Release>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    @Override
    public void persistenceInterceptors_$eq(Seq<PersistenceInterceptor<Release>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public Seq<String> findIdsByStatus(ReleaseStatus ... statuses) {
        return this.findIdsByStatus((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])statuses));
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public CommentPersistence commentPersistence() {
        return this.commentPersistence;
    }

    public TeamRepository teamRepository() {
        return this.teamRepository;
    }

    public ReleaseExtensionsRepository releaseExtensionsRepository() {
        return this.releaseExtensionsRepository;
    }

    @Override
    public ConfigurationPersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public TriggerPersistence triggerPersistence() {
        return this.triggerPersistence;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String id) {
        return this.releasePersistence.existsRelease(CiId$.MODULE$.RichCiId(id).normalized());
    }

    @Timed
    public Release create(Release release, ReleaseCreationSource releaseCreationSource) {
        if (this.releasePersistence.existsRelease(release.getId())) {
            throw new ItemAlreadyExistsException("A release with ID [%s] already exists", new Object[]{release.getId()});
        }
        this.interceptCreate((ConfigurationItem)release);
        this.releasePersistence.insert(release);
        release.getReleaseTriggers().forEach(trigger -> this.triggerPersistence().insert((ReleaseTrigger)trigger));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)task -> {
            SqlReleaseRepository.$anonfun$create$2(this, release, task);
            return BoxedUnit.UNIT;
        });
        release.getExtensions().forEach(extension -> this.releaseExtensionsRepository().create(extension));
        this.updateConfigurationRefs(release);
        this.facetRepository.createFromTasks((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala());
        return release;
    }

    @Timed
    public Release findById(String id, WorkDir workDir) {
        return this.getRelease(id, id);
    }

    @Timed
    public Seq<String> findIdsByStatus(Seq<ReleaseStatus> statuses) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses(statuses).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
    }

    @Timed
    public Release findByCalendarToken(String calendarToken) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withCalendarToken(calendarToken).build();
        Seq<ReleaseRow> releases = this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
        return (Release)releases.headOption().map((Function1 & Serializable & scala.Serializable)releaseData -> this.deserializeRelease((ReleaseRow)releaseData)).map((Function1 & Serializable & scala.Serializable)release -> this.releaseExtensionsRepository().decorate(release)).map((Function1 & Serializable & scala.Serializable)release -> this.commentPersistence().decorate((Release)release)).orNull(Predef$.MODULE$.$conforms());
    }

    @Timed
    @IsReadOnly
    public Seq<String> findArchivableReleaseIds(Date date, int pageSize) {
        ReleasesSqlBuilder qual$1 = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((Seq<ReleaseStatus>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED})))).withEndDateBefore(date).withPage(new Page(0L, (long)pageSize, Predef$.MODULE$.int2Integer(0)));
        boolean x$1 = qual$1.withPreArchived$default$1();
        Tuple2 sqlWithParams = qual$1.withPreArchived(x$1).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
    }

    @Timed
    public void setPreArchived(String releaseId, boolean preArchived) {
        this.releasePersistence.setPreArchived(releaseId, preArchived);
    }

    @Timed
    @IsReadOnly
    public Seq<Release> findPreArchivableReleases(int page, int pageSize) {
        Seq inactive = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED}));
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withOneOfStatuses((Seq<ReleaseStatus>)inactive).withPreArchived(false).limitAndOffset(pageSize, page * pageSize).build();
        return (Seq)((TraversableLike)((TraversableLike)((TraversableLike)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable & scala.Serializable)releaseData -> Option$.MODULE$.option2Iterable(this.tryDeserializeRelease((ReleaseRow)releaseData)), Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isTutorial()))).map((Function1 & Serializable & scala.Serializable)release -> this.releaseExtensionsRepository().decorate(release), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)release -> this.commentPersistence().decorate((Release)release), Seq$.MODULE$.canBuildFrom());
    }

    @Timed
    public List<Release> search(ReleaseSearchByParams searchParams) {
        ReleaseSearchByParams releaseSearchByParams = searchParams;
        if (releaseSearchByParams == null) {
            throw new MatchError((Object)releaseSearchByParams);
        }
        Page page = releaseSearchByParams.page();
        Either folderId2 = releaseSearchByParams.folderId();
        ReleaseStatus[] statuses = releaseSearchByParams.statuses();
        String title = releaseSearchByParams.title();
        String rootReleaseId = releaseSearchByParams.rootReleaseId();
        boolean autoStart = releaseSearchByParams.autoStart();
        ReleasesSqlBuilder base = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withTitle(title).withRootReleaseId(rootReleaseId).withPage(page);
        ReleasesSqlBuilder sqlBuilder = folderId2 == null ? base : (ReleasesSqlBuilder)((Object)folderId2.fold((Function1 & Serializable & scala.Serializable)folderId -> base.withFolder((String)folderId), (Function1 & Serializable & scala.Serializable)ancestorId -> base.withAncestor((String)ancestorId)));
        Object object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).nonEmpty() ? sqlBuilder.withOneOfStatuses((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])statuses)) : BoxedUnit.UNIT;
        Object object2 = autoStart ? sqlBuilder.withAutoStart() : BoxedUnit.UNIT;
        List list = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((TraversableLike)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlBuilder.build()).flatMap((Function1 & Serializable & scala.Serializable)releaseData -> Option$.MODULE$.option2Iterable(this.tryDeserializeRelease((ReleaseRow)releaseData)), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)release -> this.releaseExtensionsRepository().decorate(release), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)release -> this.commentPersistence().decorate((Release)release), Seq$.MODULE$.canBuildFrom())).asJava();
        return list;
    }

    @Timed
    public void delete(String id) {
        this.checkIsNotReferencedByDependencies(id);
        this.releasePersistence.findUidByReleaseId(id).foreach((Function1 & Serializable & scala.Serializable)uid -> {
            this.deleteReleaseReferences(id, uid);
            return BoxedUnit.UNIT;
        });
        this.releasePersistence.deleteById(id);
    }

    private void deleteReleaseReferences(String id, int releaseUid) {
        this.dependencyPersistence().deleteByReleaseUid(Predef$.MODULE$.int2Integer(releaseUid));
        this.triggerPersistence().deleteByTemplateId(id);
        this.commentPersistence().deleteByRelease(Predef$.MODULE$.int2Integer(releaseUid));
        this.taskPersistence().deleteTasksByReleaseUid(releaseUid);
        this.teamRepository().deleteTeamsFromPlatform(new SecuredCi(id, releaseUid));
        this.releaseExtensionsRepository().deleteAll(id);
        this.deleteConfigurationRefs(Predef$.MODULE$.int2Integer(releaseUid));
        this.interceptDelete(id);
    }

    @Timed
    public void deleteWithUid(String id, int releaseUid) {
        this.deleteReleaseReferences(id, releaseUid);
        this.releasePersistence.deleteById(id);
    }

    @Timed
    public void move(String originalId, String newId) {
        this.releasePersistence.move(originalId, newId);
    }

    @Timed
    public ReleaseStatus getStatus(String id) {
        String status = (String)this.releasePersistence.findReleaseStatus(CiId$.MODULE$.RichCiId(id).normalized()).orNull(Predef$.MODULE$.$conforms());
        return status == null ? null : ReleaseStatus.valueOf((String)status.toUpperCase());
    }

    @Timed
    public Seq<ReleaseStatus> getStatuses(Seq<String> ids) {
        return ids.isEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$) : (Seq)this.releasePersistence.findReleaseStatuses(ids).map((Function1 & Serializable & scala.Serializable)status -> ReleaseStatus.valueOf((String)status.toUpperCase()), Seq$.MODULE$.canBuildFrom());
    }

    @Timed
    @IsReadOnly
    public Seq<Object> getRiskScores(Seq<String> ids) {
        return this.releasePersistence.findReleaseRiskScores(ids);
    }

    @Timed
    public void setRiskScores(String releaseId, int score, int totalScore) {
        this.releasePersistence.updateReleaseRiskScores(releaseId, score, totalScore);
    }

    @Timed
    @IsReadOnly
    public boolean isTemplate(String releaseId) {
        return ReleaseStatus.TEMPLATE.equals(this.getStatus(releaseId));
    }

    @Timed
    @IsReadOnly
    public String getTitle(String id) {
        return (String)this.releasePersistence.findReleaseTitle(CiId$.MODULE$.RichCiId(id).normalized()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException("Release [%s] not found", new Object[]{id});
        });
    }

    @Timed
    public Release update(Release release) {
        return this.update(null, release);
    }

    @Timed
    public Release update(Release original, Release updated) {
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        if (original != null) {
            Diff$.MODULE$.apply((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(original.getAllTasks()).asScala(), (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(updated.getAllTasks()).asScala()).newValues().foreach((Function1 & Serializable & scala.Serializable)task -> {
                SqlReleaseRepository.$anonfun$update$1(this, updated, task);
                return BoxedUnit.UNIT;
            });
            Buffer originalTriggers = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(original.getReleaseTriggers()).asScala();
            Buffer updatedTriggers = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(updated.getReleaseTriggers()).asScala();
            Diff triggerDiff = Diff$.MODULE$.apply((Iterable)originalTriggers, (Iterable)updatedTriggers);
            triggerDiff.newValues().foreach((Function1 & Serializable & scala.Serializable)trigger -> {
                SqlReleaseRepository.$anonfun$update$5(this, trigger);
                return BoxedUnit.UNIT;
            });
            ((IterableLike)((TraversableLike)triggerDiff.updatedPairs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$update$6(x0$1)))).map((Function1 & Serializable & scala.Serializable)x$3 -> (ReleaseTrigger)x$3._2(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)releaseTrigger -> {
                SqlReleaseRepository.$anonfun$update$8(this, releaseTrigger);
                return BoxedUnit.UNIT;
            });
        }
        this.updateConfigurationRefs(updated);
        return updated;
    }

    @Timed
    public Release replace(Release original, Release updated) {
        if (Ids.isFolderId((String)original.getId())) {
            updated.setTeams(Collections.emptyList());
        }
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        if (original != null) {
            this.replaceTasks(original, updated);
            this.replaceTriggers(original, updated);
            this.replaceReleaseExtensions(original, updated);
            this.replaceReleaseTeams(original, updated);
        }
        this.updateConfigurationRefs(updated);
        return updated;
    }

    @Timed
    @IsReadOnly
    public Set<String> getAllTags(int limitNumber) {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.releasePersistence.findAllTags(limitNumber)).asJava();
    }

    private Release getRelease(String releaseId, String entityId) {
        Release release = (Release)this.repositoryAdapter().read(releaseId);
        if (release == null) {
            throw new NotFoundException(new StringBuilder(30).append("Repository entity [").append(entityId).append("] not found").toString(), new Object[0]);
        }
        this.releaseExtensionsRepository().decorate(release);
        return this.commentPersistence().decorate(release);
    }

    private void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        Seq externalIncomingDependencies = (Seq)((TraversableLike)this.dependencyPersistence().findByPartialTargetIds((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{planItemIdOrItsChildren}))), (Option<scala.collection.immutable.Set<String>>)None$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$4 -> DependencyRow$.MODULE$.DependencyRowOps((DependencyRow)x$4).fullDependencyId(), Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.startsWith(CiId$.MODULE$.RichCiId(planItemIdOrItsChildren).normalized())));
        if (externalIncomingDependencies.nonEmpty()) {
            throw new ItemInUseException(new StringBuilder(68).append("Cannot delete [").append(planItemIdOrItsChildren).append("] because it or one of its children is referenced by ").append(new StringBuilder(28).append("one or more dependencies: [").append(externalIncomingDependencies.mkString(", ")).append("]").toString()).toString(), new Object[0]);
        }
    }

    public static final /* synthetic */ boolean $anonfun$create$3(SqlReleaseRepository $this, Integer taskUid$1, Comment comment) {
        return $this.commentPersistence().create(taskUid$1, CommentPersistence$CommentRow$.MODULE$.fromComment(comment));
    }

    public static final /* synthetic */ void $anonfun$create$2(SqlReleaseRepository $this, Release release$1, Task task) {
        Integer taskUid = $this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(release$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)comment -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$create$3($this, taskUid, comment)));
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$update$2(SqlReleaseRepository $this, Integer taskUid$2, Comment c) {
        return $this.commentPersistence().create(taskUid$2, CommentPersistence$CommentRow$.MODULE$.fromComment(c));
    }

    public static final /* synthetic */ void $anonfun$update$1(SqlReleaseRepository $this, Release updated$1, Task task) {
        Integer taskUid = $this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(updated$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$update$2($this, taskUid, c)));
        ((IterableLike)syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isArchived()))).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$update$5(SqlReleaseRepository $this, ReleaseTrigger trigger) {
        $this.triggerPersistence().insert(trigger);
    }

    public static final /* synthetic */ boolean $anonfun$update$6(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ReleaseTrigger orig = (ReleaseTrigger)tuple2._1();
        ReleaseTrigger up = (ReleaseTrigger)tuple2._2();
        boolean bl = orig.isEnabled() != up.isEnabled();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$update$8(SqlReleaseRepository $this, ReleaseTrigger releaseTrigger) {
        $this.triggerPersistence().update(releaseTrigger);
    }

    public SqlReleaseRepository(ReleasePersistence releasePersistence, TaskPersistence taskPersistence, DependencyPersistence dependencyPersistence, CommentPersistence commentPersistence, TeamRepository teamRepository, ReleaseExtensionsRepository releaseExtensionsRepository, ConfigurationPersistence configurationPersistence, SqlRepositoryAdapter repositoryAdapter, TriggerPersistence triggerPersistence, FacetRepository facetRepository, SqlBuilder.Dialect sqlDialect) {
        this.releasePersistence = releasePersistence;
        this.taskPersistence = taskPersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.commentPersistence = commentPersistence;
        this.teamRepository = teamRepository;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        this.configurationPersistence = configurationPersistence;
        this.repositoryAdapter = repositoryAdapter;
        this.triggerPersistence = triggerPersistence;
        this.facetRepository = facetRepository;
        this.sqlDialect = sqlDialect;
        ReleaseRepository.$init$((ReleaseRepository)this);
        InterceptedRepository.$init$(this);
        Logging.$init$((Logging)this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        SqlReleaseRepositoryHelper.$init$(this);
    }
}

