/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseTriggerRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.TriggerPersistence;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;

@Repository
@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u0006\r\u0001]A\u0001B\t\u0001\u0003\u0006\u0004%\ta\t\u0005\tO\u0001\u0011\t\u0011)A\u0005I!A\u0001\u0006\u0001BC\u0002\u0013\u0005\u0011\u0006\u0003\u00051\u0001\t\u0005\t\u0015!\u0003+\u0011\u0015\t\u0004\u0001\"\u00013\u0011\u00151\u0005\u0001\"\u0011H\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015a\u0007\u0001\"\u0011n\u0011\u0015\u0019\b\u0001\"\u0011u\u0011\u00159\b\u0001\"\u0011y\u0005m\u0019\u0016\u000f\u001c*fY\u0016\f7/\u001a+sS\u001e<WM\u001d*fa>\u001c\u0018\u000e^8ss*\u0011QBD\u0001\u0004gFd'BA\b\u0011\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003#I\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005M!\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005)\u0012aA2p[\u000e\u00011c\u0001\u0001\u0019=A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1\u0011I\\=SK\u001a\u0004\"a\b\u0011\u000e\u00039I!!\t\b\u00031I+G.Z1tKR\u0013\u0018nZ4feJ+\u0007o\\:ji>\u0014\u00180A\tsK2,\u0017m]3SKB|7/\u001b;pef,\u0012\u0001\n\t\u0003?\u0015J!A\n\b\u0003#I+G.Z1tKJ+\u0007o\\:ji>\u0014\u00180\u0001\nsK2,\u0017m]3SKB|7/\u001b;pef\u0004\u0013A\u0005;sS\u001e<WM\u001d)feNL7\u000f^3oG\u0016,\u0012A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0003[1\t1\u0002]3sg&\u001cH/\u001a8dK&\u0011q\u0006\f\u0002\u0013)JLwmZ3s!\u0016\u00148/[:uK:\u001cW-A\nue&<w-\u001a:QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004gU2\u0004C\u0001\u001b\u0001\u001b\u0005a\u0001\"\u0002\u0012\u0006\u0001\u0004!\u0003\"\u0002\u0015\u0006\u0001\u0004Q\u0003FA\u00039!\tID)D\u0001;\u0015\tYD(\u0001\u0006b]:|G/\u0019;j_:T!!\u0010 \u0002\u000f\u0019\f7\r^8ss*\u0011q\bQ\u0001\u0006E\u0016\fgn\u001d\u0006\u0003\u0003\n\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u0007\u0006\u0019qN]4\n\u0005\u0015S$!C!vi><\u0018N]3e\u0003\u00111\u0017N\u001c3\u0015\u0005!s\u0005CA%M\u001b\u0005Q%BA&\u0011\u0003\u0019!w.\\1j]&\u0011QJ\u0013\u0002\u000f%\u0016dW-Y:f)JLwmZ3s\u0011\u0015ye\u00011\u0001Q\u0003%!(/[4hKJLE\r\u0005\u0002R1:\u0011!K\u0016\t\u0003'ji\u0011\u0001\u0016\u0006\u0003+Z\ta\u0001\u0010:p_Rt\u0014BA,\u001b\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011L\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005]S\u0002F\u0001\u0004]!\ti6-D\u0001_\u0015\tYtL\u0003\u0002aC\u00069Q.\u001a;sS\u000e\u001c(B\u00012\u0015\u0003!\u0019w\u000eZ1iC2,\u0017B\u00013_\u0005\u0015!\u0016.\\3e\u0003\u0019\u0019'/Z1uKR\u0019\u0001jZ5\t\u000b!<\u0001\u0019\u0001)\u0002\u0015Q,W\u000e\u001d7bi\u0016LE\rC\u0003k\u000f\u0001\u0007\u0001*\u0001\bsK2,\u0017m]3Ue&<w-\u001a:)\u0005\u001da\u0016AB;qI\u0006$X\r\u0006\u0002ocB\u0011\u0011d\\\u0005\u0003aj\u0011A!\u00168ji\")!\u000e\u0003a\u0001\u0011\"\u0012\u0001\u0002X\u0001\u0007I\u0016dW\r^3\u0015\u00059,\b\"B(\n\u0001\u0004\u0001\u0006FA\u0005]\u0003i1\u0017N\u001c3F]\u0006\u0014G.\u001a3SK2,\u0017m]3Ue&<w-\u001a:t)\rI\u00181\u0001\t\u0004u~\u0004V\"A>\u000b\u0005ql\u0018\u0001B;uS2T\u0011A`\u0001\u0005U\u00064\u0018-C\u0002\u0002\u0002m\u0014A\u0001T5ti\")\u0001N\u0003a\u0001!\"\u0012!\u0002\u0018\u0015\u0004\u0001\u0005%\u0001\u0003BA\u0006\u0003/i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\fiJ\fgn]1di&|gNC\u0002\u000e\u0003'Q1!!\u0006\u0011\u0003\t!'-\u0003\u0003\u0002\u001a\u00055!aD%t)J\fgn]1di&|g.\u00197)\u0007\u0001\ti\u0002\u0005\u0003\u0002 \u0005\u0015RBAA\u0011\u0015\r\t\u0019\u0003Q\u0001\u000bgR,'/Z8usB,\u0017\u0002BA\u0014\u0003C\u0011!BU3q_NLGo\u001c:z\u0001")
public class SqlReleaseTriggerRepository
implements ReleaseTriggerRepository {
    private final ReleaseRepository releaseRepository;
    private final TriggerPersistence triggerPersistence;

    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    public TriggerPersistence triggerPersistence() {
        return this.triggerPersistence;
    }

    @Timed
    public ReleaseTrigger find(String triggerId) {
        Release template = this.releaseRepository().findById(Ids.getParentId((String)triggerId));
        Optional maybeTrigger = template.getReleaseTriggerById(CiId$.MODULE$.RichCiId(triggerId).normalized());
        return (ReleaseTrigger)maybeTrigger.orElseThrow(() -> new NotFoundException("Repository entity [%s] not found", new Object[]{triggerId}));
    }

    @Timed
    public ReleaseTrigger create(String templateId, ReleaseTrigger releaseTrigger) {
        Release template = this.releaseRepository().findById(templateId);
        if (!template.getReleaseTriggers().contains(releaseTrigger)) {
            template.getReleaseTriggers().add(releaseTrigger);
            releaseTrigger.setTemplate(template);
        }
        this.triggerPersistence().insert(releaseTrigger);
        this.releaseRepository().update(template);
        return releaseTrigger;
    }

    @Timed
    public void update(ReleaseTrigger releaseTrigger) {
        Release template = this.releaseRepository().findById(Ids.getParentId((String)releaseTrigger.getId()));
        template.replaceTrigger(releaseTrigger);
        releaseTrigger.setTemplate(template);
        this.releaseRepository().update(template);
        this.triggerPersistence().update(releaseTrigger);
    }

    @Timed
    public void delete(String triggerId) {
        Release template = this.releaseRepository().findById(Ids.getParentId((String)triggerId));
        template.deleteReleaseTriggerById(CiId$.MODULE$.RichCiId(triggerId).normalized());
        this.releaseRepository().update(template);
        this.triggerPersistence().delete(triggerId);
    }

    @Timed
    public List<String> findEnabledReleaseTriggers(String templateId) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.triggerPersistence().getEnabledReleaseTriggerIds(templateId)).asJava();
    }

    @Autowired
    public SqlReleaseTriggerRepository(ReleaseRepository releaseRepository, TriggerPersistence triggerPersistence) {
        this.releaseRepository = releaseRepository;
        this.triggerPersistence = triggerPersistence;
    }
}

