/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.repository.FolderVariableRepository;
import com.xebialabs.xlrelease.repository.IdMatchers;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderId$;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderVariablePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderVariableRow;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;

@Repository
@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\u0001\u0003\u00015\u00111dU9m\r>dG-\u001a:WCJL\u0017M\u00197f%\u0016\u0004xn]5u_JL(BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\t!B]3q_NLGo\u001c:z\u0015\t9\u0001\"A\u0005yYJ,G.Z1tK*\u0011\u0011BC\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aC\u0001\u0004G>l7\u0001A\n\u0005\u00019!\u0002\u0004\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+Yi\u0011\u0001B\u0005\u0003/\u0011\u0011\u0001DR8mI\u0016\u0014h+\u0019:jC\ndWMU3q_NLGo\u001c:z!\tIb$D\u0001\u001b\u0015\tYB$A\u0003tY\u001a$$NC\u0001\u001e\u0003!9'/\u001b>{Y\u0016$\u0017BA\u0010\u001b\u0005\u001daunZ4j]\u001eD\u0001\"\t\u0001\u0003\u0002\u0003\u0006IAI\u0001\u0014m\u0006\u0014\u0018.\u00192mKB+'o]5ti\u0016t7-\u001a\t\u0003G\u0019j\u0011\u0001\n\u0006\u0003K\t\t1\u0002]3sg&\u001cH/\u001a8dK&\u0011q\u0005\n\u0002\u001a\r>dG-\u001a:WCJL\u0017M\u00197f!\u0016\u00148/[:uK:\u001cW\r\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0003E\u0011X\r]8tSR|'/_!eCB$XM\u001d\t\u0003W1j\u0011AA\u0005\u0003[\t\u0011AcU9m%\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014\b\"B\u0018\u0001\t\u0003\u0001\u0014A\u0002\u001fj]&$h\bF\u00022eM\u0002\"a\u000b\u0001\t\u000b\u0005r\u0003\u0019\u0001\u0012\t\u000b%r\u0003\u0019\u0001\u0016)\u00059*\u0004C\u0001\u001cB\u001b\u00059$B\u0001\u001d:\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003um\nqAZ1di>\u0014\u0018P\u0003\u0002={\u0005)!-Z1og*\u0011ahP\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0001)A\u0002pe\u001eL!AQ\u001c\u0003\u0013\u0005+Ho\\<je\u0016$\u0007\"\u0002#\u0001\t\u0003*\u0015AB3ySN$8\u000f\u0006\u0002G\u0013B\u0011qbR\u0005\u0003\u0011B\u0011qAQ8pY\u0016\fg\u000eC\u0003K\u0007\u0002\u00071*\u0001\u0006wCJL\u0017M\u00197f\u0013\u0012\u0004\"\u0001T*\u000f\u00055\u000b\u0006C\u0001(\u0011\u001b\u0005y%B\u0001)\r\u0003\u0019a$o\\8u}%\u0011!\u000bE\u0001\u0007!J,G-\u001a4\n\u0005Q+&AB*ue&twM\u0003\u0002S!!)q\u000b\u0001C!1\u0006Aa-\u001b8e\u0005fLE\r\u0006\u0002ZCB\u0011!lX\u0007\u00027*\u0011A,X\u0001\nm\u0006\u0014\u0018.\u00192mKNT!A\u0018\u0004\u0002\r\u0011|W.Y5o\u0013\t\u00017L\u0001\u0005WCJL\u0017M\u00197f\u0011\u0015Qe\u000b1\u0001L\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0003%1\u0017N\u001c3Cs.+\u0017\u0010F\u0002ZK\u001eDQA\u001a2A\u0002-\u000b1B^1sS\u0006\u0014G.Z&fs\")\u0001N\u0019a\u0001\u0017\u0006Aam\u001c7eKJLE\rC\u0003k\u0001\u0011\u00053.\u0001\u0004de\u0016\fG/\u001a\u000b\u000332DQ!\\5A\u0002e\u000b\u0001B^1sS\u0006\u0014G.\u001a\u0005\u0006_\u0002!\t\u0005]\u0001\u0007kB$\u0017\r^3\u0015\u0005e\u000b\b\"B7o\u0001\u0004I\u0006\"B:\u0001\t\u0003\"\u0018A\u00023fY\u0016$X\r\u0006\u0002vqB\u0011qB^\u0005\u0003oB\u0011A!\u00168ji\")!J\u001da\u0001\u0017\")!\u0010\u0001C!w\u0006\u0001r-\u001a;BY24%o\\7QCJ,g\u000e\u001e\u000b\u0004y\u0006%\u0001\u0003B?\u0002\u0006ek\u0011A \u0006\u0004\u007f\u0006\u0005\u0011\u0001B;uS2T!!a\u0001\u0002\t)\fg/Y\u0005\u0004\u0003\u000fq(\u0001\u0002'jgRDa!a\u0003z\u0001\u0004Y\u0015\u0001\u0005<be&\f'\r\\3QCJ,g\u000e^%e\u0011\u001d\ty\u0001\u0001C!\u0003#\t!cZ3u\u00032dgI]8n\u0003:\u001cWm\u001d;ssR\u0019A0a\u0005\t\u000f\u0005-\u0011Q\u0002a\u0001\u0017\"9\u0011q\u0003\u0001\u0005\n\u0005e\u0011A\u0003;p-\u0006\u0014\u0018.\u00192mKR\u0019\u0011,a\u0007\t\u0011\u0005u\u0011Q\u0003a\u0001\u0003?\t1B^1sS\u0006\u0014G.\u001a*poB!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&\u0011\nA\u0001Z1uC&!\u0011\u0011FA\u0012\u0005E1u\u000e\u001c3feZ\u000b'/[1cY\u0016\u0014vn\u001e\u0015\u0004\u0001\u00055\u0002\u0003BA\u0018\u0003wi!!!\r\u000b\t\u0005M\u0012QG\u0001\fiJ\fgn]1di&|gNC\u0002\u0004\u0003oQ1!!\u000f\u0007\u0003\t!'-\u0003\u0003\u0002>\u0005E\"aD%t)J\fgn]1di&|g.\u00197)\u0007\u0001\t\t\u0005\u0005\u0003\u0002D\u0005%SBAA#\u0015\r\t9%P\u0001\u000bgR,'/Z8usB,\u0017\u0002BA&\u0003\u000b\u0012!BU3q_NLGo\u001c:z\u0001")
public class SqlFolderVariableRepository
implements FolderVariableRepository,
Logging {
    private final FolderVariablePersistence variablePersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlFolderVariableRepository sqlFolderVariableRepository = this;
        synchronized (sqlFolderVariableRepository) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public boolean exists(String variableId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"checking folder variable exists [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{variableId})));
        return this.variablePersistence.exists(variableId);
    }

    public Variable findById(String variableId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"finding folder variable [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{variableId})));
        return (Variable)this.variablePersistence.findById(variableId).map((Function1 & Serializable & scala.Serializable)variableRow -> this.toVariable((FolderVariableRow)variableRow)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException("Variable with id='%s' not found", new Object[]{variableId});
        });
    }

    public Variable findByKey(String variableKey, String folderId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"finding folder variable [key=", "], [folderId=", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{variableKey, folderId})));
        return (Variable)this.variablePersistence.findVariableByKey(variableKey, folderId).map((Function1 & Serializable & scala.Serializable)variableRow -> this.toVariable((FolderVariableRow)variableRow)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException("Variable with key='%s' not found", new Object[]{variableKey});
        });
    }

    public Variable create(Variable variable) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"creating new folder variable [key=", "], [folderId=", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{variable.getKey(), variable.getFolderId()})));
        Integer ciUid = this.variablePersistence.create(variable);
        return (Variable)this.variablePersistence.findByCiUid(ciUid).map((Function1 & Serializable & scala.Serializable)variableRow -> this.toVariable((FolderVariableRow)variableRow)).get();
    }

    public Variable update(Variable variable) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"updating folder variable [key=", "], [folderId=", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{variable.getKey(), variable.getFolderId()})));
        this.variablePersistence.update(variable);
        return this.findById(variable.getId());
    }

    public void delete(String variableId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"deleting folder variable [", "])"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{variableId})));
        this.variablePersistence.delete(variableId);
    }

    public List<Variable> getAllFromParent(String variableParentId) {
        List list;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"getting all folder variables by parent [id=", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{variableParentId})));
        String string = variableParentId;
        Option option = IdMatchers.FolderId$.MODULE$.unapply(string);
        if (!option.isEmpty()) {
            String folderId = (String)option.get();
            list = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)this.variablePersistence.findByFolderId(folderId).map((Function1 & Serializable & scala.Serializable)variableRow -> this.toVariable((FolderVariableRow)variableRow), Buffer$.MODULE$.canBuildFrom())).asJava();
        } else {
            list = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)Buffer$.MODULE$.empty()).asJava();
        }
        return list;
    }

    public List<Variable> getAllFromAncestry(String variableParentId) {
        List list;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"getting all folder variables from ancestry [id=", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{variableParentId})));
        String string = variableParentId;
        Option option = IdMatchers.FolderId$.MODULE$.unapply(string);
        if (!option.isEmpty()) {
            String folderId = (String)option.get();
            list = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)this.variablePersistence.findByParentIdIncludingAncestors(folderId).map((Function1 & Serializable & scala.Serializable)variableRow -> this.toVariable((FolderVariableRow)variableRow), Buffer$.MODULE$.canBuildFrom())).asJava();
        } else {
            list = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)Buffer$.MODULE$.empty()).asJava();
        }
        return list;
    }

    private Variable toVariable(FolderVariableRow variableRow) {
        return (Variable)this.repositoryAdapter.deserialize(variableRow.json()).map((Function1 & Serializable & scala.Serializable)variable -> {
            variable.setFolderId(FolderId$.MODULE$.absolute$extension(variableRow.folderId()));
            return variable;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error reading folder variable '", "', see logs for more details."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{variableRow.ciUid()})), new Object[0]);
        });
    }

    @Autowired
    public SqlFolderVariableRepository(FolderVariablePersistence variablePersistence, SqlRepositoryAdapter repositoryAdapter) {
        this.variablePersistence = variablePersistence;
        this.repositoryAdapter = repositoryAdapter;
        Logging.$init$((Logging)this);
    }
}

