/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql.persistence;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderId$;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleaseStoreException;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder$;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema$DEPENDENCIES$;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema$FOLDERS$;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema$RELEASES$;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema$TASKS$;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence$;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TargetRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TargetRow$TargetRowOps$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.UUID;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Profile;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Profile(value={"sql"})
@Repository
@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\t\rf\u0001B\u0001\u0003\u0001=\u0011Q\u0003R3qK:$WM\\2z!\u0016\u00148/[:uK:\u001cWM\u0003\u0002\u0004\t\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002\n\u0015\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u00171\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u00035\t1aY8n\u0007\u0001\u0019B\u0001\u0001\t\u00175A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"a\u0006\r\u000e\u0003\tI!!\u0007\u0002\u0003%A+'o]5ti\u0016t7-Z*vaB|'\u000f\u001e\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\tQa\u001d7gi)T\u0011aH\u0001\tOJL'P\u001f7fI&\u0011\u0011\u0005\b\u0002\b\u0019><w-\u001b8h\u0011!\u0019\u0003A!b\u0001\n\u0003!\u0013\u0001\u00046eE\u000e$V-\u001c9mCR,W#A\u0013\u0011\u0005\u0019zS\"A\u0014\u000b\u0005!J\u0013\u0001B2pe\u0016T!AK\u0016\u0002\t)$'m\u0019\u0006\u0003Y5\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002]\u0005\u0019qN]4\n\u0005A:#\u0001\u0004&eE\u000e$V-\u001c9mCR,\u0007\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002\u001b)$'m\u0019+f[Bd\u0017\r^3!\u0011!!\u0004A!b\u0001\n\u0007)\u0014a\u00023jC2,7\r^\u000b\u0002mA\u0011qG\u0013\b\u0003q\u001ds!!O#\u000f\u0005i\u001aeBA\u001eC\u001d\ta\u0014I\u0004\u0002>\u00016\taH\u0003\u0002@\u001d\u00051AH]8pizJ\u0011!D\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u0011C\u0011A\u00013c\u0013\t)aI\u0003\u0002E\u0011%\u0011\u0001*S\u0001\u000b'Fd')^5mI\u0016\u0014(BA\u0003G\u0013\tYEJA\u0004ES\u0006dWm\u0019;\u000b\u0005!K\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\u0002\u0011\u0011L\u0017\r\\3di\u0002BQ\u0001\u0015\u0001\u0005\u0002E\u000ba\u0001P5oSRtDc\u0001*TEB\u0011q\u0003\u0001\u0005\u0006G=\u0003\r!\n\u0015\u0005'V{\u0006\r\u0005\u0002W;6\tqK\u0003\u0002Y3\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005i[\u0016a\u00024bGR|'/\u001f\u0006\u00039.\nQAY3b]NL!AX,\u0003\u0013E+\u0018\r\\5gS\u0016\u0014\u0018!\u0002<bYV,\u0017%A1\u00023ad'OU3q_NLGo\u001c:z\u0015\u0012\u00147\rV3na2\fG/\u001a\u0005\u0006i=\u0003\u001dA\u000e\u0015\u0005EV{F-I\u0001f\u0003]AHN\u001d*fa>\u001c\u0018\u000e^8ssN\u000bH\u000eR5bY\u0016\u001cG\u000f\u000b\u0002POB\u0011a\u000b[\u0005\u0003S^\u0013\u0011\"Q;u_^L'/\u001a3\t\u000b-\u0004A\u0011\u00027\u0002\u000fY\f'/\u0019:hgV\u0019Q.a\u0005\u0015\u00059d\b\u0003B\tpcfL!\u0001\u001d\n\u0003\rQ+\b\u000f\\33!\t\u0011hO\u0004\u0002tiB\u0011QHE\u0005\u0003kJ\ta\u0001\u0015:fI\u00164\u0017BA<y\u0005\u0019\u0019FO]5oO*\u0011QO\u0005\t\u0004#i\u0004\u0012BA>\u0013\u0005\u0015\t%O]1z\u0011\u0015i(\u000e1\u0001\u007f\u0003\u0011\t'oZ:\u0011\u000b}\fI!a\u0004\u000f\t\u0005\u0005\u0011Q\u0001\b\u0004{\u0005\r\u0011\"A\n\n\u0007\u0005\u001d!#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005-\u0011Q\u0002\u0002\t\u0013R,'/\u00192mK*\u0019\u0011q\u0001\n\u0011\t\u0005E\u00111\u0003\u0007\u0001\t\u001d\t)B\u001bb\u0001\u0003/\u0011\u0011\u0001V\t\u0005\u00033\ty\u0002E\u0002\u0012\u00037I1!!\b\u0013\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!EA\u0011\u0013\r\t\u0019C\u0005\u0002\u0004\u0003:L\bbBA\u0014\u0001\u0011%\u0011\u0011F\u0001\rM&dG/\u001a:Ti\u0006$Xo\u001d\u000b\u0004]\u0006-\u0002\u0002CA\u0017\u0003K\u0001\r!a\f\u0002\rM$\u0018\r^;t!\u0015\t\u0012\u0011GA\u001b\u0013\r\t\u0019D\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\tI\f9$]\u0005\u0004\u0003sA(aA*fi\"I\u0011Q\b\u0001C\u0002\u0013%\u0011qH\u0001\u000eI\u00164\u0017-\u001e7u\u001b\u0006\u0004\b/\u001a:\u0016\u0005\u0005\u0005\u0003#\u0002\u0014\u0002D\u0005\u001d\u0013bAA#O\tI!k\\<NCB\u0004XM\u001d\t\u0005\u0003\u0013\ny%\u0004\u0002\u0002L)\u0019\u0011Q\n\u0002\u0002\t\u0011\fG/Y\u0005\u0005\u0003#\nYEA\u0007EKB,g\u000eZ3oGf\u0014vn\u001e\u0005\t\u0003+\u0002\u0001\u0015!\u0003\u0002B\u0005qA-\u001a4bk2$X*\u00199qKJ\u0004\u0003\"CA-\u0001\t\u0007I\u0011BA.\u00031!WMZ1vYR\fV/\u001a:z+\u0005\t\bbBA0\u0001\u0001\u0006I!]\u0001\u000eI\u00164\u0017-\u001e7u#V,'/\u001f\u0011\t\u0013\u0005\r\u0004A1A\u0005\n\u0005m\u0013\u0001H*U\u001bR{f)\u0013(E?\nKvlR!U\u000b~\u0013V\tT#B'\u0016{\u0016\n\u0012\u0005\b\u0003O\u0002\u0001\u0015!\u0003r\u0003u\u0019F+\u0014+`\r&sEi\u0018\"Z?\u001e\u000bE+R0S\u000b2+\u0015iU#`\u0013\u0012\u0003\u0003\"CA6\u0001\t\u0007I\u0011BA.\u000351\u0017N\u001c3UCN\\7)[+jI\"9\u0011q\u000e\u0001!\u0002\u0013\t\u0018A\u00044j]\u0012$\u0016m]6DSVKG\r\t\u0005\b\u0003g\u0002A\u0011BA;\u0003)!\u0018m]6JI\"\u000b7\u000f\u001b\u000b\u0004c\u0006]\u0004bBA=\u0003c\u0002\r!]\u0001\u0007i\u0006\u001c8.\u00133\t\u000f\u0005u\u0004\u0001\"\u0001\u0002\u0000\u0005\u0019b-\u001b8e\u0005f<\u0015\r^3SK2,\u0017m]3JIR!\u0011\u0011QAD!\u0015y\u00181QA$\u0013\u0011\t))!\u0004\u0003\u0007M+\u0017\u000f\u0003\u0005\u0002\n\u0006m\u0004\u0019AAF\u0003%\u0011X\r\\3bg\u0016LE\r\u0005\u0003\u0002\u000e\u0006}e\u0002BAH\u00037sA!!%\u0002\u001a:!\u00111SAL\u001d\rQ\u0014QS\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005\r!\u0011bAAO\u0005\u0005!1)[%e\u0013\u0011\t\t+a)\u0003\t\rK\u0017\n\u001a\u0006\u0004\u0003;\u0013\u0001bBAT\u0001\u0011\u0005\u0011\u0011V\u0001\u0017M&tGMQ=QCJ$\u0018.\u00197UCJ<W\r^%egR1\u0011\u0011QAV\u0003cC\u0001\"!,\u0002&\u0002\u0007\u0011qV\u0001\na\u0006\u0014XM\u001c;JIN\u0004RA]A\u001c\u0003\u0017C\u0001\"!\f\u0002&\u0002\u0007\u0011q\u0006\u0005\n\u0003k\u0003!\u0019!C\u0005\u00037\nqb\u0015+N)~3\u0015J\u0014#`\u0005f{\u0016\n\u0012\u0005\b\u0003s\u0003\u0001\u0015!\u0003r\u0003A\u0019F+\u0014+`\r&sEi\u0018\"Z?&#\u0005\u0005C\u0004\u0002>\u0002!\t!a0\u0002\u0011\u0019Lg\u000e\u001a\"z\u0013\u0012$B!a\u0012\u0002B\"A\u00111YA^\u0001\u0004\tY)\u0001\u0007eKB,g\u000eZ3oGfLE\rC\u0005\u0002H\u0002\u0011\r\u0011\"\u0003\u0002\\\u0005\u00112\u000bV'U?\u001e+Ek\u0018+B%\u001e+EkX%E\u0011\u001d\tY\r\u0001Q\u0001\nE\f1c\u0015+N)~;U\tV0U\u0003J;U\tV0J\t\u0002Bq!a4\u0001\t\u0003\t\t.A\u0006hKR$\u0016M]4fi&#G\u0003BAj\u0003+\u0004B!EA\u0019c\"A\u00111YAg\u0001\u0004\tY\tC\u0004\u0002Z\u0002!\t!a7\u0002\u001f\u0019Lg\u000e\u001a\"z)\u0006\u0014x-\u001a;JIN$b!!!\u0002^\u0006\u0005\b\u0002CAp\u0003/\u0004\r!a,\u0002\u0013Q\f'oZ3u\u0013\u0012\u001c\b\u0002CA\u0017\u0003/\u0004\r!a\f\t\u0013\u0005\u0015\bA1A\u0005\n\u0005m\u0013AF*U\u001bR{\u0016JT*F%R{F)\u0012)F\u001d\u0012+ejQ-\t\u000f\u0005%\b\u0001)A\u0005c\u000692\u000bV'U?&s5+\u0012*U?\u0012+\u0005+\u0012(E\u000b:\u001b\u0015\f\t\u0005\b\u0003[\u0004A\u0011AAx\u0003AIgn]3si\u0012+\u0007/\u001a8eK:\u001c\u0017\u0010\u0006\u0003\u0002r\u0006]\bcA\t\u0002t&\u0019\u0011Q\u001f\n\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003s\fY\u000f1\u0001\u0002|\u0006QA-\u001a9f]\u0012,gnY=\u0011\t\u0005u(1A\u0007\u0003\u0003\u007fT1A!\u0001\t\u0003\u0019!w.\\1j]&!!QAA\u0000\u0005)!U\r]3oI\u0016t7-\u001f\u0005\n\u0005\u0013\u0001!\u0019!C\u0005\u00037\n\u0011f\u0015+N)~KejU#S)~#U\tU#O\t\u0016s5)W0X\u0013RCulR!U\u000b~#\u0016iU&`+&#\u0005b\u0002B\u0007\u0001\u0001\u0006I!]\u0001+'RkEkX%O'\u0016\u0013Fk\u0018#F!\u0016sE)\u0012(D3~;\u0016\n\u0016%`\u000f\u0006#Vi\u0018+B'.{V+\u0013#!\u0011\u001d\u0011\t\u0002\u0001C\u0001\u0005'\tq$\u001b8tKJ$H)\u001a9f]\u0012,gnY=XSRDw)\u0019;f)\u0006\u001c8.V5e)\u0011\u0011)B!\u0007\u0015\t\u0005E(q\u0003\u0005\t\u0003s\u0014y\u00011\u0001\u0002|\"A!1\u0004B\b\u0001\u0004\u0011i\"A\u0006hCR,G+Y:l+&$\u0007\u0003\u0002B\u0010\u0005Gq1a\u0006B\u0011\u0013\r\t9AA\u0005\u0005\u0005K\u00119CA\u0003DSVKGMC\u0002\u0002\b\tA\u0011Ba\u000b\u0001\u0005\u0004%I!a\u0017\u0002\u0017M#V\nV0E\u000b2+E+\u0012\u0005\b\u0005_\u0001\u0001\u0015!\u0003r\u00031\u0019F+\u0014+`\t\u0016cU\tV#!\u0011\u001d\u0011\u0019\u0004\u0001C\u0001\u0005k\t\u0001\u0003Z3mKR,G)\u001a9f]\u0012,gnY=\u0015\t\u0005E(q\u0007\u0005\b\u0005s\u0011\t\u00041\u0001r\u0003\tIG\rC\u0004\u00034\u0001!\tA!\u0010\u0015\t\u0005E(q\b\u0005\t\u0003s\u0014Y\u00041\u0001\u0002|\"I!1\t\u0001C\u0002\u0013%\u00111L\u0001\u001b'RkEk\u0018#F\u0019\u0016#Vi\u0018\"Z?J+E*R!T\u000b~+\u0016\n\u0012\u0005\b\u0005\u000f\u0002\u0001\u0015!\u0003r\u0003m\u0019F+\u0014+`\t\u0016cU\tV#`\u0005f{&+\u0012'F\u0003N+u,V%EA!9!1\n\u0001\u0005\u0002\t5\u0013A\u00053fY\u0016$XMQ=SK2,\u0017m]3VS\u0012$BAa\u0014\u0003VA\u0019\u0011C!\u0015\n\u0007\tM#CA\u0004C_>dW-\u00198\t\u0011\t]#\u0011\na\u0001\u0005;\t!B]3mK\u0006\u001cX-V5e\u0011%\u0011Y\u0006\u0001b\u0001\n\u0013\tY&A\u0006T)6#v,\u0016)E\u0003R+\u0005b\u0002B0\u0001\u0001\u0006I!]\u0001\r'RkEkX+Q\t\u0006#V\t\t\u0005\b\u0005G\u0002A\u0011\u0001B3\u0003A)\b\u000fZ1uK\u0012+\u0007/\u001a8eK:\u001c\u0017\u0010\u0006\u0003\u0002r\n\u001d\u0004\u0002CA}\u0005C\u0002\r!a?\t\u000f\t-\u0004\u0001\"\u0003\u0003n\u0005Qq-\u001a;UCJ<W\r^:\u0015\t\t=$\u0011\u000f\t\u0005#=\f\u0018\u000f\u0003\u0005\u0002z\n%\u0004\u0019AA~Q\r\u0001!Q\u000f\t\u0005\u0005o\u0012i(\u0004\u0002\u0003z)\u0019!1P%\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0005\u007f\u0012IHA\bJgR\u0013\u0018M\\:bGRLwN\\1mQ\r\u0001!1\u0011\t\u0005\u0005\u000b\u0013Y)\u0004\u0002\u0003\b*\u0019!\u0011R\u0016\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0003\u000e\n\u001d%A\u0003*fa>\u001c\u0018\u000e^8ss\"2\u0001A!%`\u0005?\u0003BAa%\u0003\u001c6\u0011!Q\u0013\u0006\u00041\n]%b\u0001BMW\u000591m\u001c8uKb$\u0018\u0002\u0002BO\u0005+\u0013q\u0001\u0015:pM&dW\r\f\u0002\u0003\"\u0006\nQ\u0001")
public class DependencyPersistence
implements PersistenceSupport,
Logging {
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private final RowMapper<DependencyRow> defaultMapper;
    private final String defaultQuery;
    private final String STMT_FIND_BY_GATE_RELEASE_ID;
    private final String findTaskCiUid;
    private final String STMT_FIND_BY_ID;
    private final String STMT_GET_TARGET_ID;
    private final String STMT_INSERT_DEPENDENCY;
    private final String STMT_INSERT_DEPENDENCY_WITH_GATE_TASK_UID;
    private final String STMT_DELETE;
    private final String STMT_DELETE_BY_RELEASE_UID;
    private final String STMT_UPDATE;
    private Logger grizzled$slf4j$Logging$$_logger;
    private NamedParameterJdbcTemplate namedTemplate;
    private volatile byte bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Integer sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params) {
        return PersistenceSupport.sqlInsert$(this, pkColumn, sqlStatement, params);
    }

    @Override
    public <R> R sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlInsert(String pkColumn, String sqlStatement, MapSqlParameterSource params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public void sqlInsert(String sqlStatement, Map<String, Object> params) {
        PersistenceSupport.sqlInsert$(this, sqlStatement, params);
    }

    @Override
    public <R> R sqlExec(String sqlStatement, Map<String, Object> params, PreparedStatementCallback<R> callback) {
        return (R)PersistenceSupport.sqlExec$(this, sqlStatement, params, callback);
    }

    @Override
    public <R> R sqlExecWithContent(String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlExecWithContent$(this, sqlStatement, params, contentParam, mapper);
    }

    @Override
    public <R> R sqlInsertWithContent(String pkColumn, String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsertWithContent$(this, pkColumn, sqlStatement, params, contentParam, mapper);
    }

    @Override
    public <R> R sqlUpdate(String sqlStatement, Map<String, Object> params, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlUpdate$(this, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlSet(String sqlStatement, Function1<PreparedStatement, PreparedStatement> setup, Function1<Object, R> callback) {
        return (R)PersistenceSupport.sqlSet$(this, sqlStatement, setup, callback);
    }

    @Override
    public Function1<Object, BoxedUnit> checkCiUpdated(String entityId) {
        return PersistenceSupport.checkCiUpdated$(this, entityId);
    }

    @Override
    public Function1<Object, UUID> checkCiUpdated(Integer uid, Option<UUID> token, UUID freshToken) {
        return PersistenceSupport.checkCiUpdated$(this, uid, token, freshToken);
    }

    @Override
    public Function1<Object, BoxedUnit> checkCiDeleted(Integer uid) {
        return PersistenceSupport.checkCiDeleted$(this, uid);
    }

    @Override
    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, RowMapper<R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, mapper);
    }

    @Override
    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, Function1<ResultSet, R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlQuery(String sqlStatement, Map<String, Object> params, ResultSetExtractor<R> extractor) {
        return (R)PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, extractor);
    }

    @Override
    public Seq<Object> sqlBatch(String sqlStatement, Set<Map<String, Object>> parameters) {
        return PersistenceSupport.sqlBatch$(this, sqlStatement, parameters);
    }

    @Override
    public Seq<Object> sqlBatchWithContent(String sqlStatement, Seq<Tuple2<Map<String, Object>, Tuple2<String, String>>> params) {
        return PersistenceSupport.sqlBatchWithContent$(this, sqlStatement, params);
    }

    @Override
    public String pkName(String pkColumn) {
        return PersistenceSupport.pkName$(this, pkColumn);
    }

    @Override
    public byte[] compress(String text) {
        return CompressionSupport.compress$((CompressionSupport)this, text);
    }

    @Override
    public String decompress(InputStream inputStream) {
        return CompressionSupport.decompress$((CompressionSupport)this, inputStream);
    }

    @Override
    public byte[] compress(byte[] byteArray) {
        return CompressionSupport.compress$((CompressionSupport)this, byteArray);
    }

    @Override
    public byte[] decompress(byte[] byteArray) {
        return CompressionSupport.decompress$((CompressionSupport)this, byteArray);
    }

    @Override
    public <A> Option<A> findOptional(Function1<JdbcTemplate, A> body, JdbcTemplate jdbcTemplate) {
        return Utils.findOptional$(this, body, jdbcTemplate);
    }

    @Override
    public <A> Option<A> findOne(Function0<Buffer<A>> body) {
        return Utils.findOne$(this, body);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DependencyPersistence dependencyPersistence = this;
        synchronized (dependencyPersistence) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private NamedParameterJdbcTemplate namedTemplate$lzycompute() {
        DependencyPersistence dependencyPersistence = this;
        synchronized (dependencyPersistence) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.namedTemplate = PersistenceSupport.namedTemplate$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.namedTemplate;
    }

    @Override
    public NamedParameterJdbcTemplate namedTemplate() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.namedTemplate$lzycompute() : this.namedTemplate;
    }

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    private <T> Tuple2<String, Object[]> varargs(Iterable<T> args) {
        Seq seq = args.toSeq();
        Tuple2 tuple2 = new Tuple2((Object)((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)x$1 -> "?", Seq$.MODULE$.canBuildFrom())).mkString(", "), ((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.AnyRef()));
        return tuple2;
    }

    private Tuple2<String, Object[]> filterStatus(Option<Set<String>> status) {
        return (Tuple2)status.fold((Function0 & Serializable & scala.Serializable)() -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), Array$.MODULE$.empty(ClassTag$.MODULE$.AnyRef())), (Function1 & Serializable & scala.Serializable)statuses -> {
            Tuple2<String, Object[]> tuple2 = this.varargs((Iterable)statuses);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String placeholdersStatus = (String)tuple2._1();
            Object[] argsStatus = (Object[])tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AND d.", " IN (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema$DEPENDENCIES$.MODULE$.GATE_STATUS(), placeholdersStatus}))), (Object)argsStatus);
            return tuple22;
        });
    }

    private RowMapper<DependencyRow> defaultMapper() {
        return this.defaultMapper;
    }

    private String defaultQuery() {
        return this.defaultQuery;
    }

    private String STMT_FIND_BY_GATE_RELEASE_ID() {
        return this.STMT_FIND_BY_GATE_RELEASE_ID;
    }

    private String findTaskCiUid() {
        return this.findTaskCiUid;
    }

    private String taskIdHash(String taskId) {
        return TaskPersistence$.MODULE$.hash(Ids.getFolderlessId((String)taskId));
    }

    public Seq<DependencyRow> findByGateReleaseId(String releaseId) {
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Find dependencies by gate releaseId: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})));
        return this.sqlQuery(this.STMT_FIND_BY_GATE_RELEASE_ID(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"releaseId"), (Object)Ids.getName((String)CiId$.MODULE$.RichCiId(releaseId).normalized()))})), this.defaultMapper());
    }

    public Seq<DependencyRow> findByPartialTargetIds(Set<String> parentIds, Option<Set<String>> status) {
        Nil$ nil$;
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Find dependencies by targetIds starting with ", " with statuses ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parentIds, status})));
        if (parentIds.isEmpty()) {
            nil$ = Nil$.MODULE$;
        } else {
            String clause = ((TraversableOnce)parentIds.map((Function1 & Serializable & scala.Serializable)id -> {
                Tuple2 tuple2 = new Tuple2((Object)Ids.getReleaselessChildId((String)CiId$.MODULE$.RichCiId((String)id).normalized()), (Object)Ids.getName((String)Ids.releaseIdFrom((String)CiId$.MODULE$.RichCiId((String)id).normalized())));
                if (tuple2 != null) {
                    String string = (String)tuple2._1();
                    String releaseId = (String)tuple2._2();
                    if (string == null) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t.", " LIKE '", "%'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema$RELEASES$.MODULE$.RELEASE_ID(), releaseId}));
                    }
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                String targetId = (String)tuple2._1();
                String releaseId = (String)tuple2._2();
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d.", " LIKE '", "%' AND t.", " = '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema$DEPENDENCIES$.MODULE$.TARGET_ID(), targetId, Schema$RELEASES$.MODULE$.RELEASE_ID(), releaseId}));
            }, Set$.MODULE$.canBuildFrom())).mkString("(", " OR ", ")");
            Tuple2<String, Object[]> tuple2 = this.filterStatus(status);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String statusClause = (String)tuple2._1();
            Object[] args = (Object[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)statusClause, (Object)args);
            Tuple2 tuple23 = tuple22;
            String statusClause2 = (String)tuple23._1();
            Object[] args2 = (Object[])tuple23._2();
            nil$ = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().query(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\n           |  WHERE ", "\n           |  ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.defaultQuery(), clause, statusClause2})))).stripMargin(), args2, this.defaultMapper())).asScala();
        }
        return nil$;
    }

    private String STMT_FIND_BY_ID() {
        return this.STMT_FIND_BY_ID;
    }

    public DependencyRow findById(String dependencyId) {
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Find dependency by id: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependencyId})));
        return (DependencyRow)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (DependencyRow)this.sqlQuery(this.STMT_FIND_BY_ID(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dependencyId"), (Object)Ids.getName((String)dependencyId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"taskIdHash"), (Object)this.taskIdHash(Ids.getParentId((String)CiId$.MODULE$.RichCiId(dependencyId).normalized())))})), this.defaultMapper()).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dependency with Id '", "' not found."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependencyId})), new Object[0]);
        })).recoverWith((PartialFunction)new scala.Serializable(null, dependencyId){
            public static final long serialVersionUID = 0L;
            private final String dependencyId$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof EmptyResultDataAccessException) {
                    EmptyResultDataAccessException emptyResultDataAccessException = (EmptyResultDataAccessException)A1;
                    object = new Failure((Throwable)new NotFoundException((Throwable)emptyResultDataAccessException, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dependency with Id '", "' not found."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dependencyId$2})), new Object[0]));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof EmptyResultDataAccessException;
                return bl;
            }
            {
                this.dependencyId$2 = dependencyId$2;
            }
        }).fold((Function1 & Serializable & scala.Serializable)x$6 -> {
            throw x$6;
        }, (Function1 & Serializable & scala.Serializable)x -> (DependencyRow)Predef$.MODULE$.identity(x));
    }

    private String STMT_GET_TARGET_ID() {
        return this.STMT_GET_TARGET_ID;
    }

    public Option<String> getTargetId(String dependencyId) {
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading targetId of a dependency ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependencyId})));
        return this.sqlQuery(this.STMT_GET_TARGET_ID(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dependencyId"), (Object)Ids.getName((String)dependencyId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"taskIdHash"), (Object)this.taskIdHash(Ids.getParentId((String)CiId$.MODULE$.RichCiId(dependencyId).normalized())))})), (Function1 & Serializable & scala.Serializable)rs -> (String)TargetRow$TargetRowOps$.MODULE$.getTargetId$extension(TargetRow$.MODULE$.TargetRowOps(TargetRow$.MODULE$.apply(rs.getString(Schema$FOLDERS$.MODULE$.FOLDER_PATH()), rs.getString(Schema$FOLDERS$.MODULE$.FOLDER_ID()), rs.getString(Schema$RELEASES$.MODULE$.RELEASE_ID()), rs.getString(Schema$DEPENDENCIES$.MODULE$.TARGET_ID())))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).headOption();
    }

    public Seq<DependencyRow> findByTargetIds(Set<String> targetIds, Option<Set<String>> status) {
        Nil$ nil$;
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Find dependencies by targetIds: ", " with statuses ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetIds, status})));
        if (targetIds.isEmpty()) {
            nil$ = Nil$.MODULE$;
        } else {
            String clause = ((TraversableOnce)targetIds.map((Function1 & Serializable & scala.Serializable)id -> {
                Tuple2 tuple2 = new Tuple2((Object)Ids.getReleaselessChildId((String)CiId$.MODULE$.RichCiId((String)id).normalized()), (Object)Ids.getName((String)Ids.releaseIdFrom((String)id)));
                if (tuple2 != null) {
                    String string = (String)tuple2._1();
                    String releaseId = (String)tuple2._2();
                    if (string == null) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d.", " is NULL AND t.", " = '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema$DEPENDENCIES$.MODULE$.TARGET_ID(), Schema$RELEASES$.MODULE$.RELEASE_ID(), releaseId}));
                    }
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                String targetId = (String)tuple2._1();
                String releaseId = (String)tuple2._2();
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d.", " = '", "' AND t.", " = '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema$DEPENDENCIES$.MODULE$.TARGET_ID(), targetId, Schema$RELEASES$.MODULE$.RELEASE_ID(), releaseId}));
            }, Set$.MODULE$.canBuildFrom())).mkString("(", " OR ", ")");
            Tuple2<String, Object[]> tuple2 = this.filterStatus(status);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String statusQuery = (String)tuple2._1();
            Object[] statusArgs = (Object[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)statusQuery, (Object)statusArgs);
            Tuple2 tuple23 = tuple22;
            String statusQuery2 = (String)tuple23._1();
            Object[] statusArgs2 = (Object[])tuple23._2();
            nil$ = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().query(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\n           |  WHERE ", "\n           |  ", "\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.defaultQuery(), clause, statusQuery2})))).stripMargin(), statusArgs2, this.defaultMapper())).asScala();
        }
        return nil$;
    }

    private String STMT_INSERT_DEPENDENCY() {
        return this.STMT_INSERT_DEPENDENCY;
    }

    public void insertDependency(Dependency dependency) {
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Inserting dependency ", " of Gate ", " to Target ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependency.getId(), dependency.getGateTask().getId(), dependency.getTargetId()})));
        Tuple2<String, String> tuple2 = this.getTargets(dependency);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String targetId = (String)tuple2._1();
        String targetReleaseId = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)targetId, (Object)targetReleaseId);
        Tuple2 tuple23 = tuple22;
        String targetId2 = (String)tuple23._1();
        String targetReleaseId2 = (String)tuple23._2();
        this.sqlExec(this.STMT_INSERT_DEPENDENCY(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dependencyId"), (Object)Ids.getName((String)dependency.getId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"taskIdHash"), (Object)this.taskIdHash(Ids.getParentId((String)CiId$.MODULE$.RichCiId(dependency.getId()).normalized()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"gateStatus"), (Object)dependency.getGateTask().getStatus().name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetId"), (Object)targetId2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetReleaseId"), Option$.MODULE$.apply((Object)targetReleaseId2).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""))})), ps -> {
            DependencyPersistence.$anonfun$insertDependency$3(dependency, ps);
            return BoxedUnit.UNIT;
        });
    }

    private String STMT_INSERT_DEPENDENCY_WITH_GATE_TASK_UID() {
        return this.STMT_INSERT_DEPENDENCY_WITH_GATE_TASK_UID;
    }

    public void insertDependencyWithGateTaskUid(Integer gateTaskUid, Dependency dependency) {
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Inserting dependency ", " of Gate ", " to Target ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependency.getId(), dependency.getGateTask().getId(), dependency.getTargetId()})));
        Tuple2<String, String> tuple2 = this.getTargets(dependency);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String targetId = (String)tuple2._1();
        String targetReleaseId = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)targetId, (Object)targetReleaseId);
        Tuple2 tuple23 = tuple22;
        String targetId2 = (String)tuple23._1();
        String targetReleaseId2 = (String)tuple23._2();
        this.sqlExec(this.STMT_INSERT_DEPENDENCY_WITH_GATE_TASK_UID(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dependencyId"), (Object)Ids.getName((String)dependency.getId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"gateTaskUid"), (Object)gateTaskUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"gateStatus"), (Object)dependency.getGateTask().getStatus().name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetId"), (Object)targetId2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetReleaseId"), Option$.MODULE$.apply((Object)targetReleaseId2).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""))})), ps -> {
            DependencyPersistence.$anonfun$insertDependencyWithGateTaskUid$3(dependency, ps);
            return BoxedUnit.UNIT;
        });
    }

    private String STMT_DELETE() {
        return this.STMT_DELETE;
    }

    public void deleteDependency(String id) {
        this.sqlUpdate(this.STMT_DELETE(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dependencyId"), (Object)Ids.getName((String)id)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"taskIdHash"), (Object)this.taskIdHash(Ids.getParentId((String)CiId$.MODULE$.RichCiId(id).normalized())))})), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$12 -> {});
    }

    public void deleteDependency(Dependency dependency) {
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting dependency ", " of Gate ", " to Target ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependency.getId(), dependency.getGateTask().getId(), dependency.getTargetId()})));
        this.deleteDependency(dependency.getId());
    }

    private String STMT_DELETE_BY_RELEASE_UID() {
        return this.STMT_DELETE_BY_RELEASE_UID;
    }

    public boolean deleteByReleaseUid(Integer releaseUid) {
        return BoxesRunTime.unboxToBoolean(this.sqlUpdate(this.STMT_DELETE_BY_RELEASE_UID(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"releaseUid"), (Object)releaseUid)})), (Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$13 -> x$13 != 0));
    }

    private String STMT_UPDATE() {
        return this.STMT_UPDATE;
    }

    public void updateDependency(Dependency dependency) {
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updating dependency ", " of Gate ", " to Target ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependency.getId(), dependency.getGateTask().getId(), dependency.getTargetId()})));
        Tuple2<String, String> tuple2 = this.getTargets(dependency);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String targetId = (String)tuple2._1();
        String targetReleaseId = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)targetId, (Object)targetReleaseId);
        Tuple2 tuple23 = tuple22;
        String targetId2 = (String)tuple23._1();
        String targetReleaseId2 = (String)tuple23._2();
        this.sqlExec(this.STMT_UPDATE(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"gateStatus"), (Object)dependency.getGateTask().getStatus().name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetId"), (Object)targetId2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetReleaseId"), Option$.MODULE$.apply((Object)targetReleaseId2).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dependencyId"), (Object)Ids.getName((String)dependency.getId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"taskIdHash"), (Object)this.taskIdHash(Ids.getParentId((String)CiId$.MODULE$.RichCiId(dependency.getId()).normalized())))})), ps -> {
            DependencyPersistence.$anonfun$updateDependency$3(dependency, ps);
            return BoxedUnit.UNIT;
        });
    }

    private Tuple2<String, String> getTargets(Dependency dependency) {
        String targetId = CiId$.MODULE$.RichCiId(dependency.getTargetId()).normalized();
        return !dependency.hasVariableTarget() && !dependency.isArchived() ? (Ids.isReleaseId((String)targetId) ? new Tuple2(null, (Object)Ids.getName((String)targetId)) : (Tuple2)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)Ids.getReleaselessChildId((String)targetId), (Object)Ids.getName((String)Ids.releaseIdFrom((String)targetId)))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)targetId, null))) : new Tuple2((Object)targetId, null);
    }

    public static final /* synthetic */ void $anonfun$insertDependency$6(boolean x$9) {
    }

    public static final /* synthetic */ void $anonfun$insertDependency$3(Dependency dependency$2, PreparedStatement ps) {
        Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ps.execute()).fold((Function1 & Serializable & scala.Serializable)t -> {
            throw new ReleaseStoreException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to insert dependency ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependency$2.getId()})), (Throwable)t);
        }, (Function1 & Serializable & scala.Serializable)x$9 -> {
            DependencyPersistence.$anonfun$insertDependency$6(BoxesRunTime.unboxToBoolean((Object)x$9));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$insertDependencyWithGateTaskUid$6(boolean x$11) {
    }

    public static final /* synthetic */ void $anonfun$insertDependencyWithGateTaskUid$3(Dependency dependency$1, PreparedStatement ps) {
        Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ps.execute()).fold((Function1 & Serializable & scala.Serializable)t -> {
            throw new ReleaseStoreException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to insert dependency ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependency$1.getId()})), (Throwable)t);
        }, (Function1 & Serializable & scala.Serializable)x$11 -> {
            DependencyPersistence.$anonfun$insertDependencyWithGateTaskUid$6(BoxesRunTime.unboxToBoolean((Object)x$11));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$updateDependency$3(Dependency dependency$3, PreparedStatement ps) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ps.executeUpdate());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            int n = BoxesRunTime.unboxToInt((Object)success.value());
            if (n == 0) {
                throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find dependency to update by ID ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependency$3.getId()})), new Object[0]);
            }
        } else {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                throw new ReleaseStoreException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to update dependency ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependency$3.getId()})), ex);
            }
            throw new MatchError((Object)try_);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Autowired
    public DependencyPersistence(@Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="xlrRepositorySqlDialect") SqlBuilder.Dialect dialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        Utils.$init$(this);
        CompressionSupport.$init$(this);
        PersistenceSupport.$init$(this);
        Logging.$init$((Logging)this);
        this.defaultMapper = (rs, x$3) -> DependencyRow$.MODULE$.apply(FolderId$.MODULE$.$div$extension(FolderId$.MODULE$.apply(rs.getString(Schema$FOLDERS$.MODULE$.FOLDER_PATH())), rs.getString(Schema$FOLDERS$.MODULE$.FOLDER_ID())), rs.getString(Schema$TASKS$.MODULE$.TASK_ID()), rs.getString(Schema$DEPENDENCIES$.MODULE$.DEPENDENCY_ID()), rs.getString(Schema$DEPENDENCIES$.MODULE$.GATE_STATUS()), (Option<String>)Option$.MODULE$.apply((Object)rs.getString(Schema$DEPENDENCIES$.MODULE$.TARGET_RELEASE_ID())).map((Function1 & Serializable & scala.Serializable)x$4 -> FolderId$.MODULE$.absolute$extension(FolderId$.MODULE$.apply((String)x$4))), rs.getString(Schema$DEPENDENCIES$.MODULE$.TARGET_ID()));
        this.defaultQuery = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT\n       | fr.", ",\n       | fr.", ",\n       | k.", ",\n       | d.", ",\n       | d.", ",\n       | d.", ",\n       | ", "\n       |  FROM ", " d\n       |  JOIN ", " k ON\n       |    k.", " = d.", "\n       |  JOIN ", " r ON\n       |    r.", " = k.", "\n       |  JOIN ", " fr ON\n       |    fr.", " = r.", "\n       |  JOIN ", " t ON\n       |    t.", " = d.", "\n       |  JOIN ", " ft ON\n       |    ft.", " = t.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema$FOLDERS$.MODULE$.FOLDER_PATH(), Schema$FOLDERS$.MODULE$.FOLDER_ID(), Schema$TASKS$.MODULE$.TASK_ID(), Schema$DEPENDENCIES$.MODULE$.DEPENDENCY_ID(), Schema$DEPENDENCIES$.MODULE$.GATE_STATUS(), Schema$DEPENDENCIES$.MODULE$.TARGET_ID(), ReleasesSqlBuilder$.MODULE$.selectReleaseFullPathSql("t", "ft", Schema$DEPENDENCIES$.MODULE$.TARGET_RELEASE_ID(), dialect), Schema$DEPENDENCIES$.MODULE$.TABLE(), Schema$TASKS$.MODULE$.TABLE(), Schema$TASKS$.MODULE$.CI_UID(), Schema$DEPENDENCIES$.MODULE$.GATE_TASK_UID(), Schema$RELEASES$.MODULE$.TABLE(), Schema$RELEASES$.MODULE$.CI_UID(), Schema$TASKS$.MODULE$.RELEASE_UID(), Schema$FOLDERS$.MODULE$.TABLE(), Schema$FOLDERS$.MODULE$.CI_UID(), Schema$RELEASES$.MODULE$.FOLDER_CI_UID(), Schema$RELEASES$.MODULE$.TABLE(), Schema$RELEASES$.MODULE$.CI_UID(), Schema$DEPENDENCIES$.MODULE$.TARGET_RELEASE_UID(), Schema$FOLDERS$.MODULE$.TABLE(), Schema$FOLDERS$.MODULE$.CI_UID(), Schema$RELEASES$.MODULE$.FOLDER_CI_UID()})))).stripMargin();
        this.STMT_FIND_BY_GATE_RELEASE_ID = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\n       |  WHERE\n       |    r.", " = :releaseId"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.defaultQuery(), Schema$RELEASES$.MODULE$.RELEASE_ID()})))).stripMargin();
        this.findTaskCiUid = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(SELECT ", " FROM ", " WHERE ", " = :taskIdHash)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema$TASKS$.MODULE$.CI_UID(), Schema$TASKS$.MODULE$.TABLE(), Schema$TASKS$.MODULE$.TASK_ID_HASH()}));
        this.STMT_FIND_BY_ID = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\n       |  WHERE\n       |    d.", " = :dependencyId\n       |    AND d.", " = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.defaultQuery(), Schema$DEPENDENCIES$.MODULE$.DEPENDENCY_ID(), Schema$DEPENDENCIES$.MODULE$.GATE_TASK_UID(), this.findTaskCiUid()})))).stripMargin();
        this.STMT_GET_TARGET_ID = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT\n       |  f.", ",\n       |  f.", ",\n       |  r.", ",\n       |  d.", "\n       |  FROM ", " d\n       |  LEFT OUTER JOIN ", " r ON r.", " = d.", "\n       |  LEFT OUTER JOIN ", " f ON f.", " = r.", "\n       |  WHERE ", " = :dependencyId\n       |  AND d.", " = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema$FOLDERS$.MODULE$.FOLDER_PATH(), Schema$FOLDERS$.MODULE$.FOLDER_ID(), Schema$RELEASES$.MODULE$.RELEASE_ID(), Schema$DEPENDENCIES$.MODULE$.TARGET_ID(), Schema$DEPENDENCIES$.MODULE$.TABLE(), Schema$RELEASES$.MODULE$.TABLE(), Schema$RELEASES$.MODULE$.CI_UID(), Schema$DEPENDENCIES$.MODULE$.TARGET_RELEASE_UID(), Schema$FOLDERS$.MODULE$.TABLE(), Schema$FOLDERS$.MODULE$.CI_UID(), Schema$RELEASES$.MODULE$.FOLDER_CI_UID(), Schema$DEPENDENCIES$.MODULE$.DEPENDENCY_ID(), Schema$DEPENDENCIES$.MODULE$.GATE_TASK_UID(), this.findTaskCiUid()})))).stripMargin();
        this.STMT_INSERT_DEPENDENCY = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", " (\n       | ", ",\n       | ", ",\n       | ", ",\n       | ", ",\n       | ", "\n       |) VALUES (\n       |  :dependencyId,\n       |  ", ",\n       |  :gateStatus,\n       |  :targetId,\n       |  (SELECT r.", " FROM ", " r WHERE r.", " = :targetReleaseId)\n       |)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema$DEPENDENCIES$.MODULE$.TABLE(), Schema$DEPENDENCIES$.MODULE$.DEPENDENCY_ID(), Schema$DEPENDENCIES$.MODULE$.GATE_TASK_UID(), Schema$DEPENDENCIES$.MODULE$.GATE_STATUS(), Schema$DEPENDENCIES$.MODULE$.TARGET_ID(), Schema$DEPENDENCIES$.MODULE$.TARGET_RELEASE_UID(), this.findTaskCiUid(), Schema$RELEASES$.MODULE$.CI_UID(), Schema$RELEASES$.MODULE$.TABLE(), Schema$RELEASES$.MODULE$.RELEASE_ID()})))).stripMargin();
        this.STMT_INSERT_DEPENDENCY_WITH_GATE_TASK_UID = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", " (\n       | ", ",\n       | ", ",\n       | ", ",\n       | ", ",\n       | ", "\n       |) VALUES (\n       |  :dependencyId,\n       |  :gateTaskUid,\n       |  :gateStatus,\n       |  :targetId,\n       |  (SELECT r.", " FROM ", " r WHERE r.", " = :targetReleaseId)\n       |)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema$DEPENDENCIES$.MODULE$.TABLE(), Schema$DEPENDENCIES$.MODULE$.DEPENDENCY_ID(), Schema$DEPENDENCIES$.MODULE$.GATE_TASK_UID(), Schema$DEPENDENCIES$.MODULE$.GATE_STATUS(), Schema$DEPENDENCIES$.MODULE$.TARGET_ID(), Schema$DEPENDENCIES$.MODULE$.TARGET_RELEASE_UID(), Schema$RELEASES$.MODULE$.CI_UID(), Schema$RELEASES$.MODULE$.TABLE(), Schema$RELEASES$.MODULE$.RELEASE_ID()})))).stripMargin();
        this.STMT_DELETE = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM ", "\n       | WHERE\n       |  ", " = :dependencyId\n       |  AND ", " = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema$DEPENDENCIES$.MODULE$.TABLE(), Schema$DEPENDENCIES$.MODULE$.DEPENDENCY_ID(), Schema$DEPENDENCIES$.MODULE$.GATE_TASK_UID(), this.findTaskCiUid()})))).stripMargin();
        this.STMT_DELETE_BY_RELEASE_UID = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM ", "\n       | WHERE\n       |  ", " = :releaseUid OR EXISTS (\n       |    SELECT 1 FROM ", " t\n       |    WHERE t.", " = ", " AND t.", " = :releaseUid\n       |)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema$DEPENDENCIES$.MODULE$.TABLE(), Schema$DEPENDENCIES$.MODULE$.TARGET_RELEASE_UID(), Schema$TASKS$.MODULE$.TABLE(), Schema$TASKS$.MODULE$.CI_UID(), Schema$DEPENDENCIES$.MODULE$.GATE_TASK_UID(), Schema$TASKS$.MODULE$.RELEASE_UID()})))).stripMargin();
        this.STMT_UPDATE = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UPDATE ", "\n       | SET\n       |  ", " = :gateStatus,\n       |  ", " = :targetId,\n       |  ", " =\n       |   (SELECT r.", " FROM ", " r WHERE r.", " = :targetReleaseId)\n       |  WHERE\n       |    ", " = :dependencyId\n       |    AND ", " = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema$DEPENDENCIES$.MODULE$.TABLE(), Schema$DEPENDENCIES$.MODULE$.GATE_STATUS(), Schema$DEPENDENCIES$.MODULE$.TARGET_ID(), Schema$DEPENDENCIES$.MODULE$.TARGET_RELEASE_UID(), Schema$RELEASES$.MODULE$.CI_UID(), Schema$RELEASES$.MODULE$.TABLE(), Schema$RELEASES$.MODULE$.RELEASE_ID(), Schema$DEPENDENCIES$.MODULE$.DEPENDENCY_ID(), Schema$DEPENDENCIES$.MODULE$.GATE_TASK_UID(), this.findTaskCiUid()})))).stripMargin();
    }
}

