/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.internal.ReleaseGlobalAndFolderVariablesDecorator$;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.TasksUnionSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.service.SqlTasksFilterSupport$;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.service.TaskSearchService;
import com.xebialabs.xlrelease.views.ReleaseTasks;
import com.xebialabs.xlrelease.views.TaskSearchView;
import com.xebialabs.xlrelease.views.TasksFilters;
import com.xebialabs.xlrelease.views.converters.TasksViewConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u0005a\u0001B\u0001\u0003\u0001-\u0011AcU9m)\u0006\u001c8nU3be\u000eD7+\u001a:wS\u000e,'BA\u0002\u0005\u0003\u001d\u0019XM\u001d<jG\u0016T!!\u0002\u0004\u0002\u0013ad'/\u001a7fCN,'BA\u0004\t\u0003%AXMY5bY\u0006\u00147OC\u0001\n\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001A\u0002\u0006\r\u0011\u00055\u0011R\"\u0001\b\u000b\u0005=\u0001\u0012\u0001\u00027b]\u001eT\u0011!E\u0001\u0005U\u00064\u0018-\u0003\u0002\u0014\u001d\t1qJ\u00196fGR\u0004\"!\u0006\f\u000e\u0003\tI!a\u0006\u0002\u0003#Q\u000b7o[*fCJ\u001c\u0007nU3sm&\u001cW\r\u0005\u0002\u001a=5\t!D\u0003\u0002\u001c9\u0005)1\u000f\u001c45U*\tQ$\u0001\u0005he&T(\u0010\\3e\u0013\ty\"DA\u0004M_\u001e<\u0017N\\4\t\u0011\u0005\u0002!\u0011!Q\u0001\n\t\n1B]8mKN+'O^5dKB\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\tg\u0016\u001cWO]5us*\u0011qEB\u0001\tI\u0016\u0004Hn\\=ji&\u0011\u0011\u0006\n\u0002\f%>dWmU3sm&\u001cW\r\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0003E!\u0018m]6BG\u000e,7o]*feZL7-\u001a\t\u0003+5J!A\f\u0002\u0003#Q\u000b7o[!dG\u0016\u001c8oU3sm&\u001cW\r\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0003I!\u0018m]6t-&,woQ8om\u0016\u0014H/\u001a:\u0011\u0005I:T\"A\u001a\u000b\u0005Q*\u0014AC2p]Z,'\u000f^3sg*\u0011a\u0007B\u0001\u0006m&,wo]\u0005\u0003qM\u0012!\u0003V1tWN4\u0016.Z<D_:4XM\u001d;fe\"A!\b\u0001B\u0001B\u0003%1(\u0001\teK\u000e|'/\u0019;peN+'O^5dKB\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\tS:$XM\u001d8bY*\u0011\u0001\tB\u0001\u0004CBL\u0017B\u0001\">\u0005\u0001Je\u000e^3s]\u0006dW*\u001a;bI\u0006$\u0018\rR3d_J\fGo\u001c:TKJ4\u0018nY3\t\u0011\u0011\u0003!\u0011!Q\u0001\n\u0015\u000b!C]3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dKB\u0011a)T\u0007\u0002\u000f*\u0011\u0001*S\u0001\fa\u0016\u00148/[:uK:\u001cWM\u0003\u0002K\u0017\u0006\u00191/\u001d7\u000b\u00051#\u0011A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011aj\u0012\u0002\u0013%\u0016dW-Y:f!\u0016\u00148/[:uK:\u001cW\r\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003R\u0003=!\u0018m]6QKJ\u001c\u0018n\u001d;f]\u000e,\u0007C\u0001$S\u0013\t\u0019vIA\bUCN\\\u0007+\u001a:tSN$XM\\2f\u0011!)\u0006A!A!\u0002\u00131\u0016AE2p[6,g\u000e\u001e)feNL7\u000f^3oG\u0016\u0004\"AR,\n\u0005a;%AE\"p[6,g\u000e\u001e)feNL7\u000f^3oG\u0016D\u0001B\u0017\u0001\u0003\u0006\u0004%\taW\u0001\u0012e\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014X#\u0001/\u0011\u0005usV\"A%\n\u0005}K%\u0001F*rYJ+\u0007o\\:ji>\u0014\u00180\u00113baR,'\u000f\u0003\u0005b\u0001\t\u0005\t\u0015!\u0003]\u0003I\u0011X\r]8tSR|'/_!eCB$XM\u001d\u0011\t\u0011\r\u0004!Q1A\u0005\u0004\u0011\f!\u0003]3s[&\u001c8/[8o\u000b:4wN]2feV\tQ\r\u0005\u0002$M&\u0011q\r\n\u0002\u0013!\u0016\u0014X.[:tS>tWI\u001c4pe\u000e,'\u000f\u0003\u0005j\u0001\t\u0005\t\u0015!\u0003f\u0003M\u0001XM]7jgNLwN\\#oM>\u00148-\u001a:!\u0011!Y\u0007A!b\u0001\n\u0007a\u0017AC:rY\u0012K\u0017\r\\3diV\tQ\u000eE\u0002o\u0003\u0007q!a\u001c@\u000f\u0005AdhBA9{\u001d\t\u0011\u0018P\u0004\u0002tq:\u0011Ao^\u0007\u0002k*\u0011aOC\u0001\u0007yI|w\u000e\u001e \n\u0003%I!a\u0002\u0005\n\u0005\u00151\u0011BA>\u0005\u0003\t!'-\u0003\u0002K{*\u00111\u0010B\u0005\u0004\u007f\u0006\u0005\u0011AC*rY\n+\u0018\u000e\u001c3fe*\u0011!*`\u0005\u0005\u0003\u000b\t9AA\u0004ES\u0006dWm\u0019;\u000b\u0007}\f\t\u0001C\u0005\u0002\f\u0001\u0011\t\u0011)A\u0005[\u0006Y1/\u001d7ES\u0006dWm\u0019;!\u0011\u001d\ty\u0001\u0001C\u0001\u0003#\ta\u0001P5oSRtDCFA\n\u0003+\t9\"!\u0007\u0002\u001c\u0005u\u0011qDA\u0011\u0003G\t)#a\n\u0011\u0005U\u0001\u0001BB\u0011\u0002\u000e\u0001\u0007!\u0005\u0003\u0004,\u0003\u001b\u0001\r\u0001\f\u0005\u0007a\u00055\u0001\u0019A\u0019\t\ri\ni\u00011\u0001<\u0011\u0019!\u0015Q\u0002a\u0001\u000b\"1\u0001+!\u0004A\u0002ECa!VA\u0007\u0001\u00041\u0006B\u0002.\u0002\u000e\u0001\u0007A\f\u0003\u0004d\u0003\u001b\u0001\u001d!\u001a\u0005\u0007W\u00065\u00019A7\t\u000f\u0005-\u0002\u0001\"\u0011\u0002.\u0005\tr-\u001a;UCN\\7OQ=SK2,\u0017m]3\u0015\r\u0005=\u0012qGA!!\u0011\t\t$a\r\u000e\u0003UJ1!!\u000e6\u00059!\u0016m]6TK\u0006\u00148\r\u001b,jK^D\u0001\"!\u000f\u0002*\u0001\u0007\u00111H\u0001\ri\u0006\u001c8n\u001d$jYR,'o\u001d\t\u0005\u0003c\ti$C\u0002\u0002@U\u0012A\u0002V1tWN4\u0015\u000e\u001c;feND\u0001\"a\u0011\u0002*\u0001\u0007\u0011QI\u0001\u0015Y&l\u0017\u000e\u001e+bg.\u001c\b*\u001b8u\u001fB$\u0018n\u001c8\u0011\u00075\t9%C\u0002\u0002J9\u0011q!\u00138uK\u001e,'\u000f\u000b\u0003\u0002*\u00055\u0003\u0003BA(\u0003;j!!!\u0015\u000b\t\u0005M\u0013QK\u0001\u000bC:tw\u000e^1uS>t'\u0002BA,\u00033\nq!\\3ue&\u001c7OC\u0002\u0002\\!\t\u0001bY8eC\"\fG.Z\u0005\u0005\u0003?\n\tFA\u0003US6,G\rC\u0004\u0002d\u0001!I!!\u001a\u0002\tQLW.Z\u000b\u0005\u0003O\ny\u0007\u0006\u0003\u0002j\u0005EE\u0003BA6\u0003\u000f\u0003B!!\u001c\u0002p1\u0001A\u0001CA9\u0003C\u0012\r!a\u001d\u0003\u0003\u0005\u000bB!!\u001e\u0002\u0002B!\u0011qOA?\u001b\t\tIH\u0003\u0002\u0002|\u0005)1oY1mC&!\u0011qPA=\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!a\u001e\u0002\u0004&!\u0011QQA=\u0005\r\te.\u001f\u0005\n\u0003\u0013\u000b\t\u0007\"a\u0001\u0003\u0017\u000bQA\u00197pG.\u0004b!a\u001e\u0002\u000e\u0006-\u0014\u0002BAH\u0003s\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\t\u0003'\u000b\t\u00071\u0001\u0002\u0016\u0006!A-Z:d!\u0011\t9*a(\u000f\t\u0005e\u00151\u0014\t\u0004i\u0006e\u0014\u0002BAO\u0003s\na\u0001\u0015:fI\u00164\u0017\u0002BAQ\u0003G\u0013aa\u0015;sS:<'\u0002BAO\u0003sBq!a*\u0001\t\u0013\tI+\u0001\nt_J$()\u001f*fY\u0016\f7/\u001a+ji2,G\u0003BAV\u0003{\u0003b!!,\u00024\u0006]VBAAX\u0015\r\t\t\fE\u0001\u0005kRLG.\u0003\u0003\u00026\u0006=&\u0001\u0002'jgR\u0004B!!\r\u0002:&\u0019\u00111X\u001b\u0003\u0019I+G.Z1tKR\u000b7o[:\t\u0011\u0005}\u0016Q\u0015a\u0001\u0003\u0003\fQB]3mK\u0006\u001cXm\u001d+bg.\u001c\bCBAb\u0003\u001b\f9L\u0004\u0003\u0002F\u0006%gb\u0001;\u0002H&\u0011\u00111P\u0005\u0005\u0003\u0017\fI(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\u0017\u0011\u001b\u0002\u0004'\u0016\f(\u0002BAf\u0003sBq!!6\u0001\t\u0013\t9.A\u0007tK\u0006\u00148\r\u001b+bg.LEm\u001d\u000b\u0007\u00033\f)0a>\u0011\r\u0005\r\u0017QZAn!\u0011\ti.a<\u000f\t\u0005}\u00171\u001e\b\u0005\u0003C\fIO\u0004\u0003\u0002d\u0006\u001dhbA9\u0002f&\u0011A\nB\u0005\u0003\u0015.K!\u0001S%\n\u0007\u00055x)\u0001\u0003DS&#\u0017\u0002BAy\u0003g\u0014AaQ5JI*\u0019\u0011Q^$\t\u0011\u0005e\u00121\u001ba\u0001\u0003wA\u0001\"!?\u0002T\u0002\u0007\u00111`\u0001\u0006Y&l\u0017\u000e\u001e\t\u0005\u0003o\ni0\u0003\u0003\u0002\u0000\u0006e$aA%oi\u0002")
public class SqlTaskSearchService
implements TaskSearchService,
Logging {
    private final RoleService roleService;
    private final TaskAccessService taskAccessService;
    private final TasksViewConverter tasksViewConverter;
    private final InternalMetadataDecoratorService decoratorService;
    private final ReleasePersistence releasePersistence;
    private final TaskPersistence taskPersistence;
    private final CommentPersistence commentPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final PermissionEnforcer permissionEnforcer;
    private final SqlBuilder.Dialect sqlDialect;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTaskSearchService sqlTaskSearchService = this;
        synchronized (sqlTaskSearchService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    @Timed
    public TaskSearchView getTasksByRelease(TasksFilters tasksFilters, Integer limitTasksHintOption) {
        int limit = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)limitTasksHintOption).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 30));
        Seq taskIds = (Seq)this.time("finding task ids", (Function0 & Serializable & scala.Serializable)() -> this.searchTaskIds(tasksFilters, limit));
        Seq releaseIds = (Seq)((SeqLike)taskIds.map((Function1 & Serializable & scala.Serializable)x$1 -> Ids.releaseIdFrom((String)x$1), Seq$.MODULE$.canBuildFrom())).distinct();
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " tasks in ", " releases for user ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)taskIds.size()), BoxesRunTime.boxToInteger((int)releaseIds.size()), Permissions.getAuthenticatedUserName()})));
        List allowedTaskTypesForAuthenticatedUser = (List)this.time("fetching allowed task types for authenticated user", (Function0 & Serializable & scala.Serializable)() -> $this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser());
        Tuple2 queryReleases = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withReleaseIds((Seq<String>)releaseIds).build();
        Seq releasesTasks = (Seq)this.time("total time to create releasesTasks", (Function0 & Serializable & scala.Serializable)() -> (Seq)((TraversableLike)((GenericTraversableTemplate)this.time("de-serializing releases", (Function0 & Serializable & scala.Serializable)() -> {
            boolean bl = this.repositoryAdapter().tryDeserialize$default$1();
            return (Seq)$this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)queryReleases).map((Function1 & Serializable & scala.Serializable)releaseData -> this.repositoryAdapter().tryDeserialize(bl, (ReleaseRow)releaseData), Seq$.MODULE$.canBuildFrom());
        })).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).flatMap((Function1 & Serializable & scala.Serializable)foundRelease -> {
            $this.decoratorService.decorate((ConfigurationItem)$this.commentPersistence.decorate((Release)foundRelease), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ReleaseGlobalAndFolderVariablesDecorator$.MODULE$.GLOBAL_AND_FOLDER_VARIABLES(), EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY()}))).asJava());
            return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)BoxedUnit.UNIT).map((Function1 & Serializable & scala.Serializable)x$2 -> {
                Buffer orderedTasks = (Buffer)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(foundRelease.getAllTasks()).asScala()).filter((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToBoolean((boolean)taskIds.exists((Function1 & Serializable & scala.Serializable)foundId -> BoxesRunTime.boxToBoolean((boolean)SqlTaskSearchService.$anonfun$getTasksByRelease$14(task, foundId)))))).sortBy((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToInteger((int)taskIds.indexWhere((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)SqlTaskSearchService.$anonfun$getTasksByRelease$16(task, id)))), (Ordering)Ordering.Int$.MODULE$);
                return new Tuple2(x$2, (Object)orderedTasks);
            }).map((Function1 & Serializable & scala.Serializable)x$3 -> {
                Tuple2 tuple2 = x$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Buffer orderedTasks = (Buffer)tuple2._2();
                ReleaseTasks releaseTasks = new ReleaseTasks(foundRelease, $this.tasksViewConverter.toFullView((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(orderedTasks).asJava(), allowedTaskTypesForAuthenticatedUser));
                return releaseTasks;
            }));
        }, Seq$.MODULE$.canBuildFrom()));
        return new TaskSearchView(this.sortByReleaseTitle((Seq<ReleaseTasks>)releasesTasks), taskIds.size() >= limit);
    }

    private <A> A time(String desc, Function0<A> block) {
        long startTime = System.currentTimeMillis();
        Object res = block.apply();
        long endTime = System.currentTimeMillis();
        long total = endTime - startTime;
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIME: ", " took ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc, BoxesRunTime.boxToLong((long)total)})));
        return (A)res;
    }

    private List<ReleaseTasks> sortByReleaseTitle(Seq<ReleaseTasks> releasesTasks) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)releasesTasks.sortBy((Function1 & Serializable & scala.Serializable)releaseTasks -> (String)Option$.MODULE$.apply((Object)releaseTasks.getTitle()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), (Ordering)Ordering.String$.MODULE$)).asJava();
    }

    private Seq<String> searchTaskIds(TasksFilters tasksFilters, int limit) {
        Iterable principals = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
        Buffer roleIds = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService.getRolesFor(Permissions.getAuthentication())).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getId(), Buffer$.MODULE$.canBuildFrom());
        Tuple2<String, Seq<Object>> tasksQuery = ((TasksUnionSqlBuilder)SqlTasksFilterSupport$.MODULE$.sqlBuilderByFilters(tasksFilters, (Iterable<String>)principals, (Iterable<String>)roleIds, this.permissionEnforcer(), this.sqlDialect()).limit(limit)).build();
        return this.taskPersistence.findTaskIdsByQuery(tasksQuery);
    }

    public static final /* synthetic */ boolean $anonfun$getTasksByRelease$14(Task task$1, String foundId) {
        return task$1.getId().endsWith(foundId);
    }

    public static final /* synthetic */ boolean $anonfun$getTasksByRelease$16(Task task$2, String id) {
        return task$2.getId().startsWith(id);
    }

    public SqlTaskSearchService(RoleService roleService, TaskAccessService taskAccessService, TasksViewConverter tasksViewConverter, InternalMetadataDecoratorService decoratorService, ReleasePersistence releasePersistence, TaskPersistence taskPersistence, CommentPersistence commentPersistence, SqlRepositoryAdapter repositoryAdapter, PermissionEnforcer permissionEnforcer, SqlBuilder.Dialect sqlDialect) {
        this.roleService = roleService;
        this.taskAccessService = taskAccessService;
        this.tasksViewConverter = tasksViewConverter;
        this.decoratorService = decoratorService;
        this.releasePersistence = releasePersistence;
        this.taskPersistence = taskPersistence;
        this.commentPersistence = commentPersistence;
        this.repositoryAdapter = repositoryAdapter;
        this.permissionEnforcer = permissionEnforcer;
        this.sqlDialect = sqlDialect;
        Logging.$init$((Logging)this);
    }
}

