/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata$;
import com.xebialabs.xlrelease.domain.calendar.Blackout;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.repository.CommentRepository;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.ResolveOptions;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.repository.sql.BaseReleaseItemRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.ConfigurationPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\t5d\u0001\u0002\u0011\"\u00011B\u0001\"\u0013\u0001\u0003\u0006\u0004%\tA\u0013\u0005\t#\u0002\u0011\t\u0011)A\u0005\u0017\"A!\u000b\u0001BC\u0002\u0013\u00051\u000b\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003U\u0011!A\u0006A!b\u0001\n\u0003I\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u0011y\u0003!Q1A\u0005\u0002}C\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tI\u0002\u0011)\u0019!C\u0001K\"A\u0011\u000e\u0001B\u0001B\u0003%a\r\u0003\u0005k\u0001\t\u0015\r\u0011\"\u0001l\u0011!y\u0007A!A!\u0002\u0013a\u0007\u0002\u00039\u0001\u0005\u000b\u0007I\u0011A9\t\u0011U\u0004!\u0011!Q\u0001\nID\u0001B\u001e\u0001\u0003\u0006\u0004%\u0019a\u001e\u0005\n\u0003?\u0001!\u0011!Q\u0001\naDq!!\t\u0001\t\u0003\t\u0019\u0003C\u0004\u00028\u0001!\t%!\u000f\t\u000f\u0005]\u0002\u0001\"\u0011\u0002\u0004\"9\u0011q\u0014\u0001\u0005B\u0005\u0005\u0006bBAh\u0001\u0011\u0005\u0013\u0011\u001b\u0005\b\u0003?\u0004A\u0011IAq\u0011\u001d\tI\u000f\u0001C!\u0003WDq!a>\u0001\t\u0003\nI\u0010C\u0004\u0003\n\u0001!\tEa\u0003\t\u000f\tE\u0001\u0001\"\u0011\u0003\u0014!9!\u0011\u0004\u0001\u0005\n\tm\u0001b\u0002B\u0011\u0001\u0011\u0005#1\u0005\u0005\b\u0005S\u0001A\u0011\tB\u0016\u0011\u001d\u0011)\u0005\u0001C!\u0005\u000fBqAa\u0017\u0001\t\u0003\u0012iFA\tTc2$\u0016m]6SKB|7/\u001b;pefT!AI\u0012\u0002\u0007M\fHN\u0003\u0002%K\u0005Q!/\u001a9pg&$xN]=\u000b\u0005\u0019:\u0013!\u0003=me\u0016dW-Y:f\u0015\tA\u0013&A\u0005yK\nL\u0017\r\\1cg*\t!&A\u0002d_6\u001c\u0001aE\u0004\u0001[M:4HP!\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\r\u0005s\u0017PU3g!\t!T'D\u0001$\u0013\t14E\u0001\bUCN\\'+\u001a9pg&$xN]=\u0011\u0005aJT\"A\u0011\n\u0005i\n#!\u0007\"bg\u0016\u0014V\r\\3bg\u0016LE/Z7SKB|7/\u001b;pef\u0004\"\u0001\u000f\u001f\n\u0005u\n#A\u0006#fg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8TkB\u0004xN\u001d;\u0011\u0005az\u0014B\u0001!\"\u0005y\u0019uN\u001c4jOV\u0014\u0018\r^5p]J+g-\u001a:f]\u000e,7oU;qa>\u0014H\u000f\u0005\u0002C\u000f6\t1I\u0003\u0002E\u000b\u0006)1\u000f\u001c45U*\ta)\u0001\u0005he&T(\u0010\\3e\u0013\tA5IA\u0004M_\u001e<\u0017N\\4\u0002%I,G.Z1tKB+'o]5ti\u0016t7-Z\u000b\u0002\u0017B\u0011AjT\u0007\u0002\u001b*\u0011a*I\u0001\fa\u0016\u00148/[:uK:\u001cW-\u0003\u0002Q\u001b\n\u0011\"+\u001a7fCN,\u0007+\u001a:tSN$XM\\2f\u0003M\u0011X\r\\3bg\u0016\u0004VM]:jgR,gnY3!\u0003U!W\r]3oI\u0016t7-\u001f)feNL7\u000f^3oG\u0016,\u0012\u0001\u0016\t\u0003\u0019VK!AV'\u0003+\u0011+\u0007/\u001a8eK:\u001c\u0017\u0010U3sg&\u001cH/\u001a8dK\u00061B-\u001a9f]\u0012,gnY=QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%A\buCN\\\u0007+\u001a:tSN$XM\\2f+\u0005Q\u0006C\u0001'\\\u0013\taVJA\bUCN\\\u0007+\u001a:tSN$XM\\2f\u0003A!\u0018m]6QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%A\td_6lWM\u001c;SKB|7/\u001b;pef,\u0012\u0001\u0019\t\u0003i\u0005L!AY\u0012\u0003#\r{W.\\3oiJ+\u0007o\\:ji>\u0014\u00180\u0001\nd_6lWM\u001c;SKB|7/\u001b;pef\u0004\u0013!\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;feV\ta\r\u0005\u00029O&\u0011\u0001.\t\u0002\u0015'Fd'+\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0002%I,\u0007o\\:ji>\u0014\u00180\u00113baR,'\u000fI\u0001\u0019G>tg-[4ve\u0006$\u0018n\u001c8QKJ\u001c\u0018n\u001d;f]\u000e,W#\u00017\u0011\u00051k\u0017B\u00018N\u0005a\u0019uN\u001c4jOV\u0014\u0018\r^5p]B+'o]5ti\u0016t7-Z\u0001\u001aG>tg-[4ve\u0006$\u0018n\u001c8QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%A\bgC\u000e,GOU3q_NLGo\u001c:z+\u0005\u0011\bC\u0001\u001bt\u0013\t!8EA\bGC\u000e,GOU3q_NLGo\u001c:z\u0003A1\u0017mY3u%\u0016\u0004xn]5u_JL\b%A\u0004eS\u0006dWm\u0019;\u0016\u0003a\u00042!_A\r\u001d\rQ\u00181\u0003\b\u0004w\u0006=ab\u0001?\u0002\f9\u0019Q0!\u0003\u000f\u0007y\f9AD\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\r1&\u0001\u0004=e>|GOP\u0005\u0002U%\u0011\u0001&K\u0005\u0003M\u001dJ1!!\u0004&\u0003\t!'-C\u0002#\u0003#Q1!!\u0004&\u0013\u0011\t)\"a\u0006\u0002\u0015M\u000bHNQ;jY\u0012,'OC\u0002#\u0003#IA!a\u0007\u0002\u001e\t9A)[1mK\u000e$(\u0002BA\u000b\u0003/\t\u0001\u0002Z5bY\u0016\u001cG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015%\u0005\u0015\u0012qEA\u0015\u0003W\ti#a\f\u00022\u0005M\u0012Q\u0007\t\u0003q\u0001AQ!S\tA\u0002-CQAU\tA\u0002QCQ\u0001W\tA\u0002iCQAX\tA\u0002\u0001DQ\u0001Z\tA\u0002\u0019DQA[\tA\u00021DQ\u0001]\tA\u0002IDQA^\tA\u0004a\f\u0001BZ5oI\nK\u0018\nZ\u000b\u0005\u0003w\t\t\u0005\u0006\u0003\u0002>\u0005e\u0003\u0003BA \u0003\u0003b\u0001\u0001B\u0004\u0002DI\u0011\r!!\u0012\u0003\u0003Q\u000bB!a\u0012\u0002NA\u0019a&!\u0013\n\u0007\u0005-sFA\u0004O_RD\u0017N\\4\u0011\t\u0005=\u0013QK\u0007\u0003\u0003#R1!a\u0015&\u0003\u0019!w.\\1j]&!\u0011qKA)\u0005\u0011!\u0016m]6\t\u000f\u0005m#\u00031\u0001\u0002^\u00051A/Y:l\u0013\u0012\u0004B!a\u0018\u0002h9!\u0011\u0011MA2!\tyx&C\u0002\u0002f=\na\u0001\u0015:fI\u00164\u0017\u0002BA5\u0003W\u0012aa\u0015;sS:<'bAA3_!\u001a!#a\u001c\u0011\t\u0005E\u0014qP\u0007\u0003\u0003gRA!!\u001e\u0002x\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\u0005e\u00141P\u0001\b[\u0016$(/[2t\u0015\r\ti(K\u0001\tG>$\u0017\r[1mK&!\u0011\u0011QA:\u0005\u0015!\u0016.\\3e+\u0011\t))!#\u0015\r\u0005\u001d\u00151RAG!\u0011\ty$!#\u0005\u000f\u0005\r3C1\u0001\u0002F!9\u00111L\nA\u0002\u0005u\u0003bBAH'\u0001\u0007\u0011\u0011S\u0001\u000fe\u0016\u001cx\u000e\u001c<f\u001fB$\u0018n\u001c8t!\u0011\t\u0019*!'\u000e\u0005\u0005U%bAALG\u0005)\u0011/^3ss&!\u00111TAK\u00059\u0011Vm]8mm\u0016|\u0005\u000f^5p]ND3aEA8\u0003M1\u0017N\u001c3UCN\\7OR8s!>dG.\u001b8h)\u0011\t\u0019+!/\u0011\r\u0005\u0015\u0016qVAZ\u001b\t\t9K\u0003\u0003\u0002*\u0006-\u0016\u0001B;uS2T!!!,\u0002\t)\fg/Y\u0005\u0005\u0003c\u000b9K\u0001\u0003MSN$\b\u0003BAJ\u0003kKA!a.\u0002\u0016\niA+Y:l\u0005\u0006\u001c\u0018n\u0019#bi\u0006Dq!a/\u0015\u0001\u0004\ti,A\u0004uCN\\\u0017\nZ:\u0011\r\u0005\u0015\u0016qVA/Q\r!\u0012\u0011\u0019\t\u0005\u0003\u0007\fI-\u0004\u0002\u0002F*!\u0011qYA\f\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\t\u0005-\u0017Q\u0019\u0002\u000b\u0013N\u0014V-\u00193P]2L\bf\u0001\u000b\u0002p\u00051Q\r_5tiN$B!a5\u0002ZB\u0019a&!6\n\u0007\u0005]wFA\u0004C_>dW-\u00198\t\u000f\u0005mS\u00031\u0001\u0002^!\u001aQ#!1)\u0007U\ty'\u0001\u0004va\u0012\fG/\u001a\u000b\u0005\u0003\u001b\n\u0019\u000fC\u0004\u0002fZ\u0001\r!!\u0014\u0002\tQ\f7o\u001b\u0015\u0004-\u0005=\u0014\u0001F;qI\u0006$X\rV1tWB\u0013x\u000e]3si&,7\u000f\u0006\u0003\u0002n\u0006M\bc\u0001\u0018\u0002p&\u0019\u0011\u0011_\u0018\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003K<\u0002\u0019AA'Q\r9\u0012qN\u0001\u001fkB$\u0017\r^3UCN\\\u0017I\u001c3SK2,\u0017m]3GY\u0006<7\u000b^1ukN$b!!\u0014\u0002|\u0006u\bbBAs1\u0001\u0007\u0011Q\n\u0005\b\u0003\u007fD\u0002\u0019\u0001B\u0001\u0003\u001d\u0011X\r\\3bg\u0016\u0004B!a\u0014\u0003\u0004%!!QAA)\u0005\u001d\u0011V\r\\3bg\u0016D3\u0001GA8\u0003))\b\u000fZ1uKRK\b/\u001a\u000b\u0005\u0003\u001b\u0012i\u0001C\u0004\u0002ff\u0001\r!!\u0014)\u0007e\ty'\u0001\u0004eK2,G/\u001a\u000b\u0005\u0003[\u0014)\u0002C\u0004\u0002fj\u0001\r!!\u0014)\u0007i\ty'\u0001\u0006de\u0016\fG/\u001a+bg.$B!!\u0014\u0003\u001e!9!qD\u000eA\u0002\u00055\u0013a\u00028foR\u000b7o[\u0001\u0007GJ,\u0017\r^3\u0015\t\u00055#Q\u0005\u0005\b\u0005?a\u0002\u0019AA'Q\ra\u0012qN\u0001\t[>4X\rV1tWRQ\u0011Q\nB\u0017\u0005c\u0011)Da\u0010\t\u000f\t=R\u00041\u0001\u0002N\u0005QA/Y:l)>luN^3\t\u000f\tMR\u00041\u0001\u0002N\u0005IQn\u001c<fIR\u000b7o\u001b\u0005\b\u0005oi\u0002\u0019\u0001B\u001d\u0003Y)\b\u000fZ1uK\u0012|%/[4j]\u000e{g\u000e^1j]\u0016\u0014\b\u0003BA(\u0005wIAA!\u0010\u0002R\tiA+Y:l\u0007>tG/Y5oKJDqA!\u0011\u001e\u0001\u0004\u0011I$\u0001\fva\u0012\fG/\u001a3UCJ<W\r^\"p]R\f\u0017N\\3sQ\ri\u0012qN\u0001\u0017M&tG-\u00114gK\u000e$X\r\u001a\"z\u00052\f7m[8viR!\u0011Q\u0018B%\u0011\u001d\u0011YE\ba\u0001\u0005\u001b\n\u0001B\u00197bG.|W\u000f\u001e\t\u0005\u0005\u001f\u0012)&\u0004\u0002\u0003R)!!1KA)\u0003!\u0019\u0017\r\\3oI\u0006\u0014\u0018\u0002\u0002B,\u0005#\u0012\u0001B\u00117bG.|W\u000f\u001e\u0015\u0004=\u0005=\u0014\u0001C4fiRKG\u000f\\3\u0015\t\u0005u#q\f\u0005\b\u00037z\u0002\u0019AA/Q\ry\u0012\u0011\u0019\u0015\u0004?\u0005=\u0004f\u0001\u0001\u0003hA!\u00111\u0019B5\u0013\u0011\u0011Y'!2\u0003\u001f%\u001bHK]1og\u0006\u001cG/[8oC2\u0004")
public class SqlTaskRepository
implements TaskRepository,
BaseReleaseItemRepository,
DeserializationSupport,
ConfigurationReferencesSupport,
Logging {
    private final ReleasePersistence releasePersistence;
    private final DependencyPersistence dependencyPersistence;
    private final TaskPersistence taskPersistence;
    private final CommentRepository commentRepository;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final ConfigurationPersistence configurationPersistence;
    private final FacetRepository facetRepository;
    private final SqlBuilder.Dialect dialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void updateConfigurationRefs(Release release) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, release);
    }

    @Override
    public void deleteConfigurationRefs(Integer releaseUid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, releaseUid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.deserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Release getRelease(String releaseId, String entityId) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId);
    }

    @Override
    public Release getRelease(String releaseId, String entityId, ResolveOptions resolveOptions) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId, resolveOptions);
    }

    @Override
    public <T> T notNull(T ci, String ciId) {
        return (T)BaseReleaseItemRepository.notNull$(this, ci, ciId);
    }

    @Override
    public void insertDependencyWithGateTaskUid(Integer gateTaskUid, Dependency dependency) {
        BaseReleaseItemRepository.insertDependencyWithGateTaskUid$(this, gateTaskUid, dependency);
    }

    @Override
    public void insertDependency(Dependency dependency) {
        BaseReleaseItemRepository.insertDependency$(this, dependency);
    }

    @Override
    public void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        BaseReleaseItemRepository.checkIsNotReferencedByDependencies$(this, planItemIdOrItsChildren);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTaskRepository sqlTaskRepository = this;
        synchronized (sqlTaskRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    @Override
    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public CommentRepository commentRepository() {
        return this.commentRepository;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Override
    public ConfigurationPersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    public FacetRepository facetRepository() {
        return this.facetRepository;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    public <T extends Task> T findById(String taskId) {
        return this.findById(taskId, new ResolveOptionsBuilder().withEverything().build());
    }

    @Timed
    public <T extends Task> T findById(String taskId, ResolveOptions resolveOptions) {
        if (!this.exists(taskId)) {
            throw new NotFoundException(new StringBuilder(30).append("Repository entity [").append(taskId).append("] not found").toString(), new Object[0]);
        }
        Release release = this.getRelease(Ids.releaseIdFrom((String)taskId), taskId, resolveOptions);
        return (T)((Task)Option$.MODULE$.apply((Object)release.getTask(CiId$.MODULE$.RichCiId(taskId).normalized())).fold((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(41).append("Repository entity [").append(taskId).append("] not found in release").toString(), new Object[0]);
        }, (Function1 & Serializable & scala.Serializable)task2 -> {
            task2.getAllTasks().forEach(task -> this.commentRepository().decorate(task));
            return task2;
        }));
    }

    @Timed
    @IsReadOnly
    public List<TaskBasicData> findTasksForPolling(List<String> taskIds) {
        List list;
        if (taskIds.isEmpty()) {
            list = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.empty()).asJava();
        } else {
            Seq<TaskRow> tasksData = this.taskPersistence().findByIds((Iterable<String>)((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(taskIds).asScala()));
            list = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(taskIds).asScala()).map((Function1 & Serializable & scala.Serializable)taskId -> new Tuple2(taskId, (Object)tasksData.find((Function1 & Serializable & scala.Serializable)data -> BoxesRunTime.boxToBoolean((boolean)taskId.endsWith(data.taskId())))), Buffer$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                String id = (String)tuple2._1();
                Option option = (Option)tuple2._2();
                if (!(option instanceof Some)) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                Some some = (Some)option;
                TaskRow data = (TaskRow)some.value();
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)TaskRow$.MODULE$.TaskDataOps(data).asTaskData(id)));
            }, Buffer$.MODULE$.canBuildFrom())).asJava();
        }
        return list;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String taskId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Checking if exists task [").append(taskId).append("]").toString());
        return this.taskPersistence().exists(taskId);
    }

    @Timed
    public Task update(Task task) {
        Release release = task.getRelease();
        this.releasePersistence().update(release);
        this.updateTaskProperties(task);
        this.updateConfigurationRefs(release);
        return task;
    }

    @Timed
    public void updateTaskProperties(Task task) {
        this.taskPersistence().updateProperties(task);
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SqlTaskRepository.$anonfun$updateTaskProperties$1(this, task, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Task updateTaskAndReleaseFlagStatus(Task task, Release release) {
        return this.update(task);
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Task updateType(Task task) {
        void var2_2;
        Task updated = this.update(task);
        this.taskPersistence().updateType(task);
        return var2_2;
    }

    @Timed
    public void delete(Task task) {
        this.checkIsNotReferencedByDependencies(task.getId());
        this.releasePersistence().update(task.getRelease());
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            SqlTaskRepository.$anonfun$delete$1(this, dependency);
            return BoxedUnit.UNIT;
        });
        task.getAllTasks().forEach(t -> {
            this.commentRepository().deleteByTask(t);
            this.taskPersistence().delete((Task)t);
        });
        this.updateConfigurationRefs(task.getRelease());
    }

    private Task createTask(Task newTask2) {
        this.taskPersistence().insert(newTask2, Predef$.MODULE$.Integer2int(newTask2.getRelease().getCiUid()));
        Object object = newTask2 instanceof TaskGroup ? ((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(newTask2.getAllTasks()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$createTask$1(newTask2, x$1)))).map((Function1 & Serializable & scala.Serializable)newTask -> this.createTask((Task)newTask), Buffer$.MODULE$.canBuildFrom()) : BoxedUnit.UNIT;
        return newTask2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Task create(Task newTask) {
        void var2_2;
        this.releasePersistence().update(newTask.getRelease());
        Task createdTask = this.createTask(newTask);
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(createdTask)).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            this.insertDependency(dependency);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs(createdTask.getRelease());
        this.facetRepository().createFromTasks((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(newTask.getAllTasks()).asScala());
        return var2_2;
    }

    @Timed
    public Task moveTask(Task taskToMove, Task movedTask, TaskContainer updatedOriginContainer, TaskContainer updatedTargetContainer) {
        TaskContainer taskContainer = updatedOriginContainer;
        TaskContainer taskContainer2 = updatedTargetContainer;
        if (taskContainer == null ? taskContainer2 != null : !taskContainer.equals(taskContainer2)) {
            this.checkIsNotReferencedByDependencies(taskToMove.getId());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(taskToMove.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)taskWithOldId -> {
                SqlTaskRepository.$anonfun$moveTask$1(this, taskToMove, movedTask, taskWithOldId);
                return BoxedUnit.UNIT;
            });
        }
        this.releasePersistence().update(movedTask.getRelease());
        return movedTask;
    }

    @Timed
    public List<String> findAffectedByBlackout(Blackout blackout) {
        Date endDate = BlackoutMetadata$.MODULE$.toStartOfNextMinute(blackout.getEndDate());
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.dialect()).selectReleaseData().withOneOfStatuses((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])ReleaseStatus.ACTIVE_STATUSES)).build();
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((TraversableLike)((TraversableLike)this.releasePersistence().findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(this.tryDeserializeRelease((ReleaseRow)x$2, new ResolveOptionsBuilder().build())), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)rel -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(rel.getAllTasks()).asScala(), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$findAffectedByBlackout$3(endDate, task)))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Seq$.MODULE$.canBuildFrom())).asJava();
    }

    @Timed
    @IsReadOnly
    public String getTitle(String taskId) {
        return (String)this.taskPersistence().getTitle(taskId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException("Task [%s] not found", new Object[]{taskId});
        });
    }

    public static final /* synthetic */ void $anonfun$updateTaskProperties$1(SqlTaskRepository $this, Task task$1, Dependency x0$1) {
        Dependency dependency = x0$1;
        if (dependency.isArchived()) {
            $this.dependencyPersistence().deleteDependency(dependency);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            try {
                $this.dependencyPersistence().updateDependency(dependency);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (NotFoundException e) {
                $this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Dependency ").append(dependency).append(" not found when updating task ").append(task$1).toString(), (Function0 & Serializable & scala.Serializable)() -> e);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public static final /* synthetic */ void $anonfun$delete$1(SqlTaskRepository $this, Dependency dependency) {
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    public static final /* synthetic */ boolean $anonfun$createTask$1(Task newTask$1, Task x$1) {
        String string = x$1.getContainer().getId();
        String string2 = newTask$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$moveTask$1(SqlTaskRepository $this, Task taskToMove$1, Task movedTask$1, Task taskWithOldId) {
        String oldId = taskWithOldId.getId();
        String newId = oldId.replace(taskToMove$1.getId(), movedTask$1.getId());
        $this.taskPersistence().move(oldId, newId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$findAffectedByBlackout$3(Date endDate$1, Task task) {
        TaskStatus taskStatus = task.getStatus();
        TaskStatus taskStatus2 = TaskStatus.PENDING;
        if (taskStatus == null) {
            if (taskStatus2 != null) {
                return false;
            }
        } else if (!taskStatus.equals(taskStatus2)) return false;
        if (!task.isPostponedDueToBlackout()) return false;
        Date date = task.getScheduledStartDate();
        Date date2 = endDate$1;
        if (date == null) {
            if (date2 == null) return true;
            return false;
        } else {
            if (!((Object)date).equals(date2)) return false;
            return true;
        }
    }

    public SqlTaskRepository(ReleasePersistence releasePersistence, DependencyPersistence dependencyPersistence, TaskPersistence taskPersistence, CommentRepository commentRepository, SqlRepositoryAdapter repositoryAdapter, ConfigurationPersistence configurationPersistence, FacetRepository facetRepository, SqlBuilder.Dialect dialect) {
        this.releasePersistence = releasePersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.taskPersistence = taskPersistence;
        this.commentRepository = commentRepository;
        this.repositoryAdapter = repositoryAdapter;
        this.configurationPersistence = configurationPersistence;
        this.facetRepository = facetRepository;
        this.dialect = dialect;
        BaseReleaseItemRepository.$init$(this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        Logging.$init$((Logging)this);
    }
}

