/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata$;
import com.xebialabs.xlrelease.domain.calendar.Blackout;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.repository.CommentRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.ResolveOptions;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.repository.sql.BaseReleaseItemRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.ConfigurationPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\t5d\u0001\u0002\u0011\"\u00011B\u0001\"\u0013\u0001\u0003\u0006\u0004%\tA\u0013\u0005\t#\u0002\u0011\t\u0011)A\u0005\u0017\"A!\u000b\u0001BC\u0002\u0013\u00051\u000b\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003U\u0011!A\u0006A!b\u0001\n\u0003I\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u0011y\u0003!Q1A\u0005\u0002}C\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tI\u0002\u0011)\u0019!C\u0001K\"A\u0011\u000e\u0001B\u0001B\u0003%a\r\u0003\u0005k\u0001\t\u0015\r\u0011\"\u0001l\u0011!y\u0007A!A!\u0002\u0013a\u0007\u0002\u00039\u0001\u0005\u000b\u0007I\u0011A9\t\u0011U\u0004!\u0011!Q\u0001\nID\u0001B\u001e\u0001\u0003\u0006\u0004%\u0019a\u001e\u0005\n\u0003?\u0001!\u0011!Q\u0001\naDq!!\t\u0001\t\u0003\t\u0019\u0003C\u0004\u00028\u0001!\t%!\u000f\t\u000f\u0005]\u0002\u0001\"\u0011\u0002\u0004\"9\u0011q\u0014\u0001\u0005B\u0005\u0005\u0006bBAh\u0001\u0011\u0005\u0013\u0011\u001b\u0005\b\u0003?\u0004A\u0011IAq\u0011\u001d\tI\u000f\u0001C!\u0003WDq!a>\u0001\t\u0003\nI\u0010C\u0004\u0003\n\u0001!\tEa\u0003\t\u000f\tE\u0001\u0001\"\u0011\u0003\u0014!9!\u0011\u0004\u0001\u0005\n\tm\u0001b\u0002B\u0011\u0001\u0011\u0005#1\u0005\u0005\b\u0005S\u0001A\u0011\tB\u0016\u0011\u001d\u0011)\u0005\u0001C!\u0005\u000fBqAa\u0017\u0001\t\u0003\u0012iFA\tTc2$\u0016m]6SKB|7/\u001b;pefT!AI\u0012\u0002\u0007M\fHN\u0003\u0002%K\u0005Q!/\u001a9pg&$xN]=\u000b\u0005\u0019:\u0013!\u0003=me\u0016dW-Y:f\u0015\tA\u0013&A\u0005yK\nL\u0017\r\\1cg*\t!&A\u0002d_6\u001c\u0001aE\u0004\u0001[M:4HP!\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\r\u0005s\u0017PU3g!\t!T'D\u0001$\u0013\t14E\u0001\bUCN\\'+\u001a9pg&$xN]=\u0011\u0005aJT\"A\u0011\n\u0005i\n#!\u0007\"bg\u0016\u0014V\r\\3bg\u0016LE/Z7SKB|7/\u001b;pef\u0004\"\u0001\u000f\u001f\n\u0005u\n#A\u0006#fg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8TkB\u0004xN\u001d;\u0011\u0005az\u0014B\u0001!\"\u0005y\u0019uN\u001c4jOV\u0014\u0018\r^5p]J+g-\u001a:f]\u000e,7oU;qa>\u0014H\u000f\u0005\u0002C\u000f6\t1I\u0003\u0002E\u000b\u0006)1\u000f\u001c45U*\ta)\u0001\u0005he&T(\u0010\\3e\u0013\tA5IA\u0004M_\u001e<\u0017N\\4\u0002%I,G.Z1tKB+'o]5ti\u0016t7-Z\u000b\u0002\u0017B\u0011AjT\u0007\u0002\u001b*\u0011a*I\u0001\fa\u0016\u00148/[:uK:\u001cW-\u0003\u0002Q\u001b\n\u0011\"+\u001a7fCN,\u0007+\u001a:tSN$XM\\2f\u0003M\u0011X\r\\3bg\u0016\u0004VM]:jgR,gnY3!\u0003U!W\r]3oI\u0016t7-\u001f)feNL7\u000f^3oG\u0016,\u0012\u0001\u0016\t\u0003\u0019VK!AV'\u0003+\u0011+\u0007/\u001a8eK:\u001c\u0017\u0010U3sg&\u001cH/\u001a8dK\u00061B-\u001a9f]\u0012,gnY=QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%A\buCN\\\u0007+\u001a:tSN$XM\\2f+\u0005Q\u0006C\u0001'\\\u0013\taVJA\bUCN\\\u0007+\u001a:tSN$XM\\2f\u0003A!\u0018m]6QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%A\td_6lWM\u001c;SKB|7/\u001b;pef,\u0012\u0001\u0019\t\u0003i\u0005L!AY\u0012\u0003#\r{W.\\3oiJ+\u0007o\\:ji>\u0014\u00180\u0001\nd_6lWM\u001c;SKB|7/\u001b;pef\u0004\u0013!\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;feV\ta\r\u0005\u00029O&\u0011\u0001.\t\u0002\u0015'Fd'+\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0002%I,\u0007o\\:ji>\u0014\u00180\u00113baR,'\u000fI\u0001\u0019G>tg-[4ve\u0006$\u0018n\u001c8QKJ\u001c\u0018n\u001d;f]\u000e,W#\u00017\u0011\u00051k\u0017B\u00018N\u0005a\u0019uN\u001c4jOV\u0014\u0018\r^5p]B+'o]5ti\u0016t7-Z\u0001\u001aG>tg-[4ve\u0006$\u0018n\u001c8QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%A\rgC\u000e,GOU3q_NLGo\u001c:z\t&\u001c\b/\u0019;dQ\u0016\u0014X#\u0001:\u0011\u0005Q\u001a\u0018B\u0001;$\u0005e1\u0015mY3u%\u0016\u0004xn]5u_JLH)[:qCR\u001c\u0007.\u001a:\u00025\u0019\f7-\u001a;SKB|7/\u001b;pef$\u0015n\u001d9bi\u000eDWM\u001d\u0011\u0002\u000f\u0011L\u0017\r\\3diV\t\u0001\u0010E\u0002z\u00033q1A_A\n\u001d\rY\u0018q\u0002\b\u0004y\u0006-abA?\u0002\n9\u0019a0a\u0002\u000f\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111A\u0016\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0013B\u0001\u0015*\u0013\t1s%C\u0002\u0002\u000e\u0015\n!\u0001\u001a2\n\u0007\t\n\tBC\u0002\u0002\u000e\u0015JA!!\u0006\u0002\u0018\u0005Q1+\u001d7Ck&dG-\u001a:\u000b\u0007\t\n\t\"\u0003\u0003\u0002\u001c\u0005u!a\u0002#jC2,7\r\u001e\u0006\u0005\u0003+\t9\"\u0001\u0005eS\u0006dWm\u0019;!\u0003\u0019a\u0014N\\5u}Q\u0011\u0012QEA\u0014\u0003S\tY#!\f\u00020\u0005E\u00121GA\u001b!\tA\u0004\u0001C\u0003J#\u0001\u00071\nC\u0003S#\u0001\u0007A\u000bC\u0003Y#\u0001\u0007!\fC\u0003_#\u0001\u0007\u0001\rC\u0003e#\u0001\u0007a\rC\u0003k#\u0001\u0007A\u000eC\u0003q#\u0001\u0007!\u000fC\u0003w#\u0001\u000f\u00010\u0001\u0005gS:$')_%e+\u0011\tY$!\u0011\u0015\t\u0005u\u0012\u0011\f\t\u0005\u0003\u007f\t\t\u0005\u0004\u0001\u0005\u000f\u0005\r#C1\u0001\u0002F\t\tA+\u0005\u0003\u0002H\u00055\u0003c\u0001\u0018\u0002J%\u0019\u00111J\u0018\u0003\u000f9{G\u000f[5oOB!\u0011qJA+\u001b\t\t\tFC\u0002\u0002T\u0015\na\u0001Z8nC&t\u0017\u0002BA,\u0003#\u0012A\u0001V1tW\"9\u00111\f\nA\u0002\u0005u\u0013A\u0002;bg.LE\r\u0005\u0003\u0002`\u0005\u001dd\u0002BA1\u0003G\u0002\"a`\u0018\n\u0007\u0005\u0015t&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003S\nYG\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003Kz\u0003f\u0001\n\u0002pA!\u0011\u0011OA@\u001b\t\t\u0019H\u0003\u0003\u0002v\u0005]\u0014AC1o]>$\u0018\r^5p]*!\u0011\u0011PA>\u0003\u001diW\r\u001e:jGNT1!! *\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BAA\u0003g\u0012Q\u0001V5nK\u0012,B!!\"\u0002\nR1\u0011qQAF\u0003\u001b\u0003B!a\u0010\u0002\n\u00129\u00111I\nC\u0002\u0005\u0015\u0003bBA.'\u0001\u0007\u0011Q\f\u0005\b\u0003\u001f\u001b\u0002\u0019AAI\u00039\u0011Xm]8mm\u0016|\u0005\u000f^5p]N\u0004B!a%\u0002\u001a6\u0011\u0011Q\u0013\u0006\u0004\u0003/\u001b\u0013!B9vKJL\u0018\u0002BAN\u0003+\u0013aBU3t_24Xm\u00149uS>t7\u000fK\u0002\u0014\u0003_\n!CZ5oIR\u000b7o[:CCNL7\rR1uCR!\u00111UA]!\u0019\t)+a,\u000246\u0011\u0011q\u0015\u0006\u0005\u0003S\u000bY+\u0001\u0003vi&d'BAAW\u0003\u0011Q\u0017M^1\n\t\u0005E\u0016q\u0015\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\u0014\u0006U\u0016\u0002BA\\\u0003+\u0013Q\u0002V1tW\n\u000b7/[2ECR\f\u0007bBA^)\u0001\u0007\u0011QX\u0001\bi\u0006\u001c8.\u00133t!\u0019\t)+a,\u0002^!\u001aA#!1\u0011\t\u0005\r\u0017\u0011Z\u0007\u0003\u0003\u000bTA!a2\u0002\u0018\u0005YAO]1og\u0006\u001cG/[8o\u0013\u0011\tY-!2\u0003\u0015%\u001b(+Z1e\u001f:d\u0017\u0010K\u0002\u0015\u0003_\na!\u001a=jgR\u001cH\u0003BAj\u00033\u00042ALAk\u0013\r\t9n\f\u0002\b\u0005>|G.Z1o\u0011\u001d\tY&\u0006a\u0001\u0003;B3!FAaQ\r)\u0012qN\u0001\u0007kB$\u0017\r^3\u0015\t\u00055\u00131\u001d\u0005\b\u0003K4\u0002\u0019AA'\u0003\u0011!\u0018m]6)\u0007Y\ty'\u0001\u000bva\u0012\fG/\u001a+bg.\u0004&o\u001c9feRLWm\u001d\u000b\u0005\u0003[\f\u0019\u0010E\u0002/\u0003_L1!!=0\u0005\u0011)f.\u001b;\t\u000f\u0005\u0015x\u00031\u0001\u0002N!\u001aq#a\u001c\u0002=U\u0004H-\u0019;f)\u0006\u001c8.\u00118e%\u0016dW-Y:f\r2\fwm\u0015;biV\u001cHCBA'\u0003w\fi\u0010C\u0004\u0002fb\u0001\r!!\u0014\t\u000f\u0005}\b\u00041\u0001\u0003\u0002\u00059!/\u001a7fCN,\u0007\u0003BA(\u0005\u0007IAA!\u0002\u0002R\t9!+\u001a7fCN,\u0007f\u0001\r\u0002p\u0005QQ\u000f\u001d3bi\u0016$\u0016\u0010]3\u0015\t\u00055#Q\u0002\u0005\b\u0003KL\u0002\u0019AA'Q\rI\u0012qN\u0001\u0007I\u0016dW\r^3\u0015\t\u00055(Q\u0003\u0005\b\u0003KT\u0002\u0019AA'Q\rQ\u0012qN\u0001\u000bGJ,\u0017\r^3UCN\\G\u0003BA'\u0005;AqAa\b\u001c\u0001\u0004\ti%A\u0004oK^$\u0016m]6\u0002\r\r\u0014X-\u0019;f)\u0011\tiE!\n\t\u000f\t}A\u00041\u0001\u0002N!\u001aA$a\u001c\u0002\u00115|g/\u001a+bg.$\"\"!\u0014\u0003.\tE\"Q\u0007B \u0011\u001d\u0011y#\ba\u0001\u0003\u001b\n!\u0002^1tWR{Wj\u001c<f\u0011\u001d\u0011\u0019$\ba\u0001\u0003\u001b\n\u0011\"\\8wK\u0012$\u0016m]6\t\u000f\t]R\u00041\u0001\u0003:\u00051R\u000f\u001d3bi\u0016$wJ]5hS:\u001cuN\u001c;bS:,'\u000f\u0005\u0003\u0002P\tm\u0012\u0002\u0002B\u001f\u0003#\u0012Q\u0002V1tW\u000e{g\u000e^1j]\u0016\u0014\bb\u0002B!;\u0001\u0007!\u0011H\u0001\u0017kB$\u0017\r^3e)\u0006\u0014x-\u001a;D_:$\u0018-\u001b8fe\"\u001aQ$a\u001c\u0002-\u0019Lg\u000eZ!gM\u0016\u001cG/\u001a3Cs\nc\u0017mY6pkR$B!!0\u0003J!9!1\n\u0010A\u0002\t5\u0013\u0001\u00032mC\u000e\\w.\u001e;\u0011\t\t=#QK\u0007\u0003\u0005#RAAa\u0015\u0002R\u0005A1-\u00197f]\u0012\f'/\u0003\u0003\u0003X\tE#\u0001\u0003\"mC\u000e\\w.\u001e;)\u0007y\ty'\u0001\u0005hKR$\u0016\u000e\u001e7f)\u0011\tiFa\u0018\t\u000f\u0005ms\u00041\u0001\u0002^!\u001aq$!1)\u0007}\ty\u0007K\u0002\u0001\u0005O\u0002B!a1\u0003j%!!1NAc\u0005=I5\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007")
public class SqlTaskRepository
implements TaskRepository,
BaseReleaseItemRepository,
DeserializationSupport,
ConfigurationReferencesSupport,
Logging {
    private final ReleasePersistence releasePersistence;
    private final DependencyPersistence dependencyPersistence;
    private final TaskPersistence taskPersistence;
    private final CommentRepository commentRepository;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final ConfigurationPersistence configurationPersistence;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final SqlBuilder.Dialect dialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void updateConfigurationRefs(Release release) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, release);
    }

    @Override
    public void deleteConfigurationRefs(Integer releaseUid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, releaseUid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.deserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Release getRelease(String releaseId, String entityId) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId);
    }

    @Override
    public Release getRelease(String releaseId, String entityId, ResolveOptions resolveOptions) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId, resolveOptions);
    }

    @Override
    public <T> T notNull(T ci, String ciId) {
        return (T)BaseReleaseItemRepository.notNull$(this, ci, ciId);
    }

    @Override
    public void insertDependencyWithGateTaskUid(Integer gateTaskUid, Dependency dependency) {
        BaseReleaseItemRepository.insertDependencyWithGateTaskUid$(this, gateTaskUid, dependency);
    }

    @Override
    public void insertDependency(Dependency dependency) {
        BaseReleaseItemRepository.insertDependency$(this, dependency);
    }

    @Override
    public void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        BaseReleaseItemRepository.checkIsNotReferencedByDependencies$(this, planItemIdOrItsChildren);
    }

    public TaskBasicData findTaskBasicData(String taskId) {
        return TaskRepository.findTaskBasicData$((TaskRepository)this, (String)taskId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTaskRepository sqlTaskRepository = this;
        synchronized (sqlTaskRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    @Override
    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public CommentRepository commentRepository() {
        return this.commentRepository;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Override
    public ConfigurationPersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    public FacetRepositoryDispatcher facetRepositoryDispatcher() {
        return this.facetRepositoryDispatcher;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    public <T extends Task> T findById(String taskId) {
        return this.findById(taskId, new ResolveOptionsBuilder().withEverything().build());
    }

    @Timed
    public <T extends Task> T findById(String taskId, ResolveOptions resolveOptions) {
        if (!this.exists(taskId)) {
            throw new NotFoundException(new StringBuilder(30).append("Repository entity [").append(taskId).append("] not found").toString(), new Object[0]);
        }
        Release release = this.getRelease(Ids.releaseIdFrom((String)taskId), taskId, resolveOptions);
        return (T)((Task)Option$.MODULE$.apply((Object)release.getTask(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(taskId)))).fold((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(41).append("Repository entity [").append(taskId).append("] not found in release").toString(), new Object[0]);
        }, (Function1 & Serializable & scala.Serializable)task2 -> {
            task2.getAllTasks().forEach(task -> this.commentRepository().decorate(task));
            return task2;
        }));
    }

    @Timed
    @IsReadOnly
    public List<TaskBasicData> findTasksBasicData(List<String> taskIds) {
        List list;
        if (taskIds.isEmpty()) {
            list = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.empty()).asJava();
        } else {
            Seq<TaskRow> tasksData = this.taskPersistence().findByIds((Iterable<String>)((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(taskIds).asScala()));
            list = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(taskIds).asScala()).map((Function1 & Serializable & scala.Serializable)taskId -> new Tuple2(taskId, (Object)tasksData.find((Function1 & Serializable & scala.Serializable)data -> BoxesRunTime.boxToBoolean((boolean)taskId.endsWith(data.taskId())))), Buffer$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                String id = (String)tuple2._1();
                Option option = (Option)tuple2._2();
                if (!(option instanceof Some)) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                Some some = (Some)option;
                TaskRow data = (TaskRow)some.value();
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)TaskRow$.MODULE$.TaskDataOps(data).asTaskData(id)));
            }, Buffer$.MODULE$.canBuildFrom())).asJava();
        }
        return list;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String taskId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Checking if exists task [").append(taskId).append("]").toString());
        return this.taskPersistence().exists(taskId);
    }

    @Timed
    public Task update(Task task) {
        Release release = task.getRelease();
        this.releasePersistence().update(release);
        this.updateTaskProperties(task);
        this.updateConfigurationRefs(release);
        return task;
    }

    @Timed
    public void updateTaskProperties(Task task) {
        this.taskPersistence().updateProperties(task);
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SqlTaskRepository.$anonfun$updateTaskProperties$1(this, task, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Task updateTaskAndReleaseFlagStatus(Task task, Release release) {
        return this.update(task);
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Task updateType(Task task) {
        void var2_2;
        Task updated = this.update(task);
        this.taskPersistence().updateType(task);
        return var2_2;
    }

    @Timed
    public void delete(Task task) {
        this.checkIsNotReferencedByDependencies(task.getId());
        this.releasePersistence().update(task.getRelease());
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            SqlTaskRepository.$anonfun$delete$1(this, dependency);
            return BoxedUnit.UNIT;
        });
        task.getAllTasks().forEach(t -> {
            this.commentRepository().deleteByTask(t);
            this.taskPersistence().delete((Task)t);
        });
        this.updateConfigurationRefs(task.getRelease());
    }

    private Task createTask(Task newTask2) {
        this.taskPersistence().insert(newTask2, Predef$.MODULE$.Integer2int(newTask2.getRelease().getCiUid()));
        Object object = newTask2 instanceof TaskGroup ? ((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(newTask2.getAllTasks()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$createTask$1(newTask2, x$1)))).map((Function1 & Serializable & scala.Serializable)newTask -> this.createTask((Task)newTask), Buffer$.MODULE$.canBuildFrom()) : BoxedUnit.UNIT;
        return newTask2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Task create(Task newTask) {
        void var2_2;
        this.releasePersistence().update(newTask.getRelease());
        Task createdTask = this.createTask(newTask);
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(createdTask)).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            this.insertDependency(dependency);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs(createdTask.getRelease());
        this.facetRepositoryDispatcher().liveRepository().createFromTasks((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(newTask.getAllTasks()).asScala(), this.facetRepositoryDispatcher().liveRepository().createFromTasks$default$2());
        return var2_2;
    }

    @Timed
    public Task moveTask(Task taskToMove, Task movedTask, TaskContainer updatedOriginContainer, TaskContainer updatedTargetContainer) {
        TaskContainer taskContainer = updatedOriginContainer;
        TaskContainer taskContainer2 = updatedTargetContainer;
        if (taskContainer == null ? taskContainer2 != null : !taskContainer.equals(taskContainer2)) {
            this.checkIsNotReferencedByDependencies(taskToMove.getId());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(taskToMove.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)taskWithOldId -> {
                SqlTaskRepository.$anonfun$moveTask$1(this, taskToMove, movedTask, taskWithOldId);
                return BoxedUnit.UNIT;
            });
        }
        this.releasePersistence().update(movedTask.getRelease());
        return movedTask;
    }

    @Timed
    public List<String> findAffectedByBlackout(Blackout blackout) {
        Date endDate = BlackoutMetadata$.MODULE$.toStartOfNextMinute(blackout.getEndDate());
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.dialect()).selectReleaseData().withOneOfStatuses((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])ReleaseStatus.ACTIVE_STATUSES)).build();
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((TraversableLike)((TraversableLike)this.releasePersistence().findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(this.tryDeserializeRelease((ReleaseRow)x$2, new ResolveOptionsBuilder().build())), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)rel -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(rel.getAllTasks()).asScala(), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$findAffectedByBlackout$3(endDate, task)))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Seq$.MODULE$.canBuildFrom())).asJava();
    }

    @Timed
    @IsReadOnly
    public String getTitle(String taskId) {
        return (String)this.taskPersistence().getTitle(taskId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException("Task [%s] not found", new Object[]{taskId});
        });
    }

    public static final /* synthetic */ void $anonfun$updateTaskProperties$1(SqlTaskRepository $this, Task task$1, Dependency x0$1) {
        Dependency dependency = x0$1;
        if (dependency.isArchived()) {
            $this.dependencyPersistence().deleteDependency(dependency);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            try {
                $this.dependencyPersistence().updateDependency(dependency);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (NotFoundException e) {
                $this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Dependency ").append(dependency).append(" not found when updating task ").append(task$1).toString(), (Function0 & Serializable & scala.Serializable)() -> e);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public static final /* synthetic */ void $anonfun$delete$1(SqlTaskRepository $this, Dependency dependency) {
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    public static final /* synthetic */ boolean $anonfun$createTask$1(Task newTask$1, Task x$1) {
        String string = x$1.getContainer().getId();
        String string2 = newTask$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$moveTask$1(SqlTaskRepository $this, Task taskToMove$1, Task movedTask$1, Task taskWithOldId) {
        String oldId = taskWithOldId.getId();
        String newId = oldId.replace(taskToMove$1.getId(), movedTask$1.getId());
        $this.taskPersistence().move(oldId, newId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$findAffectedByBlackout$3(Date endDate$1, Task task) {
        TaskStatus taskStatus = task.getStatus();
        TaskStatus taskStatus2 = TaskStatus.PENDING;
        if (taskStatus == null) {
            if (taskStatus2 != null) {
                return false;
            }
        } else if (!taskStatus.equals(taskStatus2)) return false;
        if (!task.isPostponedDueToBlackout()) return false;
        Date date = task.getScheduledStartDate();
        Date date2 = endDate$1;
        if (date == null) {
            if (date2 == null) return true;
            return false;
        } else {
            if (!((Object)date).equals(date2)) return false;
            return true;
        }
    }

    public SqlTaskRepository(ReleasePersistence releasePersistence, DependencyPersistence dependencyPersistence, TaskPersistence taskPersistence, CommentRepository commentRepository, SqlRepositoryAdapter repositoryAdapter, ConfigurationPersistence configurationPersistence, FacetRepositoryDispatcher facetRepositoryDispatcher, SqlBuilder.Dialect dialect) {
        this.releasePersistence = releasePersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.taskPersistence = taskPersistence;
        this.commentRepository = commentRepository;
        this.repositoryAdapter = repositoryAdapter;
        this.configurationPersistence = configurationPersistence;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.dialect = dialect;
        TaskRepository.$init$((TaskRepository)this);
        BaseReleaseItemRepository.$init$(this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        Logging.$init$((Logging)this);
    }
}

