/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.query.ResolveOptions;
import com.xebialabs.xlrelease.repository.sql.BaseReleaseItemRepository;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\u0005ee\u0001\u0002\n\u0014\u0001yA\u0001\"\u000e\u0001\u0003\u0006\u0004%\tA\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005o!Aa\b\u0001BC\u0002\u0013\u0005q\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003A\u0011!!\u0005A!b\u0001\n\u0003)\u0005\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u000b)\u0003A\u0011A&\t\u000bA\u0003A\u0011I)\t\u000bA\u0004A\u0011I9\t\u000bi\u0004A\u0011I>\t\r}\u0004A\u0011IA\u0001\u0011\u001d\ti\u0001\u0001C!\u0003\u001fAq!a\u000b\u0001\t\u0003\ni\u0003C\u0004\u0002F\u0001!\t%a\u0012\t\u000f\u0005}\u0003\u0001\"\u0003\u0002b!9\u0011q\r\u0001\u0005\n\u0005%\u0004bBA?\u0001\u0011%\u0011q\u0010\u0002\u0018'FdG)\u001a9f]\u0012,gnY=SKB|7/\u001b;pefT!\u0001F\u000b\u0002\u0007M\fHN\u0003\u0002\u0017/\u0005Q!/\u001a9pg&$xN]=\u000b\u0005aI\u0012!\u0003=me\u0016dW-Y:f\u0015\tQ2$A\u0005yK\nL\u0017\r\\1cg*\tA$A\u0002d_6\u001c\u0001aE\u0003\u0001?\u0015JS\u0006\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VM\u001a\t\u0003M\u001dj\u0011!F\u0005\u0003QU\u0011A\u0003R3qK:$WM\\2z%\u0016\u0004xn]5u_JL\bC\u0001\u0016,\u001b\u0005\u0019\u0012B\u0001\u0017\u0014\u0005e\u0011\u0015m]3SK2,\u0017m]3Ji\u0016l'+\u001a9pg&$xN]=\u0011\u00059\u001aT\"A\u0018\u000b\u0005A\n\u0014!B:mMRR'\"\u0001\u001a\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!\u0001N\u0018\u0003\u000f1{wmZ5oO\u0006\u0011\"/\u001a7fCN,\u0007+\u001a:tSN$XM\\2f+\u00059\u0004C\u0001\u001d<\u001b\u0005I$B\u0001\u001e\u0014\u0003-\u0001XM]:jgR,gnY3\n\u0005qJ$A\u0005*fY\u0016\f7/\u001a)feNL7\u000f^3oG\u0016\f1C]3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dK\u0002\nQ\u0003Z3qK:$WM\\2z!\u0016\u00148/[:uK:\u001cW-F\u0001A!\tA\u0014)\u0003\u0002Cs\t)B)\u001a9f]\u0012,gnY=QKJ\u001c\u0018n\u001d;f]\u000e,\u0017A\u00063fa\u0016tG-\u001a8dsB+'o]5ti\u0016t7-\u001a\u0011\u0002#I,\u0007o\\:ji>\u0014\u00180\u00113baR,'/F\u0001G!\tQs)\u0003\u0002I'\t!2+\u001d7SKB|7/\u001b;pef\fE-\u00199uKJ\f!C]3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3sA\u00051A(\u001b8jiz\"B\u0001T'O\u001fB\u0011!\u0006\u0001\u0005\u0006k\u001d\u0001\ra\u000e\u0005\u0006}\u001d\u0001\r\u0001\u0011\u0005\u0006\t\u001e\u0001\rAR\u0001\tM&tGMQ=JIR\u0011!\u000b\u0017\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+^\ta\u0001Z8nC&t\u0017BA,U\u0005)!U\r]3oI\u0016t7-\u001f\u0005\u00063\"\u0001\rAW\u0001\u0003S\u0012\u0004\"a\u00172\u000f\u0005q\u0003\u0007CA/\"\u001b\u0005q&BA0\u001e\u0003\u0019a$o\\8u}%\u0011\u0011-I\u0001\u0007!J,G-\u001a4\n\u0005\r$'AB*ue&twM\u0003\u0002bC!\u0012\u0001B\u001a\t\u0003O:l\u0011\u0001\u001b\u0006\u0003S*\f!\"\u00198o_R\fG/[8o\u0015\tYG.A\u0004nKR\u0014\u0018nY:\u000b\u00055\\\u0012\u0001C2pI\u0006D\u0017\r\\3\n\u0005=D'!\u0002+j[\u0016$\u0017AB2sK\u0006$X\rF\u0002Se^DQa]\u0005A\u0002Q\fqA]3mK\u0006\u001cX\r\u0005\u0002Tk&\u0011a\u000f\u0016\u0002\b%\u0016dW-Y:f\u0011\u0015A\u0018\u00021\u0001S\u0003)!W\r]3oI\u0016t7-\u001f\u0015\u0003\u0013\u0019\fa!\u001e9eCR,Gc\u0001*}{\")1O\u0003a\u0001i\")\u0001P\u0003a\u0001%\"\u0012!BZ\u0001\u0007I\u0016dW\r^3\u0015\t\u0005\r\u0011\u0011\u0002\t\u0004A\u0005\u0015\u0011bAA\u0004C\t!QK\\5u\u0011\u0015A8\u00021\u0001SQ\tYa-A\u0004be\u000eD\u0017N^3\u0015\r\u0005\r\u0011\u0011CA\n\u0011\u0015\u0019H\u00021\u0001u\u0011\u001d\t)\u0002\u0004a\u0001\u0003/\tA#\u0019:dQ&4X\r\u001a#fa\u0016tG-\u001a8dS\u0016\u001c\b#BA\r\u0003G\u0011f\u0002BA\u000e\u0003?q1!XA\u000f\u0013\u0005\u0011\u0013bAA\u0011C\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0013\u0003O\u00111aU3r\u0015\r\t\t#\t\u0015\u0003\u0019\u0019\fqBZ5oI\nK(+\u001a7fCN,\u0017\n\u001a\u000b\u0005\u0003_\ty\u0004E\u0003\u00022\u0005m\"+\u0004\u0002\u00024)!\u0011QGA\u001c\u0003\u0011)H/\u001b7\u000b\u0005\u0005e\u0012\u0001\u00026bm\u0006LA!!\u0010\u00024\t!A*[:u\u0011\u0019\t\t%\u0004a\u00015\u0006I!/\u001a7fCN,\u0017\n\u001a\u0015\u0003\u001b\u0019\f1DZ5oI\u0006cG.\u00138d_6Lgn\u001a#fa\u0016tG-\u001a8dS\u0016\u001cH\u0003CA\f\u0003\u0013\ny%a\u0015\t\u000f\u0005-c\u00021\u0001\u0002N\u0005IA/\u0019:hKRLEm\u001d\t\u0006\u00033\t\u0019C\u0017\u0005\b\u0003#r\u0001\u0019AA'\u0003!\u0019H/\u0019;vg\u0016\u001c\bbBA+\u001d\u0001\u0007\u0011qK\u0001\u0014e\u00164WM]3oG&twm\u00115jY\u0012\u0014XM\u001c\t\u0004A\u0005e\u0013bAA.C\t9!i\\8mK\u0006t\u0007F\u0001\bg\u00039\u0011Xm]8mm\u0016$\u0016M]4fiN$B!a\u0006\u0002d!9\u0011QM\bA\u0002\u0005]\u0011\u0001\u00043fa\u0016tG-\u001a8dS\u0016\u001c\u0018a\u0007:fg>dg/\u001a+be\u001e,GO\u0012:p[\u000e\u000bg\u000eZ5eCR,7\u000fF\u0003S\u0003W\nY\bC\u0004\u0002nA\u0001\r!a\u001c\u0002-Q\f'oZ3u%\u0016dW-Y:f!2\fg.\u0013;f[N\u0004RaWA9\u0003kJ1!a\u001de\u0005\r\u0019V\r\u001e\t\u0004'\u0006]\u0014bAA=)\nA\u0001\u000b\\1o\u0013R,W\u000eC\u0003y!\u0001\u0007!+\u0001\u000bm_\u0006$'+\u001a7fCN,\u0007\u000b\\1o\u0013R,Wn\u001d\u000b\u0005\u0003_\n\t\t\u0003\u0004\u0002\u0004F\u0001\rAW\u0001\u0010i\u0006\u0014x-\u001a;SK2,\u0017m]3JI\"\u001a\u0001!a\"\u0011\t\u0005%\u0015QS\u0007\u0003\u0003\u0017SA!!$\u0002\u0010\u0006YAO]1og\u0006\u001cG/[8o\u0015\r!\u0012\u0011\u0013\u0006\u0004\u0003';\u0012A\u00013c\u0013\u0011\t9*a#\u0003\u001f%\u001bHK]1og\u0006\u001cG/[8oC2\u0004")
public class SqlDependencyRepository
implements DependencyRepository,
BaseReleaseItemRepository,
Logging {
    private final ReleasePersistence releasePersistence;
    private final DependencyPersistence dependencyPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Release getRelease(String releaseId, String entityId) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId);
    }

    @Override
    public Release getRelease(String releaseId, String entityId, ResolveOptions resolveOptions) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId, resolveOptions);
    }

    @Override
    public <T> T notNull(T ci, String ciId) {
        return (T)BaseReleaseItemRepository.notNull$(this, ci, ciId);
    }

    @Override
    public void insertDependencyWithGateTaskUid(Integer gateTaskUid, Dependency dependency) {
        BaseReleaseItemRepository.insertDependencyWithGateTaskUid$(this, gateTaskUid, dependency);
    }

    @Override
    public void insertDependency(Dependency dependency) {
        BaseReleaseItemRepository.insertDependency$(this, dependency);
    }

    @Override
    public void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        BaseReleaseItemRepository.checkIsNotReferencedByDependencies$(this, planItemIdOrItsChildren);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlDependencyRepository sqlDependencyRepository = this;
        synchronized (sqlDependencyRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    @Override
    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Timed
    public Dependency findById(String id) {
        String releaseId = Ids.releaseIdFrom((String)id);
        Release release = this.getRelease(releaseId, id);
        Option maybeDependency = ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllGates()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$1.getDependencies()).asScala(), Buffer$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SqlDependencyRepository.$anonfun$findById$2(id, x$2)));
        return (Dependency)maybeDependency.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(30).append("Repository entity [").append(id).append("] not found").toString(), new Object[0]);
        });
    }

    @Timed
    public Dependency create(Release release, Dependency dependency) {
        this.insertDependency(dependency);
        this.releasePersistence().update(release);
        return dependency;
    }

    @Timed
    public Dependency update(Release release, Dependency dependency) {
        if (!dependency.isArchived()) {
            this.dependencyPersistence().updateDependency(dependency);
        }
        this.releasePersistence().update(release);
        return dependency;
    }

    @Timed
    public void delete(Dependency dependency) {
        Release release = this.getRelease(Ids.releaseIdFrom((String)dependency.getId()), dependency.getId());
        Option maybeGateTask = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllGates()).asScala()).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SqlDependencyRepository.$anonfun$delete$1(dependency, x$3)));
        maybeGateTask.map((Function1 & Serializable & scala.Serializable)gateTask -> {
            gateTask.setDependencies((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(gateTask.getDependencies()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SqlDependencyRepository.$anonfun$delete$3(dependency, x$4)))).asJava());
            this.releasePersistence().update(release);
            this.dependencyPersistence().deleteDependency(dependency);
            return dependency;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(47).append("GateTask ").append(dependency.getGateTask().getId()).append(" not found while deleting dependency ").append(dependency.getId()).append(".").toString(), new Object[0]);
        });
    }

    @Timed
    public void archive(Release release, Seq<Dependency> archivedDependencies) {
        block0: {
            if (!archivedDependencies.nonEmpty()) break block0;
            archivedDependencies.foreach((Function1 & Serializable & scala.Serializable)dependency -> {
                SqlDependencyRepository.$anonfun$archive$1(this, dependency);
                return BoxedUnit.UNIT;
            });
            this.releasePersistence().update(release);
        }
    }

    @Timed
    public List<Dependency> findByReleaseId(String releaseId) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.resolveTargets(DependencyRow$.MODULE$.DependencyDataSeqOps(this.dependencyPersistence().findByGateReleaseId(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(releaseId)))).asDependencies())).asJava();
    }

    @Timed
    public Seq<Dependency> findAllIncomingDependencies(Seq<String> targetIds, Seq<String> statuses, boolean referencingChildren) {
        return referencingChildren ? DependencyRow$.MODULE$.DependencyDataSeqOps(this.dependencyPersistence().findByPartialTargetIds((Set<String>)targetIds.toSet(), (Option<Set<String>>)SqlDependencyRepository.status$1(statuses))).asDependencies() : DependencyRow$.MODULE$.DependencyDataSeqOps(this.dependencyPersistence().findByTargetIds((Set<String>)targetIds.toSet(), (Option<Set<String>>)SqlDependencyRepository.status$1(statuses))).asDependencies();
    }

    private Seq<Dependency> resolveTargets(Seq<Dependency> dependencies) {
        ((TraversableLike)((TraversableLike)dependencies.filterNot((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.hasVariableTarget()))).filter((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)SqlDependencyRepository.$anonfun$resolveTargets$2(d)))).groupBy((Function1 & Serializable & scala.Serializable)d -> Ids.releaseIdFrom((String)d.getTargetId())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SqlDependencyRepository.$anonfun$resolveTargets$4(this, x0$1);
            return BoxedUnit.UNIT;
        });
        return dependencies;
    }

    private Dependency resolveTargetFromCandidates(Set<PlanItem> targetReleasePlanItems, Dependency dependency) {
        String targetId = dependency.getTargetId();
        if (!dependency.hasVariableTarget()) {
            Option option = targetReleasePlanItems.find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SqlDependencyRepository.$anonfun$resolveTargetFromCandidates$1(targetId, x$6)));
            if (option instanceof Some) {
                Some some = (Some)option;
                PlanItem target = (PlanItem)some.value();
                dependency.setTarget(target);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Target '").append(dependency.getTargetId()).append("' of the Dependency '").append(dependency.getId()).append("' could not be resolved").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
        return dependency;
    }

    private Set<PlanItem> loadReleasePlanItems(String targetReleaseId) {
        Set set;
        try {
            Release releaseOrNull = (Release)this.repositoryAdapter().read(targetReleaseId);
            set = (Set)Option$.MODULE$.apply((Object)releaseOrNull).map((Function1 & Serializable & scala.Serializable)x$7 -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$7.getAllPlanItems()).asScala()).toSet()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
        }
        catch (NotFoundException notFoundException) {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Could not find release by ID ").append(targetReleaseId).toString());
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    public static final /* synthetic */ boolean $anonfun$findById$2(String id$1, Dependency x$2) {
        String string = x$2.getId();
        String string2 = CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id$1));
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$delete$1(Dependency dependency$1, GateTask x$3) {
        String string = x$3.getId();
        String string2 = CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(dependency$1.getGateTask().getId()));
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$delete$3(Dependency dependency$1, Dependency x$4) {
        String string = x$4.getId();
        String string2 = CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(dependency$1.getId()));
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$archive$1(SqlDependencyRepository $this, Dependency dependency) {
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    private static final Option status$1(Seq statuses$1) {
        return statuses$1.isEmpty() ? None$.MODULE$ : new Some((Object)statuses$1.toSet());
    }

    public static final /* synthetic */ boolean $anonfun$resolveTargets$2(Dependency d) {
        return Ids.isReleaseId((String)d.getTargetId()) || Ids.isInRelease((String)d.getTargetId());
    }

    public static final /* synthetic */ void $anonfun$resolveTargets$4(SqlDependencyRepository $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String targetReleaseId = (String)tuple2._1();
        Seq releaseDependencies = (Seq)tuple2._2();
        Set<PlanItem> targetReleasePlanItems = $this.loadReleasePlanItems(targetReleaseId);
        releaseDependencies.foreach((Function1 & Serializable & scala.Serializable)d -> $this.resolveTargetFromCandidates(targetReleasePlanItems, (Dependency)d));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$resolveTargetFromCandidates$1(String targetId$1, PlanItem x$6) {
        String string = x$6.getId();
        String string2 = targetId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public SqlDependencyRepository(ReleasePersistence releasePersistence, DependencyPersistence dependencyPersistence, SqlRepositoryAdapter repositoryAdapter) {
        this.releasePersistence = releasePersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.repositoryAdapter = repositoryAdapter;
        BaseReleaseItemRepository.$init$(this);
        Logging.$init$((Logging)this);
    }
}

