/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.CiWithUid;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.Diff$;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.query.ResolveOptions;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.SqlReleaseRepositoryHelper;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence$CommentRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.security.SecuredCi;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\r5e\u0001B\u00181\u0001mB\u0001\"\u0019\u0001\u0003\u0002\u0003\u0006IA\u0019\u0005\tQ\u0002\u0011)\u0019!C\tS\"AQ\u000e\u0001B\u0001B\u0003%!\u000e\u0003\u0005o\u0001\t\u0015\r\u0011\"\u0005p\u0011!\u0019\bA!A!\u0002\u0013\u0001\b\u0002\u0003;\u0001\u0005\u000b\u0007I\u0011C;\t\u0011e\u0004!\u0011!Q\u0001\nYD\u0001B\u001f\u0001\u0003\u0006\u0004%\tb\u001f\u0005\t\u007f\u0002\u0011\t\u0011)A\u0005y\"Q\u0011\u0011\u0001\u0001\u0003\u0006\u0004%\t\"a\u0001\t\u0015\u0005-\u0001A!A!\u0002\u0013\t)\u0001\u0003\u0006\u0002\u000e\u0001\u0011)\u0019!C\u0001\u0003\u001fA!\"!\b\u0001\u0005\u0003\u0005\u000b\u0011BA\t\u0011)\ty\u0002\u0001BC\u0002\u0013\u0005\u0011\u0011\u0005\u0005\u000b\u0003S\u0001!\u0011!Q\u0001\n\u0005\r\u0002BCA\u0016\u0001\t\u0005\t\u0015!\u0003\u0002.!Q\u00111\u0007\u0001\u0003\u0006\u0004%\u0019!!\u000e\t\u0015\u0005\u0015\u0004A!A!\u0002\u0013\t9\u0004C\u0004\u0002h\u0001!\t!!\u001b\t\u000f\u0005\r\u0005\u0001\"\u0011\u0002\u0006\"9\u0011Q\u0019\u0001\u0005B\u0005\u001d\u0007bBAp\u0001\u0011\u0005\u0013\u0011\u001d\u0005\b\u0003?\u0004A\u0011IAt\u0011\u001d\ti\u0010\u0001C!\u0003\u007fDqAa\u000e\u0001\t\u0003\u0012I\u0004C\u0004\u0003B\u0001!\tAa\u0011\t\u000f\t\u001d\u0004\u0001\"\u0011\u0003j!9!1\u0010\u0001\u0005\u0002\tu\u0004b\u0002BF\u0001\u0011\u0005#Q\u0012\u0005\b\u0005C\u0003A\u0011\tBR\u0011\u001d\u0011I\u000b\u0001C\u0005\u0005WCqAa-\u0001\t\u0003\u0012)\fC\u0004\u0003>\u0002!\tEa0\t\u000f\t-\u0007\u0001\"\u0011\u0003N\"9!1\u001b\u0001\u0005B\tU\u0007b\u0002Bp\u0001\u0011\u0005#\u0011\u001d\u0005\b\u0005W\u0004A\u0011\tBw\u0011\u001d\u0011Y\u0010\u0001C!\u0005{Dqa!\u0002\u0001\t\u0003\u001a9\u0001C\u0004\u0004\u0010\u0001!\te!\u0005\t\u000f\r=\u0001\u0001\"\u0011\u0004\u0018!911\u0005\u0001\u0005B\r\u0015\u0002bBB\u0017\u0001\u0011\u00053q\u0006\u0005\b\u0007\u007f\u0001A\u0011BB!\u0011\u001d\u0019\t\u0007\u0001C\u0005\u0007GBqa!\u001b\u0001\t\u0003\u001aYG\u0001\u000bTc2\u0014V\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\u0006\u0003cI\n1a]9m\u0015\t\u0019D'\u0001\u0006sKB|7/\u001b;pefT!!\u000e\u001c\u0002\u0013ad'/\u001a7fCN,'BA\u001c9\u0003%AXMY5bY\u0006\u00147OC\u0001:\u0003\r\u0019w.\\\u0002\u0001'!\u0001AH\u0011$Q1ns\u0006CA\u001fA\u001b\u0005q$\"A \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005s$AB!osJ+g\r\u0005\u0002D\t6\t!'\u0003\u0002Fe\t\t\"+\u001a7fCN,'+\u001a9pg&$xN]=\u0011\u0007\u001dC%*D\u00011\u0013\tI\u0005GA\u000bJ]R,'oY3qi\u0016$'+\u001a9pg&$xN]=\u0011\u0005-sU\"\u0001'\u000b\u00055#\u0014A\u00023p[\u0006Lg.\u0003\u0002P\u0019\n9!+\u001a7fCN,\u0007CA)W\u001b\u0005\u0011&BA*U\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005)\u0016\u0001C4sSjTH.\u001a3\n\u0005]\u0013&a\u0002'pO\u001eLgn\u001a\t\u0003\u000ffK!A\u0017\u0019\u0003-\u0011+7/\u001a:jC2L'0\u0019;j_:\u001cV\u000f\u001d9peR\u0004\"a\u0012/\n\u0005u\u0003$AH\"p]\u001aLw-\u001e:bi&|gNU3gKJ,gnY3t'V\u0004\bo\u001c:u!\t9u,\u0003\u0002aa\tQ2+\u001d7SK2,\u0017m]3SKB|7/\u001b;pefDU\r\u001c9fe\u0006\u0011\"/\u001a7fCN,\u0007+\u001a:tSN$XM\\2f!\t\u0019g-D\u0001e\u0015\t)\u0007'A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,\u0017BA4e\u0005I\u0011V\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0002\u001fQ\f7o\u001b)feNL7\u000f^3oG\u0016,\u0012A\u001b\t\u0003G.L!\u0001\u001c3\u0003\u001fQ\u000b7o\u001b)feNL7\u000f^3oG\u0016\f\u0001\u0003^1tWB+'o]5ti\u0016t7-\u001a\u0011\u0002+\u0011,\u0007/\u001a8eK:\u001c\u0017\u0010U3sg&\u001cH/\u001a8dKV\t\u0001\u000f\u0005\u0002dc&\u0011!\u000f\u001a\u0002\u0016\t\u0016\u0004XM\u001c3f]\u000eL\b+\u001a:tSN$XM\\2f\u0003Y!W\r]3oI\u0016t7-\u001f)feNL7\u000f^3oG\u0016\u0004\u0013AE2p[6,g\u000e\u001e)feNL7\u000f^3oG\u0016,\u0012A\u001e\t\u0003G^L!\u0001\u001f3\u0003%\r{W.\\3oiB+'o]5ti\u0016t7-Z\u0001\u0014G>lW.\u001a8u!\u0016\u00148/[:uK:\u001cW\rI\u0001\u000fi\u0016\fWNU3q_NLGo\u001c:z+\u0005a\bCA\"~\u0013\tq(G\u0001\bUK\u0006l'+\u001a9pg&$xN]=\u0002\u001fQ,\u0017-\u001c*fa>\u001c\u0018\u000e^8ss\u0002\n1D]3mK\u0006\u001cX-\u0012=uK:\u001c\u0018n\u001c8t%\u0016\u0004xn]5u_JLXCAA\u0003!\r\u0019\u0015qA\u0005\u0004\u0003\u0013\u0011$a\u0007*fY\u0016\f7/Z#yi\u0016t7/[8ogJ+\u0007o\\:ji>\u0014\u00180\u0001\u000fsK2,\u0017m]3FqR,gn]5p]N\u0014V\r]8tSR|'/\u001f\u0011\u00021\r|gNZ5hkJ\fG/[8o!\u0016\u00148/[:uK:\u001cW-\u0006\u0002\u0002\u0012A!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u0018\u0011\fQbY8oM&<WO]1uS>t\u0017\u0002BA\u000e\u0003+\u0011\u0011eQ8oM&<WO]1uS>t'+\u001a4fe\u0016t7-\u001a)feNL7\u000f^3oG\u0016\f\u0011dY8oM&<WO]1uS>t\u0007+\u001a:tSN$XM\\2fA\u0005\t\"/\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0016\u0005\u0005\r\u0002cA$\u0002&%\u0019\u0011q\u0005\u0019\u0003)M\u000bHNU3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3s\u0003I\u0011X\r]8tSR|'/_!eCB$XM\u001d\u0011\u00023\u0019\f7-\u001a;SKB|7/\u001b;pef$\u0015n\u001d9bi\u000eDWM\u001d\t\u0004\u0007\u0006=\u0012bAA\u0019e\tIb)Y2fiJ+\u0007o\\:ji>\u0014\u0018\u0010R5ta\u0006$8\r[3s\u0003)\u0019\u0018\u000f\u001c#jC2,7\r^\u000b\u0003\u0003o\u0001B!!\u000f\u0002`9!\u00111HA-\u001d\u0011\ti$!\u0016\u000f\t\u0005}\u0012\u0011\u000b\b\u0005\u0003\u0003\nyE\u0004\u0003\u0002D\u00055c\u0002BA#\u0003\u0017j!!a\u0012\u000b\u0007\u0005%#(\u0001\u0004=e>|GOP\u0005\u0002s%\u0011q\u0007O\u0005\u0003kYJ1!a\u00155\u0003\t!'-C\u00022\u0003/R1!a\u00155\u0013\u0011\tY&!\u0018\u0002\u0015M\u000bHNQ;jY\u0012,'OC\u00022\u0003/JA!!\u0019\u0002d\t9A)[1mK\u000e$(\u0002BA.\u0003;\n1b]9m\t&\fG.Z2uA\u00051A(\u001b8jiz\"B#a\u001b\u0002r\u0005M\u0014QOA<\u0003s\nY(! \u0002\u0000\u0005\u0005E\u0003BA7\u0003_\u0002\"a\u0012\u0001\t\u000f\u0005M2\u0003q\u0001\u00028!)\u0011m\u0005a\u0001E\")\u0001n\u0005a\u0001U\")an\u0005a\u0001a\")Ao\u0005a\u0001m\")!p\u0005a\u0001y\"9\u0011\u0011A\nA\u0002\u0005\u0015\u0001bBA\u0007'\u0001\u0007\u0011\u0011\u0003\u0005\b\u0003?\u0019\u0002\u0019AA\u0012\u0011\u001d\tYc\u0005a\u0001\u0003[\ta!\u001a=jgR\u001cH\u0003BAD\u0003\u001b\u00032!PAE\u0013\r\tYI\u0010\u0002\b\u0005>|G.Z1o\u0011\u001d\ty\t\u0006a\u0001\u0003#\u000b!!\u001b3\u0011\t\u0005M\u00151\u0014\b\u0005\u0003+\u000b9\nE\u0002\u0002FyJ1!!'?\u0003\u0019\u0001&/\u001a3fM&!\u0011QTAP\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0014 )\u0007Q\t\u0019\u000b\u0005\u0003\u0002&\u0006-VBAAT\u0015\u0011\tI+!\u0018\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0003[\u000b9K\u0001\u0006JgJ+\u0017\rZ(oYfD3\u0001FAY!\u0011\t\u0019,!1\u000e\u0005\u0005U&\u0002BA\\\u0003s\u000b!\"\u00198o_R\fG/[8o\u0015\u0011\tY,!0\u0002\u000f5,GO]5dg*\u0019\u0011q\u0018\u001d\u0002\u0011\r|G-\u00195bY\u0016LA!a1\u00026\n)A+[7fI\u000611M]3bi\u0016$RASAe\u0003\u001bDa!a3\u0016\u0001\u0004Q\u0015a\u0002:fY\u0016\f7/\u001a\u0005\b\u0003\u001f,\u0002\u0019AAi\u0003U\u0011X\r\\3bg\u0016\u001c%/Z1uS>t7k\\;sG\u0016\u0004B!a5\u0002Z6\u0011\u0011Q\u001b\u0006\u0004\u0003/d\u0015AB3wK:$8/\u0003\u0003\u0002\\\u0006U'!\u0006*fY\u0016\f7/Z\"sK\u0006$\u0018n\u001c8T_V\u00148-\u001a\u0015\u0004+\u0005E\u0016\u0001\u00034j]\u0012\u0014\u00150\u00133\u0015\u0007)\u000b\u0019\u000fC\u0004\u0002\u0010Z\u0001\r!!%)\u0007Y\t\t\fF\u0003K\u0003S\fY\u000fC\u0004\u0002\u0010^\u0001\r!!%\t\u000f\u00055x\u00031\u0001\u0002p\u0006q!/Z:pYZ,w\n\u001d;j_:\u001c\b\u0003BAy\u0003ol!!a=\u000b\u0007\u0005U('A\u0003rk\u0016\u0014\u00180\u0003\u0003\u0002z\u0006M(A\u0004*fg>dg/Z(qi&|gn\u001d\u0015\u0004/\u0005E\u0016a\u00044j]\u0012LEm\u001d\"z'R\fG/^:\u0015\t\t\u0005!1\u0003\t\u0007\u0005\u0007\u0011i!!%\u000f\t\t\u0015!\u0011\u0002\b\u0005\u0003\u000b\u00129!C\u0001@\u0013\r\u0011YAP\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011yA!\u0005\u0003\u0007M+\u0017OC\u0002\u0003\fyBqA!\u0006\u0019\u0001\u0004\u00119\"\u0001\u0005ti\u0006$Xo]3t!\u0015i$\u0011\u0004B\u000f\u0013\r\u0011YB\u0010\u0002\u000byI,\u0007/Z1uK\u0012t\u0004\u0003\u0002B\u0010\u0005Ki!A!\t\u000b\u0007\t\rB*\u0001\u0004ti\u0006$Xo]\u0005\u0005\u0005O\u0011\tCA\u0007SK2,\u0017m]3Ti\u0006$Xo\u001d\u0015\u00041\u0005E\u0006f\u0001\r\u0003.A!!q\u0006B\u001a\u001b\t\u0011\tDC\u0002\u00028zJAA!\u000e\u00032\t9a/\u0019:be\u001e\u001c\u0018a\u00054j]\u0012\u0014\u0015pQ1mK:$\u0017M\u001d+pW\u0016tGc\u0001&\u0003<!9!QH\rA\u0002\u0005E\u0015!D2bY\u0016tG-\u0019:U_.,g\u000eK\u0002\u001a\u0003c\u000b\u0001DZ5oI\u0006\u00138\r[5wC\ndWMU3mK\u0006\u001cX-\u00133t)\u0019\u0011\tA!\u0012\u0003Z!9!q\t\u000eA\u0002\t%\u0013\u0001\u00023bi\u0016\u0004BAa\u0013\u0003V5\u0011!Q\n\u0006\u0005\u0005\u001f\u0012\t&\u0001\u0003vi&d'B\u0001B*\u0003\u0011Q\u0017M^1\n\t\t]#Q\n\u0002\u0005\t\u0006$X\rC\u0004\u0003\\i\u0001\rA!\u0018\u0002\u0011A\fw-Z*ju\u0016\u00042!\u0010B0\u0013\r\u0011\tG\u0010\u0002\u0004\u0013:$\bf\u0001\u000e\u0002$\"\u001a!$!-\u0002\u001dM,G\u000f\u0015:f\u0003J\u001c\u0007.\u001b<fIR1!1\u000eB9\u0005k\u00022!\u0010B7\u0013\r\u0011yG\u0010\u0002\u0005+:LG\u000fC\u0004\u0003tm\u0001\r!!%\u0002\u0013I,G.Z1tK&#\u0007b\u0002B<7\u0001\u0007\u0011qQ\u0001\faJ,\u0017I]2iSZ,G\rK\u0002\u001c\u0003c\u000b\u0011DZ5oIB\u0013X-\u0011:dQ&4\u0018M\u00197f%\u0016dW-Y:fgR1!q\u0010BA\u0005\u000b\u0003RAa\u0001\u0003\u000e)CqAa!\u001d\u0001\u0004\u0011i&\u0001\u0003qC\u001e,\u0007b\u0002B.9\u0001\u0007!Q\f\u0015\u00049\u0005\r\u0006f\u0001\u000f\u00022\u000611/Z1sG\"$BAa$\u0003\u0016B)!1\nBI\u0015&!!1\u0013B'\u0005\u0011a\u0015n\u001d;\t\u000f\t]U\u00041\u0001\u0003\u001a\u0006a1/Z1sG\"\u0004\u0016M]1ngB\u00191Ia'\n\u0007\tu%GA\u000bSK2,\u0017m]3TK\u0006\u00148\r\u001b\"z!\u0006\u0014\u0018-\\:)\u0007u\t\t,\u0001\u0004eK2,G/\u001a\u000b\u0005\u0005W\u0012)\u000bC\u0004\u0002\u0010z\u0001\r!!%)\u0007y\t\t,A\feK2,G/\u001a*fY\u0016\f7/\u001a*fM\u0016\u0014XM\\2fgR1!1\u000eBW\u0005_Cq!a$ \u0001\u0004\t\t\nC\u0004\u00032~\u0001\rA!\u0018\u0002\u0015I,G.Z1tKVKG-A\u0007eK2,G/Z,ji\",\u0016\u000e\u001a\u000b\u0007\u0005W\u00129L!/\t\u000f\u0005=\u0005\u00051\u0001\u0002\u0012\"9!\u0011\u0017\u0011A\u0002\tu\u0003f\u0001\u0011\u00022\u0006!Qn\u001c<f)\u0019\u0011YG!1\u0003F\"9!1Y\u0011A\u0002\u0005E\u0015AC8sS\u001eLg.\u00197JI\"9!qY\u0011A\u0002\u0005E\u0015!\u00028fo&#\u0007fA\u0011\u00022\u0006Iq-\u001a;Ti\u0006$Xo\u001d\u000b\u0005\u0005;\u0011y\rC\u0004\u0002\u0010\n\u0002\r!!%)\u0007\t\n\t,A\u0006hKR\u001cF/\u0019;vg\u0016\u001cH\u0003\u0002Bl\u00053\u0004bAa\u0001\u0003\u000e\tu\u0001b\u0002BnG\u0001\u0007!\u0011A\u0001\u0004S\u0012\u001c\bfA\u0012\u00022\u0006iq-\u001a;SSN\\7kY8sKN$BAa9\u0003fB1!1\u0001B\u0007\u0005;BqAa7%\u0001\u0004\u0011\t\u0001K\u0002%\u0003GC3\u0001JAY\u00035\u0019X\r\u001e*jg.\u001c6m\u001c:fgRA!1\u000eBx\u0005c\u0014)\u0010C\u0004\u0003t\u0015\u0002\r!!%\t\u000f\tMX\u00051\u0001\u0003^\u0005)1oY8sK\"9!q_\u0013A\u0002\tu\u0013A\u0003;pi\u0006d7kY8sK\"\u001aQ%!-\u0002\u0015%\u001cH+Z7qY\u0006$X\r\u0006\u0003\u0002\b\n}\bb\u0002B:M\u0001\u0007\u0011\u0011\u0013\u0015\u0004M\u0005\r\u0006f\u0001\u0014\u00022\u0006Aq-\u001a;USRdW\r\u0006\u0003\u0002\u0012\u000e%\u0001bBAHO\u0001\u0007\u0011\u0011\u0013\u0015\u0004O\u0005\r\u0006fA\u0014\u00022\u00061Q\u000f\u001d3bi\u0016$2ASB\n\u0011\u0019\tY\r\u000ba\u0001\u0015\"\u001a\u0001&!-\u0015\u000b)\u001bIb!\b\t\r\rm\u0011\u00061\u0001K\u0003!y'/[4j]\u0006d\u0007BBB\u0010S\u0001\u0007!*A\u0004va\u0012\fG/\u001a3)\u0007%\n\t,A\u0004sKBd\u0017mY3\u0015\u000b)\u001b9c!\u000b\t\r\rm!\u00061\u0001K\u0011\u0019\u0019yB\u000ba\u0001\u0015\"\u001a!&!-\u0002\u0015\u001d,G/\u00117m)\u0006<7\u000f\u0006\u0003\u00042\r]\u0002C\u0002B&\u0007g\t\t*\u0003\u0003\u00046\t5#aA*fi\"91\u0011H\u0016A\u0002\tu\u0013a\u00037j[&$h*^7cKJD3aKARQ\rY\u0013\u0011W\u0001\u000bO\u0016$(+\u001a7fCN,G#\u0002&\u0004D\r}\u0003b\u0002B:Y\u0001\u00071Q\t\t\u0005\u0007\u000f\u001aIF\u0004\u0003\u0004J\rUc\u0002BB&\u0007'rAa!\u0014\u0004R9!\u0011qHB(\u0013\t\u0019D'\u0003\u00022e%\u0011Q\rM\u0005\u0004\u0007/\"\u0017\u0001B\"j\u0013\u0012LAaa\u0017\u0004^\t!1)[%e\u0015\r\u00199\u0006\u001a\u0005\b\u0003[d\u0003\u0019AAx\u0003\t\u001a\u0007.Z2l\u0013Ntu\u000e\u001e*fM\u0016\u0014XM\\2fI\nKH)\u001a9f]\u0012,gnY5fgR!!1NB3\u0011\u001d\u00199'\fa\u0001\u0007\u000b\nq\u0003\u001d7b]&#X-\\%e\u001fJLEo]\"iS2$'/\u001a8\u0002\u001f\u0019Lg\u000eZ*D\u001b\u0012\u000bG/\u0019\"z\u0013\u0012$Ba!\u001c\u0004\u0000A)Qha\u001c\u0004t%\u00191\u0011\u000f \u0003\r=\u0003H/[8o!\u0011\u0019)ha\u001f\u000e\u0005\r]$\u0002BB=\u0005#\nA\u0001\\1oO&!1QPB<\u0005\u001dIe\u000e^3hKJDq!a$/\u0001\u0004\t\t\nK\u0002/\u0003GC3ALAYQ\r\u00011q\u0011\t\u0005\u0003K\u001bI)\u0003\u0003\u0004\f\u0006\u001d&aD%t)J\fgn]1di&|g.\u00197")
public class SqlReleaseRepository
implements ReleaseRepository,
InterceptedRepository<Release>,
Logging,
DeserializationSupport,
ConfigurationReferencesSupport,
SqlReleaseRepositoryHelper {
    private final ReleasePersistence releasePersistence;
    private final TaskPersistence taskPersistence;
    private final DependencyPersistence dependencyPersistence;
    private final CommentPersistence commentPersistence;
    private final TeamRepository teamRepository;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private final ConfigurationReferencePersistence configurationPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final SqlBuilder.Dialect sqlDialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private Seq<PersistenceInterceptor<Release>> persistenceInterceptors;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public void replaceTasks(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceTasks$(this, original, updated);
    }

    @Override
    public void replaceReleaseExtensions(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceReleaseExtensions$(this, original, updated);
    }

    @Override
    public void replaceReleaseTeams(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceReleaseTeams$(this, original, updated);
    }

    @Override
    public void updateCommentsOnTasks(Task originalTask, Task updatedTask) {
        SqlReleaseRepositoryHelper.updateCommentsOnTasks$(this, originalTask, updatedTask);
    }

    @Override
    public void insertDependency(Integer gateTaskUid, Dependency dependency) {
        SqlReleaseRepositoryHelper.insertDependency$(this, gateTaskUid, dependency);
    }

    @Override
    public void updateConfigurationRefs(CiWithUid entity) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, entity);
    }

    @Override
    public void deleteConfigurationRefs(Integer uid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, uid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.deserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData, resolveOptions);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public void registerPersistenceInterceptor(PersistenceInterceptor<Release> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlReleaseRepository sqlReleaseRepository = this;
        synchronized (sqlReleaseRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public Seq<PersistenceInterceptor<Release>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(Seq<PersistenceInterceptor<Release>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public Seq<String> findIdsByStatus(ReleaseStatus ... statuses) {
        return this.findIdsByStatus((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])statuses));
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public CommentPersistence commentPersistence() {
        return this.commentPersistence;
    }

    public TeamRepository teamRepository() {
        return this.teamRepository;
    }

    public ReleaseExtensionsRepository releaseExtensionsRepository() {
        return this.releaseExtensionsRepository;
    }

    @Override
    public ConfigurationReferencePersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String id) {
        return this.releasePersistence.existsRelease(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id)));
    }

    @Timed
    public Release create(Release release, ReleaseCreationSource releaseCreationSource) {
        if (this.releasePersistence.existsRelease(release.getId())) {
            throw new ItemAlreadyExistsException("A release with ID [%s] already exists", new Object[]{release.getId()});
        }
        this.interceptCreate((ConfigurationItem)release);
        this.releasePersistence.insert(release);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)task -> {
            SqlReleaseRepository.$anonfun$create$1(this, release, task);
            return BoxedUnit.UNIT;
        });
        release.getExtensions().forEach(extension -> this.releaseExtensionsRepository().create(extension));
        this.updateConfigurationRefs((CiWithUid)release);
        this.facetRepositoryDispatcher.liveRepository().createFromTasks((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala(), this.facetRepositoryDispatcher.liveRepository().createFromTasks$default$2());
        return release;
    }

    @Timed
    public Release findById(String id) {
        return this.getRelease(id, new ResolveOptionsBuilder().withEverything().build());
    }

    @Timed
    public Release findById(String id, ResolveOptions resolveOptions) {
        return this.getRelease(id, resolveOptions);
    }

    @Timed
    public Seq<String> findIdsByStatus(Seq<ReleaseStatus> statuses) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses(statuses).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
    }

    @Timed
    public Release findByCalendarToken(String calendarToken) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withCalendarToken(calendarToken).build();
        Seq<ReleaseRow> releases = this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
        return (Release)releases.headOption().map((Function1 & Serializable & scala.Serializable)x$1 -> this.deserializeRelease((ReleaseRow)x$1, new ResolveOptionsBuilder().withEverything().build())).orNull(Predef$.MODULE$.$conforms());
    }

    @Timed
    @IsReadOnly
    public Seq<String> findArchivableReleaseIds(Date date, int pageSize) {
        ReleasesSqlBuilder qual$1 = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((Seq<ReleaseStatus>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED})))).withEndDateBefore(date).withPage(new Page(0L, (long)pageSize, Predef$.MODULE$.int2Integer(0)));
        boolean x$1 = qual$1.withPreArchived$default$1();
        Tuple2 sqlWithParams = qual$1.withPreArchived(x$1).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
    }

    @Timed
    public void setPreArchived(String releaseId, boolean preArchived) {
        this.releasePersistence.setPreArchived(releaseId, preArchived);
    }

    @Timed
    @IsReadOnly
    public Seq<Release> findPreArchivableReleases(int page, int pageSize) {
        Seq inactive = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED}));
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withOneOfStatuses((Seq<ReleaseStatus>)inactive).withPreArchived(false).limitAndOffset(pageSize, page * pageSize).build();
        return (Seq)((TraversableLike)((TraversableLike)((TraversableLike)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(this.tryDeserializeRelease((ReleaseRow)x$2, new ResolveOptionsBuilder().withEverything().build())), Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isTutorial()))).map((Function1 & Serializable & scala.Serializable)release -> this.releaseExtensionsRepository().decorate(release), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)release -> this.commentPersistence().decorate((Release)release), Seq$.MODULE$.canBuildFrom());
    }

    @Timed
    public List<Release> search(ReleaseSearchByParams searchParams) {
        ReleaseSearchByParams releaseSearchByParams = searchParams;
        if (releaseSearchByParams == null) {
            throw new MatchError((Object)releaseSearchByParams);
        }
        Page page = releaseSearchByParams.page();
        Either folderId2 = releaseSearchByParams.folderId();
        ReleaseStatus[] statuses = releaseSearchByParams.statuses();
        String title = releaseSearchByParams.title();
        String rootReleaseId = releaseSearchByParams.rootReleaseId();
        boolean autoStart = releaseSearchByParams.autoStart();
        ReleasesSqlBuilder base = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withTitle(title).withRootReleaseId(rootReleaseId).withPage(page);
        ReleasesSqlBuilder sqlBuilder = folderId2 == null ? base : (ReleasesSqlBuilder)folderId2.fold((Function1 & Serializable & scala.Serializable)folderId -> base.withFolder((String)folderId), (Function1 & Serializable & scala.Serializable)ancestorId -> base.withAncestor((String)ancestorId));
        Object object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).nonEmpty() ? sqlBuilder.withOneOfStatuses((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])statuses)) : BoxedUnit.UNIT;
        Object object2 = autoStart ? sqlBuilder.withAutoStart() : BoxedUnit.UNIT;
        List list = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((TraversableLike)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlBuilder.build()).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> Option$.MODULE$.option2Iterable(this.tryDeserializeRelease((ReleaseRow)x$4, new ResolveOptionsBuilder().withEverything().build())), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)release -> this.releaseExtensionsRepository().decorate(release), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)release -> this.commentPersistence().decorate((Release)release), Seq$.MODULE$.canBuildFrom())).asJava();
        return list;
    }

    @Timed
    public void delete(String id) {
        this.checkIsNotReferencedByDependencies(id);
        this.releasePersistence.findUidByReleaseId(id).foreach((Function1 & Serializable & scala.Serializable)uid -> {
            this.deleteReleaseReferences(id, uid);
            return BoxedUnit.UNIT;
        });
        this.releasePersistence.deleteById(id);
    }

    private void deleteReleaseReferences(String id, int releaseUid) {
        this.dependencyPersistence().deleteByReleaseUid(Predef$.MODULE$.int2Integer(releaseUid));
        this.commentPersistence().deleteByRelease(Predef$.MODULE$.int2Integer(releaseUid));
        this.taskPersistence().deleteTasksByReleaseUid(releaseUid);
        this.teamRepository().deleteTeamsFromPlatform(new SecuredCi(id, releaseUid));
        this.releaseExtensionsRepository().deleteAll(id);
        this.deleteConfigurationRefs(Predef$.MODULE$.int2Integer(releaseUid));
        this.interceptDelete(id);
    }

    @Timed
    public void deleteWithUid(String id, int releaseUid) {
        this.deleteReleaseReferences(id, releaseUid);
        this.releasePersistence.deleteById(id);
    }

    @Timed
    public void move(String originalId, String newId) {
        this.releasePersistence.move(originalId, newId);
    }

    @Timed
    public ReleaseStatus getStatus(String id) {
        String status = (String)this.releasePersistence.findReleaseStatus(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id))).orNull(Predef$.MODULE$.$conforms());
        return status == null ? null : ReleaseStatus.valueOf((String)status.toUpperCase());
    }

    @Timed
    public Seq<ReleaseStatus> getStatuses(Seq<String> ids) {
        return ids.isEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$) : (Seq)this.releasePersistence.findReleaseStatuses(ids).map((Function1 & Serializable & scala.Serializable)status -> ReleaseStatus.valueOf((String)status.toUpperCase()), Seq$.MODULE$.canBuildFrom());
    }

    @Timed
    @IsReadOnly
    public Seq<Object> getRiskScores(Seq<String> ids) {
        return this.releasePersistence.findReleaseRiskScores(ids);
    }

    @Timed
    public void setRiskScores(String releaseId, int score, int totalScore) {
        this.releasePersistence.updateReleaseRiskScores(releaseId, score, totalScore);
    }

    @Timed
    @IsReadOnly
    public boolean isTemplate(String releaseId) {
        return ReleaseStatus.TEMPLATE.equals(this.getStatus(releaseId));
    }

    @Timed
    @IsReadOnly
    public String getTitle(String id) {
        return (String)this.releasePersistence.findReleaseTitle(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new LogFriendlyNotFoundException("Release [%s] not found", new Object[]{id});
        });
    }

    @Timed
    public Release update(Release release) {
        return this.update(null, release);
    }

    @Timed
    public Release update(Release original, Release updated) {
        Option originalReleaseOpt = Option$.MODULE$.apply((Object)original);
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        originalReleaseOpt.foreach((Function1 & Serializable & scala.Serializable)rel -> {
            SqlReleaseRepository.$anonfun$update$1(this, updated, rel);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs((CiWithUid)updated);
        return updated;
    }

    @Timed
    public Release replace(Release original, Release updated) {
        if (Ids.isFolderId((String)original.getId())) {
            updated.setTeams(Collections.emptyList());
        }
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        if (original != null) {
            this.replaceTasks(original, updated);
            this.replaceReleaseExtensions(original, updated);
            this.replaceReleaseTeams(original, updated);
        }
        this.updateConfigurationRefs((CiWithUid)updated);
        return updated;
    }

    @Timed
    @IsReadOnly
    public Set<String> getAllTags(int limitNumber) {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.releasePersistence.findAllTags(limitNumber)).asJava();
    }

    /*
     * WARNING - void declaration
     */
    private Release getRelease(String releaseId, ResolveOptions resolveOptions) {
        void var3_3;
        BoxedUnit boxedUnit;
        Release release = (Release)this.repositoryAdapter().read(releaseId, resolveOptions);
        if (release == null) {
            throw new LogFriendlyNotFoundException(new StringBuilder(30).append("Repository entity [").append(releaseId).append("] not found").toString(), new Object[0]);
        }
        if (resolveOptions.hasDecorators()) {
            this.releaseExtensionsRepository().decorate(release);
            boxedUnit = this.commentPersistence().decorate(release);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    private void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        Seq externalIncomingDependencies = (Seq)((TraversableLike)this.dependencyPersistence().findByPartialTargetIds((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{planItemIdOrItsChildren}))), (Option<scala.collection.immutable.Set<String>>)None$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$6 -> DependencyRow$.MODULE$.DependencyRowOps((DependencyRow)x$6).fullDependencyId(), Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.startsWith(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(planItemIdOrItsChildren)))));
        if (externalIncomingDependencies.nonEmpty()) {
            throw new ItemInUseException(new StringBuilder(68).append("Cannot delete [").append(planItemIdOrItsChildren).append("] because it or one of its children is referenced by ").append(new StringBuilder(28).append("one or more dependencies: [").append(externalIncomingDependencies.mkString(", ")).append("]").toString()).toString(), new Object[0]);
        }
    }

    @Timed
    @IsReadOnly
    public Option<Integer> findSCMDataById(String id) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Finding scm data for template or release with id ").append(id).toString());
        return this.releasePersistence.findSCMDataById(id).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1));
    }

    public static final /* synthetic */ boolean $anonfun$create$2(SqlReleaseRepository $this, Integer taskUid$1, Comment comment) {
        return $this.commentPersistence().create(taskUid$1, CommentPersistence$CommentRow$.MODULE$.fromComment(comment));
    }

    public static final /* synthetic */ void $anonfun$create$1(SqlReleaseRepository $this, Release release$1, Task task) {
        Integer taskUid = $this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(release$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)comment -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$create$2($this, taskUid, comment)));
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$update$3(SqlReleaseRepository $this, Integer taskUid$2, Comment c) {
        return $this.commentPersistence().create(taskUid$2, CommentPersistence$CommentRow$.MODULE$.fromComment(c));
    }

    public static final /* synthetic */ void $anonfun$update$2(SqlReleaseRepository $this, Release updated$1, Task task) {
        Integer taskUid = $this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(updated$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$update$3($this, taskUid, c)));
        ((IterableLike)syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).filterNot((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isArchived()))).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$update$1(SqlReleaseRepository $this, Release updated$1, Release rel) {
        Diff$.MODULE$.apply((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(rel.getAllTasks()).asScala(), (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(updated$1.getAllTasks()).asScala()).newValues().foreach((Function1 & Serializable & scala.Serializable)task -> {
            SqlReleaseRepository.$anonfun$update$2($this, updated$1, task);
            return BoxedUnit.UNIT;
        });
    }

    public SqlReleaseRepository(ReleasePersistence releasePersistence, TaskPersistence taskPersistence, DependencyPersistence dependencyPersistence, CommentPersistence commentPersistence, TeamRepository teamRepository, ReleaseExtensionsRepository releaseExtensionsRepository, ConfigurationReferencePersistence configurationPersistence, SqlRepositoryAdapter repositoryAdapter, FacetRepositoryDispatcher facetRepositoryDispatcher, SqlBuilder.Dialect sqlDialect) {
        this.releasePersistence = releasePersistence;
        this.taskPersistence = taskPersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.commentPersistence = commentPersistence;
        this.teamRepository = teamRepository;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        this.configurationPersistence = configurationPersistence;
        this.repositoryAdapter = repositoryAdapter;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.sqlDialect = sqlDialect;
        InterceptedRepository.$init$((InterceptedRepository)this);
        Logging.$init$((Logging)this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        SqlReleaseRepositoryHelper.$init$(this);
    }
}

