/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.AttachmentRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import org.slf4j.Marker;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001\u0002\u0006\f\u0001YA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\u0006a\u0001!\t!\r\u0005\u0006k\u0001!\tE\u000e\u0005\u0006+\u0002!\tE\u0016\u0005\u0006+\u0002!\t\u0005\u001a\u0005\u0006Q\u0002!\t%\u001b\u0005\u0006Q\u0002!\t\u0005\u001d\u0005\u0006i\u0002!\t!\u001e\u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0005]\u0019\u0016\u000f\\!ui\u0006\u001c\u0007.\\3oiJ+\u0007o\\:ji>\u0014\u0018P\u0003\u0002\r\u001b\u0005\u00191/\u001d7\u000b\u00059y\u0011A\u0003:fa>\u001c\u0018\u000e^8ss*\u0011\u0001#E\u0001\nq2\u0014X\r\\3bg\u0016T!AE\n\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u000b\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u00019R$\t\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005yyR\"A\u0007\n\u0005\u0001j!\u0001F!ui\u0006\u001c\u0007.\\3oiJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002#O5\t1E\u0003\u0002%K\u0005)1\u000f\u001c45U*\ta%\u0001\u0005he&T(\u0010\\3e\u0013\tA3EA\u0004M_\u001e<\u0017N\\4\u0002%I,G.Z1tKB+'o]5ti\u0016t7-\u001a\t\u0003W9j\u0011\u0001\f\u0006\u0003[-\t1\u0002]3sg&\u001cH/\u001a8dK&\u0011q\u0006\f\u0002\u0013%\u0016dW-Y:f!\u0016\u00148/[:uK:\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0003eQ\u0002\"a\r\u0001\u000e\u0003-AQ!\u000b\u0002A\u0002)\n\u0001BZ5oI\nK\u0018\n\u001a\u000b\u0003ou\u0002\"\u0001O\u001e\u000e\u0003eR!AO\b\u0002\r\u0011|W.Y5o\u0013\ta\u0014H\u0001\u0006BiR\f7\r[7f]RDQAP\u0002A\u0002}\nA\"\u0019;uC\u000eDW.\u001a8u\u0013\u0012\u0004\"\u0001Q$\u000f\u0005\u0005+\u0005C\u0001\"\u001a\u001b\u0005\u0019%B\u0001#\u0016\u0003\u0019a$o\\8u}%\u0011a)G\u0001\u0007!J,G-\u001a4\n\u0005!K%AB*ue&twM\u0003\u0002G3!\u00121a\u0013\t\u0003\u0019Nk\u0011!\u0014\u0006\u0003\u001d>\u000b!\"\u00198o_R\fG/[8o\u0015\t\u0001\u0016+A\u0004nKR\u0014\u0018nY:\u000b\u0005I\u001b\u0012\u0001C2pI\u0006D\u0017\r\\3\n\u0005Qk%!\u0002+j[\u0016$\u0017AB2sK\u0006$X\r\u0006\u00038/r\u000b\u0007\"\u0002-\u0005\u0001\u0004I\u0016a\u0002:fY\u0016\f7/\u001a\t\u0003qiK!aW\u001d\u0003\u000fI+G.Z1tK\")Q\f\u0002a\u0001=\u0006!A/Y:l!\tAt,\u0003\u0002as\t!A+Y:l\u0011\u0015\u0011G\u00011\u00018\u0003)\tG\u000f^1dQ6,g\u000e\u001e\u0015\u0003\t-#2aN3g\u0011\u0015AV\u00011\u0001Z\u0011\u0015\u0011W\u00011\u00018Q\t)1*\u0001\u0004eK2,G/\u001a\u000b\u0004U6t\u0007C\u0001\rl\u0013\ta\u0017D\u0001\u0003V]&$\b\"\u0002-\u0007\u0001\u0004I\u0006\"\u00022\u0007\u0001\u00049\u0004F\u0001\u0004L)\rQ\u0017O\u001d\u0005\u0006;\u001e\u0001\rA\u0018\u0005\u0006E\u001e\u0001\ra\u000e\u0015\u0003\u000f-\u000b1BY1uG\"Len]3siR\u0019a/\u001f>\u0011\u0005a9\u0018B\u0001=\u001a\u0005\u001d\u0011un\u001c7fC:DQ\u0001\u0017\u0005A\u0002eCQa\u001f\u0005A\u0002q\f1\"\u0019;uC\u000eDW.\u001a8ugB!Q0!\u00028\u001d\rq\u0018\u0011\u0001\b\u0003\u0005~L\u0011AG\u0005\u0004\u0003\u0007I\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u000f\tIAA\u0002TKFT1!a\u0001\u001a\u0003\u0019Ign]3siRIa/a\u0004\u00028\u0005m\u0012q\b\u0005\b\u0003#I\u0001\u0019AA\n\u0003)\u0011X\r\\3bg\u0016,\u0016\u000e\u001a\t\u0005\u0003+\t\tD\u0004\u0003\u0002\u0018\u0005=b\u0002BA\r\u0003[qA!a\u0007\u0002,9!\u0011QDA\u0015\u001d\u0011\ty\"a\n\u000f\t\u0005\u0005\u0012Q\u0005\b\u0004\u0005\u0006\r\u0012\"\u0001\u000b\n\u0005I\u0019\u0012B\u0001\t\u0012\u0013\tqq\"\u0003\u0002\r\u001b%\u0011QfC\u0005\u0004\u0003\u0007a\u0013\u0002BA\u001a\u0003k\u0011QaQ5VS\u0012T1!a\u0001-\u0011\u0019\tI$\u0003a\u0001\u007f\u0005Q\u0011M\u001d;jM\u0006\u001cG/\u00133\t\r\u0005u\u0012\u00021\u0001@\u00031\t'\u000f^5gC\u000e$h*Y7f\u0011\u001d\t\t%\u0003a\u0001\u0003\u0007\nqaY8oi\u0016tG\u000f\u0005\u0003\u0002F\u0005=SBAA$\u0015\u0011\tI%a\u0013\u0002\u0005%|'BAA'\u0003\u0011Q\u0017M^1\n\t\u0005E\u0013q\t\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000eK\u0002\u0001\u0003+\u0002B!a\u0016\u0002d5\u0011\u0011\u0011\f\u0006\u0005\u00037\ni&A\u0006ue\u0006t7/Y2uS>t'b\u0001\u0007\u0002`)\u0019\u0011\u0011M\b\u0002\u0005\u0011\u0014\u0017\u0002BA3\u00033\u0012q\"S:Ue\u0006t7/Y2uS>t\u0017\r\u001c")
public class SqlAttachmentRepository
implements AttachmentRepository,
Logging {
    private final ReleasePersistence releasePersistence;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlAttachmentRepository sqlAttachmentRepository = this;
        synchronized (sqlAttachmentRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public Attachment findById(String attachmentId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Searching for attachment [").append(attachmentId).append("]").toString());
        return (Attachment)this.releasePersistence.findAttachmentById(attachmentId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new LogFriendlyNotFoundException("Repository entity [%s] not found", new Object[]{attachmentId});
        });
    }

    @Timed
    public Attachment create(Release release, Task task, Attachment attachment) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Adding attachment to task [").append(task.getId()).append("]").toString());
        Task releaseTask = release.getTask(task.getId());
        Set taskAttachments = (Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(releaseTask.getAttachments()).asScala()).toSet().$plus((Object)attachment);
        releaseTask.setAttachments((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)taskAttachments.toList()).asJava());
        return this.create(release, attachment);
    }

    @Timed
    public Attachment create(Release release, Attachment attachment) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Adding attachment to release [").append(release.getId()).append("]").toString());
        this.releasePersistence.update((Option<Release>)None$.MODULE$, release);
        this.releasePersistence.insertAttachments(release.getId(), (Seq<SourceArtifact>)new .colon.colon((Object)attachment, (List)Nil$.MODULE$));
        return attachment;
    }

    @Timed
    public void delete(Release release, Attachment attachment) {
        block0: {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Deleting attachment reference '").append(attachment.getId()).append("' from release '").append(release.getId()).append("'").toString());
            release.deleteAttachment(attachment.getId());
            this.releasePersistence.update(release);
            if (release.isTemplate()) break block0;
            this.releasePersistence.deleteAttachmentById(attachment.getId());
        }
    }

    @Timed
    public void delete(Task task, Attachment attachment) {
        task.deleteAttachment(attachment.getId());
        Release release = task.getRelease();
        if (release.getTasksUsingAttachment(attachment.getId()).isEmpty()) {
            this.delete(release, attachment);
        } else {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Deleting attachment reference ").append(attachment.getId()).append(" from task ").append(task.getId()).toString());
            this.releasePersistence.update(release);
        }
    }

    public boolean batchInsert(Release release, Seq<Attachment> attachments) {
        boolean bl;
        try {
            bl = this.releasePersistence.insertAttachments(release.getId(), attachments);
        }
        catch (RuntimeException e) {
            this.logger().error((Function0 & Serializable & scala.Serializable)() -> e.getMessage(), (Function0 & Serializable & scala.Serializable)() -> e);
            bl = false;
        }
        return bl;
    }

    public boolean insert(Integer releaseUid, String artifactId, String artifactName, InputStream content) {
        boolean bl;
        try {
            bl = this.releasePersistence.insertArtifact(Predef$.MODULE$.Integer2int(releaseUid), artifactId, artifactName, content);
        }
        catch (RuntimeException e) {
            this.logger().error((Function0 & Serializable & scala.Serializable)() -> e.getMessage(), (Function0 & Serializable & scala.Serializable)() -> e);
            bl = false;
        }
        return bl;
    }

    public SqlAttachmentRepository(ReleasePersistence releasePersistence) {
        this.releasePersistence = releasePersistence;
        Logging.$init$((Logging)this);
    }
}

