/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.sql.PlatformSecurityMappingSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.package$;
import com.xebialabs.xlrelease.security.SecuredCi;
import com.xebialabs.xlrelease.security.sql.SqlRoleService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.SetLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001\u0002\u000b\u0016\u0001\u0001B\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0001\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005s!A!\t\u0001BC\u0002\u0013\u00051\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003E\u0011!Y\u0005A!b\u0001\n\u0003a\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u000bE\u0003A\u0011\u0001*\t\u000b]\u0003A\u0011\t-\t\u000be\u0004A\u0011\t>\t\u000bu\u0004A\u0011\t@\t\ru\u0004A\u0011IA\n\u0011\u001d\t\u0019\u0003\u0001C!\u0003KAq!a\r\u0001\t\u0003\n)\u0004C\u0004\u00024\u0001!\t%a\u000f\t\u000f\u0005\r\u0003\u0001\"\u0011\u0002F!9\u00111\t\u0001\u0005\n\u0005=\u0003bBA4\u0001\u0011%\u0011\u0011\u000e\u0005\b\u0003\u000f\u0003A\u0011BAE\u0011\u001d\ty\t\u0001C\u0005\u0003#\u0013\u0011cU9m)\u0016\fWNU3q_NLGo\u001c:z\u0015\t1r#A\u0002tc2T!\u0001G\r\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002\u001b7\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u00039u\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003y\t1aY8n\u0007\u0001\u0019R\u0001A\u0011(W=\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0007C\u0001\u0015*\u001b\u00059\u0012B\u0001\u0016\u0018\u00059!V-Y7SKB|7/\u001b;pef\u0004\"\u0001L\u0017\u000e\u0003UI!AL\u000b\u0003=Ac\u0017\r\u001e4pe6\u001cVmY;sSRLX*\u00199qS:<7+\u001e9q_J$\bC\u0001\u00196\u001b\u0005\t$B\u0001\u001a4\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005!\u0014\u0001C4sSjTH.\u001a3\n\u0005Y\n$a\u0002'pO\u001eLgnZ\u0001\u0011a\u0016\u0014X.[:tS>tW\tZ5u_J,\u0012!\u000f\t\u0003u}j\u0011a\u000f\u0006\u0003yu\n\u0001b]3dkJLG/\u001f\u0006\u0003}m\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003\u0001n\u0012\u0001\u0003U3s[&\u001c8/[8o\u000b\u0012LGo\u001c:\u0002#A,'/\\5tg&|g.\u00123ji>\u0014\b%A\u0006s_2,7+\u001a:wS\u000e,W#\u0001#\u0011\u0005\u0015CU\"\u0001$\u000b\u0005Y9%B\u0001\u001f\u001a\u0013\tIeI\u0001\bTc2\u0014v\u000e\\3TKJ4\u0018nY3\u0002\u0019I|G.Z*feZL7-\u001a\u0011\u0002\u0015M,7-\u001e:fI\u000eK7/F\u0001N!\tAc*\u0003\u0002P/\tQ1+Z2ve\u0016$7)[:\u0002\u0017M,7-\u001e:fI\u000eK7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\tM#VK\u0016\t\u0003Y\u0001AQaN\u0004A\u0002eBQAQ\u0004A\u0002\u0011CQaS\u0004A\u00025\u000baa\u0019:fCR,GcA-`YB\u0011!,X\u0007\u00027*\u0011A,G\u0001\u0007I>l\u0017-\u001b8\n\u0005y[&\u0001\u0002+fC6DQ\u0001\u0019\u0005A\u0002\u0005\f1bY8oi\u0006Lg.\u001a:JIB\u0011!-\u001b\b\u0003G\u001e\u0004\"\u0001Z\u0012\u000e\u0003\u0015T!AZ\u0010\u0002\rq\u0012xn\u001c;?\u0013\tA7%\u0001\u0004Qe\u0016$WMZ\u0005\u0003U.\u0014aa\u0015;sS:<'B\u00015$\u0011\u0015i\u0007\u00021\u0001Z\u0003\u0011!X-Y7)\u0005!y\u0007C\u00019x\u001b\u0005\t(B\u0001:t\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003iV\fq!\\3ue&\u001c7O\u0003\u0002w;\u0005A1m\u001c3bQ\u0006dW-\u0003\u0002yc\n)A+[7fI\u00061Q\u000f\u001d3bi\u0016$\"!W>\t\u000b5L\u0001\u0019A-)\u0005%y\u0017\u0001C4fiR+\u0017-\\:\u0015\u0007}\fy\u0001E\u0003\u0002\u0002\u0005-\u0011,\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003\u0011)H/\u001b7\u000b\u0005\u0005%\u0011\u0001\u00026bm\u0006LA!!\u0004\u0002\u0004\t!A*[:u\u0011\u0015\u0001'\u00021\u0001bQ\tQq\u000eF\u0002\u0000\u0003+Aq!a\u0006\f\u0001\u0004\tI\"\u0001\u0002dSB!\u00111DA\u000f\u001b\u00059\u0015bAA\u0010\u000f\nI1+Z2ve\u0016$7)\u001b\u0015\u0003\u0017=\fa\u0001Z3mKR,G\u0003BA\u0014\u0003[\u00012AIA\u0015\u0013\r\tYc\t\u0002\u0005+:LG\u000f\u0003\u0004\u000201\u0001\r!Y\u0001\u0007i\u0016\fW.\u00133)\u00051y\u0017a\u00063fY\u0016$X\rV3b[N4%o\\7QY\u0006$hm\u001c:n)\u0011\t9#a\u000e\t\u000b\u0001l\u0001\u0019A1)\u00055yG\u0003BA\u0014\u0003{Aq!a\u0010\u000f\u0001\u0004\tI\"A\u0005d_:$\u0018-\u001b8fe\"\u0012ab\\\u0001\u0014g\u00064X\rV3b[N$v\u000e\u00157bi\u001a|'/\u001c\u000b\u0006\u007f\u0006\u001d\u0013\u0011\n\u0005\u0006A>\u0001\r!\u0019\u0005\u0007\u0003\u0017z\u0001\u0019A@\u0002\u000bQ,\u0017-\\:)\u0005=yGCBA)\u0003G\n)\u0007E\u0003\u0002T\u0005u\u0013L\u0004\u0003\u0002V\u0005ecb\u00013\u0002X%\tA%C\u0002\u0002\\\r\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002`\u0005\u0005$aA*fc*\u0019\u00111L\u0012\t\u000b\u0001\u0004\u0002\u0019A1\t\u000f\u0005-\u0003\u00031\u0001\u0002R\u0005\tR\u000f\u001d3bi\u0016\u0004VM]7jgNLwN\\:\u0015\r\u0005\u001d\u00121NA8\u0011\u0019\ti'\u0005a\u0001C\u0006Y1/Z2ve&$\u00180V5e\u0011\u001d\t\t(\u0005a\u0001\u0003g\nAC]8mKN<\u0016\u000e\u001e5QKJl\u0017n]:j_:\u001c\b#\u0002\u0012\u0002v\u0005e\u0014bAA<G\tQAH]3qK\u0006$X\r\u001a \u0011\u000f\t\nY(a \u0002\u0006&\u0019\u0011QP\u0012\u0003\rQ+\b\u000f\\33!\rQ\u0014\u0011Q\u0005\u0004\u0003\u0007[$\u0001\u0002*pY\u0016\u0004R!!\u0001\u0002\f\u0005\fQ#\u001e9eCR,\u0017J\u001c5fe&$\u0018M\\2f\r2\fw\r\u0006\u0004\u0002(\u0005-\u0015Q\u0012\u0005\u0006AJ\u0001\r!\u0019\u0005\b\u0003\u0017\u0012\u0002\u0019AA)\u0003I\u0011X-\\8wK6K7o]5oOJ{G.Z:\u0015\t\u0005\u001d\u00121\u0013\u0005\b\u0003\u0017\u001a\u0002\u0019AAK!\u0011\u0011\u0013QO-")
public class SqlTeamRepository
implements TeamRepository,
PlatformSecurityMappingSupport,
Logging {
    private final PermissionEditor permissionEditor;
    private final SqlRoleService roleService;
    private final SecuredCis securedCis;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Team fromPlatformRole(String containerId, Role role, Seq<Permission> permissions) {
        return PlatformSecurityMappingSupport.fromPlatformRole$(this, containerId, role, permissions);
    }

    @Override
    public Role toPlatformRole(Team team) {
        return PlatformSecurityMappingSupport.toPlatformRole$(this, team);
    }

    @Override
    public String toPlatformId(String id) {
        return PlatformSecurityMappingSupport.toPlatformId$(this, id);
    }

    @Override
    public String fromPlatformId(String containerId, String id) {
        return PlatformSecurityMappingSupport.fromPlatformId$(this, containerId, id);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTeamRepository sqlTeamRepository = this;
        synchronized (sqlTeamRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public PermissionEditor permissionEditor() {
        return this.permissionEditor;
    }

    public SqlRoleService roleService() {
        return this.roleService;
    }

    public SecuredCis securedCis() {
        return this.securedCis;
    }

    @Timed
    public Team create(String containerId, Team team) {
        this.removeMissingRoles((Seq<Team>)Predef$.MODULE$.wrapRefArray((Object[])new Team[]{team}));
        Role role = this.toPlatformRole(team);
        String securityUid = this.securedCis().getSecuredCi(containerId).getSecurityUid();
        this.roleService().create(securityUid, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Role[]{role}));
        this.updatePermissions(securityUid, (Seq<Tuple2<Role, java.util.List<String>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)role), (Object)team.getPermissions())}));
        this.updateInheritanceFlag(containerId, (Seq<Team>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Team[]{team}))));
        return team;
    }

    @Timed
    public Team update(Team team) {
        String containerId = Ids.getParentId((String)team.getId());
        this.removeMissingRoles((Seq<Team>)Predef$.MODULE$.wrapRefArray((Object[])new Team[]{team}));
        Role role = this.toPlatformRole(team);
        String securityUid = this.securedCis().getSecuredCi(containerId).getSecurityUid();
        this.roleService().update((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Role[]{role}));
        this.updatePermissions(securityUid, (Seq<Tuple2<Role, java.util.List<String>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)role), (Object)team.getPermissions())}));
        return team;
    }

    @Timed
    public java.util.List<Team> getTeams(String containerId) {
        return this.getTeams(this.securedCis().getSecuredCi(containerId));
    }

    @Timed
    public java.util.List<Team> getTeams(SecuredCi ci) {
        Seq seq;
        List roles = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService().readRoleAssignments(ci.getSecurityUid())).asScala()).toList();
        List list = roles;
        if (Nil$.MODULE$.equals(list)) {
            seq = (Seq)Seq$.MODULE$.empty();
        } else {
            Map permissionsByRole = this.permissionEditor().readPermissions(ci.getSecurityUid());
            seq = (Seq)roles.map((Function1 & Serializable & scala.Serializable)role -> this.fromPlatformRole(ci.getId(), (Role)role, (Seq<Permission>)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter((java.util.Set)permissionsByRole.getOrDefault(role, new HashSet())).asScala()).toSeq()), List$.MODULE$.canBuildFrom());
        }
        return package$.MODULE$.ListExtensions(seq).asJavaMutable();
    }

    @Timed
    public void delete(String teamId) {
        this.roleService().delete((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.toPlatformId(teamId)}));
        String containerId = Ids.getParentId((String)teamId);
        this.updateInheritanceFlag(containerId, (Seq<Team>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.getTeams(containerId)).asScala()));
    }

    @Timed
    public void deleteTeamsFromPlatform(String containerId) {
        this.deleteTeamsFromPlatform(this.securedCis().getSecuredCi(containerId));
    }

    @Timed
    public void deleteTeamsFromPlatform(SecuredCi container) {
        block0: {
            Buffer roles = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService().getRoles(container.getSecurityUid())).asScala();
            this.roleService().delete((Seq)roles.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getId(), Buffer$.MODULE$.canBuildFrom()));
            if (!Ids.isFolderId((String)container.getId())) break block0;
            this.securedCis().setAsEffectiveSecuredCi(container.getId(), false);
        }
    }

    @Timed
    public java.util.List<Team> saveTeamsToPlatform(String containerId, java.util.List<Team> teams) {
        return package$.MODULE$.ListExtensions(this.saveTeamsToPlatform(containerId, (Seq<Team>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(teams).asScala()))).asJavaMutable();
    }

    private Seq<Team> saveTeamsToPlatform(String containerId, Seq<Team> teams) {
        this.removeMissingRoles(teams);
        String securityUid = this.securedCis().getSecuredCi(containerId).getSecurityUid();
        Seq roles = (Seq)teams.map((Function1 & Serializable & scala.Serializable)team -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.toPlatformRole((Team)team)), (Object)team.getPermissions()), Seq$.MODULE$.canBuildFrom());
        this.roleService().writeRoleAssignments(securityUid, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)roles.map((Function1 & Serializable & scala.Serializable)x$2 -> (Role)x$2._1(), Seq$.MODULE$.canBuildFrom())).asJava());
        this.updatePermissions(securityUid, (Seq<Tuple2<Role, java.util.List<String>>>)roles);
        this.updateInheritanceFlag(containerId, teams);
        return teams;
    }

    private void updatePermissions(String securityUid, Seq<Tuple2<Role, java.util.List<String>>> rolesWithPermissions) {
        Map permissions = this.permissionEditor().readPermissions(securityUid);
        rolesWithPermissions.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Role role = (Role)tuple2._1();
            java.util.List rolePermissions = (java.util.List)tuple2._2();
            java.util.Set set = (java.util.Set)permissions.put(role, JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rolePermissions).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> Permission.find((String)x$1), Buffer$.MODULE$.canBuildFrom())).toSet()).asJava());
            return set;
        });
        this.permissionEditor().editPermissions(securityUid, permissions);
    }

    private void updateInheritanceFlag(String containerId, Seq<Team> teams) {
        this.securedCis().setAsEffectiveSecuredCi(containerId, teams.nonEmpty());
    }

    private void removeMissingRoles(Seq<Team> teams) {
        LazyRef availableRoles$lzy = new LazyRef();
        teams.foreach((Function1 & Serializable & scala.Serializable)team -> {
            Object object;
            Buffer nonExistingRoles = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(team.getRoles()).asScala()).filter((Function1 & Serializable & scala.Serializable)roleName -> BoxesRunTime.boxToBoolean((boolean)SqlTeamRepository.$anonfun$removeMissingRoles$2(this, availableRoles$lzy, roleName)));
            if (nonExistingRoles.nonEmpty()) {
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("The following role(s) do not exist: ").append(nonExistingRoles).append(". They were removed from the team ").append(team.getTeamName()).append(" [").append(team.getId()).append("].").toString());
                object = BoxesRunTime.boxToBoolean((boolean)team.getRoles().removeAll((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(nonExistingRoles).asJava()));
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
    }

    private final /* synthetic */ Buffer availableRoles$lzycompute$1(LazyRef availableRoles$lzy$1) {
        Buffer buffer;
        LazyRef lazyRef = availableRoles$lzy$1;
        synchronized (lazyRef) {
            buffer = availableRoles$lzy$1.initialized() ? (Buffer)availableRoles$lzy$1.value() : (Buffer)availableRoles$lzy$1.initialize(JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService().getRoles()).asScala());
        }
        return buffer;
    }

    private final Buffer availableRoles$1(LazyRef availableRoles$lzy$1) {
        return availableRoles$lzy$1.initialized() ? (Buffer)availableRoles$lzy$1.value() : this.availableRoles$lzycompute$1(availableRoles$lzy$1);
    }

    public static final /* synthetic */ boolean $anonfun$removeMissingRoles$3(String roleName$1, Role x$3) {
        String string = x$3.getName();
        String string2 = roleName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$removeMissingRoles$2(SqlTeamRepository $this, LazyRef availableRoles$lzy$1, String roleName) {
        return !$this.availableRoles$1(availableRoles$lzy$1).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SqlTeamRepository.$anonfun$removeMissingRoles$3(roleName, x$3)));
    }

    public SqlTeamRepository(PermissionEditor permissionEditor, SqlRoleService roleService, SecuredCis securedCis) {
        this.permissionEditor = permissionEditor;
        this.roleService = roleService;
        this.securedCis = securedCis;
        PlatformSecurityMappingSupport.$init$(this);
        Logging.$init$((Logging)this);
    }
}

