/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql.persistence;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.package;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.TasksSqlBuilder$;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.security.sql.db.SecuritySchema;
import java.io.Serializable;
import java.util.Date;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015v!\u0002\u000e\u001c\u0011\u0003Ac!\u0002\u0016\u001c\u0011\u0003Y\u0003\"\u0002\u001a\u0002\t\u0003\u0019\u0004\"\u0002\u001b\u0002\t\u0003)d\u0001\u0002\u0016\u001c\u0001\u0019C\u0011b\u0014\u0003\u0003\u0002\u0003\u0006Y\u0001U1\t\u000bI\"A\u0011\u00012\t\u000b\u0015$A\u0011\u00014\t\u000b\u001d$A\u0011\u00015\t\u000bq$A\u0011A?\t\u000f\u0005eA\u0001\"\u0001\u0002\u001c!9\u0011q\u0005\u0003\u0005\u0002\u0005%\u0002bBA\u0018\t\u0011\u0005\u0011\u0011\u0007\u0005\b\u0003\u0017\"A\u0011AA'\u0011\u001d\t\t\u0006\u0002C\u0001\u0003'Bq!!\u0017\u0005\t\u0003\tY\u0006C\u0004\u0002h\u0011!\t!!\u001b\t\u000f\u0005ED\u0001\"\u0001\u0002t!1\u00111\u0011\u0003\u0005\u0002\u0019Dq!!\"\u0005\t\u0013\t9\tC\u0004\u0002\u0010\u0012!I!!%\t\u000f\u0005eE\u0001\"\u0003\u0002\u0012\"9\u00111\u0014\u0003\u0005\n\u0005E\u0005bBAO\t\u0011%\u0011\u0011\u0013\u0005\b\u0003?#A\u0011BAI\u0011\u001d\t\t\u000b\u0002C!\u0003G\u000bq\u0002V1tWN\u001c\u0016\u000f\u001c\"vS2$WM\u001d\u0006\u00039u\t1\u0002]3sg&\u001cH/\u001a8dK*\u0011adH\u0001\u0004gFd'B\u0001\u0011\"\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003E\r\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005\u0011*\u0013!\u0003=fE&\fG.\u00192t\u0015\u00051\u0013aA2p[\u000e\u0001\u0001CA\u0015\u0002\u001b\u0005Y\"a\u0004+bg.\u001c8+\u001d7Ck&dG-\u001a:\u0014\u0005\u0005a\u0003CA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002Q\u0005ian\u001c:nC2L'0\u001a+bON$\"A\u000e#\u0011\u0007]r\u0014I\u0004\u00029yA\u0011\u0011HL\u0007\u0002u)\u00111hJ\u0001\u0007yI|w\u000e\u001e \n\u0005ur\u0013A\u0002)sK\u0012,g-\u0003\u0002@\u0001\n\u00191+\u001a;\u000b\u0005ur\u0003CA\u001cC\u0013\t\u0019\u0005I\u0001\u0004TiJLgn\u001a\u0005\u0006\u000b\u000e\u0001\rAN\u0001\u0005i\u0006<7o\u0005\u0002\u0005\u000fB\u0019\u0001\n\u0014(\u000e\u0003%S!A\b&\u000b\u0005-\u000b\u0013A\u00013c\u0013\ti\u0015J\u0001\u0006Tc2\u0014U/\u001b7eKJ\u0004\"!\u000b\u0003\u0002\u000f\u0011L\u0017\r\\3diB\u0011\u0011K\u0018\b\u0003%rs!aU.\u000f\u0005QSfBA+Z\u001d\t1\u0006L\u0004\u0002:/&\ta%\u0003\u0002%K%\u0011!eI\u0005\u0003\u0017\u0006J!A\b&\n\u0005uK\u0015AC*rY\n+\u0018\u000e\u001c3fe&\u0011q\f\u0019\u0002\b\t&\fG.Z2u\u0015\ti\u0016*\u0003\u0002P\u0019R\t1\r\u0006\u0002OI\")qJ\u0002a\u0002!\u0006a1/\u001a7fGR$\u0016m]6JIR\ta*\u0001\rxSRDwJ\\3PMJ+G.Z1tKN#\u0018\r^;tKN$\"AT5\t\u000b)D\u0001\u0019A6\u0002\u0011M$\u0018\r^;tKN\u00042\u0001\\9u\u001d\tiwN\u0004\u0002:]&\tq&\u0003\u0002q]\u00059\u0001/Y2lC\u001e,\u0017B\u0001:t\u0005\r\u0019V-\u001d\u0006\u0003a:\u0002\"!\u001e>\u000e\u0003YT!a\u001e=\u0002\rM$\u0018\r^;t\u0015\tI\u0018%\u0001\u0004e_6\f\u0017N\\\u0005\u0003wZ\u0014QBU3mK\u0006\u001cXm\u0015;biV\u001c\u0018aD<ji\"$\u0016m]6UsB,gj\u001c;\u0015\u00059s\bBB@\n\u0001\u0004\t\t!\u0001\u0005uCN\\G+\u001f9f!\u0011\t\u0019!!\u0006\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\tqA]3gY\u0016\u001cGO\u0003\u0003\u0002\f\u00055\u0011aA1qS*!\u0011qBA\t\u0003\u0019\u0001H.^4j]*\u0019\u00111C\u0012\u0002\u0011\u0011,\u0007\u000f\\8zSRLA!a\u0006\u0002\u0006\t!A+\u001f9f\u0003U9\u0018\u000e\u001e5P]\u0016|e\rV1tWN#\u0018\r^;tKN$2ATA\u000f\u0011\u0019Q'\u00021\u0001\u0002 A!A.]A\u0011!\r)\u00181E\u0005\u0004\u0003K1(A\u0003+bg.\u001cF/\u0019;vg\u0006Qq/\u001b;i\r&dG/\u001a:\u0015\u00079\u000bY\u0003\u0003\u0004\u0002.-\u0001\r!Q\u0001\u0007M&dG/\u001a:\u0002\u0013]LG\u000f\u001b#bi\u0016\u001cH#\u0002(\u00024\u0005\u001d\u0003bBA\u001b\u0019\u0001\u0007\u0011qG\u0001\u0005MJ|W\u000e\u0005\u0003\u0002:\u0005\rSBAA\u001e\u0015\u0011\ti$a\u0010\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u0003\nAA[1wC&!\u0011QIA\u001e\u0005\u0011!\u0015\r^3\t\u000f\u0005%C\u00021\u0001\u00028\u0005\u0011Ao\\\u0001\u000eo&$\b.\u00118z\u001f\u001a$\u0016mZ:\u0015\u00079\u000by\u0005C\u0003F\u001b\u0001\u0007a'A\u0007xSRDgi\u001c7eKJLEm\u001d\u000b\u0004\u001d\u0006U\u0003BBA,\u001d\u0001\u0007a'A\u0005g_2$WM]%eg\u0006\u0001r/\u001b;i\u0003N\u001c\u0018n\u001a8fIR{W*\u001a\u000b\u0004\u001d\u0006u\u0003bBA0\u001f\u0001\u0007\u0011\u0011M\u0001\u000baJLgnY5qC2\u001c\b\u0003\u00027\u0002d\u0005K1!!\u001at\u0005!IE/\u001a:bE2,\u0017!G<ji\"\f5o]5h]\u0016$Gk\\'f\u001fJl\u0015\u0010V3b[N$RATA6\u0003[Bq!a\u0018\u0011\u0001\u0004\t\t\u0007C\u0004\u0002pA\u0001\r!!\u0019\u0002\u000fI|G.Z%eg\u0006)r/\u001b;i\u0003N\u001c\u0018n\u001a8fIR{\u0017I\\=c_\u0012LHc\u0002(\u0002v\u0005]\u0014\u0011\u0010\u0005\b\u0003?\n\u0002\u0019AA1\u0011\u001d\ty'\u0005a\u0001\u0003CBq!a\u001f\u0012\u0001\u0004\ti(A\u0004jg\u0006#W.\u001b8\u0011\u00075\ny(C\u0002\u0002\u0002:\u0012qAQ8pY\u0016\fg.A\u0007pe\u0012,'OQ=UCN\\\u0017\nZ\u0001\bE&tG-\u001b8h)\r\t\u0015\u0011\u0012\u0005\b\u0003\u0017\u001b\u0002\u0019AAG\u0003\u00191\u0018\r\\;fgB!A.a\u0019-\u0003%Qw.\u001b8UK\u0006l7\u000f\u0006\u0002\u0002\u0014B\u0019Q&!&\n\u0007\u0005]eF\u0001\u0003V]&$\u0018!\u00046pS:$V-Y7S_2,7/\u0001\nk_&tG+Z1n!JLgnY5qC2\u001c\u0018a\u00056pS:$V-Y7QKJl\u0017n]:j_:\u001c\u0018a\u00036pS:4u\u000e\u001c3feN\f1B\\3x\u0013:\u001cH/\u00198dKV\ta\n")
public class TasksSqlBuilder
extends SqlBuilder<TasksSqlBuilder> {
    public static Set<String> normalizeTags(Set<String> set) {
        return TasksSqlBuilder$.MODULE$.normalizeTags(set);
    }

    public TasksSqlBuilder selectTaskId() {
        return (TasksSqlBuilder)super.select(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(127).append("SELECT\n         |  DISTINCT tasks.").append(Schema.TASKS$.MODULE$.TASK_ID()).append("\n         |FROM\n         |  ").append(Schema.TASKS$.MODULE$.TABLE()).append(" tasks\n         |  JOIN ").append(Schema.RELEASES$.MODULE$.TABLE()).append(" releases ON tasks.").append(Schema.TASKS$.MODULE$.RELEASE_UID()).append(" = releases.").append(Schema.RELEASES$.MODULE$.CI_UID()).append("\n         ").toString())).stripMargin());
    }

    public TasksSqlBuilder withOneOfReleaseStatuses(Seq<ReleaseStatus> statuses) {
        Object object = statuses.nonEmpty() ? this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(15).append("releases.").append(Schema.RELEASES$.MODULE$.STATUS()).append(" IN (").append(this.binding((Iterable<Object>)statuses)).append(")").toString(), (Iterable)statuses.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.value(), Seq$.MODULE$.canBuildFrom()))) : BoxedUnit.UNIT;
        return this;
    }

    public TasksSqlBuilder withTaskTypeNot(Type taskType) {
        this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(11).append("tasks.").append(Schema.TASKS$.MODULE$.TASK_TYPE()).append(" != ?").toString(), (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{taskType.toString()}))));
        return this;
    }

    public TasksSqlBuilder withOneOfTaskStatuses(Seq<TaskStatus> statuses) {
        Object object = statuses.nonEmpty() ? this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(12).append("tasks.").append(Schema.TASKS$.MODULE$.STATUS()).append(" IN (").append(this.binding((Iterable<Object>)statuses)).append(")").toString(), (Iterable)statuses.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.value(), Seq$.MODULE$.canBuildFrom()))) : BoxedUnit.UNIT;
        return this;
    }

    public TasksSqlBuilder withFilter(String filter) {
        Object object = filter != null ? this.likeOr((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(6).append("tasks.").append(Schema.TASKS$.MODULE$.TITLE()).toString(), new StringBuilder(6).append("tasks.").append(Schema.TASKS$.MODULE$.OWNER()).toString(), new StringBuilder(6).append("tasks.").append(Schema.TASKS$.MODULE$.TEAM()).toString(), new StringBuilder(9).append("releases.").append(Schema.RELEASES$.MODULE$.RELEASE_TITLE()).toString()})), filter) : BoxedUnit.UNIT;
        return this;
    }

    public TasksSqlBuilder withDates(Date from, Date to) {
        Object object;
        if (from != null && to != null) {
            object = this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(43).append("(? <= tasks.").append(Schema.TASKS$.MODULE$.START_DATE()).append(" OR ? <= tasks.").append(Schema.TASKS$.MODULE$.END_DATE()).append(") AND tasks.").append(Schema.TASKS$.MODULE$.START_DATE()).append(" < ?").toString(), (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Date[]{from, from, to}))));
        } else {
            Object object2 = from != null ? this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(28).append("(? <= tasks.").append(Schema.TASKS$.MODULE$.START_DATE()).append(" OR ? <= tasks.").append(Schema.TASKS$.MODULE$.END_DATE()).append(")").toString(), (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Date[]{from, from})))) : BoxedUnit.UNIT;
            object = to != null ? this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(10).append("tasks.").append(Schema.TASKS$.MODULE$.START_DATE()).append(" < ?").toString(), (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Date[]{to})))) : BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withAnyOfTags(Set<String> tags) {
        BoxedUnit boxedUnit;
        Set<String> normalizedTags = TasksSqlBuilder$.MODULE$.normalizeTags(tags);
        if (normalizedTags.nonEmpty()) {
            String sql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(159).append("\n           |tasks.").append(Schema.TASKS$.MODULE$.CI_UID()).append(" IN (\n           |  SELECT DISTINCT task_tags.").append(Schema.TASK_TAGS$.MODULE$.CI_UID()).append("\n           |  FROM ").append(Schema.TASK_TAGS$.MODULE$.TABLE()).append(" task_tags\n           |  WHERE task_tags.").append(Schema.TASK_TAGS$.MODULE$.VALUE()).append(" IN (").append(this.binding((Iterable<Object>)normalizedTags)).append(")\n           |)\n           |").toString())).stripMargin();
            boxedUnit = this.conditions().$plus$eq((Object)new package.Sql(sql, normalizedTags));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withFolderIds(Set<String> folderIds) {
        BoxedUnit boxedUnit;
        Set normalizedFolderIds = (Set)folderIds.map((Function1 & Serializable & scala.Serializable)x$1 -> Ids.getName((String)x$1), Set$.MODULE$.canBuildFrom());
        if (normalizedFolderIds.nonEmpty()) {
            this.joinFolders();
            boxedUnit = this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(14).append("folders.").append(Schema.FOLDERS$.MODULE$.FOLDER_ID()).append(" IN (").append(this.binding((Iterable<Object>)normalizedFolderIds)).append(")").toString(), (Iterable)normalizedFolderIds));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withAssignedToMe(Iterable<String> principals) {
        BoxedUnit boxedUnit;
        if (principals.nonEmpty()) {
            boxedUnit = this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(19).append("LOWER(tasks.").append(Schema.TASKS$.MODULE$.OWNER()).append(") IN (").append(this.binding(principals)).append(")").toString(), (Iterable)principals.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toLowerCase(), Iterable$.MODULE$.canBuildFrom())));
        } else {
            this.nothingToBeFound_$eq(true);
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withAssignedToMeOrMyTeams(Iterable<String> principals, Iterable<String> roleIds) {
        this.joinTeams();
        if (principals.nonEmpty()) {
            this.joinTeamPrincipals();
        }
        if (roleIds.nonEmpty()) {
            this.joinTeamRoles();
        }
        this.conditions().$plus$eq((Object)new package.Sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(154).append("|(\n          |").append((Object)(principals.nonEmpty() ? new StringBuilder(19).append("LOWER(tasks.").append(Schema.TASKS$.MODULE$.OWNER()).append(") IN (").append(this.binding(principals)).append(")").toString() : "1 = 0")).append("\n          |OR (\n          | tasks.").append(Schema.TASKS$.MODULE$.TEAM()).append(" = teams.").append(SecuritySchema.ROLES$.MODULE$.name()).append("\n          | AND (\n          |   ").append((Object)(principals.nonEmpty() ? new StringBuilder(28).append("LOWER(teamPrincipals.").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.principalName()).append(") IN (").append(this.binding(principals)).append(")").toString() : "1 = 0")).append("\n          |   ").append((Object)(roleIds.nonEmpty() ? new StringBuilder(19).append("OR teamRoles.").append(SecuritySchema.ROLE_ROLES$.MODULE$.memberRoleId()).append(" IN (").append(this.binding(roleIds)).append(")").toString() : "")).append("\n          | )\n          |)\n          |)\n       ").toString())).stripMargin(), (Iterable)((TraversableLike)((TraversableLike)principals.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toLowerCase(), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)principals.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toLowerCase(), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).$plus$plus(roleIds, Iterable$.MODULE$.canBuildFrom())));
        return this;
    }

    public TasksSqlBuilder withAssignedToAnybody(Iterable<String> principals, Iterable<String> roleIds, boolean isAdmin) {
        BoxedUnit boxedUnit;
        if (!isAdmin) {
            this.joinTeams();
            this.joinTeamPermissions();
            this.joinTeamPrincipals();
            if (roleIds.nonEmpty()) {
                this.joinTeamRoles();
            }
            boxedUnit = this.conditions().$plus$eq((Object)new package.Sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(91).append("teamPermissions.").append(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.permissionName()).append(" = '").append(XLReleasePermissions.VIEW_RELEASE.getPermissionName()).append("'\n           |AND (\n           |  ").append((Object)(principals.nonEmpty() ? new StringBuilder(28).append("LOWER(teamPrincipals.").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.principalName()).append(") IN (").append(this.binding(principals)).append(")").toString() : "1 = 0")).append("\n           |  ").append((Object)(roleIds.nonEmpty() ? new StringBuilder(19).append("OR teamRoles.").append(SecuritySchema.ROLE_ROLES$.MODULE$.memberRoleId()).append(" IN (").append(this.binding(roleIds)).append(")").toString() : "")).append("\n           |)\n       ").toString())).stripMargin(), (Iterable)((TraversableLike)principals.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toLowerCase(), Iterable$.MODULE$.canBuildFrom())).$plus$plus(roleIds, Iterable$.MODULE$.canBuildFrom())));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder orderByTaskId() {
        this.orderBy(new StringBuilder(6).append("tasks.").append(Schema.TASKS$.MODULE$.TASK_ID()).toString());
        return this;
    }

    private String binding(Iterable<Object> values) {
        return ((TraversableOnce)values.toSeq().map((Function1 & Serializable & scala.Serializable)x$8 -> "?", Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    private void joinTeams() {
        this.addJoin(new StringBuilder(33).append("JOIN ").append(SecuritySchema.ROLES$.MODULE$.TABLE()).append(" teams ON releases.").append(Schema.RELEASES$.MODULE$.SECURITY_UID()).append(" = teams.").append(SecuritySchema.ROLES$.MODULE$.ciId()).toString());
    }

    private void joinTeamRoles() {
        this.addJoin(new StringBuilder(43).append("LEFT JOIN ").append(SecuritySchema.ROLE_ROLES$.MODULE$.TABLE()).append(" teamRoles ON teams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" = teamRoles.").append(SecuritySchema.ROLE_ROLES$.MODULE$.roleId()).toString());
    }

    private void joinTeamPrincipals() {
        this.addJoin(new StringBuilder(53).append("LEFT JOIN ").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE()).append(" teamPrincipals ON teams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" = teamPrincipals.").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.roleId()).toString());
    }

    private void joinTeamPermissions() {
        this.addJoin(new StringBuilder(50).append("JOIN ").append(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.TABLE()).append(" teamPermissions ON teams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" = teamPermissions.").append(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.roleId()).toString());
    }

    private void joinFolders() {
        this.addJoin(new StringBuilder(37).append("JOIN ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" folders ON releases.").append(Schema.RELEASES$.MODULE$.FOLDER_CI_UID()).append(" = folders.").append(Schema.FOLDERS$.MODULE$.CI_UID()).toString());
    }

    public TasksSqlBuilder newInstance() {
        return new TasksSqlBuilder(super.dialect());
    }

    public TasksSqlBuilder(SqlBuilder.Dialect dialect) {
        super(dialect);
    }
}

