/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlplatform.repository.sql.db.MetadataSchema;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlrelease.SqlStorageFacade$;
import com.xebialabs.xlrelease.StorageFacade;
import com.xebialabs.xlrelease.TestAuthentication;
import com.xebialabs.xlrelease.actors.utils.ScalaSpringSupport;
import com.xebialabs.xlrelease.db.ArchivedReleases$;
import com.xebialabs.xlrelease.db.LiquibaseSupport;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.CalendarEntryRepository;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.repository.sql.SqlTeamRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.security.sql.db.SecuritySchema;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.upgrade.liquibase.BeforeUpgrade;
import java.io.Serializable;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import liquibase.Liquibase;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Profile;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@Profile(value={"integrationTest"})
@ScalaSignature(bytes="\u0006\u0001\rUa\u0001B\u001a5\u0001mB\u0001b\u001b\u0001\u0003\u0002\u0003\u0006I\u0001\u001c\u0005\te\u0002\u0011\t\u0011)A\u0005g\"A1\u0010\u0001B\u0001B\u0003%A\u0010\u0003\u0006\u0002\u0002\u0001\u0011\t\u0011)A\u0005\u0003\u0007A!\"!\u0003\u0001\u0005\u0003\u0005\u000b\u0011BA\u0006\u0011)\t9\u0002\u0001B\u0001B\u0003%\u0011\u0011\u0004\u0005\u000b\u0003?\u0001!\u0011!Q\u0001\n\u0005\u0005\u0002BCA\u0014\u0001\t\u0005\t\u0015!\u0003\u0002*!Q\u0011q\u0006\u0001\u0003\u0002\u0003\u0006I!!\r\t\u0015\u0005]\u0002A!A!\u0002\u0013\tI\u0004\u0003\u0006\u0002f\u0001\u0011\t\u0011)A\u0005\u0003sAq!a\u001b\u0001\t\u0003\ti\u0007C\u0004\u0002\u0014\u0002!\t%!&\t\r5\u0003A\u0011IAW\u0011\u001d\tY\f\u0001C!\u0003{Cq!!4\u0001\t\u0003\ni\u000bC\u0004\u0002P\u0002!\t%!5\t\u000f\u0005M\b\u0001\"\u0003\u0002v\"9\u0011q\u001f\u0001\u0005\n\u0005U\bbBA}\u0001\u0011%\u00111 \u0005\b\u0005\u0007\u0001A\u0011BA~\u0011)\u0011)\u0001\u0001EC\u0002\u0013\u0005!q\u0001\u0005\n\u0005/\u0001!\u0019!C\u0005\u00053A\u0001Ba\b\u0001A\u0003%!1\u0004\u0005\b\u0005C\u0001A\u0011\u0001B\u0012\u0011\u001d\u0011Y\u0003\u0001C\u0005\u0005[AqA!\u000e\u0001\t\u0003\ni\u000bC\u0004\u00038\u0001!\t%!,\t\u000f\te\u0002\u0001\"\u0011\u0003<!9!\u0011\t\u0001\u0005\u0012\t\r\u0003b\u0002B\u001d\u0001\u0011\u0005#q\t\u0005\b\u00053\u0002A\u0011\tB.\u0011\u001d\u00119\u0007\u0001C!\u0003[CqA!\u001b\u0001\t\u0013\u0011Y\u0007C\u0004\u0003\u0014\u0002!IA!&\t\u000f\t]\u0005\u0001\"\u0003\u0003\u0016\"9!\u0011\u0014\u0001\u0005\n\tm\u0005b\u0002BP\u0001\u0011%!\u0011\u0015\u0005\b\u0005G\u0003A\u0011\u0002BQ\u0011\u001d\u0011)\u000b\u0001C\u0005\u0005+CqAa*\u0001\t\u0003\ti\u000bC\u0006\u00036\u0002\u0001\r\u00111A\u0005\u0002\t]\u0006b\u0003B`\u0001\u0001\u0007\t\u0019!C\u0001\u0005\u0003D1Ba2\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003:\"9!Q\u001b\u0001\u0005\u0002\t]\u0007b\u0002Bm\u0001\u0011\u0005!1\\\u0004\b\u0005\u007f$\u0004\u0012AB\u0001\r\u0019\u0019D\u0007#\u0001\u0004\u0004!9\u00111\u000e\u0019\u0005\u0002\r-\u0001b\u0002B-a\u0011\u00051Q\u0002\u0002\u0011'Fd7\u000b^8sC\u001e,g)Y2bI\u0016T!!\u000e\u001c\u0002\u0013ad'/\u001a7fCN,'BA\u001c9\u0003%AXMY5bY\u0006\u00147OC\u0001:\u0003\r\u0019w.\\\u0002\u0001'!\u0001A\b\u0012%Q'f\u000b\u0007CA\u001fC\u001b\u0005q$BA A\u0003\u0011a\u0017M\\4\u000b\u0003\u0005\u000bAA[1wC&\u00111I\u0010\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\u00153U\"\u0001\u001b\n\u0005\u001d#$!D*u_J\fw-\u001a$bG\u0006$W\r\u0005\u0002J\u001d6\t!J\u0003\u0002L\u0019\u0006IA.[9vS\n\f7/\u001a\u0006\u0003\u001bR\nq!\u001e9he\u0006$W-\u0003\u0002P\u0015\ni!)\u001a4pe\u0016,\u0006o\u001a:bI\u0016\u0004\"!R)\n\u0005I#$A\u0005+fgR\fU\u000f\u001e5f]RL7-\u0019;j_:\u0004\"\u0001V,\u000e\u0003US!A\u0016\u001b\u0002\u0005\u0011\u0014\u0017B\u0001-V\u0005Aa\u0015.];jE\u0006\u001cXmU;qa>\u0014H\u000f\u0005\u0002[?6\t1L\u0003\u0002];\u0006)Q\u000f^5mg*\u0011a\fN\u0001\u0007C\u000e$xN]:\n\u0005\u0001\\&AE*dC2\f7\u000b\u001d:j]\u001e\u001cV\u000f\u001d9peR\u0004\"AY5\u000e\u0003\rT!\u0001Z3\u0002\u000f\r|g\u000e^3yi*\u0011amZ\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0001.A\u0002pe\u001eL!A[2\u0003/\u0005\u0003\b\u000f\\5dCRLwN\\\"p]R,\u0007\u0010^!xCJ,\u0017!\u00044pY\u0012,'oU3sm&\u001cW\r\u0005\u0002na6\taN\u0003\u0002pi\u000591/\u001a:wS\u000e,\u0017BA9o\u000551u\u000e\u001c3feN+'O^5dK\u0006qA/Z1n%\u0016\u0004xn]5u_JL\bC\u0001;z\u001b\u0005)(B\u0001<x\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003qR\n!B]3q_NLGo\u001c:z\u0013\tQXOA\tTc2$V-Y7SKB|7/\u001b;pef\f\u0011C]3mK\u0006\u001cXMU3q_NLGo\u001c:z!\tih0D\u0001x\u0013\tyxOA\tSK2,\u0017m]3SKB|7/\u001b;pef\fAC]3mK\u0006\u001cXmU3be\u000eD7+\u001a:wS\u000e,\u0007cA7\u0002\u0006%\u0019\u0011q\u00018\u0003)I+G.Z1tKN+\u0017M]2i'\u0016\u0014h/[2f\u0003U!W\r]3oI\u0016t7-\u001f)feNL7\u000f^3oG\u0016\u0004B!!\u0004\u0002\u00145\u0011\u0011q\u0002\u0006\u0004\u0003#)\u0018a\u00039feNL7\u000f^3oG\u0016LA!!\u0006\u0002\u0010\t)B)\u001a9f]\u0012,gnY=QKJ\u001c\u0018n\u001d;f]\u000e,\u0017aF2p]\u001aLw-\u001e:bi&|gNU3q_NLGo\u001c:z!\ri\u00181D\u0005\u0004\u0003;9(aF\"p]\u001aLw-\u001e:bi&|gNU3q_NLGo\u001c:z\u0003]\u0019\u0017\r\\3oI\u0006\u0014XI\u001c;ssJ+\u0007o\\:ji>\u0014\u0018\u0010E\u0002~\u0003GI1!!\nx\u0005]\u0019\u0015\r\\3oI\u0006\u0014XI\u001c;ssJ+\u0007o\\:ji>\u0014\u00180\u0001\tbe\u000eD\u0017N^5oON+'O^5dKB\u0019Q.a\u000b\n\u0007\u00055bN\u0001\tBe\u000eD\u0017N^5oON+'O^5dK\u0006\tBO]5hO\u0016\u0014(+\u001a9pg&$xN]=\u0011\u0007u\f\u0019$C\u0002\u00026]\u0014\u0011\u0003\u0016:jO\u001e,'OU3q_NLGo\u001c:z\u00031QGMY2UK6\u0004H.\u0019;f!\u0011\tY$!\u0012\u000e\u0005\u0005u\"\u0002BA \u0003\u0003\nAaY8sK*\u0019\u00111I3\u0002\t)$'mY\u0005\u0005\u0003\u000f\niD\u0001\u0007KI\n\u001cG+Z7qY\u0006$X\rK\u0004\u000b\u0003\u0017\ny&!\u0019\u0011\t\u00055\u00131L\u0007\u0003\u0003\u001fRA!!\u0015\u0002T\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\u0005U\u0013qK\u0001\bM\u0006\u001cGo\u001c:z\u0015\r\tI&Z\u0001\u0006E\u0016\fgn]\u0005\u0005\u0003;\nyEA\u0005Rk\u0006d\u0017NZ5fe\u0006)a/\u00197vK\u0006\u0012\u00111M\u0001\u001aq2\u0014(+\u001a9pg&$xN]=KI\n\u001cG+Z7qY\u0006$X-A\u000bsKB|'\u000f^5oO*#'m\u0019+f[Bd\u0017\r^3)\u000f-\tY%a\u0018\u0002j\u0005\u0012\u0011QM\u0001\u0007y%t\u0017\u000e\u001e \u00151\u0005=\u0014\u0011OA:\u0003k\n9(!\u001f\u0002|\u0005u\u0014qPAA\u0003\u0007\u000b9\t\u0005\u0002F\u0001!)1\u000e\u0004a\u0001Y\")!\u000f\u0004a\u0001g\")1\u0010\u0004a\u0001y\"9\u0011\u0011\u0001\u0007A\u0002\u0005\r\u0001bBA\u0005\u0019\u0001\u0007\u00111\u0002\u0005\b\u0003/a\u0001\u0019AA\r\u0011\u001d\ty\u0002\u0004a\u0001\u0003CAq!a\n\r\u0001\u0004\tI\u0003C\u0004\u000201\u0001\r!!\r\t\u000f\u0005]B\u00021\u0001\u0002:!B\u00111QA&\u0003?\n\t\u0007C\u0004\u0002f1\u0001\r!!\u000f)\u0011\u0005\u001d\u00151JA0\u0003SB3\u0001DAG!\u0011\ti%a$\n\t\u0005E\u0015q\n\u0002\n\u0003V$xn^5sK\u0012\f\u0001\u0003\u001f7SK2,\u0017m]3WKJ\u001c\u0018n\u001c8\u0015\u0005\u0005]\u0005\u0003BAM\u0003Sk!!a'\u000b\u00075\u000biJ\u0003\u0003\u0002 \u0006\u0005\u0016aA1qS*!\u00111UAS\u0003\u0019\u0019XM\u001d<fe*\u0019\u0011q\u0015\u001c\u0002\u0011\u0011,\u0007\u000f\\8zSRLA!a+\u0002\u001c\n9a+\u001a:tS>tGCAAX!\u0011\t\t,a.\u000e\u0005\u0005M&BAA[\u0003\u0015\u00198-\u00197b\u0013\u0011\tI,a-\u0003\tUs\u0017\u000e^\u0001\u0019e\u0016\u0004xn]5u_JLh+\u001a:tS>t7+\u001a:wS\u000e,WCAA`!\u0011\t\t-!3\u000e\u0005\u0005\r'bA'\u0002F*\u0019\u0011q\u0019\u001c\u0002\u0015ad\u0007\u000f\\1uM>\u0014X.\u0003\u0003\u0002L\u0006\r'\u0001\u0007*fa>\u001c\u0018\u000e^8ssZ+'o]5p]N+'O^5dK\u0006IAm\\+qOJ\fG-Z\u0001\u0014G>,h\u000e\u001e*fG>\u0014Hm]%o)\u0006\u0014G.\u001a\u000b\u0005\u0003'\fI\u000e\u0005\u0003\u00022\u0006U\u0017\u0002BAl\u0003g\u0013A\u0001T8oO\"9\u00111\\\tA\u0002\u0005u\u0017!\u0003;bE2,g*Y7f!\u0011\ty.!<\u000f\t\u0005\u0005\u0018\u0011\u001e\t\u0005\u0003G\f\u0019,\u0004\u0002\u0002f*\u0019\u0011q\u001d\u001e\u0002\rq\u0012xn\u001c;?\u0013\u0011\tY/a-\u0002\rA\u0013X\rZ3g\u0013\u0011\ty/!=\u0003\rM#(/\u001b8h\u0015\u0011\tY/a-\u0002-]L\u0007/Z(vi\u0006\u00138\r[5wK\u0012\u000bG/\u00192bg\u0016,\"!a,\u0002\u001f]L\u0007/Z(vi\u0012\u000bG/\u00192bg\u0016\f!#[:EE\u000ecW-\u00198va\u0016s\u0017M\u00197fIV\u0011\u0011Q \t\u0005\u0003c\u000by0\u0003\u0003\u0003\u0002\u0005M&a\u0002\"p_2,\u0017M\\\u0001\u001fSNLe\u000e^3he\u0006$\u0018n\u001c8UKN$\bK]8gS2,\u0017i\u0019;jm\u0016\f!\u0002Z1uCN{WO]2f+\t\u0011I\u0001\u0005\u0003\u0003\f\tMQB\u0001B\u0007\u0015\r1(q\u0002\u0006\u0003\u0005#\tQA[1wCbLAA!\u0006\u0003\u000e\tQA)\u0019;b'>,(oY3\u0002\u00059cUC\u0001B\u000e!\ri$QD\u0005\u0004\u0003_t\u0014a\u0001(MA\u0005YA/\u00192mK\u0016C\u0018n\u001d;t)\u0011\u0011)C!\u000b\u0015\t\u0005u(q\u0005\u0005\b\u0003oI\u00029AA\u001d\u0011\u001d\tY.\u0007a\u0001\u0003;\f!\u0003Z3mKR,G+\u00192mK\u000e{g\u000e^3oiR!!q\u0006B\u001a)\u0011\tyK!\r\t\u000f\u0005]\"\u0004q\u0001\u0002:!9\u00111\u001c\u000eA\u0002\u0005u\u0017!\u00073fY\u0016$X\rU3s[&\u001c8/[8o':\f\u0007o\u001d5piN\fqa\u00197fC:,\b/\u0001\u0004eK2,G/\u001a\u000b\u0005\u0003{\u0014i\u0004C\u0004\u0003@u\u0001\r!!8\u0002\u0005%$\u0017!\u00043fY\u0016$XMU3mK\u0006\u001cX\r\u0006\u0003\u00020\n\u0015\u0003b\u0002B =\u0001\u0007\u0011Q\u001c\u000b\u0005\u0003{\u0014I\u0005C\u0004\u0003L}\u0001\rA!\u0014\u0002\tQ,\u0017-\u001c\t\u0005\u0005\u001f\u0012)&\u0004\u0002\u0003R)\u0019!1\u000b\u001b\u0002\r\u0011|W.Y5o\u0013\u0011\u00119F!\u0015\u0003\tQ+\u0017-\\\u0001\u0012I\u0016dW\r^3Ge>l\u0017I]2iSZ,G\u0003\u0002B/\u0005G\u0002B!!-\u0003`%!!\u0011MAZ\u0005\rIe\u000e\u001e\u0005\b\u0005K\u0002\u0003\u0019AAo\u0003%\u0011X\r\\3bg\u0016LE-A\u000bwKJLg-\u001f*fa>\u001c\u0018\u000e^8ss\u000ecW-\u00198\u00025Q,7\u000f\u001e#jI:{Go\u00117fC:\fe\r^3s\u0013R\u001cX\r\u001c4\u0015\r\t5$1\u000fBH!\ri$qN\u0005\u0004\u0005cr$\u0001\u0005*v]RLW.Z#yG\u0016\u0004H/[8o\u0011\u001d\u0011)H\ta\u0001\u0005o\na!Y2uSZ,\u0007C\u0002B=\u0005\u0007\u0013II\u0004\u0003\u0003|\t}d\u0002BAr\u0005{J!!!.\n\t\t\u0005\u00151W\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011)Ia\"\u0003\u0007M+\u0017O\u0003\u0003\u0003\u0002\u0006M\u0006\u0003CAY\u0005\u0017\u000bi.!8\n\t\t5\u00151\u0017\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\tE%\u00051\u0001\u0003x\u0005A\u0011M]2iSZ,G-A\u0007d_VtGOU3mK\u0006\u001cXm\u001d\u000b\u0003\u0005;\nQbY8v]R$&/[4hKJ\u001c\u0018aG4fiJ+W.Y5oS:<GK]5hO\u0016\u00148\u000fR3uC&d7\u000f\u0006\u0002\u0003\u001eB1!\u0011\u0010BB\u0003;\f1dZ3u%\u0016l\u0017-\u001b8j]\u001e\u0014V\r\\3bg\u0016\u001cH)\u001a;bS2\u001cHC\u0001B<\u0003\r:W\r\u001e*f[\u0006Lg.\u001b8h\u0003J\u001c\u0007.\u001b<fIJ+G.Z1tKN$U\r^1jYN\fQcY8v]R\f%o\u00195jm\u0016$'+\u001a7fCN,7/A\u0005dY\u0016\fg\u000e\u00177EE\"\u001a\u0011Fa+\u0011\t\t5&\u0011W\u0007\u0003\u0005_SA!!\u0015\u0003\u0010%!!1\u0017BX\u0005)\u0001&/\u001a#fgR\u0014x._\u0001\u0013CB\u0004H.[2bi&|gnQ8oi\u0016DH/\u0006\u0002\u0003:B\u0019!Ma/\n\u0007\tu6M\u0001\nBaBd\u0017nY1uS>t7i\u001c8uKb$\u0018AF1qa2L7-\u0019;j_:\u001cuN\u001c;fqR|F%Z9\u0015\t\u0005=&1\u0019\u0005\n\u0005\u000b\\\u0013\u0011!a\u0001\u0005s\u000b1\u0001\u001f\u00132\u0003M\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8D_:$X\r\u001f;!Q\ra#1\u001a\t\u0005\u0005\u001b\u0014\t.\u0004\u0002\u0003P*!\u0011\u0011LAZ\u0013\u0011\u0011\u0019Na4\u0003\u0019\t+\u0017M\u001c)s_B,'\u000f^=\u0002+\u001d,G/\u00119qY&\u001c\u0017\r^5p]\u000e{g\u000e^3yiR\u0011!\u0011X\u0001\u0016g\u0016$\u0018\t\u001d9mS\u000e\fG/[8o\u0007>tG/\u001a=u)\u0011\tyK!8\t\u0013\t\u0015g&!AA\u0002\te\u0006f\u0002\u0001\u0003b\u0006}#1\u001e\t\u0005\u0005G\u00149/\u0004\u0002\u0003f*\u0019\u0011\u0011K2\n\t\t%(Q\u001d\u0002\b!J|g-\u001b7fY\t\u0011i/\t\u0002\u0003p\u0006y\u0011N\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fK\u0002\u0001\u0005g\u0004BA!>\u0003|6\u0011!q\u001f\u0006\u0004\u0005s,\u0017AC:uKJ,w\u000e^=qK&!!Q B|\u0005%\u0019u.\u001c9p]\u0016tG/\u0001\tTc2\u001cFo\u001c:bO\u00164\u0015mY1eKB\u0011Q\tM\n\u0004a\r\u0015\u0001\u0003BAY\u0007\u000fIAa!\u0003\u00024\n1\u0011I\\=SK\u001a$\"a!\u0001\u0015\t\r=11\u0003\u000b\u0005\u0005;\u001a\t\u0002C\u0004\u00028I\u0002\r!!\u000f\t\u000f\t\u0015$\u00071\u0001\u0002^\u0002")
public class SqlStorageFacade
implements StorageFacade,
BeforeUpgrade,
TestAuthentication,
LiquibaseSupport,
ScalaSpringSupport,
ApplicationContextAware {
    private DataSource dataSource;
    private final FolderService folderService;
    private final SqlTeamRepository teamRepository;
    private final ReleaseRepository releaseRepository;
    private final DependencyPersistence dependencyPersistence;
    private final ConfigurationRepository configurationRepository;
    private final CalendarEntryRepository calendarEntryRepository;
    private final ArchivingService archivingService;
    private final TriggerRepository triggerRepository;
    @Qualifier(value="xlrRepositoryJdbcTemplate")
    private final JdbcTemplate jdbcTemplate;
    @Qualifier(value="reportingJdbcTemplate")
    private final JdbcTemplate reportingJdbcTemplate;
    private final String NL;
    private ApplicationContext applicationContext;
    private volatile boolean bitmap$0;

    public <T> T springBean(ClassTag<T> evidence$1) {
        return (T)ScalaSpringSupport.springBean$((ScalaSpringSupport)this, evidence$1);
    }

    public <T> T springBean(String name, ClassTag<T> evidence$2) {
        return (T)ScalaSpringSupport.springBean$((ScalaSpringSupport)this, (String)name, evidence$2);
    }

    public <T> T doWithLiquibase(String changelogFile, Function1<Liquibase, T> callback) {
        return (T)LiquibaseSupport.doWithLiquibase$((LiquibaseSupport)this, (String)changelogFile, callback);
    }

    public <T> T withAuthentication(Authentication auth, Function0<T> t) {
        return (T)TestAuthentication.withAuthentication$((TestAuthentication)this, (Authentication)auth, t);
    }

    @Override
    public Logger logger() {
        return StorageFacade.super.logger();
    }

    public Version xlReleaseVersion() {
        return Version.valueOf((String)"xl-release", (String)"0.0.0");
    }

    public void upgrade() {
        this.doUpgrade();
    }

    public RepositoryVersionService repositoryVersionService() {
        return null;
    }

    public void doUpgrade() {
        this.wipeOutDatabase();
        this.wipeOutArchiveDatabase();
    }

    @Override
    public long countRecordsInTable(String tableName) {
        return BoxesRunTime.unboxToLong((Object)this.jdbcTemplate.queryForObject(new StringBuilder(21).append("SELECT count(*) FROM ").append(tableName).toString(), Long.TYPE));
    }

    private void wipeOutArchiveDatabase() {
        DataSource reportingDataSource = (DataSource)this.springBean("reportingDataSource", ClassTag$.MODULE$.apply(DataSource.class));
        LiquibaseSupport reporting = new LiquibaseSupport(null, reportingDataSource){
            private final DataSource reportingDataSource$1;

            public <T> T doWithLiquibase(String changelogFile, Function1<Liquibase, T> callback) {
                return (T)LiquibaseSupport.doWithLiquibase$((LiquibaseSupport)this, (String)changelogFile, callback);
            }

            public DataSource dataSource() {
                return this.reportingDataSource$1;
            }
            {
                this.reportingDataSource$1 = reportingDataSource$1;
                LiquibaseSupport.$init$((LiquibaseSupport)this);
            }
        };
        reporting.doWithLiquibase("liquibase.xlr.drop.xml", (Function1 & Serializable & scala.Serializable)liquibase -> {
            SqlStorageFacade.$anonfun$wipeOutArchiveDatabase$1(this, liquibase);
            return BoxedUnit.UNIT;
        });
    }

    private void wipeOutDatabase() {
        block0: {
            if (!this.isDbCleanupEnabled() || !this.isIntegrationTestProfileActive()) break block0;
            this.doWithLiquibase("liquibase.xlr.drop.xml", (Function1 & Serializable & scala.Serializable)liquibase -> {
                SqlStorageFacade.$anonfun$wipeOutDatabase$1(this, liquibase);
                return BoxedUnit.UNIT;
            });
        }
    }

    private boolean isDbCleanupEnabled() {
        return !System.getProperties().contains("nodbcleanup");
    }

    private boolean isIntegrationTestProfileActive() {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.applicationContext().getEnvironment().getActiveProfiles())).contains((Object)"integrationTest");
    }

    private DataSource dataSource$lzycompute() {
        SqlStorageFacade sqlStorageFacade = this;
        synchronized (sqlStorageFacade) {
            if (!this.bitmap$0) {
                this.dataSource = (DataSource)this.springBean("xlrRepositoryDataSource", ClassTag$.MODULE$.Nothing());
                this.bitmap$0 = true;
            }
        }
        return this.dataSource;
    }

    public DataSource dataSource() {
        return !this.bitmap$0 ? this.dataSource$lzycompute() : this.dataSource;
    }

    private String NL() {
        return this.NL;
    }

    public boolean tableExists(String tableName, JdbcTemplate jdbcTemplate) {
        boolean bl;
        try {
            jdbcTemplate.queryForObject(new StringBuilder(21).append("SELECT count(*) FROM ").append(tableName).toString(), Long.TYPE);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private void deleteTableContent(String tableName, JdbcTemplate jdbcTemplate) {
        block0: {
            if (!this.tableExists(tableName, jdbcTemplate)) break block0;
            jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(tableName).toString());
        }
    }

    @Override
    public void deletePermissionSnapshots() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent(Schema.PERMISSION_SNAPSHOTS$.MODULE$.TABLE(), sqlJdbcTemplate);
    }

    @Override
    public void cleanup() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent(Schema.DEPENDENCIES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_ROLES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASE_CONFIGURATION_REFS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.COMMENTS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TASKS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent("XLR_ACTIVITY_LOGS", sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASES_EXT$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent("XLR_RISK_ASSESSMENTS", sqlJdbcTemplate);
        this.deleteTableContent("XLR_RISKS", sqlJdbcTemplate);
        this.deleteTableContent(Schema.TRIGGER_CONFIGURATION_REFS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TEMPLATE_TRIGGERS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TRIGGERS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.ARTIFACTS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deletePermissionSnapshots();
        if (this.tableExists(Schema.PATHS$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute(new StringBuilder(31).append("DELETE FROM ").append(Schema.PATHS$.MODULE$.TABLE()).append(" WHERE ").append(Schema.PATHS$.MODULE$.ANCESTOR_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).append(" OR ").append(Schema.PATHS$.MODULE$.DESCENDANT_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).toString());
        }
        if (this.tableExists(Schema.FOLDERS$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute(new StringBuilder(15).append("UPDATE ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" SET ").append(Schema.FOLDERS$.MODULE$.SECURITY_UID()).append(" = ").append(FolderRow.Root$.MODULE$.uid()).toString());
            this.jdbcTemplate.execute(new StringBuilder(23).append("DELETE FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" WHERE ").append(Schema.FOLDERS$.MODULE$.CI_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).toString());
        }
        this.deleteTableContent(MetadataSchema.METADATA$.MODULE$.TABLE(), sqlJdbcTemplate);
        if (this.tableExists(Schema.USER_PROFILE$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute(new StringBuilder(30).append("DELETE FROM ").append(Schema.USER_PROFILE$.MODULE$.TABLE()).append(" WHERE ").append(Schema.USER_PROFILE$.MODULE$.USERNAME()).append(" <> 'admin'").toString());
        }
        JdbcTemplate sqlJdbcTemplate2 = this.reportingJdbcTemplate;
        this.deleteTableContent(Schema.Archive$.ITSM_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(Schema.Archive$.DEPLOYMENT_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(Schema.Archive$.CODE_COMPLIANCE_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_TASKS_TABLE_NAME(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_PHASES_TABLE_NAME(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME(), sqlJdbcTemplate2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean delete(String id) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            this.logger().trace(new StringBuilder(12).append("Deleting id ").append(id).toString());
            if (Ids.isReleaseId((String)id)) {
                this.deleteRelease(id);
            } else if (Ids.isDependencyId((String)id)) {
                $this.dependencyPersistence.deleteDependency(id);
            } else if (!Ids.isPlanItemId((String)id)) {
                if (Ids.isFolderId((String)id)) {
                    if ($this.folderService.exists(id)) {
                        $this.folderService.delete(id);
                    }
                } else if (Ids.isCustomConfigurationId((String)id)) {
                    $this.configurationRepository.delete(id);
                } else if (Ids.isCalendarId((String)id)) {
                    $this.calendarEntryRepository.delete(id);
                } else if (Ids.isConfigurationId((String)id) && $this.configurationRepository.exists(id)) {
                    $this.configurationRepository.delete(id);
                } else if (Ids.isTeamId((String)id)) {
                    $this.teamRepository.delete(id);
                } else if (Ids.isVariableId((String)id)) {
                    this.logger().warn(new StringBuilder(63).append("Variable '").append(id).append("' will be deleted once the parent release is deleted.").toString());
                } else if (!id.endsWith("PythonScript") && !id.endsWith("/valueProvider")) {
                    if (Ids.isTriggerId((String)id)) {
                        $this.triggerRepository.delete(id);
                    } else if (Ids.isInRelease((String)id)) {
                        this.logger().warn(new StringBuilder(69).append("Id '").append(id).append("' will be deleted once the parent release or template is deleted.").toString());
                    } else {
                        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Delete of CI with id `%s` is not supported")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})));
                    }
                }
            }
            return true;
        });
        if (try_ instanceof Success) {
            this.logger().warn(new StringBuilder(8).append("Deleted ").append(id).toString());
            return true;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof NotFoundException) {
                this.logger().error(new StringBuilder(51).append("Unable to delete CI with Id: `").append(id).append("` as it was not found").toString());
                return true;
            }
        }
        if (!bl) throw new MatchError((Object)try_);
        Throwable e = failure.exception();
        this.logger().error(new StringBuilder(31).append("Unable to delete CI with Id: `").append(id).append("`").toString(), e);
        return false;
    }

    public void deleteRelease(String id) {
        block3: {
            block2: {
                if (!this.releaseRepository.exists(id)) break block2;
                try {
                    this.teamRepository.deleteTeamsFromPlatform(id);
                }
                catch (NotFoundException e) {
                    this.logger().warn(new StringBuilder(26).append("Could not delete teams of ").append(id).toString(), (Throwable)e);
                }
                this.releaseRepository.delete(id);
                break block3;
            }
            if (!this.archivingService.exists(id)) break block3;
            this.deleteFromArchive(id);
        }
    }

    @Override
    public boolean delete(Team team) {
        boolean bl;
        this.logger().trace(new StringBuilder(14).append("Deleting team ").append(team.getId()).toString());
        if (!Ids.isInRelease((String)team.getId()) || this.releaseRepository.exists(Ids.releaseIdFrom((String)team.getId()))) {
            this.teamRepository.delete(team.getId());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public int deleteFromArchive(String releaseId) {
        return SqlStorageFacade$.MODULE$.deleteFromArchive(releaseId, this.reportingJdbcTemplate);
    }

    @Override
    public void verifyRepositoryClean() {
        if (this.countReleases() > 0 || this.countArchivedReleases() > 0) {
            throw this.testDidNotCleanAfterItself(this.getRemainingReleasesDetails(), this.getRemainingArchivedReleasesDetails());
        }
        int triggerCount = this.countTriggers();
        if (triggerCount > 0) {
            throw new RuntimeException(new StringBuilder(38).append("Found ").append(triggerCount).append(" remaining triggers in database:").append(this.NL()).append(this.getRemainingTriggersDetails().mkString(this.NL())).toString());
        }
    }

    private RuntimeException testDidNotCleanAfterItself(Seq<Tuple2<String, String>> active, Seq<Tuple2<String, String>> archived) {
        int numActive = active.size();
        int numArchived = archived.size();
        int numTotal = numActive + numArchived;
        return new RuntimeException(new StringBuilder(62).append("Found ").append(numTotal).append(" remaining releases (").append(numActive).append(" from database and ").append(numArchived).append(" from archive):\n").append(SqlStorageFacade.all$1(active, archived)).toString());
    }

    private int countReleases() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(Schema.RELEASES$.MODULE$.CI_UID()).append(") FROM ").append(Schema.RELEASES$.MODULE$.TABLE()).toString(), (rs, x$1) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private int countTriggers() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(Schema.TRIGGERS$.MODULE$.CI_UID()).append(") FROM ").append(Schema.TRIGGERS$.MODULE$.TABLE()).toString(), (rs, x$2) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private Seq<String> getRemainingTriggersDetails() {
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(Schema.TRIGGERS$.MODULE$.TRIGGER_TITLE()).append(", ").append(Schema.TRIGGERS$.MODULE$.ID()).append(" FROM ").append(Schema.TRIGGERS$.MODULE$.TABLE()).toString(), (rs, x$3) -> new StringBuilder(19).append("Trigger: ").append(rs.getString(1)).append(" with id: ").append(rs.getString(2)).toString())).asScala();
    }

    private Seq<Tuple2<String, String>> getRemainingReleasesDetails() {
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(Schema.RELEASES$.MODULE$.RELEASE_ID()).append(", ").append(Schema.RELEASES$.MODULE$.RELEASE_TITLE()).append(" FROM ").append(Schema.RELEASES$.MODULE$.TABLE()).toString(), (rs, x$4) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala();
    }

    private Seq<Tuple2<String, String>> getRemainingArchivedReleasesDetails() {
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.reportingJdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_ID_COLUMN()).append(", ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TITLE_COLUMN()).append(" FROM ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME()).toString(), (rs, x$5) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala();
    }

    private int countArchivedReleases() {
        return BoxesRunTime.unboxToInt((Object)this.reportingJdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_ID_COLUMN()).append(") FROM ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME()).toString(), (rs, x$6) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    @PreDestroy
    public void cleanXlDb() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent("XL_VERSION", sqlJdbcTemplate);
        this.wipeOutDatabase();
        this.wipeOutArchiveDatabase();
    }

    public ApplicationContext applicationContext() {
        return this.applicationContext;
    }

    public void applicationContext_$eq(ApplicationContext x$1) {
        this.applicationContext = x$1;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext();
    }

    public void setApplicationContext(ApplicationContext x$1) {
        this.applicationContext_$eq(x$1);
    }

    public static final /* synthetic */ void $anonfun$wipeOutArchiveDatabase$1(SqlStorageFacade $this, Liquibase liquibase) {
        try {
            $this.logger().info("Wipe-out reporting database tables");
            liquibase.dropAll();
        }
        catch (Exception e) {
            $this.logger().warn("Unable to wipe-out database", (Throwable)e);
        }
    }

    public static final /* synthetic */ void $anonfun$wipeOutDatabase$1(SqlStorageFacade $this, Liquibase liquibase) {
        try {
            $this.logger().info("Wipe-out repository database tables");
            liquibase.dropAll();
        }
        catch (Exception e) {
            $this.logger().warn("Unable to wipe-out database", (Throwable)e);
        }
    }

    private static final String showEntry$1(String tag, Tuple2 entry) {
        Tuple2 tuple2 = entry;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String id = (String)tuple2._1();
        String title = (String)tuple2._2();
        String string = new StringBuilder(9).append(id).append(" -> '").append(title).append("' (").append(tag).append(")").toString();
        return string;
    }

    private static final String all$1(Seq active$1, Seq archived$1) {
        return ((TraversableOnce)((TraversableLike)active$1.map((Function1 & Serializable & scala.Serializable)entry -> SqlStorageFacade.showEntry$1("active", entry), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)archived$1.map((Function1 & Serializable & scala.Serializable)entry -> SqlStorageFacade.showEntry$1("archive", entry), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).mkString("", "\n * ", "\n");
    }

    @Autowired
    public SqlStorageFacade(FolderService folderService, SqlTeamRepository teamRepository, ReleaseRepository releaseRepository, ReleaseSearchService releaseSearchService, DependencyPersistence dependencyPersistence, ConfigurationRepository configurationRepository, CalendarEntryRepository calendarEntryRepository, ArchivingService archivingService, TriggerRepository triggerRepository, @Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="reportingJdbcTemplate") JdbcTemplate reportingJdbcTemplate) {
        this.folderService = folderService;
        this.teamRepository = teamRepository;
        this.releaseRepository = releaseRepository;
        this.dependencyPersistence = dependencyPersistence;
        this.configurationRepository = configurationRepository;
        this.calendarEntryRepository = calendarEntryRepository;
        this.archivingService = archivingService;
        this.triggerRepository = triggerRepository;
        this.jdbcTemplate = jdbcTemplate;
        this.reportingJdbcTemplate = reportingJdbcTemplate;
        BeforeUpgrade.$init$((BeforeUpgrade)this);
        TestAuthentication.$init$((TestAuthentication)this);
        LiquibaseSupport.$init$((LiquibaseSupport)this);
        ScalaSpringSupport.$init$((ScalaSpringSupport)this);
        this.NL = System.lineSeparator();
    }
}

