import React from 'react';
import {connect} from 'react-redux';
import {TeamsTable} from './teams-table';
import {getTeamsFromPage, teamsTableId} from '../../../features/teams/sagas/teams-saga';
import {deleteTeam, addMember as addMemberAction, removeMember as removeMemberAction, initPaginatedTable} from '../../../features/teams/actions/teams-actions';

const mapStateToProps = state => ({
    loadedTableId: state.tables[teamsTableId],
    roles: state.teamsReducers.rolesList,
    tableId: teamsTableId,
    users: state.teamsReducers.usersList,
    paginateDataApi: getTeamsFromPage,
    readOnly: state.teamsReducers.inherited,
});

const addMember = (collection) => (team, member) => addMemberAction(collection, team, member);
const removeMember = (collection) => (team, index) => removeMemberAction(collection, team, index);

export default connect(
    mapStateToProps,
    {
        onAddRole: addMember('roles'),
        onAddUser: addMember('users'),
        onRemoveRole: removeMember('roles'),
        onRemoveUser: removeMember('users'),
        onRemoveTeam: deleteTeam,
        initTables: initPaginatedTable,
    }
)(TeamsTable);
