import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import './search.less';

export const Search = ({onFilterChange, searchClassNames = [], inputPlaceholder = ''}) => {
    return (
        <div className={classNames('search', ...searchClassNames)}>
            <i className="xl-icon search-icon"/>
            <input
                className="search-input"
                onChange={onFilterChange}
                placeholder={inputPlaceholder}
                type="text"
            />
        </div>
    );
};

Search.propTypes = {
    inputPlaceholder: PropTypes.string,
    onFilterChange: PropTypes.func.isRequired,
    searchClassNames: PropTypes.arrayOf(PropTypes.string)
};
