import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {HeaderRow, OrderConst} from "./const";

import './release-list-common.component.less';

export class ReleaseHeaderLabelComponent extends Component {
    static propTypes = {
        header: PropTypes.arrayOf(HeaderRow).isRequired,
        onOrderChange: PropTypes.func.isRequired
    };

    onOrderChange = (column) => {
        if (column.sortable) {
            this.props.onOrderChange(column);
        }
    };

    render() {
        const {header} = this.props;
        const headerRow = header.map(column => {
            const className = column.sortable ? 'sortable' : '';
            return (
                <div className={`release-row-view-column ${column.class} ${className}`} key={column.fieldName} onClick={() => this.onOrderChange(column)}>
                    {column.label}
                    <div className="order-icons">
                        {(column.order === OrderConst.SORT_DESC || column.order === OrderConst.SORT_NONE) && <i className="xl-icon icon-s arrow-up-icon"/>}
                        {(column.order === OrderConst.SORT_ASC || column.order === OrderConst.SORT_NONE) && <i className="xl-icon icon-s arrow-down-icon"/>}
                    </div>
                </div>
            );
        });

        return (
            <div className="release-header-row-view">
                {headerRow}
            </div>
        );
    }
}
